/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.simulator;

import freenet.crypt.RandomSource;
import freenet.node.Node;
import freenet.node.NodeInitException;
import freenet.node.NodeStarter;
import freenet.support.Logger;
import freenet.support.LoggerHook;
import freenet.support.PooledExecutor;
import freenet.support.TimeUtil;
import freenet.support.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class BootstrapSeedTest {
    public static int EXIT_NO_SEEDNODES = 257;
    public static int EXIT_FAILED_TARGET = 258;
    public static int EXIT_THREW_SOMETHING = 259;
    public static int DARKNET_PORT = 5006;
    public static int OPENNET_PORT = 5007;

    public static void main(String[] args) throws LoggerHook.InvalidThresholdException, NodeInitException, InterruptedException, IOException {
        Node node = null;
        try {
            String ipOverride = null;
            if (args.length > 0) {
                ipOverride = args[0];
            }
            File dir = new File("bootstrap-test");
            FileUtil.removeAll(dir);
            RandomSource random = NodeStarter.globalTestInit(dir.getPath(), false, Logger.LogLevel.ERROR, "", false);
            File seednodes = new File("seednodes.fref");
            if (!seednodes.exists() || seednodes.length() == 0L || !seednodes.canRead()) {
                System.err.println("Unable to read seednodes.fref, it doesn't exist, or is empty");
                System.exit(EXIT_NO_SEEDNODES);
            }
            File innerDir = new File(dir, Integer.toString(DARKNET_PORT));
            innerDir.mkdir();
            FileInputStream fis = new FileInputStream(seednodes);
            FileUtil.writeTo(fis, new File(innerDir, "seednodes.fref"));
            fis.close();
            PooledExecutor executor = new PooledExecutor();
            node = NodeStarter.createTestNode(DARKNET_PORT, OPENNET_PORT, "bootstrap-test", false, (short)18, 0, random, executor, 1000, 0x500000L, true, true, true, true, true, true, true, 12288, false, true, false, false, ipOverride);
            Logger.getChain().setThreshold(Logger.LogLevel.ERROR);
            long startTime = System.currentTimeMillis();
            node.start(true);
            int targetPeers = node.getOpennet().getAnnouncementThreshold();
            for (int seconds = 0; seconds < 600; ++seconds) {
                Thread.sleep(1000L);
                int seeds = node.getPeers().countSeednodes();
                int seedConns = node.getPeers().getConnectedSeedServerPeersVector(null).size();
                int opennetPeers = node.getPeers().countValidPeers();
                int opennetConns = node.getPeers().countConnectedOpennetPeers();
                System.err.println("" + seconds + " : seeds: " + seeds + ", connected: " + seedConns + " opennet: peers: " + opennetPeers + ", connected: " + opennetConns);
                if (opennetConns < targetPeers) continue;
                long timeTaken = System.currentTimeMillis() - startTime;
                System.out.println("Completed bootstrap (" + targetPeers + " peers) in " + timeTaken + "ms (" + TimeUtil.formatTime(timeTaken) + ")");
                node.park();
                System.exit(0);
            }
            System.err.println("Failed to reach target peers count " + targetPeers + " in 5 minutes.");
            node.park();
            System.exit(EXIT_FAILED_TARGET);
        }
        catch (Throwable t) {
            System.err.println("CAUGHT: " + t);
            t.printStackTrace();
            try {
                if (node != null) {
                    node.park();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.exit(EXIT_THREW_SOMETHING);
        }
    }
}

