/*
 * Decompiled with CFR 0.152.
 */
package freenet.store;

import freenet.crypt.DSAPublicKey;
import freenet.keys.CHKBlock;
import freenet.keys.CHKVerifyException;
import freenet.keys.KeyVerifyException;
import freenet.keys.NodeCHK;
import freenet.store.BlockMetadata;
import freenet.store.KeyCollisionException;
import freenet.store.StoreCallback;
import freenet.support.Logger;
import java.io.IOException;

public class CHKStore
extends StoreCallback<CHKBlock> {
    @Override
    public boolean collisionPossible() {
        return false;
    }

    @Override
    public CHKBlock construct(byte[] data, byte[] headers, byte[] routingKey, byte[] fullKey, boolean canReadClientCache, boolean canReadSlashdotCache, BlockMetadata meta, DSAPublicKey ignored) throws KeyVerifyException {
        if (data == null || headers == null) {
            throw new CHKVerifyException("Need either data and headers");
        }
        return CHKBlock.construct(data, headers, NodeCHK.cryptoAlgorithmFromFullKey(fullKey));
    }

    public CHKBlock fetch(NodeCHK chk, boolean dontPromote, boolean ignoreOldBlocks, BlockMetadata meta) throws IOException {
        return (CHKBlock)this.store.fetch(chk.getRoutingKey(), chk.getFullKey(), dontPromote, false, false, ignoreOldBlocks, meta);
    }

    public void put(CHKBlock b, boolean isOldBlock) throws IOException {
        try {
            this.store.put(b, b.getRawData(), b.getRawHeaders(), false, isOldBlock);
        }
        catch (KeyCollisionException e) {
            Logger.error(this, "Impossible for CHKStore: " + e, (Throwable)e);
        }
    }

    @Override
    public int dataLength() {
        return 32768;
    }

    @Override
    public int fullKeyLength() {
        return 34;
    }

    @Override
    public int headerLength() {
        return 36;
    }

    @Override
    public int routingKeyLength() {
        return 32;
    }

    @Override
    public boolean storeFullKeys() {
        return true;
    }

    @Override
    public boolean constructNeedsKey() {
        return false;
    }

    @Override
    public byte[] routingKeyFromFullKey(byte[] keyBuf) {
        return NodeCHK.routingKeyFromFullKey(keyBuf);
    }
}

