/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.config.Dimension;
import freenet.l10n.NodeL10n;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.TimeUtil;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;

public abstract class Fields {
    private static volatile boolean logMINOR;
    private static final char[] digits;
    private static final long[] MULTIPLES;
    private static final String[] MULTIPLES_2;

    public static long hexToLong(String hex) throws NumberFormatException {
        int len = hex.length();
        if (len > 16) {
            throw new NumberFormatException();
        }
        long l = 0L;
        for (int i = 0; i < len; ++i) {
            l <<= 4;
            int c = Character.digit(hex.charAt(i), 16);
            if (c < 0) {
                throw new NumberFormatException();
            }
            l |= (long)c;
        }
        return l;
    }

    public static int hexToInt(String hex) throws NumberFormatException {
        int len = hex.length();
        if (len > 16) {
            throw new NumberFormatException();
        }
        int l = 0;
        for (int i = 0; i < len; ++i) {
            l <<= 4;
            int c = Character.digit(hex.charAt(i), 16);
            if (c < 0) {
                throw new NumberFormatException();
            }
            l |= c;
        }
        return l;
    }

    public static boolean stringToBool(String s, boolean def) {
        if (s == null) {
            return def;
        }
        return def ? !s.equalsIgnoreCase("false") : s.equalsIgnoreCase("true");
    }

    public static boolean stringToBool(String s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("Null");
        }
        if (s.equalsIgnoreCase("false") || s.equalsIgnoreCase("no")) {
            return false;
        }
        if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes")) {
            return true;
        }
        throw new NumberFormatException("Invalid boolean: " + s);
    }

    public static String boolToString(boolean b) {
        return b ? "true" : "false";
    }

    public static String[] commaList(String ls) {
        if (ls == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(ls, ",");
        String[] r = new String[st.countTokens()];
        for (int i = 0; i < r.length; ++i) {
            r[i] = st.nextToken().trim();
        }
        return r;
    }

    public static String commaList(String[] ls) {
        return Fields.textList(ls, ',');
    }

    public static String textList(String[] ls, char ch) {
        if (ls.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String s : ls) {
            sb.append(s);
            sb.append(ch);
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static long[] numberList(String ls) throws NumberFormatException {
        StringTokenizer st = new StringTokenizer(ls, ",");
        long[] r = new long[st.countTokens()];
        for (int i = 0; i < r.length; ++i) {
            r[i] = Fields.hexToLong(st.nextToken());
        }
        return r;
    }

    public static String numberList(long[] ls) {
        if (ls.length == 0) {
            return "";
        }
        char[] numberBuf = new char[64];
        StringBuilder listBuf = new StringBuilder(ls.length * 18);
        for (long l : ls) {
            int charPos = 64;
            do {
                numberBuf[--charPos] = digits[(int)(l & 0xFL)];
            } while ((l >>>= 4) != 0L);
            listBuf.append(numberBuf, charPos, 64 - charPos);
            listBuf.append(',');
        }
        listBuf.deleteCharAt(listBuf.length() - 1);
        return listBuf.toString();
    }

    public static long dateTime(String date) throws NumberFormatException {
        int dash;
        if (date.length() == 0) {
            throw new NumberFormatException("Date time empty");
        }
        if (date.charAt(0) == '-' || date.charAt(0) == '+') {
            char c;
            StringBuilder sb = new StringBuilder(10);
            for (int x = 1; x < date.length() && Character.isDigit(c = date.charAt(x)); ++x) {
                sb.append(c);
            }
            int num = Integer.parseInt(sb.toString());
            int chop = 1 + sb.length();
            int deltaType = 0;
            if (date.length() == chop) {
                deltaType = 6;
            } else {
                String deltaTypeString;
                switch (deltaTypeString = date.substring(chop).toLowerCase()) {
                    case "y": 
                    case "year": {
                        deltaType = 1;
                        break;
                    }
                    case "month": 
                    case "mo": {
                        deltaType = 2;
                        break;
                    }
                    case "week": 
                    case "w": {
                        deltaType = 3;
                        break;
                    }
                    case "day": 
                    case "d": {
                        deltaType = 6;
                        break;
                    }
                    case "hour": 
                    case "h": {
                        deltaType = 10;
                        break;
                    }
                    case "minute": 
                    case "min": {
                        deltaType = 12;
                        break;
                    }
                    case "second": 
                    case "s": 
                    case "sec": {
                        deltaType = 13;
                        break;
                    }
                    default: {
                        throw new NumberFormatException("unknown time/date delta type: " + deltaTypeString);
                    }
                }
                GregorianCalendar gc = new GregorianCalendar();
                gc.add(deltaType, date.charAt(0) == '+' ? num : -num);
                return gc.getTime().getTime();
            }
        }
        if (!((dash = date.indexOf(45)) == -1 && date.length() == 8 || dash == 8 && date.length() == 17)) {
            throw new NumberFormatException("Date time: " + date + " not correct.");
        }
        int year = Integer.parseInt(date.substring(0, 4));
        int month = Integer.parseInt(date.substring(4, 6));
        int day = Integer.parseInt(date.substring(6, 8));
        int hour = dash == -1 ? 0 : Integer.parseInt(date.substring(9, 11));
        int minute = dash == -1 ? 0 : Integer.parseInt(date.substring(12, 14));
        int second = dash == -1 ? 0 : Integer.parseInt(date.substring(15, 17));
        try {
            return new GregorianCalendar(year, month - 1, day, hour, minute, second).getTime().getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NumberFormatException("Invalid date " + date + ": " + e);
        }
    }

    public static String secToDateTime(long time) {
        SimpleDateFormat f = new SimpleDateFormat("yyyyMMdd-HH:mm:ss");
        f.setTimeZone(TimeZone.getTimeZone("GMT"));
        String dateString = f.format(new Date(time * 1000L));
        if (dateString.endsWith("-00:00:00")) {
            dateString = dateString.substring(0, 8);
        }
        return dateString;
    }

    public static int compareBytes(byte[] b1, byte[] b2) {
        int len = Math.max(b1.length, b2.length);
        for (int i = 0; i < len; ++i) {
            if (i == b1.length) {
                return i == b2.length ? 0 : -1;
            }
            if (i == b2.length) {
                return 1;
            }
            if ((0xFF & b1[i]) > (0xFF & b2[i])) {
                return 1;
            }
            if ((0xFF & b1[i]) >= (0xFF & b2[i])) continue;
            return -1;
        }
        return 0;
    }

    public static int compareBytes(byte[] a, byte[] b, int aoff, int boff, int len) {
        for (int i = 0; i < len; ++i) {
            if (i + aoff == a.length) {
                return i + boff == b.length ? 0 : -1;
            }
            if (i + boff == b.length) {
                return 1;
            }
            if ((0xFF & a[i + aoff]) > (0xFF & b[i + boff])) {
                return 1;
            }
            if ((0xFF & a[i + aoff]) >= (0xFF & b[i + boff])) continue;
            return -1;
        }
        return 0;
    }

    public static boolean byteArrayEqual(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean byteArrayEqual(byte[] a, byte[] b, int aoff, int boff, int len) {
        if (a.length < aoff + len || b.length < boff + len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (a[i + aoff] == b[i + boff]) continue;
            return false;
        }
        return true;
    }

    public static int hashCode(byte[] b) {
        return Fields.hashCode(b, 0, b.length);
    }

    public static int hashCode(byte[] b, int ptr, int length) {
        int h = 0;
        for (int i = length - 1; i >= 0; --i) {
            int x = b[ptr + i] & 0xFF;
            h ^= x << ((i & 3) << 3);
        }
        return h;
    }

    public static long longHashCode(byte[] b) {
        return Fields.longHashCode(b, 0, b.length);
    }

    public static long longHashCode(byte[] b, int offset, int length) {
        long h = 0L;
        for (int i = length - 1; i >= 0; --i) {
            int x = b[i + offset] & 0xFF;
            h ^= (long)x << ((i & 7) << 3);
        }
        return h;
    }

    public static String commaList(Object[] addr) {
        return Fields.commaList(addr, ',');
    }

    public static String commaList(Object[] addr, char comma) {
        if (addr.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object a : addr) {
            sb.append(a);
            sb.append(comma);
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static byte[] longsToBytes(long[] longs) {
        byte[] buf = new byte[longs.length * 8];
        for (int i = 0; i < longs.length; ++i) {
            long x = longs[i];
            for (int j = 0; j < 8; ++j) {
                buf[i * 8 + j] = (byte)x;
                x >>>= 8;
            }
        }
        return buf;
    }

    public static long[] bytesToLongs(byte[] buf) {
        return Fields.bytesToLongs(buf, 0, buf.length);
    }

    public static long[] bytesToLongs(byte[] buf, int offset, int length) {
        if (length % 8 != 0) {
            throw new IllegalArgumentException();
        }
        long[] longs = new long[length / 8];
        for (int i = 0; i < longs.length; ++i) {
            long x = 0L;
            for (int j = 7; j >= 0; --j) {
                long y = buf[offset + i * 8 + j] & 0xFF;
                x = x << 8 | y;
            }
            longs[i] = x;
        }
        return longs;
    }

    public static long bytesToLong(byte[] buf) {
        return Fields.bytesToLong(buf, 0);
    }

    public static long bytesToLong(byte[] buf, int offset) {
        if (buf.length < 8 + offset) {
            throw new IllegalArgumentException();
        }
        long x = 0L;
        for (int j = 7; j >= 0; --j) {
            long y = buf[j + offset] & 0xFF;
            x = x << 8 | y;
        }
        return x;
    }

    public static int bytesToInt(byte[] buf) {
        return Fields.bytesToInt(buf, 0);
    }

    public static int bytesToInt(byte[] buf, int offset) {
        if (buf.length < 4) {
            throw new IllegalArgumentException();
        }
        int x = 0;
        for (int j = 3; j >= 0; --j) {
            int y = buf[j + offset] & 0xFF;
            x = x << 8 | y;
        }
        return x;
    }

    public static short bytesToShort(byte[] buf, int offset) {
        if (buf.length < 2) {
            throw new IllegalArgumentException();
        }
        short x = 0;
        for (int j = 1; j >= 0; --j) {
            short y = (short)(buf[j + offset] & 0xFF);
            x = (short)(x << 8 | y);
        }
        return x;
    }

    public static int[] bytesToInts(byte[] buf, int offset, int length) {
        if (length % 4 != 0) {
            throw new IllegalArgumentException();
        }
        int[] ints = new int[length / 4];
        for (int i = 0; i < ints.length; ++i) {
            int x = 0;
            for (int j = 3; j >= 0; --j) {
                int y = buf[j + offset + i * 4] & 0xFF;
                x = x << 8 | y;
            }
            ints[i] = x;
        }
        return ints;
    }

    public static int[] bytesToInts(byte[] buf) {
        return Fields.bytesToInts(buf, 0, buf.length);
    }

    public static byte[] longToBytes(long x) {
        byte[] buf = new byte[8];
        for (int j = 0; j < 8; ++j) {
            buf[j] = (byte)x;
            x >>>= 8;
        }
        return buf;
    }

    public static byte[] intsToBytes(int[] ints) {
        return Fields.intsToBytes(ints, 0, ints.length);
    }

    public static byte[] intsToBytes(int[] ints, int offset, int length) {
        byte[] buf = new byte[length * 4];
        for (int i = 0; i < length; ++i) {
            long x = ints[i + offset];
            for (int j = 0; j < 4; ++j) {
                buf[i * 4 + j] = (byte)x;
                x >>>= 8;
            }
        }
        return buf;
    }

    public static byte[] intToBytes(int x) {
        byte[] buf = new byte[4];
        for (int j = 0; j < 4; ++j) {
            buf[j] = (byte)x;
            x >>>= 8;
        }
        return buf;
    }

    public static byte[] shortToBytes(short x) {
        byte[] buf = new byte[2];
        for (int j = 0; j < 2; ++j) {
            buf[j] = (byte)x;
            x = (short)(x >>> 8);
        }
        return buf;
    }

    public static long parseLong(String s, long defaultValue) {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            Logger.error(Fields.class, "Failed to parse value as long: " + s + " : " + e, (Throwable)e);
            return defaultValue;
        }
    }

    public static int parseInt(String s, int defaultValue) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            Logger.error(Fields.class, "Failed to parse value as int: " + s + " : " + e, (Throwable)e);
            return defaultValue;
        }
    }

    public static long parseShort(String s, short defaultValue) {
        try {
            return Short.parseShort(s);
        }
        catch (NumberFormatException e) {
            Logger.error(Fields.class, "Failed to parse value as short: " + s + " : " + e, (Throwable)e);
            return defaultValue;
        }
    }

    public static short parseShort(String s) throws NumberFormatException {
        s = s.replaceFirst("(i)*B$", "");
        short res = 1;
        try {
            int idx;
            int x;
            for (x = s.length() - 1; x >= 0 && (idx = "kK".indexOf(s.charAt(x))) != -1; --x) {
                res = (short)((long)res * MULTIPLES[idx]);
            }
            res = (short)((double)res * Double.parseDouble(s.substring(0, x + 1)));
        }
        catch (ArithmeticException e) {
            res = Short.MAX_VALUE;
            throw new NumberFormatException(e.getMessage());
        }
        return res;
    }

    public static String trimPerSecond(String limit) {
        if ((limit = limit.trim()).isEmpty()) {
            return "";
        }
        String lower = limit.toLowerCase();
        for (String ending : new String[]{"/s", "/sec", "/second", "ps", NodeL10n.getBase().getString("FirstTimeWizardToadlet.bandwidthPerSecond").toLowerCase()}) {
            if (!lower.endsWith(ending)) continue;
            return limit.substring(0, limit.length() - ending.length());
        }
        return limit;
    }

    public static int parseInt(String s, Dimension dimension) throws NumberFormatException {
        switch (dimension) {
            case NOT: 
            case SIZE: {
                return Fields.parseInt(s);
            }
            case DURATION: {
                long durationInMillis = TimeUtil.toMillis(s);
                if ((long)((int)durationInMillis) == durationInMillis) {
                    return (int)durationInMillis;
                }
                throw new ArithmeticException("integer overflow");
            }
        }
        throw new AssertionError((Object)("Unknown dimension " + (Object)((Object)dimension)));
    }

    public static int parseInt(String s) throws NumberFormatException {
        boolean isSizeInBits = s.endsWith("b");
        s = s.replaceFirst(isSizeInBits ? "(i)*b$" : "(i)*B$", "");
        int res = 1;
        try {
            int idx;
            int x;
            for (x = s.length() - 1; x >= 0 && (idx = "kKmMgG".indexOf(s.charAt(x))) != -1; --x) {
                res = (int)((long)res * MULTIPLES[idx]);
            }
            res = (int)((double)res * Double.parseDouble(s.substring(0, x + 1)));
        }
        catch (ArithmeticException e) {
            res = Integer.MAX_VALUE;
            throw new NumberFormatException(e.getMessage());
        }
        return isSizeInBits ? res / 8 : res;
    }

    public static long parseLong(String s) throws NumberFormatException {
        s = s.replaceFirst("(i)*B$", "");
        long res = 1L;
        int x = s.length() - 1;
        try {
            int idx;
            while (x >= 0 && (idx = "kKmMgGtTpPeE".indexOf(s.charAt(x))) != -1) {
                --x;
                res *= MULTIPLES[idx];
            }
            String multiplier = s.substring(0, x + 1).trim();
            if (multiplier.indexOf(46) > -1 || multiplier.indexOf(69) > -1) {
                double m = Double.parseDouble(multiplier);
                Fields.checkLongOverflowWhenMultiply(res, m);
                res = (long)((double)res * m);
                if (logMINOR) {
                    Logger.minor(Fields.class, "Parsed " + multiplier + " of " + s + " as double: " + res);
                }
            } else {
                long m = Long.parseLong(multiplier);
                Fields.checkLongOverflowWhenMultiply(res, m);
                res *= m;
                if (logMINOR) {
                    Logger.minor(Fields.class, "Parsed " + multiplier + " of " + s + " as long: " + res);
                }
            }
        }
        catch (ArithmeticException e) {
            throw new NumberFormatException(e.getMessage());
        }
        return res;
    }

    private static void checkLongOverflowWhenMultiply(long a, Number b) {
        if (a != 0L && Math.abs(b.longValue()) > Long.MAX_VALUE / a) {
            throw new NumberFormatException("Long overflow");
        }
    }

    public static String longToString(long val, boolean isSize) {
        String ret = Long.toString(val);
        if (val <= 0L) {
            return ret;
        }
        for (int i = MULTIPLES.length - 1; i >= 0; --i) {
            if (val <= MULTIPLES[i] || val % MULTIPLES[i] != 0L || !isSize && MULTIPLES[i] % 1000L != 0L) continue;
            ret = val / MULTIPLES[i] + MULTIPLES_2[i];
            if (MULTIPLES_2[i].toLowerCase().equals(MULTIPLES_2[i])) break;
            ret = ret + "iB";
            break;
        }
        return ret;
    }

    public static String intToString(int val, Dimension dimension) {
        switch (dimension) {
            case NOT: {
                return Fields.intToString(val, false);
            }
            case SIZE: {
                return Fields.intToString(val, true);
            }
            case DURATION: {
                return TimeUtil.formatTime(val, 6, false);
            }
        }
        throw new AssertionError((Object)("Unknown dimension " + (Object)((Object)dimension)));
    }

    public static String intToString(int val, boolean isSize) {
        String ret = Integer.toString(val);
        if (val <= 0) {
            return ret;
        }
        for (int i = MULTIPLES.length - 1; i >= 0; --i) {
            if ((long)val <= MULTIPLES[i] || (long)val % MULTIPLES[i] != 0L || !isSize && MULTIPLES[i] % 1000L != 0L) continue;
            ret = (long)val / MULTIPLES[i] + MULTIPLES_2[i];
            if (MULTIPLES_2[i].toLowerCase().equals(MULTIPLES_2[i])) break;
            ret = ret + "iB";
            break;
        }
        return ret;
    }

    public static String shortToString(short val, boolean isSize) {
        String ret = Short.toString(val);
        if (val <= 0) {
            return ret;
        }
        for (int i = MULTIPLES.length - 1; i >= 0; --i) {
            if ((long)val <= MULTIPLES[i] || (long)val % MULTIPLES[i] != 0L || !isSize && MULTIPLES[i] % 1000L != 0L) continue;
            ret = (long)val / MULTIPLES[i] + MULTIPLES_2[i];
            if (MULTIPLES_2[i].toLowerCase().equals(MULTIPLES_2[i])) break;
            ret = ret + "iB";
            break;
        }
        return ret;
    }

    public static double[] bytesToDoubles(byte[] data, int offset, int length) {
        long[] longs = Fields.bytesToLongs(data, offset, length);
        double[] doubles = new double[longs.length];
        for (int i = 0; i < longs.length; ++i) {
            doubles[i] = Double.longBitsToDouble(longs[i]);
        }
        return doubles;
    }

    public static byte[] doublesToBytes(double[] doubles) {
        long[] longs = new long[doubles.length];
        for (int i = 0; i < longs.length; ++i) {
            longs[i] = Double.doubleToLongBits(doubles[i]);
        }
        return Fields.longsToBytes(longs);
    }

    public static double[] bytesToDoubles(byte[] data) {
        return Fields.bytesToDoubles(data, 0, data.length);
    }

    public static String trimLines(String str) {
        StringBuilder r = new StringBuilder(str.length());
        for (String line : str.split("\n")) {
            if ((line = line.trim()).length() == 0) continue;
            r.append(line);
            r.append('\n');
        }
        return r.toString();
    }

    public static int compareVersion(String x, String y) {
        int i = 0;
        int j = 0;
        boolean wantDigits = false;
        while (true) {
            block14: {
                String xDigits = null;
                String yDigits = null;
                int digits = Fields.getDigits(x, i, wantDigits);
                if (digits > 0) {
                    xDigits = x.substring(i, i + digits);
                    i += digits;
                }
                if ((digits = Fields.getDigits(y, j, wantDigits)) > 0) {
                    yDigits = y.substring(j, j + digits);
                    j += digits;
                }
                if (xDigits != null && yDigits == null) {
                    return 1;
                }
                if (yDigits != null && xDigits == null) {
                    return -1;
                }
                if (xDigits != null && yDigits != null && !xDigits.equals(yDigits)) {
                    if (wantDigits) {
                        try {
                            long a = Integer.parseInt(xDigits);
                            long b = Integer.parseInt(yDigits);
                            if (a > b) {
                                return 1;
                            }
                            if (a < b) {
                                return -1;
                            }
                            if (xDigits.length() > yDigits.length()) {
                                return -1;
                            }
                            if (yDigits.length() > xDigits.length()) {
                                return 1;
                            }
                            break block14;
                        }
                        catch (NumberFormatException e) {
                            return xDigits.compareTo(yDigits);
                        }
                    }
                    return xDigits.compareTo(yDigits);
                }
            }
            if (i >= x.length() && j >= y.length()) {
                return 0;
            }
            wantDigits = !wantDigits;
        }
    }

    static int getDigits(String x, int i, boolean wantDigits) {
        int origI = i;
        while (i < x.length() && Character.isDigit(x.charAt(i)) == wantDigits) {
            ++i;
        }
        return i - origI;
    }

    public static int compareObjectID(Object o1, Object o2) {
        int id2;
        int id1 = System.identityHashCode(o1);
        if (id1 > (id2 = System.identityHashCode(o2))) {
            return 1;
        }
        if (id2 > id1) {
            return -1;
        }
        return 0;
    }

    public static final int compare(int x, int y) {
        if (x > y) {
            return 1;
        }
        if (y > x) {
            return -1;
        }
        return 0;
    }

    public static final int compare(long x, long y) {
        if (x > y) {
            return 1;
        }
        if (y > x) {
            return -1;
        }
        return 0;
    }

    public static final int compare(double x, double y) {
        if (Double.isNaN(x)) {
            if (Double.isNaN(y)) {
                return 0;
            }
            return -1;
        }
        if (Double.isNaN(y)) {
            return 1;
        }
        if (x > y) {
            return 1;
        }
        if (x < y) {
            return -1;
        }
        return 0;
    }

    public static final int compare(float x, float y) {
        if (Float.isNaN(x)) {
            if (Float.isNaN(y)) {
                return 0;
            }
            return -1;
        }
        if (Float.isNaN(y)) {
            return 1;
        }
        if (x > y) {
            return 1;
        }
        if (x < y) {
            return -1;
        }
        return 0;
    }

    public static final int compare(Date a, Date b) {
        a = a != null ? a : new Date(0L);
        b = b != null ? b : new Date(0L);
        return a.compareTo(b);
    }

    public static byte[] copyToArray(ByteBuffer buf) {
        byte[] ret = new byte[buf.remaining()];
        buf.get(ret);
        return ret;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        MULTIPLES = new long[]{1000L, 1024L, 1000000L, 0x100000L, 1000000000L, 0x40000000L, 1000000000000L, 0x10000000000L, 1000000000000000L, 0x4000000000000L, 1000000000000000000L, 0x1000000000000000L};
        MULTIPLES_2 = new String[]{"k", "K", "m", "M", "g", "G", "t", "T", "p", "P", "e", "E"};
    }

    public static final class ByteArrayComparator
    implements Comparator<byte[]> {
        @Override
        public final int compare(byte[] o1, byte[] o2) {
            return Fields.compareBytes(o1, o2);
        }
    }
}

