/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.Fields;
import freenet.support.URLEncodedFormatException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class URLDecoder {
    public static void main(String[] args) throws URLEncodedFormatException {
        for (String arg : args) {
            System.out.println(arg + " -> " + URLDecoder.decode(arg, false));
        }
    }

    public static String decode(String s, boolean tolerant) throws URLEncodedFormatException {
        if (s.length() == 0) {
            return "";
        }
        int len = s.length();
        ByteArrayOutputStream decodedBytes = new ByteArrayOutputStream();
        boolean hasDecodedSomething = false;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '%') {
                if (i >= len - 2) {
                    throw new URLEncodedFormatException(s);
                }
                char[] hexChars = new char[]{s.charAt(++i), s.charAt(++i)};
                String hexval = new String(hexChars);
                try {
                    long read = Fields.hexToLong(hexval);
                    if (read == 0L) {
                        throw new URLEncodedFormatException("Can't encode 00");
                    }
                    decodedBytes.write((int)read);
                    hasDecodedSomething = true;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    if (tolerant && !hasDecodedSomething) {
                        byte[] buf = ('%' + hexval).getBytes(StandardCharsets.UTF_8);
                        decodedBytes.write(buf, 0, buf.length);
                        continue;
                    }
                    throw new URLEncodedFormatException("Not a two character hex % escape: " + hexval + " in " + s);
                }
            }
            byte[] encoded = String.valueOf(c).getBytes(StandardCharsets.UTF_8);
            decodedBytes.write(encoded, 0, encoded.length);
        }
        try {
            decodedBytes.close();
            return new String(decodedBytes.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            throw new URLEncodedFormatException(s);
        }
    }
}

