/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.CommentException;
import freenet.client.filter.ElementInfo;
import freenet.client.filter.FilterCallback;
import freenet.client.filter.FilterUtils;
import freenet.client.filter.UnsupportedCharsetInFilterException;
import freenet.support.Fields;
import freenet.support.Logger;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class CSSTokenizerFilter {
    private Reader r;
    Writer w = null;
    FilterCallback cb;
    private static volatile boolean logDEBUG;
    private final String passedCharset;
    private String detectedCharset;
    private final boolean stopAtDetectedCharset;
    private final boolean isInline;
    private static final Map<String, CSSPropertyVerifier> elementVerifiers;
    private static final HashSet<String> allelementVerifiers;
    private static final CSSPropertyVerifier[] auxilaryVerifiers;

    CSSTokenizerFilter() {
        this.passedCharset = "UTF-8";
        this.stopAtDetectedCharset = false;
        this.isInline = false;
    }

    CSSTokenizerFilter(Reader r, Writer w, FilterCallback cb, String charset, boolean stopAtDetectedCharset, boolean isInline) {
        this.r = r;
        this.w = w;
        this.cb = cb;
        this.passedCharset = charset;
        this.stopAtDetectedCharset = stopAtDetectedCharset;
        this.isInline = isInline;
    }

    public boolean isValidURI(String URI2) {
        try {
            return URI2.equals(this.cb.processURI(URI2, null));
        }
        catch (CommentException e) {
            return false;
        }
    }

    @Deprecated
    public static <T> T[] concat(T[] a, T[] b) {
        int alen = a.length;
        int blen = b.length;
        if (alen == 0) {
            return b;
        }
        if (blen == 0) {
            return a;
        }
        Object[] result = (Object[])Array.newInstance(a.getClass().getComponentType(), alen + blen);
        System.arraycopy(a, 0, result, 0, alen);
        System.arraycopy(b, 0, result, alen, blen);
        return result;
    }

    private static void addVerifier(String element) {
        if ("accent-color".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto"), ElementInfo.VISUALMEDIA, Arrays.asList("co")));
            allelementVerifiers.remove(element);
        } else if ("align-content".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("121a124"), true, true));
            allelementVerifiers.remove(element);
        } else if ("align-items".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("125", "127"), true, true));
            allelementVerifiers.remove(element);
        } else if ("align-self".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto", "stretch", "baseline", "last-baseline"), ElementInfo.VISUALMEDIA, null, Arrays.asList("127"), true, true));
            allelementVerifiers.remove(element);
        } else if ("all".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.MEDIA, null, null, true, true));
            allelementVerifiers.remove(element);
        } else if ("appearance".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto", "none", "base", "searchfield", "textarea", "checkbox", "radio", "menulist", "listbox", "meter", "progress-bar", "button", "textfield", "menulist-button"), ElementInfo.VISUALMEDIA, null, null, true, true));
            allelementVerifiers.remove(element);
        } else if ("azimuth".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[0] = new CSSPropertyVerifier(Arrays.asList("left-side", "far-left", "left", "center-left", "center", "center-right", "right", "far-right", "right-side"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[1] = new CSSPropertyVerifier(Arrays.asList("behind"), null, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("leftwards", "rightwards"), ElementInfo.AURALMEDIA, Arrays.asList("an"), Arrays.asList("0a1")));
            allelementVerifiers.remove(element);
        } else if ("backface-visibility".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("visible", "hidden"), ElementInfo.VISUALMEDIA, null, null, true, true));
            allelementVerifiers.remove(element);
        } else if ("background-attachment".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[60] = new CSSPropertyVerifier(Arrays.asList("local", "scroll", "fixed"), null, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("60<1,65535>"), true, true));
            allelementVerifiers.remove(element);
        } else if ("background-blend-mode".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[148] = new CSSPropertyVerifier(Arrays.asList("normal", "multiply", "screen", "overlay", "darken", "lighten", "color-dodge", "color-burn", "hard-light", "soft-light", "difference", "exclusion", "hue", "saturation", "color", "luminosity"), null, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("148<1,2>"), true, true));
            allelementVerifiers.remove(element);
        } else if ("background-clip".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("61<1,65535>"), true, true));
            allelementVerifiers.remove(element);
        } else if ("background-color".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("transparent"), ElementInfo.VISUALMEDIA, Arrays.asList("co")));
            allelementVerifiers.remove(element);
        } else if ("background-image".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[56] = new CSSPropertyVerifier(Arrays.asList("none"), Arrays.asList("ur"), null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("56<1,65535>"), true, true));
            allelementVerifiers.remove(element);
        } else if ("background-origin".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("61<1,65535>"), true, true));
            allelementVerifiers.remove(element);
        } else if ("background-repeat".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[57] = new CSSPropertyVerifier(Arrays.asList("repeat", "space", "round", "no-repeat"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[58] = new CSSPropertyVerifier(Arrays.asList("repeat-x", "repeat-y"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[59] = new CSSPropertyVerifier(null, null, Arrays.asList("58", "57<1,2>"), null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("59<1,65535>"), true, true));
            allelementVerifiers.remove(element);
        } else if ("background-size".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[62] = new CSSPropertyVerifier(Arrays.asList("cover", "contain"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[63] = new CSSPropertyVerifier(null, null, Arrays.asList("36<1,2>", "62"), null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("63<1,65535>"), true, true));
            allelementVerifiers.remove(element);
        } else if ("background".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[6] = new CSSPropertyVerifier(Arrays.asList("scroll", "fixed"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[7] = new CSSPropertyVerifier(Arrays.asList("transparent"), Arrays.asList("co"), null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[8] = new CSSPropertyVerifier(Arrays.asList("none"), Arrays.asList("ur"), null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[9] = new CSSPropertyVerifier(null, null, Arrays.asList("2 3?", "4a5"), null, true);
            CSSTokenizerFilter.auxilaryVerifiers[10] = new CSSPropertyVerifier(Arrays.asList("repeat", "repeat-x", "repeat-y", "no-repeat"), null, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("6a7a8a9a10")));
            allelementVerifiers.remove(element);
        } else if ("block-size".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto"), ElementInfo.VISUALMEDIA, Arrays.asList("le", "pe")));
            allelementVerifiers.remove(element);
        } else if ("border-collapse".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("collapse", "separate"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("border-color".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, Arrays.asList("co"), Arrays.asList("11<1,4>")));
            allelementVerifiers.remove(element);
        } else if ("border-spacing".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[12] = new CSSPropertyVerifier(null, Arrays.asList("le"), null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("12 12?")));
            allelementVerifiers.remove(element);
        } else if ("border-style".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("13<1,4>")));
            allelementVerifiers.remove(element);
        } else if ("border-top-style".equalsIgnoreCase(element) || "border-bottom-style".equalsIgnoreCase(element) || "border-left-style".equalsIgnoreCase(element) || "border-right-style".equalsIgnoreCase(element) || "border-block-end-style".equalsIgnoreCase(element) || "border-block-start-style".equalsIgnoreCase(element) || "border-inline-end-style".equalsIgnoreCase(element) || "border-inline-start-style".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, null, Arrays.asList("13"), ElementInfo.VISUALMEDIA, true));
            allelementVerifiers.remove(element);
        } else if ("border-left".equalsIgnoreCase(element) || "border-right".equalsIgnoreCase(element) || "border-top".equalsIgnoreCase(element) || "border-bottom".equalsIgnoreCase(element) || "border-block-end".equalsIgnoreCase(element) || "border-block-start".equalsIgnoreCase(element) || "border-inline-end".equalsIgnoreCase(element) || "border-inline-start".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("13a14a11")));
            allelementVerifiers.remove(element);
        } else if ("border-top-color".equalsIgnoreCase(element) || "border-bottom-color".equalsIgnoreCase(element) || "border-left-color".equalsIgnoreCase(element) || "border-right-color".equalsIgnoreCase(element) || "border-inline-end-color".equalsIgnoreCase(element) || "border-inline-start-color".equalsIgnoreCase(element) || "border-block-start-color".equalsIgnoreCase(element) || "border-block-end-color".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, Arrays.asList("co")));
            allelementVerifiers.remove(element);
        } else if ("border-width".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("14<1,4>")));
            allelementVerifiers.remove(element);
        } else if ("border-top-width".equalsIgnoreCase(element) || "border-bottom-width".equalsIgnoreCase(element) || "border-left-width".equalsIgnoreCase(element) || "border-right-width".equalsIgnoreCase(element) || "border-block-end-width".equalsIgnoreCase(element) || "border-block-start-width".equalsIgnoreCase(element) || "border-inline-end-width".equalsIgnoreCase(element) || "border-inline-start-width".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("14")));
            allelementVerifiers.remove(element);
        } else if ("border".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("13a14a11")));
            allelementVerifiers.remove(element);
        } else if ("border-radius".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[65] = new CSSPropertyVerifier(Arrays.asList("/"), null, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("40<1,4>", "40<1,4> 65 40<1,4>")));
            allelementVerifiers.remove(element);
        } else if ("border-bottom-left-radius".equalsIgnoreCase(element) || "border-bottom-right-radius".equalsIgnoreCase(element) || "border-top-left-radius".equalsIgnoreCase(element) || "border-top-right-radius".equalsIgnoreCase(element) || "border-start-end-radius".equalsIgnoreCase(element) || "border-start-start-radius".equalsIgnoreCase(element) || "border-end-end-radius".equalsIgnoreCase(element) || "border-end-start-radius".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("40<1,2>")));
            allelementVerifiers.remove(element);
        } else if ("border-image-source".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("76")));
            allelementVerifiers.remove(element);
        } else if ("border-image-slice".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[66] = new CSSPropertyVerifier(null, Arrays.asList("pe", "in"), null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[67] = new CSSPropertyVerifier(Arrays.asList("fill"), null, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("66<1,4> 67?")));
            allelementVerifiers.remove(element);
        } else if ("border-image-width".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("77")));
            allelementVerifiers.remove(element);
        } else if ("border-image-outset".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[69] = new CSSPropertyVerifier(null, Arrays.asList("le", "in"), null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("69<1,4>")));
            allelementVerifiers.remove(element);
        } else if ("border-image-repeat".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("78")));
            allelementVerifiers.remove(element);
        } else if ("border-image".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("76a77a78")));
            allelementVerifiers.remove(element);
        } else if ("bottom".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto"), ElementInfo.VISUALMEDIA, Arrays.asList("le", "pe")));
            allelementVerifiers.remove(element);
        } else if ("box-decoration-break".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("slice", "clone"), ElementInfo.VISUALMEDIA, null));
            allelementVerifiers.remove(element);
        } else if ("box-shadow".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("none"), ElementInfo.VISUALMEDIA, null, Arrays.asList("75<1,65535>"), true, true));
            allelementVerifiers.remove(element);
        } else if ("box-sizing".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("content-box", "border-box"), ElementInfo.VISUALMEDIA, null));
            allelementVerifiers.remove(element);
        } else if ("box-suppress".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("show", "discard", "hide"), ElementInfo.VISUALMEDIA, null));
            allelementVerifiers.remove(element);
        } else if ("caption-side".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("top", "bottom"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("caret-color".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto", "transparent", "currentcolor"), ElementInfo.VISUALMEDIA, Arrays.asList("co")));
            allelementVerifiers.remove(element);
        } else if ("clear".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("none", "left", "right", "both", "inline-start", "inline-end"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("clip".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto"), ElementInfo.VISUALMEDIA, Arrays.asList("sh")));
            allelementVerifiers.remove(element);
        } else if ("break-after".equalsIgnoreCase(element) || "page-break-after".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto", "always", "avoid", "all", "left", "right", "recto", "verso", "page", "column", "avoid-page", "avoid-column"), ElementInfo.VISUALPAGEDMEDIA));
            allelementVerifiers.remove(element);
        } else if ("break-before".equalsIgnoreCase(element) || "page-break-before".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto", "always", "avoid", "all", "left", "right", "recto", "verso", "page", "column", "avoid-page", "avoid-column"), ElementInfo.VISUALPAGEDMEDIA));
            allelementVerifiers.remove(element);
        } else if ("break-inside".equalsIgnoreCase(element) || "page-break-inside".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto", "avoid", "avoid-page", "avoid-column"), ElementInfo.VISUALPAGEDMEDIA));
            allelementVerifiers.remove(element);
        } else if ("color-scheme".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[81] = new CSSPropertyVerifier(Arrays.asList("light", "dark", "only"), null, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("normal"), ElementInfo.VISUALMEDIA, null, Arrays.asList("81<1,3>")));
            allelementVerifiers.remove(element);
        } else if ("column-count".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto"), ElementInfo.VISUALMEDIA, Arrays.asList("in")));
            allelementVerifiers.remove(element);
        } else if ("column-fill".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto", "balance"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("column-gap".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("normal"), ElementInfo.VISUALMEDIA, Arrays.asList("le")));
            allelementVerifiers.remove(element);
        } else if ("column-rule-color".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, Arrays.asList("co")));
            allelementVerifiers.remove(element);
        } else if ("column-rule-style".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("13<1,4>")));
            allelementVerifiers.remove(element);
        } else if ("column-rule-width".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("14<1,4>")));
            allelementVerifiers.remove(element);
        } else if ("column-rule".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[54] = new CSSPropertyVerifier(null, null, null, Arrays.asList("14<1,4>"));
            CSSTokenizerFilter.auxilaryVerifiers[55] = new CSSPropertyVerifier(null, null, null, Arrays.asList("13<1,4>"));
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("54a55a11")));
            allelementVerifiers.remove(element);
        } else if ("column-span".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("1", "all"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("column-width".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto"), ElementInfo.VISUALMEDIA, Arrays.asList("le")));
            allelementVerifiers.remove(element);
        } else if ("columns".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[52] = new CSSPropertyVerifier(Arrays.asList("auto"), Arrays.asList("le"), null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[53] = new CSSPropertyVerifier(Arrays.asList("auto"), Arrays.asList("in"), null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("52a53")));
            allelementVerifiers.remove(element);
        } else if ("color".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, Arrays.asList("co")));
            allelementVerifiers.remove(element);
        } else if ("color-interpolation".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto", "sRGB", "linearRGB"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("color-rendering".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto", "optimizeSpeed", "optimizeQuality"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("content".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[16] = new ContentPropertyVerifier(Arrays.asList("open-quote", "close-quote", "no-open-quote", "no-close-quote"));
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("normal", "none"), ElementInfo.MEDIA, null, Arrays.asList("16<1,10>")));
            allelementVerifiers.remove(element);
        } else if ("counter-increment".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[17] = new CSSPropertyVerifier(null, Arrays.asList("id"), null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[18] = new CSSPropertyVerifier(null, Arrays.asList("in"), null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[19] = new CSSPropertyVerifier(null, null, Arrays.asList("17 18?"), null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("none"), ElementInfo.MEDIA, null, Arrays.asList("19<1,10>[1,2]")));
            allelementVerifiers.remove(element);
        } else if ("counter-reset".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[20] = new CSSPropertyVerifier(null, Arrays.asList("id"), null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[21] = new CSSPropertyVerifier(null, Arrays.asList("in"), null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[22] = new CSSPropertyVerifier(null, null, Arrays.asList("20 21?"), null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("none"), ElementInfo.MEDIA, null, Arrays.asList("22<1,10>[1,2]")));
            allelementVerifiers.remove(element);
        } else if ("cue-after".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("none"), ElementInfo.AURALMEDIA, Arrays.asList("ur")));
            allelementVerifiers.remove(element);
        } else if ("cue-before".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("none"), ElementInfo.AURALMEDIA, Arrays.asList("ur")));
            allelementVerifiers.remove(element);
        } else if ("cue".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[23] = new CSSPropertyVerifier(Arrays.asList("none"), Arrays.asList("ur"), null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[24] = new CSSPropertyVerifier(Arrays.asList("none"), Arrays.asList("ur"), null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.MEDIA, null, Arrays.asList("23a24")));
            allelementVerifiers.remove(element);
        } else if ("cursor".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[25] = new CSSPropertyVerifier(null, Arrays.asList("ur"), null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[141] = new CSSPropertyVerifier(null, Arrays.asList("in", "re"), null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[142] = new CSSPropertyVerifier(null, null, null, Arrays.asList("25 141 141", "25"), true, true);
            CSSTokenizerFilter.auxilaryVerifiers[26] = new CSSPropertyVerifier(Arrays.asList("auto", "default", "none", "context-menu", "help", "pointer", "progress", "wait", "cell", "crosshair", "text", "vertical-text", "alias", "copy", "move", "no-drop", "not-allowed", "grab", "grabbing", "e-resize", "n-resize", "ne-resize", "nw-resize", "s-resize", "se-resize", "sw-resize", "w-resize", "ew-resize", "ns-resize", "nesw-resize", "nwse-resize", "col-resize", "row-resize", "all-scroll", "zoom-in", "zoom-out"), null, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALINTERACTIVEMEDIA, null, Arrays.asList("142<0,10>[1,3] 26"), false, true));
            allelementVerifiers.remove(element);
        } else if ("direction".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("ltr", "rtl"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("display".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[131] = new CSSPropertyVerifier(Arrays.asList("block", "inline", "run-in"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[132] = new CSSPropertyVerifier(Arrays.asList("flow", "flow-root", "table", "flex", "grid", "ruby"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[133] = new CSSPropertyVerifier(Arrays.asList("list-item"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[134] = new CSSPropertyVerifier(Arrays.asList("flow", "flow-root"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[135] = new CSSPropertyVerifier(null, null, Arrays.asList("131?"), null, true);
            CSSTokenizerFilter.auxilaryVerifiers[136] = new CSSPropertyVerifier(null, null, Arrays.asList("134?"), null, true);
            CSSTokenizerFilter.auxilaryVerifiers[137] = new CSSPropertyVerifier(Arrays.asList("table-row-group", "table-header-group", "table-footer-group", "table-row", "table-cell", "table-column-group", "table-column", "table-caption", "ruby-base", "ruby-text", "ruby-base-container", "ruby-text-container"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[138] = new CSSPropertyVerifier(Arrays.asList("contents", "none"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[139] = new CSSPropertyVerifier(Arrays.asList("inline-block", "inline-list-item", "inline-table", "inline-flex", "inline-grid"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[140] = new CSSPropertyVerifier(null, null, Arrays.asList("133b135b136"), null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, null, Arrays.asList("131a132", "140<0,1>[1,3]", "137", "138", "139"), null, true));
            allelementVerifiers.remove(element);
        } else if ("dominant-baseline".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto", "text-bottom", "alphabetic", "ideographic", "middle", "central", "mathematical", "hanging", "text-top"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("elevation".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("below", "level", "above", "higher", "lower"), ElementInfo.AURALMEDIA, Arrays.asList("an")));
            allelementVerifiers.remove(element);
        } else if ("empty-cells".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("show", "hide"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("float".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("left", "right", "none", "inline-start", "inline-end"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("flex".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[119] = new CSSPropertyVerifier(null, null, Arrays.asList("in"));
            CSSTokenizerFilter.auxilaryVerifiers[120] = new CSSPropertyVerifier(Arrays.asList("content", "auto"), null, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("119a120")));
            allelementVerifiers.remove(element);
        } else if ("flex-basis".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("content", "auto"), ElementInfo.VISUALMEDIA, Arrays.asList("le", "pe")));
            allelementVerifiers.remove(element);
        } else if ("flex-direction".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("row", "row-reverse", "column", "column-reverse"), ElementInfo.VISUALMEDIA, null));
            allelementVerifiers.remove(element);
        } else if ("flex-flow".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[117] = new CSSPropertyVerifier(Arrays.asList("row", "row-reverse", "column", "column-reverse"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[118] = new CSSPropertyVerifier(Arrays.asList("nowrap", "wrap", "wrap-reverse"), null, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("117a118")));
            allelementVerifiers.remove(element);
        } else if ("flex-grow".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, Arrays.asList("in")));
            allelementVerifiers.remove(element);
        } else if ("flex-shrink".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, Arrays.asList("in")));
            allelementVerifiers.remove(element);
        } else if ("flex-wrap".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("nowrap", "wrap", "wrap-reverse"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("font-family".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new FontPropertyVerifier(false));
            allelementVerifiers.remove(element);
        } else if ("font-kerning".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto", "none", "normal"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("font-optical-sizing".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto", "none"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("font-size".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("xx-small", "x-small", "small", "medium", "large", "x-large", "xx-large", "xxx-large", "larger", "smaller"), ElementInfo.VISUALMEDIA, Arrays.asList("le", "pe")));
            allelementVerifiers.remove(element);
        } else if ("font-style".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("normal", "italic", "oblique"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("font-variant".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("normal", "small-caps"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("font-weight".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("normal", "bold", "bolder", "lighter", "100", "200", "300", "400", "500", "600", "700", "800", "900"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("font".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[27] = new CSSPropertyVerifier(Arrays.asList("normal", "italic", "oblique"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[28] = new CSSPropertyVerifier(Arrays.asList("normal", "small-caps"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[29] = new CSSPropertyVerifier(Arrays.asList("normal", "bold", "bolder", "lighter", "100", "200", "300", "400", "500", "600", "700", "800", "900"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[30] = new CSSPropertyVerifier(null, null, Arrays.asList("27a28a29"), null, true);
            CSSTokenizerFilter.auxilaryVerifiers[31] = new FontPartPropertyVerifier();
            CSSTokenizerFilter.auxilaryVerifiers[59] = new FontPropertyVerifier(true);
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("caption", "icon", "menu", "message-box", "small-caption", "status-bar"), ElementInfo.VISUALMEDIA, null, Arrays.asList("30<0,1>[1,3] 31<0,1>[1,3] 59"), false, true));
            allelementVerifiers.remove(element);
        } else if ("gap".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("85<1,2>")));
            allelementVerifiers.remove(element);
        } else if ("hanging-punctuation".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[97] = new CSSPropertyVerifier(Arrays.asList("allow-end", "force-end"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[98] = new CSSPropertyVerifier(Arrays.asList("first"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[99] = new CSSPropertyVerifier(Arrays.asList("last"), null, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("none"), ElementInfo.VISUALMEDIA, null, Arrays.asList("97a98a99")));
            allelementVerifiers.remove(element);
        } else if ("height".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto"), ElementInfo.VISUALMEDIA, Arrays.asList("le", "pe")));
            allelementVerifiers.remove(element);
        } else if ("hyphenate-character".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto"), ElementInfo.VISUALMEDIA, Arrays.asList("st")));
            allelementVerifiers.remove(element);
        } else if ("hyphens".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("none", "auto", "manual"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("image-orientation".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("none", "from-image"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("image-rendering".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto", "smooth", "crisp-edges", "pixelated"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("inline-size".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto"), ElementInfo.VISUALMEDIA, Arrays.asList("le", "pe")));
            allelementVerifiers.remove(element);
        } else if ("isolation".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto", "isolate"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("justify-content".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("121a124"), true, true));
            allelementVerifiers.remove(element);
        } else if ("justify-items".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("125", "130", "129"), true, true));
            allelementVerifiers.remove(element);
        } else if ("justify-self".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto", "stretch", "baseline", "last-baseline"), ElementInfo.VISUALMEDIA, null, Arrays.asList("127"), true, true));
            allelementVerifiers.remove(element);
        } else if ("left".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto"), ElementInfo.VISUALMEDIA, Arrays.asList("le", "pe")));
            allelementVerifiers.remove(element);
        } else if ("letter-spacing".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, null, ElementInfo.VISUALMEDIA, Arrays.asList("85<1,3>")));
            allelementVerifiers.remove(element);
        } else if ("line-height".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("normal"), ElementInfo.VISUALMEDIA, Arrays.asList("le", "pe", "re", "in")));
            allelementVerifiers.remove(element);
        } else if ("line-break".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto", "anywhere", "normal", "strict", "loose"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("list-style-image".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("none"), ElementInfo.VISUALMEDIA, Arrays.asList("ur")));
            allelementVerifiers.remove(element);
        } else if ("list-style-position".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("inside", "outside"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("list-style-type".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("35")));
            allelementVerifiers.remove(element);
        } else if ("list-style".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[33] = new CSSPropertyVerifier(Arrays.asList("none"), Arrays.asList("ur"), null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[34] = new CSSPropertyVerifier(Arrays.asList("inside", "outside"), null, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("33a34a35")));
            allelementVerifiers.remove(element);
        } else if ("margin-right".equalsIgnoreCase(element) || "margin-left".equalsIgnoreCase(element) || "margin-top".equalsIgnoreCase(element) || "margin-bottom".equalsIgnoreCase(element) || "margin-block-end".equalsIgnoreCase(element) || "margin-block-start".equalsIgnoreCase(element) || "margin-inline-end".equalsIgnoreCase(element) || "margin-inline-start".equalsIgnoreCase(element) || "scroll-padding-right".equalsIgnoreCase(element) || "scroll-padding-left".equalsIgnoreCase(element) || "scroll-padding-top".equalsIgnoreCase(element) || "scroll-padding-bottom".equalsIgnoreCase(element) || "scroll-padding-block-end".equalsIgnoreCase(element) || "scroll-padding-block-start".equalsIgnoreCase(element) || "scroll-padding-inline-end".equalsIgnoreCase(element) || "scroll-padding-inline-start".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("36")));
            allelementVerifiers.remove(element);
        } else if ("margin-block".equalsIgnoreCase(element) || "margin-inline".equalsIgnoreCase(element) || "scroll-padding-block".equalsIgnoreCase(element) || "scroll-padding-inline".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("36<1,2>")));
            allelementVerifiers.remove(element);
        } else if ("margin".equalsIgnoreCase(element) || "scroll-padding".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("36<1,4>")));
            allelementVerifiers.remove(element);
        } else if ("math-style".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("normal", "compact"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("max-width".equalsIgnoreCase(element) || "max-height".equalsIgnoreCase(element) || "max-block-size".equalsIgnoreCase(element) || "max-inline-size".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("none"), ElementInfo.VISUALMEDIA, Arrays.asList("le", "pe")));
            allelementVerifiers.remove(element);
        } else if ("min-width".equalsIgnoreCase(element) || "min-height".equalsIgnoreCase(element) || "min-block-size".equalsIgnoreCase(element) || "min-inline-size".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto"), ElementInfo.VISUALMEDIA, Arrays.asList("le", "pe")));
            allelementVerifiers.remove(element);
        } else if ("mix-blend-mode".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[148] = new CSSPropertyVerifier(Arrays.asList("normal", "multiply", "screen", "overlay", "darken", "lighten", "color-dodge", "color-burn", "hard-light", "soft-light", "difference", "exclusion", "hue", "saturation", "color", "luminosity"), null, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("148<1,2>"), true, true));
            allelementVerifiers.remove(element);
        } else if ("nav-down".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto"), ElementInfo.VISUALINTERACTIVEMEDIA, null, Arrays.asList("143 144?")));
            allelementVerifiers.remove(element);
        } else if ("nav-left".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto"), ElementInfo.VISUALINTERACTIVEMEDIA, null, Arrays.asList("143 144?")));
            allelementVerifiers.remove(element);
        } else if ("nav-right".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto"), ElementInfo.VISUALINTERACTIVEMEDIA, null, Arrays.asList("143 144?")));
            allelementVerifiers.remove(element);
        } else if ("nav-up".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto"), ElementInfo.VISUALINTERACTIVEMEDIA, null, Arrays.asList("143 144?")));
            allelementVerifiers.remove(element);
        } else if ("object-fit".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("contain", "cover", "fill", "none", "scale-down"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("background-position".equalsIgnoreCase(element) || "object-position".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALPAGEDMEDIA, null, Arrays.asList("4a5a40", "40 40", "4 5", "5 4", "4 40 5 40", "5 40 4 40")));
            allelementVerifiers.remove(element);
        } else if ("background-position-x".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALPAGEDMEDIA, null, Arrays.asList("2")));
            allelementVerifiers.remove(element);
        } else if ("background-position-y".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALPAGEDMEDIA, null, Arrays.asList("3")));
            allelementVerifiers.remove(element);
        } else if ("opacity".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALPAGEDMEDIA, Arrays.asList("re")));
            allelementVerifiers.remove(element);
        } else if ("order".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALPAGEDMEDIA, Arrays.asList("in")));
            allelementVerifiers.remove(element);
        } else if ("orphans".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALPAGEDMEDIA, Arrays.asList("in")));
            allelementVerifiers.remove(element);
        } else if ("outline-color".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALINTERACTIVEMEDIA, Arrays.asList("co")));
            allelementVerifiers.remove(element);
        } else if ("outline-offset".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, Arrays.asList("le")));
            allelementVerifiers.remove(element);
        } else if ("outline-style".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("none", "hidden", "dotted", "dashed", "solid", "double", "groove", "ridge", "inset", "outset"), ElementInfo.VISUALINTERACTIVEMEDIA));
            allelementVerifiers.remove(element);
        } else if ("outline-width".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("thin", "medium", "thick"), ElementInfo.VISUALINTERACTIVEMEDIA, Arrays.asList("le")));
            allelementVerifiers.remove(element);
        } else if ("outline".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[37] = new CSSPropertyVerifier(Arrays.asList("invert"), Arrays.asList("co"), null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[38] = new CSSPropertyVerifier(Arrays.asList("none", "hidden", "dotted", "dashed", "solid", "double", "groove", "ridge", "inset", "outset"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[39] = new CSSPropertyVerifier(Arrays.asList("thin", "medium", "thick"), Arrays.asList("le"), null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALINTERACTIVEMEDIA, Arrays.asList("le"), Arrays.asList("37a38a39")));
            allelementVerifiers.remove(element);
        } else if ("overflow".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[32] = new CSSPropertyVerifier(Arrays.asList("visible", "hidden", "scroll", "auto", "clip"), null, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("32<1,2>")));
        } else if ("overflow-x".equalsIgnoreCase(element) || "overflow-y".equalsIgnoreCase(element) || "overflow-block".equalsIgnoreCase(element) || "overflow-inline".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("visible", "hidden", "scroll", "auto", "clip"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("overscroll-behavior".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[64] = new CSSPropertyVerifier(Arrays.asList("auto", "contain", "none"), null, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("64<1,2>")));
        } else if ("overscroll-behavior-x".equalsIgnoreCase(element) || "overscroll-behavior-y".equalsIgnoreCase(element) || "overscroll-behavior-block".equalsIgnoreCase(element) || "overscroll-behavior-inline".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto", "contain", "none"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("padding-top".equalsIgnoreCase(element) || "padding-right".equalsIgnoreCase(element) || "padding-bottom".equalsIgnoreCase(element) || "padding-left".equalsIgnoreCase(element) || "padding-block-end".equalsIgnoreCase(element) || "padding-block-start".equalsIgnoreCase(element) || "padding-inline-end".equalsIgnoreCase(element) || "padding-inline-start".equalsIgnoreCase(element) || "scroll-margin-top".equalsIgnoreCase(element) || "scroll-margin-right".equalsIgnoreCase(element) || "scroll-margin-bottom".equalsIgnoreCase(element) || "scroll-margin-left".equalsIgnoreCase(element) || "scroll-margin-block-end".equalsIgnoreCase(element) || "scroll-margin-block-start".equalsIgnoreCase(element) || "scroll-margin-inline-end".equalsIgnoreCase(element) || "scroll-margin-inline-start".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("40")));
            allelementVerifiers.remove(element);
        } else if ("padding-block".equalsIgnoreCase(element) || "padding-inline".equalsIgnoreCase(element) || "scroll-margin-block".equalsIgnoreCase(element) || "scroll-margin-inline".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("40<1,2>")));
            allelementVerifiers.remove(element);
        } else if ("padding".equalsIgnoreCase(element) || "scroll-margin".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("40<1,4>")));
            allelementVerifiers.remove(element);
        } else if ("pause-after".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.AURALMEDIA, Arrays.asList("ti", "pe")));
            allelementVerifiers.remove(element);
        } else if ("pause-before".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.AURALMEDIA, Arrays.asList("ti", "pe")));
            allelementVerifiers.remove(element);
        } else if ("pause".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[41] = new CSSPropertyVerifier(null, Arrays.asList("ti", "pe"), null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, null, null, Arrays.asList("41<1,2>")));
            allelementVerifiers.remove(element);
        } else if ("perspective".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("none"), null, Arrays.asList("le")));
            allelementVerifiers.remove(element);
        } else if ("pitch-range".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.AURALMEDIA, Arrays.asList("in", "re")));
            allelementVerifiers.remove(element);
        } else if ("pitch".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("x-low", "low", "medium", "high", "x-high"), ElementInfo.AURALMEDIA, Arrays.asList("fr")));
            allelementVerifiers.remove(element);
        } else if ("play-during".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[42] = new CSSPropertyVerifier(null, Arrays.asList("ur"), null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[43] = new CSSPropertyVerifier(Arrays.asList("mix"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[44] = new CSSPropertyVerifier(Arrays.asList("repeat"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[45] = new CSSPropertyVerifier(null, null, Arrays.asList("43a44"), null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto", "none"), ElementInfo.AURALMEDIA, null, Arrays.asList("42 45<0,1>[1,2]")));
            allelementVerifiers.remove(element);
        } else if ("punctuation-trim".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[86] = new CSSPropertyVerifier(Arrays.asList("start"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[87] = new CSSPropertyVerifier(Arrays.asList("end", "allow-end"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[88] = new CSSPropertyVerifier(Arrays.asList("adjacent"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[89] = new CSSPropertyVerifier(null, null, Arrays.asList("86a87a88"), null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("none"), ElementInfo.AURALMEDIA, null, Arrays.asList("89")));
            allelementVerifiers.remove(element);
        } else if ("position".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("static", "relative", "absolute", "fixed", "sticky"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("pointer-events".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto", "none"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("quotes".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[46] = new CSSPropertyVerifier(null, Arrays.asList("st"), null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[47] = new CSSPropertyVerifier(null, null, Arrays.asList("46 46"), null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("none"), null, ElementInfo.VISUALMEDIA, Arrays.asList("47<1,10>[2,2]")));
            allelementVerifiers.remove(element);
        } else if ("resize".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("none", "both", "horizontal", "vertical"), ElementInfo.VISUALMEDIA, null));
            allelementVerifiers.remove(element);
        } else if ("richness".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.AURALMEDIA, Arrays.asList("re", "in")));
            allelementVerifiers.remove(element);
        } else if ("right".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto"), ElementInfo.VISUALMEDIA, Arrays.asList("le", "pe")));
            allelementVerifiers.remove(element);
        } else if ("rotate".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[141] = new CSSPropertyVerifier(null, Arrays.asList("in", "re"), null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[73] = new CSSPropertyVerifier(null, Arrays.asList("an"), null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[15] = new CSSPropertyVerifier(Arrays.asList("x", "y", "z"), null, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("none"), ElementInfo.VISUALMEDIA, null, Arrays.asList("73", "15 73", "141 141 141 73")));
            allelementVerifiers.remove(element);
        } else if ("ruby-align".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("start", "center", "space-between", "space-around"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("ruby-position".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("over", "under"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("row-gap".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("normal"), ElementInfo.VISUALMEDIA, Arrays.asList("le", "pe")));
            allelementVerifiers.remove(element);
        } else if ("scroll-behavior".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto", "smooth"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("scroll-snap-align".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[82] = new CSSPropertyVerifier(Arrays.asList("none", "start", "end", "center"), null, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("82<1,2>")));
            allelementVerifiers.remove(element);
        } else if ("scroll-snap-stop".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("normal", "always"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("scroll-snap-type".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[103] = new CSSPropertyVerifier(Arrays.asList("x", "y", "block", "inline", "both"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[80] = new CSSPropertyVerifier(Arrays.asList("mandatory", "proximity"), null, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("none"), ElementInfo.VISUALMEDIA, null, Arrays.asList("103", "103 80")));
            allelementVerifiers.remove(element);
        } else if ("speak-header".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("once", "always"), ElementInfo.AURALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("speak-numeral".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("digits", "continuous"), ElementInfo.AURALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("speak-punctuation".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("code", "none"), ElementInfo.AURALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("speak".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("normal", "none", "spell-out"), ElementInfo.AURALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("speech-rate".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("x-slow", "slow", "medium", "fast", "x-fast", "faster", "slower"), ElementInfo.AURALMEDIA, Arrays.asList("re", "in")));
            allelementVerifiers.remove(element);
        } else if ("stress".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.AURALMEDIA, Arrays.asList("re", "in")));
            allelementVerifiers.remove(element);
        } else if ("table-layout".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto", "fixed"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("tab-size".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, Arrays.asList("le", "in")));
            allelementVerifiers.remove(element);
        } else if ("text-align".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("start", "end", "left", "right", "center", "justify", "match-parent"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("text-align-last".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("start", "end", "left", "right", "center", "justify"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("text-autospace".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[90] = new CSSPropertyVerifier(Arrays.asList("ideograph-numeric"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[91] = new CSSPropertyVerifier(Arrays.asList("ideograph-alpha"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[92] = new CSSPropertyVerifier(Arrays.asList("ideograph-space"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[93] = new CSSPropertyVerifier(Arrays.asList("ideograph-parenthesis"), null, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("none"), ElementInfo.VISUALMEDIA, null, Arrays.asList("90a91a92a93")));
            allelementVerifiers.remove(element);
        } else if ("text-combine-upright".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("none", "all"), ElementInfo.VISUALMEDIA, null, null));
            allelementVerifiers.remove(element);
        } else if ("text-decoration".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("115a11a104a116")));
            allelementVerifiers.remove(element);
        } else if ("text-decoration-color".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("11")));
            allelementVerifiers.remove(element);
        } else if ("text-decoration-line".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("none"), ElementInfo.VISUALMEDIA, null, Arrays.asList("100a101a102")));
            allelementVerifiers.remove(element);
        } else if ("text-decoration-skip".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[48] = new CSSPropertyVerifier(Arrays.asList("images"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[49] = new CSSPropertyVerifier(Arrays.asList("spaces"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[50] = new CSSPropertyVerifier(Arrays.asList("ink"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[51] = new CSSPropertyVerifier(Arrays.asList("all"), null, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("none"), ElementInfo.VISUALMEDIA, null, Arrays.asList("48a49a50a51")));
            allelementVerifiers.remove(element);
        } else if ("text-decoration-skip-ink".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("none", "auto", "all"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("text-decoration-style".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("104")));
            allelementVerifiers.remove(element);
        } else if ("text-decoration-thickness".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("from-font", "auto"), ElementInfo.VISUALMEDIA, Arrays.asList("le", "pe")));
            allelementVerifiers.remove(element);
        } else if ("text-emphasis".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("11a107")));
            allelementVerifiers.remove(element);
        } else if ("text-emphasis-color".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("11")));
            allelementVerifiers.remove(element);
        } else if ("text-emphasis-position".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("over", "under"), ElementInfo.VISUALMEDIA, null, null));
            allelementVerifiers.remove(element);
        } else if ("text-emphasis-style".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("107")));
            allelementVerifiers.remove(element);
        } else if ("text-indent".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[94] = new CSSPropertyVerifier(Arrays.asList("hanging", "each-line"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[95] = new CSSPropertyVerifier(null, null, Arrays.asList("94<0,2>"), null, true);
            CSSTokenizerFilter.auxilaryVerifiers[96] = new CSSPropertyVerifier(null, Arrays.asList("le", "pe"), null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("96 95")));
            allelementVerifiers.remove(element);
        } else if ("text-justify".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[83] = new CSSPropertyVerifier(Arrays.asList("inter-word", "inter-ideograph", "inter-cluster", "distribute", "kashida"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[84] = new CSSPropertyVerifier(Arrays.asList("trim"), null, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto"), ElementInfo.VISUALMEDIA, null, Arrays.asList("84a83")));
            allelementVerifiers.remove(element);
        } else if ("text-orientation".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("mixed", "upright", "sideways", "sideways-right"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("text-outline".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[108] = new CSSPropertyVerifier(null, null, Arrays.asList("11 72 72<0,1>"), null, true);
            CSSTokenizerFilter.auxilaryVerifiers[109] = new CSSPropertyVerifier(null, null, Arrays.asList("72 72<0,1> 11"), null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("none"), ElementInfo.VISUALMEDIA, null, Arrays.asList("108a109")));
            allelementVerifiers.remove(element);
        } else if ("text-overflow".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("clip", "ellipsis"), ElementInfo.VISUALMEDIA, Arrays.asList("st")));
            allelementVerifiers.remove(element);
        } else if ("text-shadow".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("none"), ElementInfo.VISUALMEDIA, null, Arrays.asList("79"), true, true));
            allelementVerifiers.remove(element);
        } else if ("text-transform".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("capitalize", "uppercase", "lowercase", "none", "fullwidth", "full-size-kana", "math-auto"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("text-underline-offset".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("36")));
            allelementVerifiers.remove(element);
        } else if ("text-underline-position".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto", "under", "left", "right"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("text-wrap".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("wrap", "nowrap", "balance"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("text-wrap-mode".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("wrap", "nowrap"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("text-wrap-style".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto", "balance", "stable", "pretty", "avoid-orphans"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("top".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto"), ElementInfo.VISUALMEDIA, Arrays.asList("le", "pe")));
            allelementVerifiers.remove(element);
        } else if ("transform".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[110] = new CSSPropertyVerifier(null, Arrays.asList("tr"), null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("110<0,65536>"), true, true));
            allelementVerifiers.remove(element);
        } else if ("transform-origin".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[111] = new CSSPropertyVerifier(null, null, Arrays.asList("2 3<0,1>"), null, true);
            CSSTokenizerFilter.auxilaryVerifiers[112] = new CSSPropertyVerifier(Arrays.asList("left", "center", "right"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[113] = new CSSPropertyVerifier(Arrays.asList("top", "center", "bottom"), null, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[114] = new CSSPropertyVerifier(null, null, Arrays.asList("112a113"), null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("111", "114"), true, true));
            allelementVerifiers.remove(element);
        } else if ("unicode-bidi".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("normal", "embed", "bidi-override", "isolate", "isolate-override", "plaintext"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("translate".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("none"), ElementInfo.VISUALMEDIA, null, Arrays.asList("40", "40 40", "40 40 72")));
            allelementVerifiers.remove(element);
        } else if ("vertical-align".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("baseline", "sub", "super", "top", "text-top", "middle", "bottom", "text-bottom"), ElementInfo.VISUALMEDIA, Arrays.asList("pe", "le")));
            allelementVerifiers.remove(element);
        } else if ("visibility".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("visible", "hidden", "collapse"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("voice-family".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new VoiceFamilyPropertyVerifier(false));
            allelementVerifiers.remove(element);
        } else if ("volume".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("silent", "x-soft", "soft", "medium", "loud", "x-loud"), ElementInfo.AURALMEDIA, Arrays.asList("re", "le", "pe")));
            allelementVerifiers.remove(element);
        } else if ("white-space".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("normal", "pre", "nowrap", "pre-wrap", "pre-line"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("white-space-collapse".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("preserve", "preserve-break", "collapse", "discard", "break-spaces"), null, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("widows".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, Arrays.asList("in")));
            allelementVerifiers.remove(element);
        } else if ("width".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto"), ElementInfo.VISUALMEDIA, Arrays.asList("le", "pe")));
            allelementVerifiers.remove(element);
        } else if ("word-break".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("normal", "break-all", "hyphenate", "keep-all"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("word-spacing".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, null, ElementInfo.VISUALMEDIA, Arrays.asList("85<1,3>")));
            allelementVerifiers.remove(element);
        } else if ("word-wrap".equalsIgnoreCase(element) || "overflow-wrap".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("normal", "break-word", "anywhere"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("writing-mode".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("horizontal-tb", "vertical-rl", "vertical-lr", "lr", "lr-tb", "rl", "tb", "tb-lr", "tb-rl"), ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("z-index".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("auto"), ElementInfo.VISUALMEDIA, Arrays.asList("in")));
            allelementVerifiers.remove(element);
        } else if ("zoom".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(Arrays.asList("normal"), ElementInfo.VISUALMEDIA, Arrays.asList("re", "pe")));
            allelementVerifiers.remove(element);
        } else if ("transition-delay".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("145<1,65535>"), false, true));
            allelementVerifiers.remove(element);
        } else if ("transition-duration".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("145<1,65535>"), false, true));
            allelementVerifiers.remove(element);
        } else if ("transition-property".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("146<1,65535>"), false, true));
            allelementVerifiers.remove(element);
        } else if ("transition-timing-function".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("147<1,65535>"), false, true));
            allelementVerifiers.remove(element);
        }
    }

    private static synchronized CSSPropertyVerifier getVerifier(String element) {
        if (elementVerifiers.get(element = element.toLowerCase()) != null) {
            return elementVerifiers.get(element);
        }
        if (allelementVerifiers.contains(element)) {
            CSSTokenizerFilter.addVerifier(element);
            return elementVerifiers.get(element);
        }
        return null;
    }

    private boolean verifyToken(String[] media, String[] elements, CSSPropertyVerifier obj, ParsedWord[] words) {
        if (words == null) {
            return false;
        }
        if (logDEBUG) {
            Logger.debug(this, "verifyToken for " + CSSPropertyVerifier.toString(words));
        }
        if (obj == null) {
            return false;
        }
        int important = this.checkImportant(words);
        if (important > 0) {
            if (words.length == important) {
                return true;
            }
            words = Arrays.copyOf(words, words.length - important);
        }
        return obj.checkValidity(media, elements, words, this.cb);
    }

    private int checkImportant(ParsedWord[] words) {
        if (words.length == 0) {
            return 0;
        }
        if (words.length >= 1 && words[words.length - 1] instanceof SimpleParsedWord && ((SimpleParsedWord)words[words.length - 1]).original.equalsIgnoreCase("!important")) {
            return 1;
        }
        if (words.length >= 2 && words[words.length - 1] instanceof ParsedIdentifier && words[words.length - 2] instanceof SimpleParsedWord && ((SimpleParsedWord)words[words.length - 2]).original.equals("!") && ((ParsedIdentifier)words[words.length - 1]).original.equalsIgnoreCase("important")) {
            return 2;
        }
        return 0;
    }

    public static String HTMLelementVerifier(String elementString, boolean isIDSelector) {
        boolean elementValid;
        int index;
        if (logDEBUG) {
            Logger.debug(CSSTokenizerFilter.class, "varifying element/selector: \"" + elementString + "\"");
        }
        String HTMLelement = "";
        String pseudoClass = "";
        String className = "";
        String id = "";
        StringBuilder fBuffer = new StringBuilder();
        ArrayList<String> attSelections = null;
        while (elementString.indexOf(91) != -1 && elementString.indexOf(93) != -1 && elementString.indexOf(91) < elementString.indexOf(93)) {
            if (isIDSelector) {
                return null;
            }
            String attSelection = elementString.substring(elementString.indexOf(91) + 1, elementString.indexOf(93)).trim();
            StringBuilder buf = new StringBuilder(elementString);
            buf.delete(elementString.indexOf(91), elementString.indexOf(93) + 1);
            elementString = buf.toString();
            if (logDEBUG) {
                Logger.debug(CSSTokenizerFilter.class, "attSelection=" + attSelection + "  elementString=" + elementString);
            }
            if (attSelections == null) {
                attSelections = new ArrayList<String>();
            }
            attSelections.add(attSelection);
        }
        if (elementString.indexOf(58) != -1) {
            if (isIDSelector) {
                return null;
            }
            int index2 = elementString.indexOf(58);
            if (index2 != elementString.length() - 1) {
                pseudoClass = elementString.substring(index2 + 1, elementString.length()).trim();
                HTMLelement = elementString.substring(0, index2).trim();
                if (logDEBUG) {
                    Logger.debug(CSSTokenizerFilter.class, "pseudoclass=" + pseudoClass + " HTMLelement=" + HTMLelement);
                }
            } else {
                HTMLelement = elementString.trim();
            }
        } else {
            HTMLelement = elementString.trim();
        }
        if (HTMLelement.indexOf(46) != -1) {
            if (isIDSelector) {
                return null;
            }
            int index3 = HTMLelement.indexOf(46);
            if (index3 != HTMLelement.length() - 1) {
                className = HTMLelement.substring(index3 + 1, HTMLelement.length()).trim();
                HTMLelement = HTMLelement.substring(0, index3).trim();
                if (logDEBUG) {
                    Logger.debug(CSSTokenizerFilter.class, "class=" + className + " HTMLelement=" + HTMLelement);
                }
            }
        } else if (HTMLelement.indexOf(35) != -1 && (index = HTMLelement.indexOf(35)) != HTMLelement.length() - 1) {
            id = HTMLelement.substring(index + 1, HTMLelement.length()).trim();
            HTMLelement = HTMLelement.substring(0, index).trim();
            if (logDEBUG) {
                Logger.debug(CSSTokenizerFilter.class, "id=" + id + " element=" + HTMLelement);
            }
        }
        if (isIDSelector && id.isEmpty()) {
            return null;
        }
        boolean bl = elementValid = "*".equals(HTMLelement) || "~".equals(HTMLelement) || ElementInfo.isValidHTMLTag(HTMLelement.toLowerCase()) || HTMLelement.trim().isEmpty() && (!className.isEmpty() || !id.isEmpty() || attSelections != null || !pseudoClass.isEmpty());
        if (!elementValid) {
            return null;
        }
        if (!className.isEmpty() ? !ElementInfo.isValidName(className) : !id.isEmpty() && !ElementInfo.isValidName(id)) {
            return null;
        }
        if (!pseudoClass.isEmpty()) {
            if (!ElementInfo.isValidPseudoClass(pseudoClass)) {
                return null;
            }
            if (ElementInfo.isBannedPseudoClass(pseudoClass)) {
                return "";
            }
        }
        if (attSelections != null) {
            for (String attSelection : attSelections) {
                String[] attSelectionParts = new String[]{attSelection};
                List<String> operators = Arrays.asList("|=", "~=", "^=", "$=", "*=", "=");
                for (String comparisonOperator : operators) {
                    if (!attSelection.contains(comparisonOperator)) continue;
                    attSelectionParts = new String[]{attSelection.substring(0, attSelection.indexOf(comparisonOperator)), attSelection.substring(attSelection.indexOf(comparisonOperator) + comparisonOperator.length())};
                    break;
                }
                if (logDEBUG) {
                    Logger.debug(CSSTokenizerFilter.class, "HTMLelementVerifier length of attSelectionParts=" + attSelectionParts.length);
                }
                if (attSelectionParts[0].isEmpty()) {
                    return null;
                }
                char c = attSelectionParts[0].charAt(0);
                if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                    return null;
                }
                for (int i = 1; i < attSelectionParts[0].length(); ++i) {
                    c = attSelectionParts[0].charAt(i);
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '-') continue;
                    return null;
                }
                if (attSelectionParts.length <= 1) continue;
                if (logDEBUG) {
                    Logger.debug(CSSTokenizerFilter.class, "RHS is \"" + attSelectionParts[1] + "\"");
                }
                if (ElementInfo.isValidIdentifier(attSelectionParts[1]) || ElementInfo.isValidStringWithQuotes(attSelectionParts[1])) continue;
                return null;
            }
        }
        fBuffer.append(HTMLelement);
        if (!className.isEmpty()) {
            fBuffer.append('.');
            fBuffer.append(className);
        } else if (!id.isEmpty()) {
            fBuffer.append('#');
            fBuffer.append(id);
        }
        if (!pseudoClass.isEmpty()) {
            fBuffer.append(':');
            fBuffer.append(pseudoClass);
        }
        if (attSelections != null) {
            for (String attSelection : attSelections) {
                fBuffer.append('[');
                fBuffer.append(attSelection);
                fBuffer.append(']');
            }
        }
        return fBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public String recursiveSelectorVerifier(String selectorString) {
        if (logDEBUG) {
            Logger.debug(this, "selector: \"" + selectorString + "\"");
        }
        selectorString = selectorString.trim();
        int index = -1;
        char selector = '\u0000';
        char quoting = '\u0000';
        boolean escaping = false;
        int bracketing = 0;
        boolean eatLF = false;
        int escapedDigits = 0;
        for (int i = 0; i < selectorString.length(); ++i) {
            block50: {
                char c = selectorString.charAt(i);
                if (c == '+' && quoting == '\u0000' && !escaping && bracketing == 0) {
                    if (index == -1 || index == i - 1 && selector == ' ') {
                        index = i;
                        selector = c;
                    }
                } else if (c == '>' && quoting == '\u0000' && !escaping) {
                    if (index == -1 || index == i - 1 && selector == ' ') {
                        index = i;
                        selector = c;
                    }
                } else if (c == ' ' && quoting == '\u0000' && !escaping) {
                    if (index == -1 || index == i - 1 && selector == ' ') {
                        index = i;
                        selector = c;
                    }
                } else if (c == '(' && quoting == '\u0000' && !escaping) {
                    ++bracketing;
                } else if (c == ')' && quoting == '\u0000' && !escaping) {
                    --bracketing;
                } else if (c == '\'' && quoting == '\u0000' && !escaping) {
                    quoting = c;
                } else if (c == '\"' && quoting == '\u0000' && !escaping) {
                    quoting = c;
                } else if (c == quoting && !escaping) {
                    quoting = '\u0000';
                } else if (c == '\n' && eatLF) {
                    escaping = false;
                    eatLF = false;
                } else {
                    if (!(c != '\r' && c != '\n' && c != '\f' || quoting != '\u0000' && escaping)) {
                        if (logDEBUG) {
                            Logger.debug(this, "no newlines unless in a string *and* quoted at index " + i);
                        }
                        return null;
                    }
                    if (c == '\r' && escaping && escapedDigits == 0) {
                        escaping = false;
                        eatLF = true;
                    } else {
                        if ((c == '\n' || c == '\f') && escaping) {
                            if (escapedDigits == 0) {
                                escaping = false;
                                break block50;
                            } else {
                                if (logDEBUG) {
                                    Logger.debug(this, "invalid newline escaping at char " + i);
                                }
                                return null;
                            }
                        }
                        if (escaping && (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F')) {
                            if (++escapedDigits == 6) {
                                escaping = false;
                            }
                        } else if (escaping && escapedDigits > 0 && " \t\r\n\f".indexOf(c) != -1) {
                            escaping = false;
                            if (c == '\r') {
                                eatLF = true;
                            }
                        } else if (c == '\\' && !escaping) {
                            escaping = true;
                        } else {
                            if (c == '\\' && escaping && escapedDigits > 0) {
                                if (logDEBUG) {
                                    Logger.debug(this, "backslash but already escaping with digits at char " + i);
                                }
                                return null;
                            }
                            if (c == '\\' && escaping) {
                                escaping = false;
                            } else if (escaping) {
                                escaping = false;
                            }
                        }
                    }
                }
            }
            eatLF = false;
        }
        if (logDEBUG) {
            Logger.debug(this, "index=" + index + " quoting=" + quoting + " selector=" + selector + " for \"" + selectorString + "\"");
        }
        if (quoting != '\u0000') {
            return null;
        }
        if (bracketing != 0) {
            return null;
        }
        if (index == -1) {
            return CSSTokenizerFilter.HTMLelementVerifier(selectorString, false);
        }
        String[] parts = new String[]{selectorString.substring(0, index).trim(), selectorString.substring(index + 1, selectorString.length()).trim()};
        if (logDEBUG) {
            Logger.debug(this, "recursiveSelectorVerifier parts[0]=" + parts[0] + " parts[1]=" + parts[1]);
        }
        parts[0] = CSSTokenizerFilter.HTMLelementVerifier(parts[0], false);
        parts[1] = this.recursiveSelectorVerifier(parts[1]);
        if (parts[0] != null && parts[1] != null) {
            return parts[0] + selector + parts[1];
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public void parse() throws IOException {
        STATE1 = true;
        STATE2 = 2;
        STATE3 = 3;
        STATECOMMENT = 4;
        STATE1INQUOTE = 5;
        STATE2INQUOTE = 6;
        STATE3INQUOTE = 7;
        currentQuote = '\"';
        stateBeforeComment = 0;
        currentState = 1;
        isState1Present = false;
        elements = null;
        filteredTokens = new StringBuilder();
        buffer = new StringBuilder();
        openBraces = 0;
        defaultMedia = "screen";
        currentMedia = new String[]{defaultMedia};
        propertyName = "";
        propertyValue = "";
        ignoreElementsS1 = false;
        ignoreElementsS2 = false;
        ignoreElementsS3 = false;
        closeIgnoredS2 = false;
        c = '\u0000';
        prevc = '\u0000';
        s2Comma = false;
        canImport = true;
        whitespaceAfterColon = "";
        whitespaceBeforeProperty = "";
        charsetPossible = true;
        bomPossible = true;
        openBracesStartingS3 = 0;
        forPage = false;
        if (this.isInline) {
            currentState = 3;
        }
        block54: while (true) {
            x = this.r.read();
            if (x == -1) {
                if (currentState != 3 || c == ';' || propertyName.isEmpty() || !propertyValue.isEmpty()) break;
                x = 59;
            }
            if (x == 65279) {
                if (!bomPossible) continue;
                if (CSSTokenizerFilter.logDEBUG) {
                    Logger.debug(this, "Ignoring BOM");
                }
                this.w.write(x);
                continue;
            }
            bomPossible = false;
            prevc = c;
            c = (char)x;
            if (CSSTokenizerFilter.logDEBUG) {
                Logger.debug(this, "Read: " + c + " 0x" + Integer.toHexString(c));
            }
            if (prevc == '/' && c == '*' && currentState != 5 && currentState != 6 && currentState != 7 && currentState != 4) {
                stateBeforeComment = currentState;
                currentState = 4;
                if (buffer.charAt(buffer.length() - 1) == '/') {
                    buffer.deleteCharAt(buffer.length() - 1);
                }
                if (CSSTokenizerFilter.logDEBUG) {
                    Logger.debug(this, "Comment detected: buffer=" + buffer);
                }
                prevc = '\u0000';
            }
            if (c == '\u0000') continue;
            block2 : switch (currentState) {
                case 1: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case ' ': {
                            buffer.append(c);
                            if (!CSSTokenizerFilter.logDEBUG) break block2;
                            Logger.debug(this, "STATE1 CASE whitespace: " + c);
                            break block2;
                        }
                        case '@': {
                            if (prevc != '\\') {
                                isState1Present = true;
                                if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "STATE1 CASE @: " + c);
                                }
                            }
                            buffer.append(c);
                            break block2;
                        }
                        case '{': {
                            charsetPossible = false;
                            if (this.stopAtDetectedCharset) {
                                return;
                            }
                            if (prevc == '\\') {
                                buffer.append(c);
                                break block2;
                            }
                            ++openBraces;
                            isState1Present = false;
                            i = 0;
                            for (i = 0; i < buffer.length() && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); ++i) {
                            }
                            braceSpace = buffer.substring(0, i);
                            buffer.delete(0, i);
                            if (buffer.length() > 4 && buffer.substring(0, 4).equals("<!--")) {
                                braceSpace = braceSpace + buffer.substring(0, 4);
                                if (" \t\r\n".indexOf(buffer.charAt(4)) == -1) {
                                    Logger.error(this, "<!-- not followed by whitespace!");
                                    return;
                                }
                                buffer.delete(0, 4);
                                for (i = 0; i < buffer.length() && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); ++i) {
                                }
                                braceSpace = braceSpace + buffer.substring(0, i);
                                buffer.delete(0, i);
                            }
                            for (i = buffer.length() - 1; i >= 0 && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); --i) {
                            }
                            postSpace = buffer.substring(++i);
                            buffer.setLength(i);
                            orig = buffer.toString().trim();
                            parts = CSSTokenizerFilter.split(orig, false);
                            if (CSSTokenizerFilter.logDEBUG) {
                                Logger.debug(this, "Split: " + CSSPropertyVerifier.toString(parts));
                            }
                            buffer.setLength(0);
                            valid = false;
                            if (parts != null) {
                                if (parts.length < 1) {
                                    ignoreElementsS1 = true;
                                    if (CSSTokenizerFilter.logDEBUG) {
                                        Logger.debug(this, "STATE1 CASE {: Does not have one part. ignoring " + buffer.toString());
                                    }
                                    valid = false;
                                } else if (parts[0] instanceof SimpleParsedWord && "@media".equals(((SimpleParsedWord)parts[0]).original.toLowerCase())) {
                                    if (parts.length < 2) {
                                        ignoreElementsS1 = true;
                                        if (CSSTokenizerFilter.logDEBUG) {
                                            Logger.debug(this, "STATE1 CASE {: Does not have two parts. ignoring " + buffer.toString());
                                        }
                                        valid = false;
                                    } else {
                                        medias = this.commaListFromIdentifiers(parts, 1);
                                        if (medias != null && !medias.isEmpty()) {
                                            for (i = 0; i < medias.size(); ++i) {
                                                if (FilterUtils.isMedia(medias.get(i))) continue;
                                                medias.remove(i);
                                                --i;
                                            }
                                        }
                                        if (medias != null && !medias.isEmpty()) {
                                            filteredTokens.append(braceSpace);
                                            filteredTokens.append("@media ");
                                            first = true;
                                            for (String media : medias) {
                                                if (!first) {
                                                    filteredTokens.append(", ");
                                                }
                                                first = false;
                                                filteredTokens.append(media);
                                            }
                                            filteredTokens.append(postSpace);
                                            filteredTokens.append("{");
                                            valid = true;
                                            currentMedia = medias.toArray(new String[medias.size()]);
                                        }
                                    }
                                } else if (parts[0] instanceof SimpleParsedWord && "@page".equals(((SimpleParsedWord)parts[0]).original.toLowerCase())) {
                                    if (parts.length == 0) {
                                        valid = true;
                                    } else {
                                        valid = true;
                                        for (j = 1; j < parts.length; ++j) {
                                            if (!(parts[j] instanceof SimpleParsedWord)) {
                                                valid = false;
                                                break;
                                            }
                                            s = ((SimpleParsedWord)parts[j]).original;
                                            if (s.equalsIgnoreCase(":left") || s.equalsIgnoreCase(":right") || s.equals(":first")) continue;
                                            valid = false;
                                            break;
                                        }
                                    }
                                    if (valid) {
                                        forPage = true;
                                        filteredTokens.append(braceSpace);
                                        filteredTokens.append(orig);
                                        filteredTokens.append(postSpace);
                                        filteredTokens.append("{");
                                    }
                                }
                            }
                            if (!valid) {
                                ignoreElementsS1 = true;
                                if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "STATE1 CASE {: Failed verification test. ignoring " + buffer.toString());
                                }
                            } else {
                                this.w.write(filteredTokens.toString());
                                filteredTokens.setLength(0);
                            }
                            buffer.setLength(0);
                            s2Comma = false;
                            if (forPage) {
                                currentState = 3;
                                openBracesStartingS3 = openBraces;
                            } else {
                                currentState = 2;
                            }
                            buffer.setLength(0);
                            break block2;
                        }
                        case ';': {
                            if (prevc == '\\') {
                                buffer.append(c);
                                break block2;
                            }
                            if (CSSTokenizerFilter.logDEBUG) {
                                Logger.debug(this, "buffer in state 1 ; : \"" + buffer.toString() + "\"");
                            }
                            for (i = 0; i < buffer.length() && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); ++i) {
                            }
                            this.w.write(buffer.substring(0, i));
                            buffer.delete(0, i);
                            if (buffer.length() > 4 && buffer.substring(0, 4).equals("<!--")) {
                                this.w.write(buffer.substring(0, 4));
                                if (" \t\r\n".indexOf(buffer.charAt(4)) == -1) {
                                    Logger.error(this, "<!-- not followed by whitespace!");
                                    return;
                                }
                                buffer.delete(0, 4);
                                for (i = 0; i < buffer.length() && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); ++i) {
                                }
                                this.w.write(buffer.substring(0, i));
                                buffer.delete(0, i);
                            }
                            if (canImport && !ignoreElementsS1 && buffer.toString().contains("@import")) {
                                if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "STATE1 CASE ;statement=" + buffer.toString());
                                }
                                if ("".equals((strbuffer = buffer.toString().trim()).substring(0, importIndex = strbuffer.toLowerCase().indexOf("@import")).trim()) && (strparts = CSSTokenizerFilter.split(str1 = strbuffer.substring(importIndex + 7, strbuffer.length()), false)) != null && strparts.length > 0 && (strparts[0] instanceof ParsedURL || strparts[0] instanceof ParsedString)) {
                                    uri = strparts[0] instanceof ParsedString != false ? ((ParsedString)strparts[0]).getDecoded() : ((ParsedURL)strparts[0]).getDecoded();
                                    medias = this.commaListFromIdentifiers(strparts, 1);
                                    if (medias != null) {
                                        output = new StringBuilder();
                                        output.append("@import url(\"");
                                        try {
                                            s = this.cb.processURI(uri, "text/css");
                                            if (this.passedCharset != null) {
                                                s = s.indexOf(63) == -1 ? s + "?maybecharset=" + this.passedCharset : s + "&maybecharset=" + this.passedCharset;
                                            }
                                            output.append(s);
                                            output.append("\")");
                                            first = true;
                                            for (String media : medias) {
                                                if (!FilterUtils.isMedia(media)) continue;
                                                if (!first) {
                                                    output.append(", ");
                                                } else {
                                                    output.append(' ');
                                                }
                                                first = false;
                                                output.append(media);
                                            }
                                            output.append(";");
                                            this.w.write(output.toString());
                                        }
                                        catch (CommentException var48_78) {}
                                    }
                                }
                            } else if (charsetPossible && buffer.toString().startsWith("@charset ")) {
                                s = buffer.delete(0, "@charset ".length()).toString();
                                this.detectedCharset = s = CSSTokenizerFilter.removeOuterQuotes(s);
                                if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "Detected charset: \"" + this.detectedCharset + "\"");
                                }
                                if (!Charset.isSupported(this.detectedCharset)) {
                                    Logger.normal(this, "Charset not supported: " + this.detectedCharset);
                                    throw new UnsupportedCharsetInFilterException("Charset not supported: " + this.detectedCharset);
                                }
                                if (this.stopAtDetectedCharset) {
                                    return;
                                }
                                if (this.passedCharset != null && !this.detectedCharset.equalsIgnoreCase(this.passedCharset)) {
                                    Logger.normal(this, "Detected charset \"" + this.detectedCharset + "\" differs from passed in charset \"" + this.passedCharset + "\"");
                                    throw new IOException("Detected charset differs from passed in charset");
                                }
                                this.w.write("@charset \"" + this.detectedCharset + "\";");
                            }
                            isState1Present = false;
                            ignoreElementsS1 = false;
                            buffer.setLength(0);
                            charsetPossible = false;
                            break block2;
                        }
                        case '\"': 
                        case '\'': {
                            if (prevc == '\\') {
                                buffer.append(c);
                                break block2;
                            }
                            buffer.append(c);
                            currentState = 5;
                            currentQuote = c;
                            break block2;
                        }
                    }
                    buffer.append(c);
                    if (!(isState1Present || (s = buffer.toString().trim()).isEmpty() || s.equals("/") || s.equals("<") || s.equals("<!") || s.equals("<!-") || s.equals("<!--"))) {
                        currentState = 2;
                    }
                    if (!CSSTokenizerFilter.logDEBUG) break;
                    Logger.debug(this, "STATE1 default CASE: " + c);
                    break;
                }
                case 5: {
                    if (CSSTokenizerFilter.logDEBUG) {
                        Logger.debug(this, "STATE1INQUOTE: " + c);
                    }
                    switch (c) {
                        case '\"': {
                            if (currentQuote == '\"' && prevc != '\\') {
                                currentState = 1;
                            }
                            buffer.append(c);
                            break;
                        }
                        case '\'': {
                            if (currentQuote == '\'' && prevc != '\\') {
                                currentState = 1;
                            }
                            buffer.append(c);
                            break;
                        }
                        case '\n': {
                            if (prevc == '\r') break;
                        }
                        case '\f': 
                        case '\r': {
                            if (prevc != '\\') {
                                ignoreElementsS1 = true;
                                currentState = 1;
                                break;
                            }
                            buffer.setLength(buffer.length() - 1);
                            break;
                        }
                        default: {
                            buffer.append(c);
                            break;
                        }
                    }
                    continue block54;
                }
                case 2: {
                    canImport = false;
                    charsetPossible = false;
                    if (this.stopAtDetectedCharset) {
                        return;
                    }
                    switch (c) {
                        case '{': {
                            if (prevc == '\\') {
                                buffer.append(c);
                                break block2;
                            }
                            i = 0;
                            for (i = 0; i < buffer.length() && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); ++i) {
                            }
                            if (CSSTokenizerFilter.logDEBUG) {
                                Logger.debug(this, "Appending whitespace in state2: \"" + buffer.substring(0, i) + "\"");
                            }
                            ws = buffer.substring(0, i);
                            buffer.delete(0, i);
                            if (buffer.length() > 4 && buffer.substring(0, 4).equals("<!--")) {
                                ws = ws + buffer.substring(0, 4);
                                if (" \t\r\n".indexOf(buffer.charAt(4)) == -1) {
                                    Logger.error(this, "<!-- not followed by whitespace!");
                                    return;
                                }
                                buffer.delete(0, 4);
                                for (i = 0; i < buffer.length() && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); ++i) {
                                }
                                ws = ws + buffer.substring(0, i);
                                buffer.delete(0, i);
                            }
                            ++openBraces;
                            if (!buffer.toString().trim().isEmpty()) {
                                filtered = this.recursiveSelectorVerifier(buffer.toString());
                                if (filtered != null && !"".equals(filtered)) {
                                    if (s2Comma) {
                                        filteredTokens.append(",");
                                        s2Comma = false;
                                    }
                                    filteredTokens.append(ws);
                                    filteredTokens.append(filtered);
                                    filteredTokens.append(" {");
                                } else if (s2Comma && "".equals(filtered)) {
                                    s2Comma = false;
                                    filteredTokens.append(ws);
                                    filteredTokens.append(" {");
                                } else {
                                    ignoreElementsS2 = true;
                                    filteredTokens.setLength(0);
                                }
                                if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "STATE2 CASE { filtered elements" + filtered);
                                }
                            } else {
                                ignoreElementsS2 = true;
                                filteredTokens.setLength(0);
                            }
                            currentState = 3;
                            openBracesStartingS3 = openBraces;
                            if (CSSTokenizerFilter.logDEBUG) {
                                Logger.debug(this, "STATE2 -> STATE3, openBracesStartingS3 = " + openBracesStartingS3);
                            }
                            buffer.setLength(0);
                            break block2;
                        }
                        case ',': {
                            if (prevc == '\\') {
                                buffer.append(c);
                                break block2;
                            }
                            for (i = 0; i < buffer.length() && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); ++i) {
                            }
                            if (CSSTokenizerFilter.logDEBUG) {
                                Logger.debug(this, "Appending whitespace in state2: \"" + buffer.substring(0, i) + "\"");
                            }
                            ws = buffer.substring(0, i);
                            buffer.delete(0, i);
                            if (!s2Comma && buffer.length() > 4 && buffer.substring(0, 4).equals("<!--")) {
                                filteredTokens.append(buffer.substring(0, 4));
                                if (" \t\r\n".indexOf(buffer.charAt(4)) == -1) {
                                    Logger.error(this, "<!-- not followed by whitespace!");
                                    return;
                                }
                                buffer.delete(0, 4);
                                for (i = 0; i < buffer.length() && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); ++i) {
                                }
                                filteredTokens.append(buffer.substring(0, i));
                                buffer.delete(0, i);
                            }
                            filtered = this.recursiveSelectorVerifier(buffer.toString().trim());
                            if (CSSTokenizerFilter.logDEBUG) {
                                Logger.debug(this, "STATE2 CASE , filtered elements" + filtered);
                            }
                            if (filtered != null && !"".equals(filtered)) {
                                if (s2Comma) {
                                    filteredTokens.append(",");
                                } else {
                                    s2Comma = true;
                                }
                                filteredTokens.append(ws);
                                filteredTokens.append(filtered);
                            } else if ("".equals(filtered)) {
                                filteredTokens.append(ws);
                            }
                            buffer.setLength(0);
                            break block2;
                        }
                        case '}': {
                            if (prevc == '\\') {
                                buffer.append(c);
                                break block2;
                            }
                            if (openBraces > 0 && !ignoreElementsS1) {
                                if (--openBraces >= 0) {
                                    filteredTokens.append('}');
                                } else {
                                    openBraces = 0;
                                }
                                if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "Writing \"" + filteredTokens + "\"");
                                }
                                this.w.write(filteredTokens.toString());
                            } else {
                                if (openBraces > 0) {
                                    --openBraces;
                                }
                                ignoreElementsS1 = false;
                            }
                            filteredTokens.setLength(0);
                            buffer.setLength(0);
                            currentMedia = new String[]{defaultMedia};
                            isState1Present = false;
                            currentState = 1;
                            if (this.isInline) {
                                return;
                            }
                            if (!CSSTokenizerFilter.logDEBUG) break block2;
                            Logger.debug(this, "STATE2 CASE }: " + c);
                            break block2;
                        }
                        case '\"': 
                        case '\'': {
                            if (prevc == '\\') {
                                buffer.append(c);
                                break block2;
                            }
                            buffer.append(c);
                            currentState = 6;
                            currentQuote = c;
                            break block2;
                        }
                    }
                    buffer.append(c);
                    if (!CSSTokenizerFilter.logDEBUG) break;
                    Logger.debug(this, "STATE2 default CASE: " + c);
                    break;
                }
                case 6: {
                    if (CSSTokenizerFilter.logDEBUG) {
                        Logger.debug(this, "STATE2INQUOTE: " + c);
                    }
                    charsetPossible = false;
                    switch (c) {
                        case '\"': {
                            if (currentQuote == '\"' && prevc != '\\') {
                                currentState = 2;
                            }
                            buffer.append(c);
                            break;
                        }
                        case '\'': {
                            if (currentQuote == '\'' && prevc != '\\') {
                                currentState = 2;
                            }
                            buffer.append(c);
                            break;
                        }
                        case '\n': {
                            if (prevc == '\r') break;
                        }
                        case '\f': 
                        case '\r': {
                            if (prevc != '\\') {
                                ignoreElementsS2 = true;
                                closeIgnoredS2 = true;
                                currentState = 2;
                                break;
                            }
                            buffer.setLength(buffer.length() - 1);
                            break;
                        }
                        default: {
                            buffer.append(c);
                            break;
                        }
                    }
                    continue block54;
                }
                case 3: {
                    charsetPossible = false;
                    if (this.stopAtDetectedCharset) {
                        return;
                    }
                    switch (c) {
                        case ':': {
                            if (prevc == '\\') {
                                buffer.append(c);
                                break block2;
                            }
                            if (openBraces > openBracesStartingS3) {
                                buffer.append(c);
                                if (!CSSTokenizerFilter.logDEBUG) break block2;
                                Logger.debug(this, "openBraces now " + openBraces + " not moving on because openBracesStartingS3=" + openBracesStartingS3 + " in S3");
                                break block2;
                            }
                            i = 0;
                            for (i = 0; i < buffer.length() && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); ++i) {
                            }
                            if (CSSTokenizerFilter.logDEBUG) {
                                Logger.debug(this, "Appending whitespace: " + buffer.substring(0, i));
                            }
                            whitespaceBeforeProperty = buffer.substring(0, i);
                            propertyName = buffer.delete(0, i).toString().trim();
                            if (CSSTokenizerFilter.logDEBUG) {
                                Logger.debug(this, "Property name: " + propertyName);
                            }
                            buffer.setLength(0);
                            if (!CSSTokenizerFilter.logDEBUG) break block2;
                            Logger.debug(this, "STATE3 CASE :: " + c);
                            break block2;
                        }
                        case ';': {
                            if (prevc == '\\') {
                                buffer.append(c);
                                break block2;
                            }
                            if (openBraces > openBracesStartingS3) {
                                buffer.append(c);
                                if (!CSSTokenizerFilter.logDEBUG) break block2;
                                Logger.debug(this, "openBraces now " + openBraces + " not moving on because openBracesStartingS3=" + openBracesStartingS3 + " in S3");
                                break block2;
                            }
                            i = 0;
                            for (i = 0; i < buffer.length() && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); ++i) {
                            }
                            if (CSSTokenizerFilter.logDEBUG) {
                                Logger.debug(this, "Appending whitespace after colon: \"" + buffer.substring(0, i) + "\"");
                            }
                            whitespaceAfterColon = buffer.substring(0, i);
                            propertyValue = buffer.delete(0, i).toString().trim();
                            if (CSSTokenizerFilter.logDEBUG) {
                                Logger.debug(this, "Property value: " + propertyValue);
                            }
                            buffer.setLength(0);
                            obj = CSSTokenizerFilter.getVerifier(propertyName);
                            if (obj != null) {
                                words = CSSTokenizerFilter.split(propertyValue, obj.allowCommaDelimiters);
                                if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "Split: " + CSSPropertyVerifier.toString(words));
                                }
                                if (words != null && !ignoreElementsS2 && !ignoreElementsS3 && this.verifyToken(currentMedia, elements, obj, words)) {
                                    if (this.changedAnything(words)) {
                                        propertyValue = this.reconstruct(words);
                                    }
                                    filteredTokens.append(whitespaceBeforeProperty);
                                    whitespaceBeforeProperty = "";
                                    filteredTokens.append(propertyName);
                                    filteredTokens.append(':');
                                    filteredTokens.append(whitespaceAfterColon);
                                    filteredTokens.append(propertyValue);
                                    filteredTokens.append(';');
                                    if (CSSTokenizerFilter.logDEBUG) {
                                        Logger.debug(this, "STATE3 CASE ;: appending " + propertyName + ":" + propertyValue);
                                    }
                                    if (CSSTokenizerFilter.logDEBUG) {
                                        Logger.debug(this, "filtered tokens now: \"" + filteredTokens.toString() + "\"");
                                    }
                                } else if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "filtered tokens now (ignored): \"" + filteredTokens.toString() + "\" words=" + CSSPropertyVerifier.toString(words) + " ignoreS1=" + ignoreElementsS1 + " ignoreS2=" + ignoreElementsS2 + " ignoreS3=" + ignoreElementsS3);
                                }
                            } else if (CSSTokenizerFilter.logDEBUG) {
                                Logger.debug(this, "No such property name \"" + propertyName + "\"");
                            }
                            ignoreElementsS3 = false;
                            propertyName = "";
                            propertyValue = "";
                            break block2;
                        }
                        case '}': {
                            if (prevc == '\\') {
                                buffer.append(c);
                                break block2;
                            }
                            if (--openBraces > openBracesStartingS3 - 1) {
                                buffer.append(c);
                                if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "openBraces now " + openBraces + " not moving on because openBracesStartingS3=" + openBracesStartingS3 + " in S3");
                                }
                                if (openBraces >= 0) break block2;
                                openBraces = 0;
                                break block2;
                            }
                            if (openBraces < 0) {
                                openBraces = 0;
                            }
                            for (i = buffer.length() - 1; i >= 0 && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); --i) {
                            }
                            postSpace = buffer.substring(++i);
                            buffer.setLength(i);
                            if (propertyName != "") {
                                i = 0;
                                for (i = 0; i < buffer.length() && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); ++i) {
                                }
                                if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "Appending whitespace after colon (}): " + buffer.substring(0, i));
                                }
                                whitespaceAfterColon = buffer.substring(0, i);
                                buffer.delete(0, i);
                                propertyValue = buffer.toString().trim();
                                if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "Property value: " + propertyValue);
                                }
                                buffer.setLength(0);
                                obj = CSSTokenizerFilter.getVerifier(propertyName);
                                if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "Found PropertyName:" + propertyName + " propertyValue:" + propertyValue);
                                }
                                if (obj != null) {
                                    words = CSSTokenizerFilter.split(propertyValue, obj.allowCommaDelimiters);
                                    if (CSSTokenizerFilter.logDEBUG) {
                                        Logger.debug(this, "Split: " + CSSPropertyVerifier.toString(words));
                                    }
                                    if (!ignoreElementsS2 && !ignoreElementsS3 && this.verifyToken(currentMedia, elements, obj, words)) {
                                        if (this.changedAnything(words)) {
                                            propertyValue = this.reconstruct(words);
                                        }
                                        filteredTokens.append(whitespaceBeforeProperty);
                                        whitespaceBeforeProperty = "";
                                        filteredTokens.append(propertyName);
                                        filteredTokens.append(':');
                                        filteredTokens.append(whitespaceAfterColon);
                                        filteredTokens.append(propertyValue);
                                        if (CSSTokenizerFilter.logDEBUG) {
                                            Logger.debug(this, "STATE3 CASE }: appending " + propertyName + ":" + propertyValue);
                                        }
                                    }
                                } else if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "No such property name \"" + propertyName + "\"");
                                }
                                propertyName = "";
                            } else {
                                i = 0;
                                for (i = 0; i < buffer.length() && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); ++i) {
                                }
                                if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "Appending whitespace after colon (}): " + buffer.substring(0, i));
                                }
                                filteredTokens.append(buffer.substring(0, i));
                                buffer.delete(0, i);
                            }
                            ignoreElementsS3 = false;
                            if (!ignoreElementsS2 || closeIgnoredS2) {
                                filteredTokens.append(postSpace);
                                filteredTokens.append("}");
                                closeIgnoredS2 = false;
                                ignoreElementsS2 = false;
                            } else {
                                ignoreElementsS2 = false;
                            }
                            if (!ignoreElementsS1) {
                                this.w.write(filteredTokens.toString());
                                if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "writing filtered tokens: \"" + filteredTokens.toString() + "\"");
                                }
                            }
                            filteredTokens.setLength(0);
                            whitespaceAfterColon = "";
                            if (forPage) {
                                forPage = false;
                                currentState = 1;
                            } else {
                                currentState = 2;
                            }
                            if (this.isInline) {
                                return;
                            }
                            buffer.setLength(0);
                            s2Comma = false;
                            if (!CSSTokenizerFilter.logDEBUG) break block2;
                            Logger.debug(this, "STATE3 CASE }: " + c);
                            break block2;
                        }
                        case '{': {
                            ++openBraces;
                            buffer.append(c);
                            if (!CSSTokenizerFilter.logDEBUG) break block2;
                            Logger.debug(this, "openBraces now " + openBraces + " in S3");
                            break block2;
                        }
                        case '\"': 
                        case '\'': {
                            if (prevc == '\\') {
                                buffer.append(c);
                                break block2;
                            }
                            buffer.append(c);
                            currentState = 7;
                            currentQuote = c;
                            break block2;
                        }
                    }
                    buffer.append(c);
                    if (!CSSTokenizerFilter.logDEBUG) break;
                    Logger.debug(this, "STATE3 default CASE : " + c);
                    break;
                }
                case 7: {
                    charsetPossible = false;
                    if (this.stopAtDetectedCharset) {
                        return;
                    }
                    if (CSSTokenizerFilter.logDEBUG) {
                        Logger.debug(this, "STATE3INQUOTE: " + c);
                    }
                    switch (c) {
                        case '\"': {
                            if (currentQuote == '\"' && prevc != '\\') {
                                currentState = 3;
                            }
                            buffer.append(c);
                            break;
                        }
                        case '\'': {
                            if (currentQuote == '\'' && prevc != '\\') {
                                currentState = 3;
                            }
                            buffer.append(c);
                            break;
                        }
                        case '\n': {
                            if (prevc == '\r') break;
                        }
                        case '\f': 
                        case '\r': {
                            if (prevc != '\\') {
                                ignoreElementsS3 = true;
                                currentState = 3;
                                break;
                            }
                            buffer.setLength(buffer.length() - 1);
                            break;
                        }
                        default: {
                            buffer.append(c);
                            break;
                        }
                    }
                    continue block54;
                }
                case 4: {
                    charsetPossible = false;
                    if (this.stopAtDetectedCharset) {
                        return;
                    }
                    switch (c) {
                        case '/': {
                            if (prevc == '*') {
                                currentState = stateBeforeComment;
                                c = '\u0000';
                                if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "Exiting the comment state " + currentState);
                                } else {
                                    ** GOTO lbl764
                                }
                            } else {
                                ** GOTO lbl764
                            }
                        }
                    }
                }
            }
lbl764:
            // 49 sources

        }
        if (CSSTokenizerFilter.logDEBUG) {
            Logger.debug(this, "Filtered tokens: \"" + filteredTokens + "\"");
        }
        this.w.write(filteredTokens.toString());
        for (i = 0; i < openBraces; ++i) {
            this.w.write(125);
        }
        if (CSSTokenizerFilter.logDEBUG) {
            Logger.debug(this, "Remaining buffer: \"" + buffer + "\"");
        }
        i = 0;
        for (i = 0; i < buffer.length() && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); ++i) {
        }
        this.w.write(buffer.substring(0, i));
        buffer.delete(0, i);
        while (buffer.toString().trim().equals("-->")) {
            this.w.write("-->");
            buffer.delete(0, 3);
            for (i = 0; i < buffer.length() && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); ++i) {
            }
            this.w.write(buffer.substring(0, i));
            buffer.delete(0, i);
        }
    }

    private String reconstruct(ParsedWord[] words) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        ParsedWord lastWord = null;
        for (ParsedWord word : words) {
            if (lastWord != null && lastWord.postComma) {
                sb.append(',');
            }
            lastWord = word;
            if (!first) {
                sb.append(" ");
            }
            if (!word.changed) {
                sb.append(word.original);
                if (logDEBUG) {
                    Logger.debug(this, "Adding word (original): \"" + word.original + "\"");
                }
            } else {
                sb.append(word.encode(false));
                if (logDEBUG) {
                    Logger.debug(this, "Adding word (new): \"" + word.encode(false) + "\"");
                }
            }
            first = false;
        }
        if (logDEBUG) {
            Logger.debug(this, "Reconstructed: \"" + sb.toString() + "\"");
        }
        return sb.toString();
    }

    private boolean changedAnything(ParsedWord[] words) {
        for (ParsedWord word : words) {
            if (!word.changed) continue;
            return true;
        }
        return false;
    }

    private ArrayList<String> commaListFromIdentifiers(ParsedWord[] strparts, int offset) {
        ArrayList<String> medias = new ArrayList<String>(strparts.length - 1);
        if (strparts.length > offset) {
            if (strparts.length == offset + 1 && strparts[1] instanceof ParsedIdentifier) {
                medias.add(((ParsedIdentifier)strparts[1]).getDecoded());
            } else {
                boolean first = true;
                for (ParsedWord word : strparts) {
                    if (first) {
                        first = false;
                        continue;
                    }
                    if (word instanceof ParsedIdentifier) {
                        medias.add(((ParsedIdentifier)word).getDecoded());
                        continue;
                    }
                    if (word instanceof SimpleParsedWord) {
                        String data = ((SimpleParsedWord)word).original;
                        String[] split = FilterUtils.removeWhiteSpace(data.split(","), false);
                        medias.addAll(Arrays.asList(split));
                        continue;
                    }
                    return null;
                }
            }
        }
        return medias;
    }

    private static ParsedWord[] split(String input, boolean allowCommaDelimiters) {
        if (logDEBUG) {
            Logger.debug(CSSTokenizerFilter.class, "Splitting \"" + input + "\" allowCommaDelimiters=" + allowCommaDelimiters);
        }
        ArrayList<ParsedWord> words = new ArrayList<ParsedWord>();
        ParsedWord lastWord = null;
        char c = '\u0000';
        char stringchar = '\u0000';
        boolean escaping = false;
        boolean eatLF = false;
        StringBuilder origToken = new StringBuilder(input.length());
        StringBuilder decodedToken = new StringBuilder(input.length());
        boolean dontLikeOrigToken = false;
        StringBuilder escape = new StringBuilder(6);
        boolean couldBeIdentifier = true;
        boolean addComma = false;
        int bracketCount = 0;
        for (int i = 0; i < input.length(); ++i) {
            c = input.charAt(i);
            if (stringchar == '\u0000') {
                if (eatLF && c == '\n') {
                    eatLF = false;
                    continue;
                }
                eatLF = false;
                if (!escaping) {
                    if ((" \t\r\n\f".indexOf(c) != -1 || allowCommaDelimiters && c == ',') && bracketCount == 0) {
                        if (c == ',') {
                            if (decodedToken.length() == 0) {
                                if (lastWord == null) {
                                    if (logDEBUG) {
                                        Logger.debug(CSSTokenizerFilter.class, "Extra comma before first element in \"" + input + "\" i=" + i);
                                    }
                                    return null;
                                }
                                if (lastWord.postComma) {
                                    if (logDEBUG) {
                                        Logger.debug(CSSTokenizerFilter.class, "Extra comma after element " + lastWord + " in \"" + input + "\" i=" + i);
                                    }
                                    lastWord.changed = true;
                                } else {
                                    lastWord.postComma = true;
                                }
                            } else {
                                if (addComma) {
                                    if (logDEBUG) {
                                        Logger.debug(CSSTokenizerFilter.class, "Extra comma after a comma in \"" + input + "\" i=" + i);
                                    }
                                    return null;
                                }
                                addComma = true;
                            }
                        }
                        if (decodedToken.length() <= 0) continue;
                        ParsedWord word = CSSTokenizerFilter.parseToken(origToken, decodedToken, dontLikeOrigToken, couldBeIdentifier);
                        if (logDEBUG) {
                            Logger.debug(CSSTokenizerFilter.class, "Token: orig: \"" + origToken.toString() + "\" decoded: \"" + decodedToken.toString() + "\" dontLike=" + dontLikeOrigToken + " couldBeIdentifier=" + couldBeIdentifier + " parsed " + word);
                        }
                        if (word == null) {
                            return null;
                        }
                        if (addComma) {
                            word.postComma = true;
                            addComma = false;
                        }
                        words.add(word);
                        origToken.setLength(0);
                        decodedToken.setLength(0);
                        dontLikeOrigToken = false;
                        couldBeIdentifier = true;
                        lastWord = word;
                        continue;
                    }
                    if (c == '\"') {
                        stringchar = c;
                        origToken.append(c);
                        decodedToken.append(c);
                        couldBeIdentifier = false;
                        continue;
                    }
                    if (c == '\'') {
                        stringchar = c;
                        origToken.append(c);
                        decodedToken.append(c);
                        couldBeIdentifier = false;
                        continue;
                    }
                    if (c == '\\') {
                        origToken.append(c);
                        escape.setLength(0);
                        escaping = true;
                        continue;
                    }
                    if (c == '(') {
                        ++bracketCount;
                        origToken.append(c);
                        decodedToken.append(c);
                        couldBeIdentifier = false;
                        continue;
                    }
                    if (c == ')') {
                        if (--bracketCount < 0) {
                            return null;
                        }
                        origToken.append(c);
                        decodedToken.append(c);
                        couldBeIdentifier = false;
                        continue;
                    }
                    if (couldBeIdentifier) {
                        if (!(c >= '0' && c <= '9' && origToken.length() > 0 || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '-' || c == '_' || c >= '\u00a1')) {
                            couldBeIdentifier = false;
                        }
                        if (origToken.length() == 1 && origToken.charAt(0) == '-' && c >= '0' && c <= '9') {
                            couldBeIdentifier = false;
                        }
                    }
                    origToken.append(c);
                    decodedToken.append(c);
                    continue;
                }
                if (escaping && escape.length() == 0) {
                    if (c == '\"' || c == '\'') {
                        escaping = false;
                        origToken.append(c);
                        decodedToken.append(c);
                        continue;
                    }
                    if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') {
                        escape.append(c);
                        continue;
                    }
                    if (c == '\n' || c == '\r' || c == '\f') {
                        return null;
                    }
                    escaping = false;
                    origToken.append(c);
                    decodedToken.append(c);
                    continue;
                }
                if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') {
                    escape.append(c);
                    if (escape.length() != 6) continue;
                    origToken.append((CharSequence)escape);
                    decodedToken.append((char)Integer.parseInt(escape.toString(), 16));
                    escape.setLength(0);
                    escaping = false;
                    continue;
                }
                if (" \t\r\n\f".indexOf(c) != -1) {
                    origToken.append((CharSequence)escape);
                    decodedToken.append((char)Integer.parseInt(escape.toString(), 16));
                    origToken.append(" ");
                    escape.setLength(0);
                    escaping = false;
                    if (c != '\r') continue;
                    eatLF = true;
                    continue;
                }
                return null;
            }
            if (eatLF && c == '\n') {
                eatLF = false;
                origToken.append(c);
                continue;
            }
            eatLF = false;
            if (c == stringchar && !escaping) {
                origToken.append(c);
                decodedToken.append(c);
                stringchar = '\u0000';
                continue;
            }
            if (c == '\f' || c == '\r' || c == '\n' && !escaping) {
                return null;
            }
            if (c == '\\' && !escaping) {
                escaping = true;
                escape.setLength(0);
                origToken.append(c);
                continue;
            }
            if (escaping && escape.length() == 0) {
                if (c == '\"' || c == '\'') {
                    escaping = false;
                    origToken.append(c);
                    decodedToken.append(c);
                    continue;
                }
                if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') {
                    escape.append(c);
                    continue;
                }
                if (c == '\r' || c == '\n' || c == '\f') {
                    origToken.append(c);
                    if (c != '\r') continue;
                    eatLF = true;
                    continue;
                }
                origToken.append(c);
                decodedToken.append(c);
                escaping = false;
                continue;
            }
            if (escaping) {
                if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') {
                    escape.append(c);
                    if (escape.length() != 6) continue;
                    origToken.append((CharSequence)escape);
                    decodedToken.append((char)Integer.parseInt(escape.toString(), 16));
                    escape.setLength(0);
                    escaping = false;
                    continue;
                }
                if (" \t\r\n\f".indexOf(c) != -1) {
                    origToken.append((CharSequence)escape);
                    decodedToken.append((char)Integer.parseInt(escape.toString(), 16));
                    escape.setLength(0);
                    escaping = false;
                    if (c != '\r') continue;
                    eatLF = true;
                    dontLikeOrigToken = true;
                    continue;
                }
                return null;
            }
            origToken.append(c);
            decodedToken.append(c);
        }
        if (escaping && escape.length() > 0) {
            origToken.append((CharSequence)escape);
            decodedToken.append((char)Integer.parseInt(escape.toString(), 16));
        } else if (escaping) {
            dontLikeOrigToken = true;
        }
        if (origToken.length() > 0) {
            ParsedWord word;
            if (logDEBUG) {
                Logger.debug(CSSTokenizerFilter.class, "Token: orig: \"" + origToken.toString() + "\" decoded: \"" + decodedToken.toString() + "\" dontLike=" + dontLikeOrigToken + " couldBeIdentifier=" + couldBeIdentifier);
            }
            if ((word = CSSTokenizerFilter.parseToken(origToken, decodedToken, dontLikeOrigToken, couldBeIdentifier)) == null) {
                return null;
            }
            words.add(word);
        }
        return words.toArray(new ParsedWord[words.size()]);
    }

    private static ParsedWord parseToken(StringBuilder origToken, StringBuilder decodedToken, boolean dontLikeOrigToken, boolean couldBeIdentifier) {
        char c;
        if (origToken.length() > 2 && ((c = origToken.charAt(0)) == '\'' || c == '\"')) {
            char d = origToken.charAt(origToken.length() - 1);
            if (c == d) {
                decodedToken.setLength(decodedToken.length() - 1);
                decodedToken.deleteCharAt(0);
                return new ParsedString(origToken.toString(), decodedToken.toString(), dontLikeOrigToken, c);
            }
            if (d != ',') {
                return null;
            }
            return new SimpleParsedWord(origToken.toString());
        }
        String s = origToken.toString();
        if (couldBeIdentifier) {
            return new ParsedIdentifier(s, decodedToken.toString(), dontLikeOrigToken);
        }
        String sl = s.toLowerCase();
        if (sl.startsWith("url(")) {
            if (s.endsWith(")")) {
                char c2;
                int i;
                decodedToken.delete(0, 4);
                decodedToken.setLength(decodedToken.length() - 1);
                if (logDEBUG) {
                    Logger.debug(CSSTokenizerFilter.class, "stripped: " + decodedToken);
                }
                String strippedOrig = s.substring(4, s.length() - 1);
                for (i = 0; i < strippedOrig.length() && ((c2 = strippedOrig.charAt(i)) == ' ' || c2 == '\t'); ++i) {
                }
                decodedToken.delete(0, i);
                strippedOrig = strippedOrig.substring(i);
                for (i = strippedOrig.length() - 1; !(i < 0 || (c2 = strippedOrig.charAt(i)) != ' ' && c2 != '\t' || i > 0 && strippedOrig.charAt(i - 1) == '\\'); --i) {
                }
                decodedToken.setLength(decodedToken.length() - (strippedOrig.length() - i - 1));
                strippedOrig = strippedOrig.substring(0, i + 1);
                if (logDEBUG) {
                    Logger.debug(CSSTokenizerFilter.class, "whitespace stripped: " + strippedOrig + " decoded " + decodedToken);
                }
                if (strippedOrig.isEmpty()) {
                    return null;
                }
                if (strippedOrig.length() > 2 && ((c2 = strippedOrig.charAt(0)) == '\'' || c2 == '\"')) {
                    char d = strippedOrig.charAt(strippedOrig.length() - 1);
                    if (c2 == d) {
                        decodedToken.setLength(decodedToken.length() - 1);
                        decodedToken.deleteCharAt(0);
                        if (logDEBUG) {
                            Logger.debug(CSSTokenizerFilter.class, "creating url(): orig=\"" + origToken.toString() + "\" decoded=\"" + decodedToken.toString() + "\"");
                        }
                        return new ParsedURL(origToken.toString(), decodedToken.toString(), dontLikeOrigToken, c2);
                    }
                    return null;
                }
                return new ParsedURL(origToken.toString(), decodedToken.toString(), dontLikeOrigToken, '\u0000');
            }
            return null;
        }
        if (sl.startsWith("attr(")) {
            if (s.endsWith(")")) {
                char c3;
                int i;
                decodedToken.delete(0, 5);
                decodedToken.setLength(decodedToken.length() - 1);
                String strippedOrig = s.substring(4, s.length() - 1);
                for (i = 0; i < strippedOrig.length() && ((c3 = strippedOrig.charAt(i)) == ' ' || c3 == '\t'); ++i) {
                }
                decodedToken.delete(0, i);
                strippedOrig = strippedOrig.substring(i);
                for (i = strippedOrig.length() - 1; !(i < 0 || (c3 = strippedOrig.charAt(i)) != ' ' && c3 != '\t' || i > 0 && strippedOrig.charAt(i - 1) == '\\'); --i) {
                }
                decodedToken.setLength(decodedToken.length() - (strippedOrig.length() - i - 1));
                strippedOrig = strippedOrig.substring(0, i + 1);
                if (strippedOrig.isEmpty()) {
                    return null;
                }
                return new ParsedAttr(origToken.toString(), decodedToken.toString(), dontLikeOrigToken);
            }
            return null;
        }
        boolean plural = false;
        if (sl.startsWith("counter(") || (plural = sl.startsWith("counters("))) {
            if (s.endsWith(")")) {
                char c4;
                int i;
                int len = plural ? "counters(".length() : "counter(".length();
                decodedToken.delete(0, len);
                decodedToken.setLength(decodedToken.length() - 1);
                String strippedOrig = s.substring(len, s.length() - 1);
                for (i = 0; i < strippedOrig.length() && ((c4 = strippedOrig.charAt(i)) == ' ' || c4 == '\t'); ++i) {
                }
                decodedToken.delete(0, i);
                strippedOrig = strippedOrig.substring(i);
                for (i = strippedOrig.length() - 1; !(i < 0 || (c4 = strippedOrig.charAt(i)) != ' ' && c4 != '\t' || i > 0 && strippedOrig.charAt(i - 1) == '\\'); --i) {
                }
                decodedToken.setLength(decodedToken.length() - (strippedOrig.length() - i - 1));
                strippedOrig = strippedOrig.substring(0, i + 1);
                if (strippedOrig.isEmpty()) {
                    return null;
                }
                String[] split = FilterUtils.removeWhiteSpace(strippedOrig.split(","), false);
                if (split.length == 0 || plural && split.length > 3 || !plural && split.length > 2 || plural && split.length < 2) {
                    return null;
                }
                ParsedIdentifier ident = CSSTokenizerFilter.makeParsedIdentifier(split[0]);
                if (ident == null) {
                    return null;
                }
                ParsedString separator = null;
                ParsedIdentifier listType = null;
                if (plural && (separator = CSSTokenizerFilter.makeParsedString(split[1])) == null) {
                    return null;
                }
                if ((!plural && split.length == 2 || plural && split.length == 3) && (listType = CSSTokenizerFilter.makeParsedIdentifier(split[split.length - 1])) == null) {
                    return null;
                }
                return new ParsedCounter(origToken.toString(), ident, listType, separator);
            }
            return null;
        }
        return new SimpleParsedWord(origToken.toString());
    }

    private static ParsedIdentifier makeParsedIdentifier(String string) {
        ParsedWord[] words = CSSTokenizerFilter.split(string, false);
        if (words == null) {
            return null;
        }
        if (words.length != 1) {
            return null;
        }
        if (!(words[0] instanceof ParsedIdentifier)) {
            return null;
        }
        return (ParsedIdentifier)words[0];
    }

    private static ParsedString makeParsedString(String string) {
        ParsedWord[] words = CSSTokenizerFilter.split(string, false);
        if (words == null) {
            return null;
        }
        if (words.length != 1) {
            return null;
        }
        if (!(words[0] instanceof ParsedString)) {
            return null;
        }
        return (ParsedString)words[0];
    }

    public static String removeOuterQuotes(String decoded) {
        if (decoded.length() < 2) {
            return decoded;
        }
        char first = decoded.charAt(0);
        if (first != '\'' && first != '\"') {
            return decoded;
        }
        if (decoded.charAt(decoded.length() - 1) == first) {
            return decoded.substring(1, decoded.length() - 1);
        }
        return decoded;
    }

    public String detectedCharset() {
        return this.detectedCharset;
    }

    static {
        Logger.registerClass(CSSTokenizerFilter.class);
        elementVerifiers = new HashMap<String, CSSPropertyVerifier>();
        allelementVerifiers = new HashSet();
        allelementVerifiers.add("accent-color");
        allelementVerifiers.add("align-content");
        allelementVerifiers.add("align-items");
        allelementVerifiers.add("align-self");
        allelementVerifiers.add("all");
        allelementVerifiers.add("appearance");
        allelementVerifiers.add("azimuth");
        allelementVerifiers.add("backface-visibility");
        allelementVerifiers.add("background-attachment");
        allelementVerifiers.add("background-blend-mode");
        allelementVerifiers.add("background-clip");
        allelementVerifiers.add("background-color");
        allelementVerifiers.add("background-image");
        allelementVerifiers.add("background-origin");
        allelementVerifiers.add("background-position");
        allelementVerifiers.add("background-position-x");
        allelementVerifiers.add("background-position-y");
        allelementVerifiers.add("background-repeat");
        allelementVerifiers.add("background-size");
        allelementVerifiers.add("background");
        allelementVerifiers.add("block-size");
        allelementVerifiers.add("border-collapse");
        allelementVerifiers.add("border-color");
        allelementVerifiers.add("border-top-color");
        allelementVerifiers.add("border-bottom-color");
        allelementVerifiers.add("border-right-color");
        allelementVerifiers.add("border-left-color");
        allelementVerifiers.add("border-block-end-color");
        allelementVerifiers.add("border-block-start-color");
        allelementVerifiers.add("border-inline-end-color");
        allelementVerifiers.add("border-inline-start-color");
        allelementVerifiers.add("border-spacing");
        allelementVerifiers.add("border-style");
        allelementVerifiers.add("border-top-style");
        allelementVerifiers.add("border-bottom-style");
        allelementVerifiers.add("border-left-style");
        allelementVerifiers.add("border-right-style");
        allelementVerifiers.add("border-block-end-style");
        allelementVerifiers.add("border-block-start-style");
        allelementVerifiers.add("border-inline-end-style");
        allelementVerifiers.add("border-inline-start-style");
        allelementVerifiers.add("border-left");
        allelementVerifiers.add("border-top");
        allelementVerifiers.add("border-right");
        allelementVerifiers.add("border-bottom");
        allelementVerifiers.add("border-block-end");
        allelementVerifiers.add("border-block-start");
        allelementVerifiers.add("border-inline-end");
        allelementVerifiers.add("border-inline-start");
        allelementVerifiers.add("border-top-width");
        allelementVerifiers.add("border-right-width");
        allelementVerifiers.add("border-bottom-width");
        allelementVerifiers.add("border-left-width");
        allelementVerifiers.add("border-width");
        allelementVerifiers.add("border-block-end-width");
        allelementVerifiers.add("border-block-start-width");
        allelementVerifiers.add("border-bottom-width");
        allelementVerifiers.add("border-inline-end-width");
        allelementVerifiers.add("border-inline-start-width");
        allelementVerifiers.add("border-left-width");
        allelementVerifiers.add("border-right-width");
        allelementVerifiers.add("border-top-width");
        allelementVerifiers.add("border-radius");
        allelementVerifiers.add("border-bottom-left-radius");
        allelementVerifiers.add("border-bottom-right-radius");
        allelementVerifiers.add("border-end-end-radius");
        allelementVerifiers.add("border-end-start-radius");
        allelementVerifiers.add("border-start-end-radius");
        allelementVerifiers.add("border-start-start-radius");
        allelementVerifiers.add("border-top-left-radius");
        allelementVerifiers.add("border-top-right-radius");
        allelementVerifiers.add("border-image-source");
        allelementVerifiers.add("border-image-slice");
        allelementVerifiers.add("border-image-width");
        allelementVerifiers.add("border-image-outset");
        allelementVerifiers.add("border-image-repeat");
        allelementVerifiers.add("border-image");
        allelementVerifiers.add("border");
        allelementVerifiers.add("bottom");
        allelementVerifiers.add("box-decoration-break");
        allelementVerifiers.add("box-shadow");
        allelementVerifiers.add("box-sizing");
        allelementVerifiers.add("box-suppress");
        allelementVerifiers.add("caption-side");
        allelementVerifiers.add("caret-color");
        allelementVerifiers.add("clear");
        allelementVerifiers.add("clip");
        allelementVerifiers.add("break-before");
        allelementVerifiers.add("break-after");
        allelementVerifiers.add("break-inside");
        allelementVerifiers.add("color-scheme");
        allelementVerifiers.add("column-count");
        allelementVerifiers.add("column-fill");
        allelementVerifiers.add("column-gap");
        allelementVerifiers.add("column-rule-color");
        allelementVerifiers.add("column-rule-style");
        allelementVerifiers.add("column-rule-width");
        allelementVerifiers.add("column-span");
        allelementVerifiers.add("column-rule");
        allelementVerifiers.add("column-width");
        allelementVerifiers.add("columns");
        allelementVerifiers.add("color");
        allelementVerifiers.add("color-interpolation");
        allelementVerifiers.add("color-rendering");
        allelementVerifiers.add("content");
        allelementVerifiers.add("counter-increment");
        allelementVerifiers.add("counter-reset");
        allelementVerifiers.add("cue-after");
        allelementVerifiers.add("cue-before");
        allelementVerifiers.add("cue");
        allelementVerifiers.add("cursor");
        allelementVerifiers.add("direction");
        allelementVerifiers.add("display");
        allelementVerifiers.add("dominant-baseline");
        allelementVerifiers.add("elevation");
        allelementVerifiers.add("empty-cells");
        allelementVerifiers.add("flex");
        allelementVerifiers.add("flex-basis");
        allelementVerifiers.add("flex-direction");
        allelementVerifiers.add("flex-flow");
        allelementVerifiers.add("flex-grow");
        allelementVerifiers.add("flex-shrink");
        allelementVerifiers.add("flex-wrap");
        allelementVerifiers.add("float");
        allelementVerifiers.add("font-family");
        allelementVerifiers.add("font-kerning");
        allelementVerifiers.add("font-optical-sizing");
        allelementVerifiers.add("font-size");
        allelementVerifiers.add("font-style");
        allelementVerifiers.add("font-variant");
        allelementVerifiers.add("font-weight");
        allelementVerifiers.add("font");
        allelementVerifiers.add("hanging-punctuation");
        allelementVerifiers.add("height");
        allelementVerifiers.add("hyphenate-character");
        allelementVerifiers.add("hyphens");
        allelementVerifiers.add("image-orientation");
        allelementVerifiers.add("image-rendering");
        allelementVerifiers.add("inline-size");
        allelementVerifiers.add("isolation");
        allelementVerifiers.add("justify-content");
        allelementVerifiers.add("justify-items");
        allelementVerifiers.add("justify-self");
        allelementVerifiers.add("left");
        allelementVerifiers.add("letter-spacing");
        allelementVerifiers.add("line-break");
        allelementVerifiers.add("line-height");
        allelementVerifiers.add("list-style-image");
        allelementVerifiers.add("list-style-position");
        allelementVerifiers.add("list-style-type");
        allelementVerifiers.add("list-style");
        allelementVerifiers.add("margin-block");
        allelementVerifiers.add("margin-block-end");
        allelementVerifiers.add("margin-block-start");
        allelementVerifiers.add("margin-bottom");
        allelementVerifiers.add("margin-inline");
        allelementVerifiers.add("margin-inline-end");
        allelementVerifiers.add("margin-inline-start");
        allelementVerifiers.add("margin-left");
        allelementVerifiers.add("margin-right");
        allelementVerifiers.add("margin-top");
        allelementVerifiers.add("margin");
        allelementVerifiers.add("math-style");
        allelementVerifiers.add("max-block-size");
        allelementVerifiers.add("max-height");
        allelementVerifiers.add("max-inline-size");
        allelementVerifiers.add("max-width");
        allelementVerifiers.add("min-block-size");
        allelementVerifiers.add("min-height");
        allelementVerifiers.add("min-inline-size");
        allelementVerifiers.add("min-width");
        allelementVerifiers.add("mix-blend-mode");
        allelementVerifiers.add("nav-down");
        allelementVerifiers.add("nav-left");
        allelementVerifiers.add("nav-right");
        allelementVerifiers.add("nav-up");
        allelementVerifiers.add("object-fit");
        allelementVerifiers.add("object-position");
        allelementVerifiers.add("opacity");
        allelementVerifiers.add("order");
        allelementVerifiers.add("orphans");
        allelementVerifiers.add("outline-color");
        allelementVerifiers.add("outline-offset");
        allelementVerifiers.add("outline-style");
        allelementVerifiers.add("outline-width");
        allelementVerifiers.add("outline");
        allelementVerifiers.add("overflow");
        allelementVerifiers.add("overflow-block");
        allelementVerifiers.add("overflow-inline");
        allelementVerifiers.add("overflow-wrap");
        allelementVerifiers.add("overflow-x");
        allelementVerifiers.add("overflow-y");
        allelementVerifiers.add("overscroll-behavior");
        allelementVerifiers.add("overscroll-behavior-block");
        allelementVerifiers.add("overscroll-behavior-inline");
        allelementVerifiers.add("overscroll-behavior-x");
        allelementVerifiers.add("overscroll-behavior-y");
        allelementVerifiers.add("padding-block");
        allelementVerifiers.add("padding-block-end");
        allelementVerifiers.add("padding-block-start");
        allelementVerifiers.add("padding-bottom");
        allelementVerifiers.add("padding-inline");
        allelementVerifiers.add("padding-inline-end");
        allelementVerifiers.add("padding-inline-start");
        allelementVerifiers.add("padding-left");
        allelementVerifiers.add("padding-right");
        allelementVerifiers.add("padding-top");
        allelementVerifiers.add("padding");
        allelementVerifiers.add("page-break-after");
        allelementVerifiers.add("page-break-before");
        allelementVerifiers.add("page-break-inside");
        allelementVerifiers.add("pause-after");
        allelementVerifiers.add("pause-before");
        allelementVerifiers.add("pause");
        allelementVerifiers.add("perspective");
        allelementVerifiers.add("pitch-range");
        allelementVerifiers.add("pitch");
        allelementVerifiers.add("play-during");
        allelementVerifiers.add("punctuation-trim");
        allelementVerifiers.add("pointer-events");
        allelementVerifiers.add("position");
        allelementVerifiers.add("quotes");
        allelementVerifiers.add("resize");
        allelementVerifiers.add("richness");
        allelementVerifiers.add("right");
        allelementVerifiers.add("rotate");
        allelementVerifiers.add("row-gap");
        allelementVerifiers.add("ruby-align");
        allelementVerifiers.add("ruby-position");
        allelementVerifiers.add("scroll-behavior");
        allelementVerifiers.add("scroll-margin");
        allelementVerifiers.add("scroll-margin-block");
        allelementVerifiers.add("scroll-margin-block-end");
        allelementVerifiers.add("scroll-margin-block-start");
        allelementVerifiers.add("scroll-margin-bottom");
        allelementVerifiers.add("scroll-margin-inline");
        allelementVerifiers.add("scroll-margin-inline-end");
        allelementVerifiers.add("scroll-margin-inline-start");
        allelementVerifiers.add("scroll-margin-left");
        allelementVerifiers.add("scroll-margin-right");
        allelementVerifiers.add("scroll-margin-top");
        allelementVerifiers.add("scroll-padding");
        allelementVerifiers.add("scroll-padding-block");
        allelementVerifiers.add("scroll-padding-block-end");
        allelementVerifiers.add("scroll-padding-block-start");
        allelementVerifiers.add("scroll-padding-bottom");
        allelementVerifiers.add("scroll-padding-inline");
        allelementVerifiers.add("scroll-padding-inline-end");
        allelementVerifiers.add("scroll-padding-inline-start");
        allelementVerifiers.add("scroll-padding-left");
        allelementVerifiers.add("scroll-padding-right");
        allelementVerifiers.add("scroll-padding-top");
        allelementVerifiers.add("scroll-snap-align");
        allelementVerifiers.add("scroll-snap-stop");
        allelementVerifiers.add("scroll-snap-type");
        allelementVerifiers.add("speak-header");
        allelementVerifiers.add("speak-numeral");
        allelementVerifiers.add("speak-punctuation");
        allelementVerifiers.add("speak");
        allelementVerifiers.add("speech-rate");
        allelementVerifiers.add("stress");
        allelementVerifiers.add("table-layout");
        allelementVerifiers.add("tab-size");
        allelementVerifiers.add("text-align");
        allelementVerifiers.add("text-align-last");
        allelementVerifiers.add("text-autospace");
        allelementVerifiers.add("text-combine-upright");
        allelementVerifiers.add("text-decoration");
        allelementVerifiers.add("text-decoration-color");
        allelementVerifiers.add("text-decoration-line");
        allelementVerifiers.add("text-decoration-skip");
        allelementVerifiers.add("text-decoration-skip-ink");
        allelementVerifiers.add("text-decoration-style");
        allelementVerifiers.add("text-decoration-thickness");
        allelementVerifiers.add("text-emphasis");
        allelementVerifiers.add("text-emphasis-color");
        allelementVerifiers.add("text-emphasis-position");
        allelementVerifiers.add("text-emphasis-style");
        allelementVerifiers.add("text-indent");
        allelementVerifiers.add("text-justify");
        allelementVerifiers.add("text-orientation");
        allelementVerifiers.add("text-outline");
        allelementVerifiers.add("text-overflow");
        allelementVerifiers.add("text-shadow");
        allelementVerifiers.add("text-transform");
        allelementVerifiers.add("text-underline-offset");
        allelementVerifiers.add("text-underline-position");
        allelementVerifiers.add("text-wrap");
        allelementVerifiers.add("text-wrap-mode");
        allelementVerifiers.add("text-wrap-style");
        allelementVerifiers.add("top");
        allelementVerifiers.add("transform");
        allelementVerifiers.add("transform-origin");
        allelementVerifiers.add("transition-delay");
        allelementVerifiers.add("transition-duration");
        allelementVerifiers.add("transition-property");
        allelementVerifiers.add("transition-timing-function");
        allelementVerifiers.add("translate");
        allelementVerifiers.add("unicode-bidi");
        allelementVerifiers.add("vertical-align");
        allelementVerifiers.add("visibility");
        allelementVerifiers.add("voice-family");
        allelementVerifiers.add("volume");
        allelementVerifiers.add("white-space");
        allelementVerifiers.add("white-space-collapse");
        allelementVerifiers.add("widows");
        allelementVerifiers.add("width");
        allelementVerifiers.add("word-break");
        allelementVerifiers.add("word-spacing");
        allelementVerifiers.add("word-wrap");
        allelementVerifiers.add("writing-mode");
        allelementVerifiers.add("z-index");
        allelementVerifiers.add("zoom");
        auxilaryVerifiers = new CSSPropertyVerifier[149];
        CSSTokenizerFilter.auxilaryVerifiers[2] = new CSSPropertyVerifier(Arrays.asList("left", "center", "right"), Arrays.asList("pe", "le"), null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[3] = new CSSPropertyVerifier(Arrays.asList("top", "center", "bottom"), Arrays.asList("pe", "le"), null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[4] = new CSSPropertyVerifier(Arrays.asList("left", "center", "right"), null, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[5] = new CSSPropertyVerifier(Arrays.asList("top", "center", "bottom"), null, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[11] = new CSSPropertyVerifier(null, Arrays.asList("co"), null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[13] = new CSSPropertyVerifier(Arrays.asList("none", "hidden", "dotted", "dashed", "solid", "double", "groove", "ridge", "inset", "outset"), Arrays.asList("le"), null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[14] = new CSSPropertyVerifier(Arrays.asList("thin", "medium", "thick"), Arrays.asList("le"), null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[35] = new CSSPropertyVerifier(Arrays.asList("disc", "circle", "square", "decimal", "decimal-leading-zero", "lower-roman", "upper-roman", "lower-greek", "lower-latin", "upper-latin", "armenian", "georgian", "lower-alpha", "upper-alpha", "none", "arabic-indic", "bengali", "cambodian", "cjk-decimal", "cjk-earthly-branch", "cjk-heavenly-stem", "cjk-ideographic", "devanagari", "disclosure-closed", "disclosure-open", "ethiopic-numeric", "gujarati", "gurmukhi", "hebrew", "hiragana", "hiragana-iroha", "japanese-formal", "japanese-informal", "kannada", "katakana", "katakana-iroha", "khmer", "korean-hangul-formal", "korean-hanja-formal", "lao", "lower-armenian", "malayalam", "mongolian", "myanmar", "oriya", "persian", "simp-chinese-formal", "simp-chinese-informal", "tamil", "telugu", "thai", "tibetan", "trad-chinese-formal", "trad-chinese-informal", "upper-armenian"), Arrays.asList("st"), null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[36] = new CSSPropertyVerifier(Arrays.asList("auto"), Arrays.asList("le", "pe"), null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[40] = new CSSPropertyVerifier(null, Arrays.asList("le", "pe"), null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[61] = new CSSPropertyVerifier(Arrays.asList("border-box", "padding-box", "content-box"), null, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[71] = new CSSPropertyVerifier(Arrays.asList("inset"), null, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[72] = new CSSPropertyVerifier(null, Arrays.asList("le"), null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[74] = new CSSPropertyVerifier(null, null, Arrays.asList("72<1,4>"), null, true);
        CSSTokenizerFilter.auxilaryVerifiers[75] = new CSSPropertyVerifier(null, null, Arrays.asList("71a74a11"), null, true);
        CSSTokenizerFilter.auxilaryVerifiers[76] = new CSSPropertyVerifier(Arrays.asList("none"), Arrays.asList("ur"), null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[68] = new CSSPropertyVerifier(Arrays.asList("auto"), Arrays.asList("le", "pe", "in"), null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[77] = new CSSPropertyVerifier(null, null, Arrays.asList("68<1,4>"), null, true);
        CSSTokenizerFilter.auxilaryVerifiers[70] = new CSSPropertyVerifier(Arrays.asList("stretch", "repeat", "round"), null, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[78] = new CSSPropertyVerifier(null, null, Arrays.asList("70<1,2>"), null, true);
        CSSTokenizerFilter.auxilaryVerifiers[79] = new CSSPropertyVerifier(null, null, Arrays.asList("11 72 72 72", "11 72 72", "72 72 72 11", "72 72 11", "72 72"), null, true);
        CSSTokenizerFilter.auxilaryVerifiers[85] = new CSSPropertyVerifier(Arrays.asList("normal"), Arrays.asList("le", "pe"), null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[100] = new CSSPropertyVerifier(Arrays.asList("underline"), null, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[101] = new CSSPropertyVerifier(Arrays.asList("overline"), null, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[102] = new CSSPropertyVerifier(Arrays.asList("line-through"), null, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[115] = new CSSPropertyVerifier(Arrays.asList("none"), null, null, Arrays.asList("100a101a102"));
        CSSTokenizerFilter.auxilaryVerifiers[116] = new CSSPropertyVerifier(Arrays.asList("blink"), null, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[104] = new CSSPropertyVerifier(Arrays.asList("solid", "double", "dotted", "dashed", "wavy"), null, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[105] = new CSSPropertyVerifier(Arrays.asList("filled", "open"), null, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[106] = new CSSPropertyVerifier(Arrays.asList("dot", "circle", "double-circle", "triangle", "sesame"), null, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[107] = new CSSPropertyVerifier(Arrays.asList("none"), null, Arrays.asList("st"), Arrays.asList("105a106"));
        CSSTokenizerFilter.auxilaryVerifiers[121] = new CSSPropertyVerifier(Arrays.asList("auto", "baseline", "last-baseline", "space-between", "space-around", "space-evenly", "stretch"), null, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[122] = new CSSPropertyVerifier(Arrays.asList("true", "safe"), null, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[123] = new CSSPropertyVerifier(Arrays.asList("center", "start", "end", "flex-start", "flex-end", "left", "right"), null, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[124] = new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("122 123", "123", "123 122"), true, true);
        CSSTokenizerFilter.auxilaryVerifiers[125] = new CSSPropertyVerifier(Arrays.asList("auto", "stretch", "baseline", "last-baseline"), null, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[126] = new CSSPropertyVerifier(Arrays.asList("center", "start", "end", "self-start", "self-end", "flex-start", "flex-end", "left", "right"), null, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[127] = new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("122 126", "126", "126 122"), true, true);
        CSSTokenizerFilter.auxilaryVerifiers[128] = new CSSPropertyVerifier(Arrays.asList("legacy"), null, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[129] = new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("4 128", "128 4"), true, true);
        CSSTokenizerFilter.auxilaryVerifiers[130] = new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, Arrays.asList("122 126", "126", "126 122"), true, true);
        CSSTokenizerFilter.auxilaryVerifiers[143] = new CSSPropertyVerifier(null, Arrays.asList("se"), null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[144] = new CSSPropertyVerifier(Arrays.asList("current", "root"), Arrays.asList("st"), null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[145] = new CSSPropertyVerifier(null, Arrays.asList("ti"), null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[146] = new CSSPropertyVerifier(null, Arrays.asList("id"), null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[147] = new CSSPropertyVerifier(Arrays.asList("ease", "ease-in", "ease-out", "ease-in-out", "linear", "step-start", "step-end"), null, null, null, true);
    }

    static class VoiceFamilyPropertyVerifier
    extends FamilyPropertyVerifier {
        VoiceFamilyPropertyVerifier(boolean valueOnly) {
            super(valueOnly, ElementInfo.AURALMEDIA);
        }

        @Override
        boolean isSpecificFamily(String s) {
            return ElementInfo.isSpecificVoiceFamily(s);
        }

        @Override
        boolean isGenericFamily(String s) {
            return ElementInfo.isGenericVoiceFamily(s);
        }
    }

    static class FontPropertyVerifier
    extends FamilyPropertyVerifier {
        FontPropertyVerifier(boolean valueOnly) {
            super(valueOnly, ElementInfo.VISUALMEDIA);
        }

        @Override
        boolean isSpecificFamily(String s) {
            return ElementInfo.isSpecificFontFamily(s);
        }

        @Override
        boolean isGenericFamily(String s) {
            return ElementInfo.isGenericFontFamily(s);
        }
    }

    static abstract class FamilyPropertyVerifier
    extends CSSPropertyVerifier {
        FamilyPropertyVerifier(boolean valueOnly, Set<String> mediaTypes) {
            super(null, mediaTypes, null, null, valueOnly, true);
        }

        @Override
        public boolean checkValidity(String[] media, String[] elements, ParsedWord[] value, FilterCallback cb) {
            if (logDEBUG) {
                Logger.debug(this, "font verifier: " + FamilyPropertyVerifier.toString(value));
            }
            if (value.length == 1 && value[0] instanceof ParsedIdentifier && "inherit".equalsIgnoreCase(((ParsedIdentifier)value[0]).original)) {
                if (logDEBUG) {
                    Logger.debug(this, "font: inherit");
                }
                return true;
            }
            if (this.allowedMedia != null && !this.onlyValueVerifier) {
                boolean allowed = false;
                for (String m : media) {
                    if (!this.allowedMedia.contains(m)) continue;
                    allowed = true;
                    break;
                }
                if (!allowed) {
                    if (logDEBUG) {
                        Logger.debug(this, "checkValidity Media of the element is not allowed.Media=" + Fields.commaList(media) + " allowed Media=" + this.allowedMedia.toString());
                    }
                    return false;
                }
            }
            ArrayList<String> fontWords = new ArrayList<String>();
            block1: for (int i = 0; i < value.length; ++i) {
                ParsedWord word = value[i];
                String s = null;
                if (word instanceof ParsedString) {
                    String decoded = ((ParsedString)word).getDecoded();
                    if (logDEBUG) {
                        Logger.debug(this, "decoded: \"" + decoded + "\"");
                    }
                    if (this.isSpecificFamily(decoded.toLowerCase()) || this.isGenericFamily(decoded.toLowerCase())) continue;
                    s = decoded;
                } else if (word instanceof ParsedIdentifier) {
                    s = ((ParsedIdentifier)word).getDecoded();
                    if (this.isGenericFamily(s) || this.isSpecificFamily(s)) continue;
                    if (word.postComma) {
                        if (logDEBUG) {
                            Logger.debug(this, "Word ends in comma, but is not a valid font on its own: " + word + " (index " + i + ")");
                        }
                        return false;
                    }
                } else {
                    return false;
                }
                fontWords.clear();
                assert (s != null);
                fontWords.add(s);
                if (logDEBUG) {
                    Logger.debug(this, "first word: \"" + s + "\"");
                }
                if (i == value.length - 1) {
                    if (logDEBUG) {
                        Logger.debug(this, "last word. font words: " + FamilyPropertyVerifier.getStringFromArray(fontWords.toArray(new String[fontWords.size()])) + " valid=" + this.validFontWords(fontWords));
                    }
                    return this.validFontWords(fontWords);
                }
                if (!this.possiblyValidFontWords(fontWords)) {
                    return false;
                }
                boolean last = false;
                for (int j = i + 1; j < value.length; ++j) {
                    ParsedWord newWord = value[j];
                    if (j == value.length - 1) {
                        last = true;
                    }
                    if (newWord instanceof ParsedIdentifier) {
                        String s1 = ((ParsedIdentifier)newWord).original;
                        fontWords.add(s1);
                        if (logDEBUG) {
                            Logger.debug(this, "adding word: \"" + s1 + "\"");
                        }
                        if (last) {
                            if (newWord.postComma && logDEBUG) {
                                Logger.debug(this, "not valid: trailing comma at end");
                            }
                            if (this.validFontWords(fontWords)) {
                                if (logDEBUG) {
                                    Logger.debug(this, "font: reached last in inner loop, valid. font words: " + FamilyPropertyVerifier.getStringFromArray(fontWords.toArray(new String[fontWords.size()])));
                                }
                                return true;
                            }
                        }
                        if (!newWord.postComma) continue;
                        if (this.validFontWords(fontWords)) {
                            fontWords.clear();
                            i = j;
                            continue block1;
                        }
                        if (logDEBUG) {
                            Logger.debug(this, "comma but can't parse font words: " + Fields.commaList(fontWords.toArray(new String[fontWords.size()])));
                        }
                        return false;
                    }
                    if (logDEBUG) {
                        Logger.debug(this, "cannot parse " + newWord);
                    }
                    return false;
                }
                return this.validFontWords(fontWords);
            }
            if (logDEBUG) {
                Logger.debug(this, "font: reached end, valid");
            }
            return true;
        }

        private boolean possiblyValidFontWords(ArrayList<String> fontWords) {
            for (String s : fontWords) {
                if (this.isSpecificFamily(s)) continue;
                return false;
            }
            return true;
        }

        private boolean validFontWords(ArrayList<String> fontWords) {
            for (String s : fontWords) {
                if (s != null) continue;
                throw new NullPointerException();
            }
            if (fontWords.size() == 1 && this.isGenericFamily(fontWords.get(0).toLowerCase())) {
                return true;
            }
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String s : fontWords) {
                if (!first) {
                    sb.append(' ');
                }
                first = false;
                sb.append(s);
            }
            return this.isSpecificFamily(sb.toString().toLowerCase());
        }

        abstract boolean isSpecificFamily(String var1);

        abstract boolean isGenericFamily(String var1);
    }

    static class FontPartPropertyVerifier
    extends CSSPropertyVerifier {
        FontPartPropertyVerifier() {
            super(false);
        }

        @Override
        public boolean checkValidity(String[] media, String[] elements, ParsedWord[] value, FilterCallback cb) {
            CSSPropertyVerifier fontSize;
            if (logDEBUG) {
                Logger.debug(this, "FontPartPropertyVerifier called with " + FontPartPropertyVerifier.toString(value));
            }
            if ((fontSize = new CSSPropertyVerifier(Arrays.asList("xx-small", "x-small", "small", "medium", "large", "x-large", "xx-large", "larger", "smaller"), Arrays.asList("le", "pe"), null, null, true)).checkValidity(value, cb)) {
                return true;
            }
            for (ParsedWord word : value) {
                String orig;
                if (fontSize.checkValidity(word, cb)) continue;
                if (word instanceof SimpleParsedWord && (orig = ((SimpleParsedWord)word).original).contains("/")) {
                    int slashIndex = orig.indexOf("/");
                    String firstPart = orig.substring(0, slashIndex);
                    String secondPart = orig.substring(slashIndex + 1, orig.length());
                    if (logDEBUG) {
                        Logger.debug(this, "FontPartPropertyVerifier FirstPart=" + firstPart + " secondPart=" + secondPart);
                    }
                    CSSPropertyVerifier lineHeight = new CSSPropertyVerifier(Arrays.asList("normal"), Arrays.asList("le", "pe", "re", "in"), null, null, true);
                    ParsedWord[] first = CSSTokenizerFilter.split(firstPart, false);
                    ParsedWord[] second = CSSTokenizerFilter.split(secondPart, false);
                    if (first.length == 1 && second.length == 1 && fontSize.checkValidity(first, cb) && lineHeight.checkValidity(second, cb)) continue;
                }
                return false;
            }
            return true;
        }
    }

    static class ContentPropertyVerifier
    extends CSSPropertyVerifier {
        ContentPropertyVerifier(Collection<String> allowedValues) {
            super(allowedValues, null, null, null);
        }

        @Override
        public boolean checkValidity(String[] media, String[] elements, ParsedWord[] value, FilterCallback cb) {
            if (logDEBUG) {
                Logger.debug(this, "ContentPropertyVerifier checkValidity called: " + ContentPropertyVerifier.toString(value));
            }
            if (value.length != 1) {
                return false;
            }
            if (value[0] instanceof ParsedIdentifier && this.allowedValues != null && this.allowedValues.contains(((ParsedIdentifier)value[0]).getDecoded())) {
                return true;
            }
            if (value[0] instanceof ParsedString) {
                return true;
            }
            if (value[0] instanceof ParsedCounter) {
                ParsedCounter counter = (ParsedCounter)value[0];
                if (counter.listType != null) {
                    HashSet<String> listStyleType = new HashSet<String>();
                    listStyleType.addAll(Arrays.asList("disc", "circle", "square", "decimal", "decimal-leading-zero", "lower-roman", "upper-roman", "lower-greek", "lower-latin", "upper-latin", "armenian", "georgian", "lower-alpha", "upper-alpha", "none", "arabic-indic", "bengali", "cambodian", "cjk-decimal", "cjk-earthly-branch", "cjk-heavenly-stem", "cjk-ideographic", "devanagari", "disclosure-closed", "disclosure-open", "ethiopic-numeric", "gujarati", "gurmukhi", "hebrew", "hiragana", "hiragana-iroha", "japanese-formal", "japanese-informal", "kannada", "katakana", "katakana-iroha", "khmer", "korean-hangul-formal", "korean-hanja-formal", "lao", "lower-armenian", "malayalam", "mongolian", "myanmar", "oriya", "persian", "simp-chinese-formal", "simp-chinese-informal", "tamil", "telugu", "thai", "tibetan", "trad-chinese-formal", "trad-chinese-informal", "upper-armenian"));
                    if (!listStyleType.contains(counter.listType.getDecoded())) {
                        return false;
                    }
                }
                if (counter.separatorString != null) {
                    // empty if block
                }
                return true;
            }
            if (value[0] instanceof ParsedAttr) {
                return true;
            }
            if (value[0] instanceof ParsedURL) {
                return ContentPropertyVerifier.isValidURI((ParsedURL)value[0], cb);
            }
            return false;
        }
    }

    static class CSSPropertyVerifier {
        public final boolean onlyValueVerifier;
        public final boolean allowCommaDelimiters;
        public final Set<String> allowedValues;
        public final Set<String> allowedMedia;
        public final boolean isInteger;
        public final boolean isReal;
        public final boolean isPercentage;
        public final boolean isLength;
        public final boolean isAngle;
        public final boolean isColor;
        public final boolean isURI;
        public final boolean isIDSelector;
        public final boolean isShape;
        public final boolean isString;
        public final boolean isCounter;
        public final boolean isIdentifier;
        public final boolean isTime;
        public final boolean isFrequency;
        public final boolean isTransform;
        private final List<String> parserExpressions;

        CSSPropertyVerifier(boolean allowCommaDelimiters) {
            this(null, null, null, null, false, allowCommaDelimiters);
        }

        CSSPropertyVerifier(Collection<String> allowedValues, Collection<String> allowedMedia) {
            this(allowedValues, allowedMedia, null, null);
        }

        CSSPropertyVerifier(Collection<String> allowedValues, Collection<String> allowedMedia, Collection<String> possibleValues) {
            this(allowedValues, allowedMedia, possibleValues, null);
        }

        CSSPropertyVerifier(Collection<String> allowedValues, Collection<String> possibleValues, Collection<String> parseExpression, Collection<String> allowedMedia, boolean onlyValueVerifier) {
            this(allowedValues, allowedMedia, possibleValues, parseExpression, onlyValueVerifier, false);
        }

        CSSPropertyVerifier(Collection<String> allowedValues, Collection<String> allowedMedia, Collection<String> possibleValues, Collection<String> parseExpression) {
            this(allowedValues, allowedMedia, possibleValues, parseExpression, false, false);
        }

        CSSPropertyVerifier(Collection<String> allowedValues, Collection<String> allowedMedia, Collection<String> possibleValues, Collection<String> parseExpression, boolean onlyValueVerifier, boolean allowCommaDelimiters) {
            this.onlyValueVerifier = onlyValueVerifier;
            this.allowCommaDelimiters = allowCommaDelimiters;
            boolean isTransform = false;
            boolean isFrequency = false;
            boolean isIDSelector = false;
            boolean isTime = false;
            boolean isIdentifier = false;
            boolean isCounter = false;
            boolean isString = false;
            boolean isShape = false;
            boolean isURI = false;
            boolean isColor = false;
            boolean isAngle = false;
            boolean isLength = false;
            boolean isPercentage = false;
            boolean isReal = false;
            boolean isInteger = false;
            if (possibleValues != null) {
                for (String possibleValue : possibleValues) {
                    if ("in".equals(possibleValue)) {
                        isInteger = true;
                        continue;
                    }
                    if ("re".equals(possibleValue)) {
                        isReal = true;
                        continue;
                    }
                    if ("pe".equals(possibleValue)) {
                        isPercentage = true;
                        continue;
                    }
                    if ("le".equals(possibleValue)) {
                        isLength = true;
                        continue;
                    }
                    if ("an".equals(possibleValue)) {
                        isAngle = true;
                        continue;
                    }
                    if ("co".equals(possibleValue)) {
                        isColor = true;
                        continue;
                    }
                    if ("ur".equals(possibleValue)) {
                        isURI = true;
                        continue;
                    }
                    if ("se".equals(possibleValue)) {
                        isIDSelector = true;
                        continue;
                    }
                    if ("sh".equals(possibleValue)) {
                        isShape = true;
                        continue;
                    }
                    if ("st".equals(possibleValue)) {
                        isString = true;
                        continue;
                    }
                    if ("co".equals(possibleValue)) {
                        isCounter = true;
                        continue;
                    }
                    if ("id".equals(possibleValue)) {
                        isIdentifier = true;
                        continue;
                    }
                    if ("ti".equals(possibleValue)) {
                        isTime = true;
                        continue;
                    }
                    if ("fr".equals(possibleValue)) {
                        isFrequency = true;
                        continue;
                    }
                    if (!"tr".equals(possibleValue)) continue;
                    isTransform = true;
                }
            }
            this.isInteger = isInteger;
            this.isReal = isReal;
            this.isPercentage = isPercentage;
            this.isLength = isLength;
            this.isAngle = isAngle;
            this.isColor = isColor;
            this.isURI = isURI;
            this.isIDSelector = isIDSelector;
            this.isShape = isShape;
            this.isString = isString;
            this.isCounter = isCounter;
            this.isIdentifier = isIdentifier;
            this.isTime = isTime;
            this.isFrequency = isFrequency;
            this.isTransform = isTransform;
            this.allowedValues = allowedValues != null ? Collections.unmodifiableSet(new HashSet<String>(allowedValues)) : null;
            this.allowedMedia = allowedMedia != null ? Collections.unmodifiableSet(new HashSet<String>(allowedMedia)) : null;
            this.parserExpressions = parseExpression != null ? Collections.unmodifiableList(new ArrayList<String>(parseExpression)) : Collections.emptyList();
        }

        public static boolean isIntegerChecker(String value) {
            try {
                Integer.parseInt(value);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public static boolean isRealChecker(String value) {
            try {
                Float.parseFloat(value);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public static boolean isValidURI(ParsedURL word, FilterCallback cb) {
            String w = CSSTokenizerFilter.removeOuterQuotes(word.getDecoded());
            try {
                String s = cb.processURI(w, null);
                if (s == null || s.isEmpty()) {
                    return false;
                }
                if (s.equals(w)) {
                    return true;
                }
                if (logDEBUG) {
                    Logger.debug(CSSTokenizerFilter.class, "New url: \"" + s + "\" from \"" + w + "\"");
                }
                word.setNewURL(s);
                return true;
            }
            catch (CommentException e) {
                return false;
            }
        }

        public boolean checkValidity(ParsedWord[] words, FilterCallback cb) {
            return this.checkValidity(null, null, words, cb);
        }

        public boolean checkValidity(ParsedWord word, FilterCallback cb) {
            return this.checkValidity(null, null, new ParsedWord[]{word}, cb);
        }

        public boolean checkValidity(String[] media, String[] elements, ParsedWord[] words, FilterCallback cb) {
            if (logDEBUG) {
                Logger.debug(this, "checkValidity for " + CSSPropertyVerifier.toString(words) + " for " + this);
            }
            if (!this.onlyValueVerifier && this.allowedMedia != null) {
                boolean allowed = false;
                for (String m : media) {
                    if (!this.allowedMedia.contains(m)) continue;
                    allowed = true;
                    break;
                }
                if (!allowed) {
                    if (logDEBUG) {
                        Logger.debug(this, "checkValidity Media of the element is not allowed.Media=" + Fields.commaList(media) + " allowed Media=" + this.allowedMedia.toString());
                    }
                    return false;
                }
            }
            if (words.length == 1) {
                String result;
                if (words[0] instanceof ParsedIdentifier) {
                    String lowerCaseWord = ((ParsedIdentifier)words[0]).original.toLowerCase();
                    if (this.allowedValues != null && this.allowedValues.contains(lowerCaseWord)) {
                        return true;
                    }
                    if (lowerCaseWord.equals("initial") || lowerCaseWord.equals("inherit") || lowerCaseWord.equals("unset") || lowerCaseWord.equals("revert") || lowerCaseWord.equals("revert-layer")) {
                        return true;
                    }
                }
                if (words[0] instanceof SimpleParsedWord) {
                    String word = ((SimpleParsedWord)words[0]).original;
                    if (this.allowedValues != null && this.allowedValues.contains(word)) {
                        return true;
                    }
                    if (this.isInteger && CSSPropertyVerifier.isIntegerChecker(word)) {
                        return true;
                    }
                    if (this.isReal && CSSPropertyVerifier.isRealChecker(word)) {
                        return true;
                    }
                    if (this.isPercentage && FilterUtils.isPercentage(word)) {
                        return true;
                    }
                    if (this.isLength && FilterUtils.isLength(word, false)) {
                        return true;
                    }
                    if (this.isAngle && FilterUtils.isAngle(word)) {
                        return true;
                    }
                    if (this.isColor && FilterUtils.isColor(word)) {
                        return true;
                    }
                    if (this.isShape && FilterUtils.isValidCSSShape(word)) {
                        return true;
                    }
                    if (this.isFrequency && FilterUtils.isFrequency(word)) {
                        return true;
                    }
                    if (this.isTime && FilterUtils.isTime(word)) {
                        return true;
                    }
                    if (this.isTransform && FilterUtils.isCSSTransform(word)) {
                        return true;
                    }
                }
                if (words[0] instanceof ParsedIdentifier) {
                    String value = ((ParsedIdentifier)words[0]).original;
                    if (this.isColor && FilterUtils.isColor(value)) {
                        return true;
                    }
                    if (this.isLength && (value.equalsIgnoreCase("min-content") || value.equalsIgnoreCase("max-content") || value.equalsIgnoreCase("fit-content"))) {
                        return true;
                    }
                }
                if (this.isURI && words[0] instanceof ParsedURL) {
                    return CSSPropertyVerifier.isValidURI((ParsedURL)words[0], cb);
                }
                if (this.isIdentifier && words[0] instanceof ParsedIdentifier) {
                    return true;
                }
                if (this.isIDSelector && (result = CSSTokenizerFilter.HTMLelementVerifier(words[0].original, true)) != null && !result.isEmpty()) {
                    return true;
                }
                if (this.isString && words[0] instanceof ParsedString) {
                    return true;
                }
            }
            for (String parserExpression : this.parserExpressions) {
                boolean result = this.recursiveParserExpressionVerifier(parserExpression, words, cb);
                if (!result) continue;
                return true;
            }
            return false;
        }

        public boolean recursiveParserExpressionVerifier(String expression, ParsedWord[] words, FilterCallback cb) {
            if (logDEBUG) {
                Logger.debug(this, "1recursiveParserExpressionVerifier called: with " + expression + " " + CSSPropertyVerifier.toString(words));
            }
            if (expression == null || expression.trim().isEmpty()) {
                return words == null || words.length == 0;
            }
            int tokensCanBeGivenLowerLimit = 1;
            int tokensCanBeGivenUpperLimit = 1;
            for (int i = 0; i < expression.length(); ++i) {
                if (expression.charAt(i) == 'a') {
                    int noOfa = 0;
                    int endIndex = expression.length();
                    for (int j = 0; j < expression.length(); ++j) {
                        char c = expression.charAt(j);
                        if (c == 'a') {
                            ++noOfa;
                            continue;
                        }
                        if ('0' <= c && '9' >= c) continue;
                        endIndex = j;
                        break;
                    }
                    String firstPart = expression.substring(0, endIndex);
                    String secondPart = "";
                    if (endIndex != expression.length()) {
                        secondPart = expression.substring(endIndex + 1, expression.length());
                    }
                    int j = 1;
                    if (secondPart.isEmpty()) {
                        j = words.length;
                    }
                    while (j <= words.length) {
                        if (logDEBUG) {
                            Logger.debug(this, "2Making recursiveDoubleBarVerifier to consume " + j + " words");
                        }
                        ParsedWord[] partToPassToDB = Arrays.copyOf(words, j);
                        if (logDEBUG) {
                            Logger.debug(this, "3Calling recursiveDoubleBarVerifier with " + firstPart + " " + CSSPropertyVerifier.toString(partToPassToDB));
                        }
                        if (this.recursiveDoubleBarVerifier(firstPart, partToPassToDB, cb)) {
                            ParsedWord[] partToPass = Arrays.copyOfRange(words, j, words.length);
                            if (logDEBUG) {
                                Logger.debug(this, "4recursiveDoubleBarVerifier true calling itself with " + secondPart + CSSPropertyVerifier.toString(partToPass));
                            }
                            if (this.recursiveParserExpressionVerifier(secondPart, partToPass, cb)) {
                                return true;
                            }
                        }
                        if (logDEBUG) {
                            Logger.debug(this, "5Back to recursiveDoubleBarVerifier " + j + " " + (noOfa + 1) + " " + words.length);
                        }
                        ++j;
                    }
                    return false;
                }
                if (expression.charAt(i) == 'b') {
                    int endIndex = expression.length();
                    for (int j = 0; j < expression.length(); ++j) {
                        char c = expression.charAt(j);
                        if (c == 'b' || '0' <= c && '9' >= c) continue;
                        endIndex = j;
                        break;
                    }
                    String firstPart = expression.substring(0, endIndex);
                    String secondPart = "";
                    if (endIndex != expression.length()) {
                        secondPart = expression.substring(endIndex + 1, expression.length());
                    }
                    for (int j = words.length; j >= 1; --j) {
                        ParsedWord[] partToPass;
                        ParsedWord[] partToPassToDA = Arrays.copyOf(words, j);
                        if (!this.doubleAmpersandVerifier(firstPart, partToPassToDA, cb) || !this.recursiveParserExpressionVerifier(secondPart, partToPass = Arrays.copyOfRange(words, j, words.length), cb)) continue;
                        return true;
                    }
                    return false;
                }
                if (expression.charAt(i) == ' ') {
                    String firstPart = expression.substring(0, i);
                    String secondPart = expression.substring(i + 1, expression.length());
                    if (words != null && words.length > 0) {
                        int index = Integer.parseInt(firstPart);
                        boolean result = auxilaryVerifiers[index].checkValidity(words[0], cb);
                        if (result) {
                            ParsedWord[] partToPass = Arrays.copyOfRange(words, 1, words.length);
                            if (logDEBUG) {
                                Logger.debug(this, "8First part is true. partToPass=" + CSSPropertyVerifier.toString(partToPass));
                            }
                            if (this.recursiveParserExpressionVerifier(secondPart, partToPass, cb)) {
                                return true;
                            }
                        }
                    }
                    return false;
                }
                if (expression.charAt(i) == '?') {
                    ParsedWord[] partToPass;
                    boolean result;
                    String firstPart = expression.substring(0, i);
                    String secondPart = expression.substring(i + 1, expression.length());
                    int index = Integer.parseInt(firstPart);
                    return words.length > 0 ? (result = auxilaryVerifiers[index].checkValidity(words[0], cb)) && this.recursiveParserExpressionVerifier(secondPart, partToPass = Arrays.copyOfRange(words, 1, words.length), cb) : this.recursiveParserExpressionVerifier(secondPart, words, cb);
                }
                if (expression.charAt(i) != '<') continue;
                int tindex = expression.indexOf(62);
                if (tindex > i) {
                    int upperLimit;
                    int lowerLimit;
                    int indexOfSecondBracket;
                    int firstIndex = tindex + 1;
                    if (tindex != expression.length() - 1 && expression.charAt(tindex + 1) == '[' && (indexOfSecondBracket = expression.indexOf(93)) > tindex + 1) {
                        tokensCanBeGivenLowerLimit = Integer.parseInt(expression.substring(tindex + 2, indexOfSecondBracket).split(",")[0]);
                        tokensCanBeGivenUpperLimit = Integer.parseInt(expression.substring(tindex + 2, indexOfSecondBracket).split(",")[1]);
                        firstIndex = expression.indexOf(93) + 1;
                    }
                    String firstPart = expression.substring(0, i);
                    String secondPart = expression.substring(firstIndex, expression.length());
                    if (!secondPart.isEmpty() && secondPart.charAt(0) == ' ') {
                        secondPart = secondPart.substring(1);
                    } else if (!secondPart.isEmpty()) {
                        throw new IllegalStateException("Don't know what to do with char after <>[]: " + secondPart.charAt(0));
                    }
                    if (logDEBUG) {
                        Logger.debug(this, "9in < firstPart=" + firstPart + " secondPart=" + secondPart + " tokensCanBeGivenLowerLimit=" + tokensCanBeGivenLowerLimit + " tokensCanBeGivenUpperLimit=" + tokensCanBeGivenUpperLimit);
                    }
                    int index = Integer.parseInt(firstPart);
                    String[] strLimits = expression.substring(i + 1, tindex).split(",");
                    if (strLimits.length == 2 && this.recursiveVariableOccuranceVerifier(index, words, lowerLimit = Integer.parseInt(strLimits[0]), upperLimit = Integer.parseInt(strLimits[1]), tokensCanBeGivenLowerLimit, tokensCanBeGivenUpperLimit, secondPart, cb)) {
                        return true;
                    }
                }
                return false;
            }
            if (logDEBUG) {
                Logger.debug(this, "10Single token:" + expression);
            }
            int index = Integer.parseInt(expression);
            return auxilaryVerifiers[index].checkValidity(words, cb);
        }

        public boolean doubleAmpersandVerifier(String expression, ParsedWord[] words, FilterCallback cb) {
            String ignoredParts = "";
            String firstPart = "";
            int lastB = -1;
            assert (!expression.isEmpty());
            assert (expression.charAt(expression.length() - 1) != 'b');
            assert (expression.charAt(0) != 'b');
            ArrayList<CSSPropertyVerifier> propertyVerifierList = new ArrayList<CSSPropertyVerifier>();
            for (int i = 0; i <= expression.length(); ++i) {
                if (i != expression.length() && expression.charAt(i) != 'b') continue;
                ignoredParts = !firstPart.isEmpty() ? (ignoredParts.isEmpty() ? firstPart : ignoredParts + "b" + firstPart) : "";
                firstPart = expression.substring(lastB + 1, i);
                lastB = i;
                int index = Integer.parseInt(firstPart);
                propertyVerifierList.add(auxilaryVerifiers[index]);
            }
            int maxLoops = words.length;
            while (maxLoops-- > 0 && !propertyVerifierList.isEmpty()) {
                for (int i = words.length; i > 0; --i) {
                    ParsedWord[] tokensToVerify = Arrays.copyOf(words, i);
                    boolean tokenConsumed = false;
                    for (int j = 0; j < propertyVerifierList.size(); ++j) {
                        CSSPropertyVerifier propertyVerifier = (CSSPropertyVerifier)propertyVerifierList.get(j);
                        if (!propertyVerifier.checkValidity(tokensToVerify, cb)) continue;
                        words = words.length - tokensToVerify.length > 0 ? Arrays.copyOfRange(words, tokensToVerify.length, words.length) : new ParsedWord[]{};
                        propertyVerifierList.remove(j);
                        tokenConsumed = true;
                        break;
                    }
                    if (tokenConsumed) break;
                }
                if (words.length != 0) continue;
            }
            if (words.length > 0) {
                return false;
            }
            boolean result = true;
            for (int i = 0; i < propertyVerifierList.size(); ++i) {
                CSSPropertyVerifier verifier = (CSSPropertyVerifier)propertyVerifierList.get(i);
                result = result && verifier.checkValidity(words, cb);
            }
            return result;
        }

        public static String getStringFromArray(String[] parts, int lowerIndex, int upperIndex) {
            StringBuilder buffer = new StringBuilder();
            if (parts != null && lowerIndex < parts.length) {
                for (int i = lowerIndex; i < upperIndex && i < parts.length; ++i) {
                    buffer.append(parts[i]);
                    buffer.append(' ');
                }
                return buffer.toString();
            }
            return "";
        }

        public static String getStringFromArray(String[] parts) {
            return CSSPropertyVerifier.getStringFromArray(parts, 0, parts.length - 1);
        }

        public static ParsedWord[] getSubArray(ParsedWord[] array, int lowerIndex, int upperIndex) {
            ParsedWord[] arrayToReturn = new ParsedWord[upperIndex - lowerIndex];
            if (array != null && lowerIndex < array.length) {
                for (int i = lowerIndex; i < upperIndex && i < array.length; ++i) {
                    arrayToReturn[i - lowerIndex] = array[i];
                }
                return arrayToReturn;
            }
            return new ParsedWord[0];
        }

        public boolean recursiveVariableOccuranceVerifier(int verifierIndex, ParsedWord[] valueParts, int lowerLimit, int upperLimit, int tokensCanBeGivenLowerLimit, int tokensCanBeGivenUpperLimit, String secondPart, FilterCallback cb) {
            if (logDEBUG) {
                Logger.debug(this, "recursiveVariableOccurranceVerifier(" + verifierIndex + "," + CSSPropertyVerifier.toString(valueParts) + "," + lowerLimit + "," + upperLimit + "," + tokensCanBeGivenLowerLimit + "," + tokensCanBeGivenUpperLimit + "," + secondPart + ")");
            }
            if ((valueParts == null || valueParts.length == 0) && lowerLimit == 0) {
                return true;
            }
            if (lowerLimit <= 0 && this.recursiveParserExpressionVerifier(secondPart, valueParts, cb)) {
                if (logDEBUG) {
                    Logger.debug(this, "recursiveVariableOccurranceVerifier completed by " + secondPart);
                }
                return true;
            }
            if (upperLimit == 0) {
                if (logDEBUG) {
                    Logger.debug(this, "recursiveVariableOccurranceVerifier: no more parts");
                }
                return false;
            }
            for (int i = tokensCanBeGivenLowerLimit; i <= tokensCanBeGivenUpperLimit && i <= valueParts.length; ++i) {
                ParsedWord[] before = Arrays.copyOf(valueParts, i);
                if (!auxilaryVerifiers[verifierIndex].checkValidity(before, cb)) continue;
                if (logDEBUG) {
                    Logger.debug(this, "first " + i + " tokens using " + verifierIndex + " match " + CSSPropertyVerifier.toString(before));
                }
                if (i == valueParts.length && lowerLimit <= 1) {
                    if (this.recursiveParserExpressionVerifier(secondPart, new ParsedWord[0], cb)) {
                        if (logDEBUG) {
                            Logger.debug(this, "recursiveVariableOccurranceVerifier completed with no more parts by " + secondPart);
                        }
                        return true;
                    }
                    if (logDEBUG) {
                        Logger.debug(this, "recursiveVariableOccurranceVerifier: satisfied self but nothing left to match " + secondPart);
                    }
                    return false;
                }
                if (i == valueParts.length && lowerLimit > 1) {
                    return false;
                }
                ParsedWord[] after = Arrays.copyOfRange(valueParts, i, valueParts.length);
                if (logDEBUG) {
                    Logger.debug(this, "rest of tokens: " + CSSPropertyVerifier.toString(after));
                }
                if (!this.recursiveVariableOccuranceVerifier(verifierIndex, after, lowerLimit - 1, upperLimit - 1, tokensCanBeGivenLowerLimit, tokensCanBeGivenUpperLimit, secondPart, cb)) continue;
                return true;
            }
            return false;
        }

        static String toString(ParsedWord[] words) {
            if (words == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (ParsedWord word : words) {
                if (!first) {
                    sb.append(",");
                }
                first = false;
                sb.append(word);
            }
            return sb.toString();
        }

        public boolean recursiveDoubleBarVerifier(String expression, ParsedWord[] words, FilterCallback cb) {
            if (logDEBUG) {
                Logger.debug(this, "11in recursiveDoubleBarVerifier expression=" + expression + " value=" + CSSPropertyVerifier.toString(words));
            }
            if (words == null || words.length == 0) {
                return true;
            }
            String ignoredParts = "";
            String firstPart = "";
            String secondPart = "";
            int lastA = -1;
            assert (!expression.isEmpty());
            assert (expression.charAt(expression.length() - 1) != 'a');
            assert (expression.charAt(0) != 'a');
            for (int i = 0; i <= expression.length(); ++i) {
                if (i != expression.length() && expression.charAt(i) != 'a') continue;
                ignoredParts = !firstPart.isEmpty() ? (ignoredParts.isEmpty() ? firstPart : ignoredParts + "a" + firstPart) : "";
                firstPart = expression.substring(lastA + 1, i);
                lastA = i;
                secondPart = i == expression.length() ? "" : expression.substring(i + 1, expression.length());
                if (logDEBUG) {
                    Logger.debug(this, "12in a firstPart=" + firstPart + " secondPart=" + secondPart + " for expression " + expression + " i " + i);
                }
                boolean result = false;
                int index = Integer.parseInt(firstPart);
                for (int j = 0; j < words.length; ++j) {
                    result = auxilaryVerifiers[index].checkValidity(CSSPropertyVerifier.getSubArray(words, 0, j + 1), cb);
                    if (logDEBUG) {
                        Logger.debug(this, "14in for loop result:" + result + " for " + CSSPropertyVerifier.toString(words) + " for " + firstPart);
                    }
                    if (!result) continue;
                    ParsedWord[] valueToPass = Arrays.copyOfRange(words, j + 1, words.length);
                    if (valueToPass.length == 0) {
                        if (logDEBUG) {
                            Logger.debug(this, "14opt No more words to pass, have matched everything");
                        }
                        return true;
                    }
                    String pattern = ignoredParts + (ignoredParts.isEmpty() || secondPart.isEmpty() ? "" : "a") + secondPart;
                    if (logDEBUG) {
                        Logger.debug(this, "14a " + CSSPropertyVerifier.toString(CSSPropertyVerifier.getSubArray(words, 0, j + 1)) + " can be consumed by " + index + " passing on expression=" + pattern + " value=" + CSSPropertyVerifier.toString(valueToPass));
                    }
                    if (pattern.isEmpty()) {
                        return false;
                    }
                    result = this.recursiveDoubleBarVerifier(pattern, valueToPass, cb);
                    if (!result) continue;
                    if (logDEBUG) {
                        Logger.debug(this, "15else part is true, value consumed=" + words[j]);
                    }
                    return true;
                }
            }
            if (lastA != -1) {
                return false;
            }
            int index = Integer.parseInt(expression);
            if (logDEBUG) {
                Logger.debug(this, "16Single token:" + expression + " with value=*" + Fields.commaList(words) + "* validity=" + auxilaryVerifiers[index].checkValidity(words, cb));
            }
            return auxilaryVerifiers[index].checkValidity(words, cb);
        }
    }

    static class ParsedCounter
    extends ParsedWord {
        private final ParsedIdentifier identifier;
        private final ParsedIdentifier listType;
        private final ParsedString separatorString;

        public ParsedCounter(String original, ParsedIdentifier identifier, ParsedIdentifier listType, ParsedString separatorString) {
            super(original, true);
            this.identifier = identifier;
            this.listType = listType;
            this.separatorString = separatorString;
        }

        @Override
        protected void innerEncode(boolean unicode, StringBuilder out) {
            if (this.separatorString != null) {
                out.append("counters(");
            } else {
                out.append("counter(");
            }
            this.identifier.innerEncode(unicode, out);
            if (this.separatorString != null) {
                out.append(", ");
                this.separatorString.innerEncode(unicode, out);
            }
            if (this.listType != null) {
                out.append(", ");
                this.listType.innerEncode(unicode, out);
            }
            out.append(')');
            if (this.postComma) {
                out.append(',');
            }
        }

        protected boolean addComma() {
            return false;
        }
    }

    static class SimpleParsedWord
    extends ParsedWord {
        public SimpleParsedWord(String original) {
            super(original, false);
        }

        @Override
        protected void innerEncode(boolean unicode, StringBuilder out) {
            out.append(this.original);
        }
    }

    static class ParsedAttr
    extends ParsedIdentifier {
        ParsedAttr(String original, String decoded, boolean changed) {
            super(original, decoded, changed);
        }

        @Override
        protected void innerEncode(boolean unicode, StringBuilder out) {
            out.append("attr(");
            super.innerEncode(unicode, out);
            out.append(')');
        }
    }

    static class ParsedURL
    extends ParsedString {
        ParsedURL(String original, String decoded, boolean changed, char stringChar) {
            super(original, decoded, changed || stringChar == '\u0000', stringChar == '\u0000' ? (char)'\"' : (char)stringChar);
        }

        @Override
        protected void innerEncode(boolean unicode, StringBuilder out) {
            out.append("url(");
            super.innerEncode(unicode, out);
            out.append(')');
        }

        public void setNewURL(String s) {
            super.setNewValue(s);
        }
    }

    static class ParsedString
    extends BaseParsedWord {
        final char stringChar;

        ParsedString(String original, String decoded, boolean changed, char stringChar) {
            super(original, decoded, changed);
            this.stringChar = stringChar;
        }

        @Override
        protected boolean mustEncode(char c, int i, char prevc, boolean unicode) {
            if (c == '\r' || c == '\n' || c == '\f') {
                return true;
            }
            if (c == this.stringChar) {
                return true;
            }
            return c < ' ' || c >= '\u0080' && !unicode;
        }

        @Override
        protected void innerEncode(boolean unicode, StringBuilder out) {
            out.append(this.stringChar);
            super.innerEncode(unicode, out);
            out.append(this.stringChar);
        }
    }

    static class ParsedIdentifier
    extends BaseParsedWord {
        ParsedIdentifier(String original, String decoded, boolean changed) {
            super(original, decoded, changed);
        }

        @Override
        protected boolean mustEncode(char c, int i, char prevc, boolean unicode) {
            return !(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_') && (c < '\u00a1' || !unicode) || i == 0 && c >= '0' && c <= '9' || i == 1 && prevc == '-' && c >= '0' && c <= '9';
        }
    }

    static abstract class BaseParsedWord
    extends ParsedWord {
        private String decoded;

        BaseParsedWord(String original, String decoded, boolean changed) {
            super(original, changed);
            this.decoded = decoded;
        }

        @Override
        protected void innerEncode(boolean unicode, StringBuilder out) {
            char prevc = '\u0000';
            char c = '\u0000';
            for (int i = 0; i < this.decoded.length(); ++i) {
                prevc = c;
                c = this.decoded.charAt(i);
                if (!this.mustEncode(c, i, prevc, unicode)) {
                    out.append(c);
                    continue;
                }
                this.encodeChar(c, out);
            }
        }

        protected abstract boolean mustEncode(char var1, int var2, char var3, boolean var4);

        private void encodeChar(char c, StringBuilder sb) {
            String s = Integer.toHexString(c);
            sb.append('\\');
            if (s.length() == 6) {
                sb.append(s);
            } else {
                if (s.length() > 6) {
                    throw new IllegalStateException();
                }
                int x = 6 - s.length();
                for (int i = 0; i < x; ++i) {
                    sb.append('0');
                }
                sb.append(s);
            }
        }

        public String getDecoded() {
            return this.decoded;
        }

        public void setNewValue(String s) {
            this.changed = true;
            this.decoded = s;
        }
    }

    static abstract class ParsedWord {
        final String original;
        protected boolean changed;
        public boolean postComma;

        public ParsedWord(String original, boolean changed) {
            this.original = original;
            this.changed = changed;
        }

        public String encode(boolean unicode) {
            if (!this.changed) {
                return this.original;
            }
            StringBuilder out = new StringBuilder();
            this.innerEncode(unicode, out);
            return out.toString();
        }

        public String toString() {
            return super.toString() + ":\"" + this.original + "\"";
        }

        protected abstract void innerEncode(boolean var1, StringBuilder var2);
    }
}

