/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.CSSTokenizerFilter;
import freenet.client.filter.FilterUtils;
import freenet.client.filter.HTMLFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class ElementInfo {
    public static final boolean disallowUnknownSpecificFonts = false;
    public static final boolean disallowNonAlnumFonts = true;
    public static final int UPPERLIMIT = 10;
    public static final Set<String> VOID_ELEMENTS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("area", "base", "basefont", "bgsound", "br", "col", "command", "embed", "event-source", "frame", "hr", "img", "input", "keygen", "link", "meta", "param", "source", "spacer", "wbr")));
    public static final Set<String> HTML_ELEMENTS = Collections.unmodifiableSet(new HashSet<String>(HTMLFilter.getAllowedHTMLTags()));
    public static final Set<String> REPLACED_ELEMENTS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("img", "object", "textarea", "select", "input", "applet", "button")));
    public static final Set<String> MEDIA = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("all", "aural", "braille", "embossed", "handheld", "print", "projection", "screen", "speech", "tty", "tv")));
    public static final Set<String> VISUALMEDIA = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("handheld", "print", "projection", "screen", "tty", "tv")));
    public static final Set<String> AURALMEDIA = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("speech", "aural")));
    public static final Set<String> VISUALPAGEDMEDIA = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("embossed", "handheld", "print", "projection", "screen", "tty", "tv")));
    public static final Set<String> VISUALINTERACTIVEMEDIA = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("braille", "handheld", "print", "projection", "screen", "speech", "tty", "tv")));
    public static final Set<String> FONTS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("arial", "helvetica", "arial black", "gadget", "comic sans ms", "comic sans ms5", "courier new", "courier6", "monospace georgia1", "georgia", "impact", "impact5", "charcoal6", "lucida console", "monaco5", "lucida sans unicode", "lucida grande", "palatino linotype", "book antiqua3", "palatino6", "tahoma", "geneva", "times new roman", "times", "trebuchet ms1", "verdana", "webdings", "webdings2", "wingdings", "zapf dingbats", "wingdings2", "zapf dingbats2", "ms sans serif4", "ms serif4", "new york6")));
    public static final Set<String> GENERIC_FONT_KEYWORDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("serif", "sans-serif", "cursive", "fantasy", "monospace", "system-ui", "ui-serif", "ui-sans-serif", "ui-monospace", "ui-rounded", "emoji", "math", "fangsong")));
    public static final Set<String> GENERIC_VOICE_KEYWORDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("male", "female", "child")));
    public static final Set<String> PSEUDOCLASS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("first-child", "last-child", "nth-child", "nth-last-child", "nth-of-type", "nth-last-of-type", "link", "visited", "hover", "active", "checked", "focus", "focus-within", "first-line", "first-letter", "before", "after", "target", "any-link", "default", "defined", "disabled", "empty", "enabled", "focus-visible", "indeterminate", "in-range", "invalid", "only-child", "only-of-type", "optional", "out-of-range", "placeholder-shown", "read-only", "read-write", "required", "root")));
    public static final Set<String> BANNED_PSEUDOCLASS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("link", "visited", "defined")));
    public static final boolean ALLOW_ALL_VALID_STRINGS = true;

    public static boolean isSpecificFontFamily(String font) {
        for (int i = 0; i < font.length(); ++i) {
            char c = font.charAt(i);
            if (Character.isLetterOrDigit(c) || c == ' ' || c == '.' || c == '_' || c == '-' || c == ',' || c == '+' || c == '~') continue;
            return false;
        }
        return true;
    }

    public static boolean isSpecificVoiceFamily(String font) {
        for (int i = 0; i < font.length(); ++i) {
            char c = font.charAt(i);
            if (Character.isLetterOrDigit(c) || c == ' ' || c == '.' || c == '_' || c == '-' || c == ',' || c == '+' || c == '~') continue;
            return false;
        }
        return true;
    }

    public static boolean isGenericFontFamily(String font) {
        return GENERIC_FONT_KEYWORDS.contains(font);
    }

    public static boolean isGenericVoiceFamily(String font) {
        return GENERIC_VOICE_KEYWORDS.contains(font);
    }

    public static boolean isWordPrefixOrMatchOfSpecificFontFamily(String prefix) {
        String extraSpace = prefix + " ";
        for (String s : FONTS) {
            if (!s.equals(prefix) && !s.startsWith(extraSpace)) continue;
            return true;
        }
        return false;
    }

    public static boolean isVoidElement(String element) {
        return VOID_ELEMENTS.contains(element);
    }

    public static boolean tryAutoClose(String element) {
        return "li".equals(element);
    }

    public static boolean isValidHTMLTag(String tag) {
        return HTML_ELEMENTS.contains(tag.toLowerCase()) || VOID_ELEMENTS.contains(tag.toLowerCase());
    }

    public static boolean isValidName(String name) {
        if (name.isEmpty()) {
            return false;
        }
        if (!(name.charAt(0) >= 'a' && name.charAt(0) <= 'z' || name.charAt(0) >= 'A' && name.charAt(0) <= 'Z')) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (name.charAt(i) >= 'a' && name.charAt(i) <= 'z' || name.charAt(i) >= 'A' && name.charAt(i) <= 'Z' || name.charAt(i) >= '0' && name.charAt(i) <= '9' || name.charAt(i) == '_' || name.charAt(i) == ':' || name.charAt(i) == '.' || name.charAt(i) == '-') continue;
            return false;
        }
        return true;
    }

    public static boolean isValidIdentifier(String name) {
        if (name.isEmpty()) {
            return false;
        }
        boolean escape = false;
        boolean escapeNewline = false;
        boolean digitsAllowed = false;
        int unicodeChars = 0;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (escape) {
                if (escapeNewline) {
                    escapeNewline = false;
                    escape = false;
                    if (c == '\n') continue;
                }
                escapeNewline = false;
                if ('0' <= c && '9' >= c || 'a' <= c && 'f' >= c || 'A' <= c && 'F' >= c) {
                    if (unicodeChars == 5) {
                        unicodeChars = 0;
                        escape = false;
                        continue;
                    }
                    ++unicodeChars;
                    continue;
                }
                if (unicodeChars > 0) {
                    if (c == '\r') {
                        escapeNewline = true;
                        unicodeChars = 0;
                        continue;
                    }
                    if (c != '\n' && c != '\f' && c != '\t' && c != ' ') {
                        return false;
                    }
                }
                if (c == '\r' || c == '\n' || c == '\f') {
                    return false;
                }
                escape = false;
                continue;
            }
            if (digitsAllowed && c >= '0' && c <= '9' || c == '-') continue;
            digitsAllowed = true;
            if (c == '_') continue;
            if (c == '\\') {
                escape = true;
                continue;
            }
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '\u00a1' && !Character.isISOControl(c)) continue;
            return false;
        }
        return !escape;
    }

    public static boolean isBannedPseudoClass(String cname) {
        if (cname.indexOf(58) != -1) {
            String[] split;
            for (String s : split = cname.split(":")) {
                if (!ElementInfo.isBannedPseudoClass2(s)) continue;
                return true;
            }
            return false;
        }
        return ElementInfo.isBannedPseudoClass2(cname);
    }

    private static boolean isBannedPseudoClass2(String cname) {
        return BANNED_PSEUDOCLASS.contains(cname.toLowerCase());
    }

    public static boolean isValidPseudoClass(String cname) {
        if (cname.indexOf(58) != -1) {
            String[] split;
            for (String s : split = cname.split(":")) {
                if (ElementInfo.isValidPseudoClass2(s)) continue;
                return false;
            }
            return true;
        }
        return ElementInfo.isValidPseudoClass2(cname);
    }

    private static boolean isValidPseudoClass2(String cname) {
        if (PSEUDOCLASS.contains(cname = cname.toLowerCase())) {
            return true;
        }
        if (cname.startsWith("lang") && Pattern.matches("[\\w\\-*]{1,30}", ElementInfo.getPseudoClassArg(cname, "lang"))) {
            return true;
        }
        if (cname.startsWith("nth-child") && FilterUtils.isNth(ElementInfo.getPseudoClassArg(cname, "nth-child"))) {
            return true;
        }
        if (cname.startsWith("nth-last-child") && FilterUtils.isNth(ElementInfo.getPseudoClassArg(cname, "nth-last-child"))) {
            return true;
        }
        if (cname.startsWith("nth-of-type") && FilterUtils.isNth(ElementInfo.getPseudoClassArg(cname, "nth-of-type"))) {
            return true;
        }
        if (cname.startsWith("nth-last-of-type") && FilterUtils.isNth(ElementInfo.getPseudoClassArg(cname, "nth-last-of-type"))) {
            return true;
        }
        if (cname.startsWith("dir")) {
            String arg = ElementInfo.getPseudoClassArg(cname, "dir");
            return arg.equalsIgnoreCase("ltr") || arg.equalsIgnoreCase("rtl");
        }
        return false;
    }

    public static String getPseudoClassArg(String cname, String cname_sans_arg) {
        String arg = "";
        int cnameIndex = cname.indexOf(cname_sans_arg);
        int firstIndex = cname.indexOf(40);
        int secondIndex = cname.lastIndexOf(41);
        if (cnameIndex == -1 || firstIndex == -1 || secondIndex == -1) {
            return "";
        }
        if (cname.substring(cnameIndex + cname_sans_arg.length(), firstIndex).trim().isEmpty() && cname.substring(0, cnameIndex).trim().isEmpty() && cname.substring(secondIndex + 1, cname.length()).trim().isEmpty()) {
            arg = CSSTokenizerFilter.removeOuterQuotes(cname.substring(firstIndex + 1, secondIndex).trim());
        }
        return arg;
    }

    public static boolean isValidString(String name) {
        boolean escape = false;
        boolean escapeNewline = false;
        int unicodeChars = 0;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (escape) {
                if (escapeNewline) {
                    escapeNewline = false;
                    escape = false;
                    if (c == '\n') continue;
                }
                escapeNewline = false;
                if ('0' <= c && '9' >= c || 'a' <= c && 'f' >= c || 'A' <= c && 'F' >= c) {
                    if (unicodeChars == 5) {
                        unicodeChars = 0;
                        escape = false;
                        continue;
                    }
                    ++unicodeChars;
                    continue;
                }
                if (unicodeChars > 0) {
                    if (c == '\r') {
                        escapeNewline = true;
                        unicodeChars = 0;
                        continue;
                    }
                    if (c != '\n' && c != '\f' && c != '\t' && c != ' ') {
                        return false;
                    }
                }
                if (c == '\r') {
                    escapeNewline = true;
                    continue;
                }
                if (c == '\r' || c == '\n' || c == '\f') {
                    escape = false;
                    continue;
                }
                escape = false;
                continue;
            }
            if (c == '\'' || c == '\"') {
                return false;
            }
            if (c == '\r' || c == '\n' || c == '\f') {
                return false;
            }
            if (c != '\\') continue;
            escape = true;
        }
        return !escape;
    }

    public static boolean isValidStringDecoded(String s) {
        return true;
    }

    public static boolean isValidStringWithQuotes(String string) {
        if (string.length() < 2) {
            return false;
        }
        if (string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'' || string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            string = string.substring(1, string.length() - 1);
            return ElementInfo.isValidString(string);
        }
        return false;
    }
}

