/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.client.InsertContext;
import freenet.clients.fcp.BaseDataCarryingMessage;
import freenet.clients.fcp.ClientRequest;
import freenet.clients.fcp.MessageInvalidException;
import freenet.keys.FreenetURI;
import freenet.node.RequestStarter;
import freenet.support.HexUtil;
import freenet.support.SimpleFieldSet;
import freenet.support.compress.Compressor;
import freenet.support.compress.InvalidCompressionCodecException;
import java.net.MalformedURLException;

public abstract class ClientPutDirMessage
extends BaseDataCarryingMessage {
    final String identifier;
    final FreenetURI uri;
    final int verbosity;
    final int maxRetries;
    final boolean getCHKOnly;
    final short priorityClass;
    final ClientRequest.Persistence persistence;
    final boolean dontCompress;
    final String clientToken;
    final boolean global;
    final String defaultName;
    final boolean earlyEncode;
    final boolean canWriteClientCache;
    final String compressorDescriptor;
    public boolean forkOnCacheable;
    final int extraInsertsSingleBlock;
    final int extraInsertsSplitfileHeaderBlock;
    final InsertContext.CompatibilityMode compatibilityMode;
    final byte[] overrideSplitfileCryptoKey;
    final boolean localRequestOnly;
    final boolean realTimeFlag;
    final String targetFilename;
    final boolean ignoreUSKDatehints;

    public ClientPutDirMessage(SimpleFieldSet fs) throws MessageInvalidException {
        this.identifier = fs.get("Identifier");
        this.global = fs.getBoolean("Global", false);
        this.defaultName = fs.get("DefaultName");
        String s = fs.get("CompatibilityMode");
        InsertContext.CompatibilityMode cmode = null;
        if (s == null) {
            cmode = InsertContext.CompatibilityMode.COMPAT_DEFAULT;
        } else {
            try {
                cmode = InsertContext.CompatibilityMode.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                try {
                    cmode = InsertContext.CompatibilityMode.values()[Integer.parseInt(s)];
                }
                catch (NumberFormatException e1) {
                    throw new MessageInvalidException(8, "Invalid CompatibilityMode (not a name and not a number)", this.identifier, this.global);
                }
                catch (ArrayIndexOutOfBoundsException e1) {
                    throw new MessageInvalidException(8, "Invalid CompatibilityMode (not a valid number)", this.identifier, this.global);
                }
            }
        }
        this.compatibilityMode = cmode.intern();
        s = fs.get("OverrideSplitfileCryptoKey");
        if (s == null) {
            this.overrideSplitfileCryptoKey = null;
        } else {
            try {
                this.overrideSplitfileCryptoKey = HexUtil.hexToBytes(s);
            }
            catch (NumberFormatException e1) {
                throw new MessageInvalidException(8, "Invalid splitfile crypto key (not hex)", this.identifier, this.global);
            }
            catch (IndexOutOfBoundsException e1) {
                throw new MessageInvalidException(8, "Invalid splitfile crypto key (too short)", this.identifier, this.global);
            }
        }
        this.localRequestOnly = fs.getBoolean("LocalRequestOnly", false);
        if (this.identifier == null) {
            throw new MessageInvalidException(5, "No Identifier", null, this.global);
        }
        try {
            String u = fs.get("URI");
            if (u == null) {
                throw new MessageInvalidException(5, "No URI", this.identifier, this.global);
            }
            FreenetURI uu = new FreenetURI(u);
            String[] meta = uu.getAllMetaStrings();
            if (meta != null && meta.length == 1 && meta[0].isEmpty()) {
                uu = uu.setMetaString(null);
            }
            this.uri = uu;
        }
        catch (MalformedURLException e) {
            throw new MessageInvalidException(4, e.getMessage(), this.identifier, this.global);
        }
        String verbosityString = fs.get("Verbosity");
        if (verbosityString == null) {
            this.verbosity = 0;
        } else {
            try {
                this.verbosity = Integer.parseInt(verbosityString, 10);
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, "Error parsing Verbosity field: " + e.getMessage(), this.identifier, this.global);
            }
        }
        String maxRetriesString = fs.get("MaxRetries");
        if (maxRetriesString == null) {
            this.maxRetries = 0;
        } else {
            try {
                this.maxRetries = Integer.parseInt(maxRetriesString, 10);
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, "Error parsing MaxSize field: " + e.getMessage(), this.identifier, this.global);
            }
        }
        this.getCHKOnly = fs.getBoolean("GetCHKOnly", false);
        String priorityString = fs.get("PriorityClass");
        if (priorityString == null) {
            this.priorityClass = (short)2;
        } else {
            try {
                this.priorityClass = Short.parseShort(priorityString);
                if (!RequestStarter.isValidPriorityClass(this.priorityClass)) {
                    throw new MessageInvalidException(8, "Invalid priority class " + this.priorityClass + " - range is " + 6 + " to " + 0, this.identifier, this.global);
                }
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, "Error parsing PriorityClass field: " + e.getMessage(), this.identifier, this.global);
            }
        }
        this.dontCompress = fs.getBoolean("DontCompress", false);
        String persistenceString = fs.get("Persistence");
        this.persistence = ClientRequest.Persistence.parseOrThrow(persistenceString, this.identifier, this.global);
        this.canWriteClientCache = fs.getBoolean("WriteToClientCache", false);
        this.clientToken = fs.get("ClientToken");
        this.targetFilename = fs.get("TargetFilename");
        this.earlyEncode = fs.getBoolean("EarlyEncode", false);
        String codecs = fs.get("Codecs");
        if (codecs != null) {
            Compressor.COMPRESSOR_TYPE[] ca;
            try {
                ca = Compressor.COMPRESSOR_TYPE.getCompressorsArrayNoDefault(codecs);
            }
            catch (InvalidCompressionCodecException e) {
                throw new MessageInvalidException(8, e.getMessage(), this.identifier, this.global);
            }
            if (ca == null) {
                codecs = null;
            }
        }
        this.compressorDescriptor = codecs;
        this.forkOnCacheable = fs.get("ForkOnCacheable") != null ? fs.getBoolean("ForkOnCacheable", false) : true;
        this.extraInsertsSingleBlock = fs.getInt("ExtraInsertsSingleBlock", 2);
        this.extraInsertsSplitfileHeaderBlock = fs.getInt("ExtraInsertsSplitfileHeaderBlock", 2);
        this.realTimeFlag = fs.getBoolean("RealTimeFlag", false);
        this.ignoreUSKDatehints = fs.getBoolean("IgnoreUSKDatehints", false);
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet sfs = new SimpleFieldSet(true);
        sfs.putSingle("URI", this.uri.toString());
        sfs.putSingle("Identifier", this.identifier);
        sfs.put("Verbosity", this.verbosity);
        sfs.put("MaxRetries", this.maxRetries);
        sfs.putSingle("ClientToken", this.clientToken);
        sfs.put("GetCHKOnly", this.getCHKOnly);
        sfs.put("PriorityClass", this.priorityClass);
        sfs.putSingle("Persistence", this.persistence.toString().toLowerCase());
        sfs.put("DontCompress", this.dontCompress);
        if (this.compressorDescriptor != null) {
            sfs.putSingle("Codecs", this.compressorDescriptor);
        }
        sfs.put("Global", this.global);
        sfs.putSingle("DefaultName", this.defaultName);
        return sfs;
    }
}

