/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.client.InsertContext;
import freenet.client.async.PersistenceDisabledException;
import freenet.clients.fcp.ClientPutBase;
import freenet.clients.fcp.ClientRequest;
import freenet.clients.fcp.DataCarryingMessage;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPServer;
import freenet.clients.fcp.MessageInvalidException;
import freenet.keys.FreenetURI;
import freenet.node.Node;
import freenet.node.RequestStarter;
import freenet.support.HexUtil;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.BucketFactory;
import freenet.support.api.RandomAccessBucket;
import freenet.support.compress.Compressor;
import freenet.support.compress.InvalidCompressionCodecException;
import freenet.support.io.FileBucket;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;

public class ClientPutMessage
extends DataCarryingMessage {
    public static final String NAME = "ClientPut";
    final FreenetURI uri;
    final String contentType;
    final long dataLength;
    final String identifier;
    final int verbosity;
    final int maxRetries;
    final boolean getCHKOnly;
    final short priorityClass;
    final ClientRequest.Persistence persistence;
    final ClientPutBase.UploadFrom uploadFromType;
    final String fileHash;
    final boolean dontCompress;
    final String clientToken;
    final File origFilename;
    final boolean global;
    final FreenetURI redirectTarget;
    final String targetFilename;
    final boolean earlyEncode;
    final boolean binaryBlob;
    final boolean canWriteClientCache;
    final String compressorDescriptor;
    final boolean forkOnCacheable;
    final int extraInsertsSingleBlock;
    final int extraInsertsSplitfileHeaderBlock;
    final InsertContext.CompatibilityMode compatibilityMode;
    final byte[] overrideSplitfileCryptoKey;
    final boolean localRequestOnly;
    final boolean realTimeFlag;
    final long metadataThreshold;
    final boolean ignoreUSKDatehints;

    public ClientPutMessage(SimpleFieldSet fs) throws MessageInvalidException {
        Object f;
        Object fnam = null;
        this.identifier = fs.get("Identifier");
        this.binaryBlob = fs.getBoolean("BinaryBlob", false);
        this.global = fs.getBoolean("Global", false);
        this.localRequestOnly = fs.getBoolean("LocalRequestOnly", false);
        String s = fs.get("CompatibilityMode");
        InsertContext.CompatibilityMode cmode = null;
        if (s == null) {
            cmode = InsertContext.CompatibilityMode.COMPAT_DEFAULT;
        } else {
            try {
                cmode = InsertContext.CompatibilityMode.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                try {
                    cmode = InsertContext.CompatibilityMode.values()[Integer.parseInt(s)];
                }
                catch (NumberFormatException e1) {
                    throw new MessageInvalidException(8, "Invalid CompatibilityMode (not a name and not a number)", this.identifier, this.global);
                }
                catch (ArrayIndexOutOfBoundsException e1) {
                    throw new MessageInvalidException(8, "Invalid CompatibilityMode (not a valid number)", this.identifier, this.global);
                }
            }
        }
        this.compatibilityMode = cmode.intern();
        s = fs.get("OverrideSplitfileCryptoKey");
        if (s == null) {
            this.overrideSplitfileCryptoKey = null;
        } else {
            try {
                this.overrideSplitfileCryptoKey = HexUtil.hexToBytes(s);
            }
            catch (NumberFormatException e1) {
                throw new MessageInvalidException(8, "Invalid splitfile crypto key (not hex)", this.identifier, this.global);
            }
            catch (IndexOutOfBoundsException e1) {
                throw new MessageInvalidException(8, "Invalid splitfile crypto key (too short)", this.identifier, this.global);
            }
        }
        if (this.identifier == null) {
            throw new MessageInvalidException(5, "No Identifier", null, this.global);
        }
        try {
            if (this.binaryBlob) {
                this.uri = new FreenetURI("CHK@");
            } else {
                String u = fs.get("URI");
                if (u == null) {
                    throw new MessageInvalidException(5, "No URI", this.identifier, this.global);
                }
                FreenetURI uu = new FreenetURI(u);
                String[] metas = uu.getAllMetaStrings();
                if (metas != null && metas.length == 1) {
                    fnam = metas[0];
                    uu = uu.setMetaString(null);
                }
                this.uri = uu;
            }
        }
        catch (MalformedURLException e) {
            throw new MessageInvalidException(4, e.getMessage(), this.identifier, this.global);
        }
        String verbosityString = fs.get("Verbosity");
        if (verbosityString == null) {
            this.verbosity = 0;
        } else {
            try {
                this.verbosity = Integer.parseInt(verbosityString, 10);
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, "Error parsing Verbosity field: " + e.getMessage(), this.identifier, this.global);
            }
        }
        this.contentType = fs.get("Metadata.ContentType");
        String maxRetriesString = fs.get("MaxRetries");
        if (maxRetriesString == null) {
            this.maxRetries = 0;
        } else {
            try {
                this.maxRetries = Integer.parseInt(maxRetriesString, 10);
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, "Error parsing MaxSize field: " + e.getMessage(), this.identifier, this.global);
            }
        }
        this.getCHKOnly = fs.getBoolean("GetCHKOnly", false);
        String priorityString = fs.get("PriorityClass");
        if (priorityString == null) {
            this.priorityClass = (short)2;
        } else {
            try {
                this.priorityClass = Short.parseShort(priorityString);
                if (!RequestStarter.isValidPriorityClass(this.priorityClass)) {
                    throw new MessageInvalidException(8, "Invalid priority class " + this.priorityClass + " - range is " + 6 + " to " + 0, this.identifier, this.global);
                }
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, "Error parsing PriorityClass field: " + e.getMessage(), this.identifier, this.global);
            }
        }
        this.fileHash = fs.get("FileHash");
        String uploadFrom = fs.get("UploadFrom");
        if (uploadFrom == null || uploadFrom.equalsIgnoreCase("direct")) {
            this.uploadFromType = ClientPutBase.UploadFrom.DIRECT;
            String dataLengthString = fs.get("DataLength");
            if (dataLengthString == null) {
                throw new MessageInvalidException(5, "Need DataLength on a ClientPut", this.identifier, this.global);
            }
            try {
                this.dataLength = Long.parseLong(dataLengthString, 10);
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, "Error parsing DataLength field: " + e.getMessage(), this.identifier, this.global);
            }
            this.origFilename = null;
            this.redirectTarget = null;
        } else if (uploadFrom.equalsIgnoreCase("disk")) {
            this.uploadFromType = ClientPutBase.UploadFrom.DISK;
            String filename = fs.get("Filename");
            if (filename == null) {
                throw new MessageInvalidException(5, "Missing field Filename", this.identifier, this.global);
            }
            f = new File(filename);
            if (!(((File)f).exists() && ((File)f).isFile() && ((File)f).canRead())) {
                throw new MessageInvalidException(9, null, this.identifier, this.global);
            }
            this.dataLength = ((File)f).length();
            FileBucket fileBucket = new FileBucket((File)f, true, false, false, false);
            this.bucket = fileBucket;
            this.origFilename = f;
            this.redirectTarget = null;
            if (fnam == null) {
                fnam = this.origFilename.getName();
            }
        } else if (uploadFrom.equalsIgnoreCase("redirect")) {
            this.uploadFromType = ClientPutBase.UploadFrom.REDIRECT;
            String target = fs.get("TargetURI");
            if (target == null) {
                throw new MessageInvalidException(5, "TargetURI missing but UploadFrom=redirect", this.identifier, this.global);
            }
            try {
                this.redirectTarget = new FreenetURI(target);
            }
            catch (MalformedURLException e) {
                throw new MessageInvalidException(8, "Invalid TargetURI: " + e, this.identifier, this.global);
            }
            this.dataLength = 0L;
            this.origFilename = null;
            this.bucket = null;
        } else {
            throw new MessageInvalidException(8, "UploadFrom invalid or unrecognized: " + uploadFrom, this.identifier, this.global);
        }
        this.dontCompress = fs.getBoolean("DontCompress", false);
        String persistenceString = fs.get("Persistence");
        this.persistence = ClientRequest.Persistence.parseOrThrow(persistenceString, this.identifier, this.global);
        this.canWriteClientCache = fs.getBoolean("WriteToClientCache", false);
        this.clientToken = fs.get("ClientToken");
        f = fs.get("TargetFilename");
        if (f != null) {
            fnam = f;
        }
        if (fnam != null && ((String)fnam).indexOf(47) > -1) {
            throw new MessageInvalidException(8, "TargetFilename must not contain slashes", this.identifier, this.global);
        }
        if (fnam != null && ((String)fnam).isEmpty()) {
            fnam = null;
        }
        this.targetFilename = this.uri.getRoutingKey() == null && !this.uri.isKSK() ? fnam : null;
        this.earlyEncode = fs.getBoolean("EarlyEncode", false);
        String codecs = fs.get("Codecs");
        if (codecs != null) {
            Compressor.COMPRESSOR_TYPE[] ca;
            try {
                ca = Compressor.COMPRESSOR_TYPE.getCompressorsArrayNoDefault(codecs);
            }
            catch (InvalidCompressionCodecException e) {
                throw new MessageInvalidException(8, e.getMessage(), this.identifier, this.global);
            }
            if (ca == null) {
                codecs = null;
            }
        }
        this.compressorDescriptor = codecs;
        this.forkOnCacheable = fs.get("ForkOnCacheable") != null ? fs.getBoolean("ForkOnCacheable", false) : true;
        this.extraInsertsSingleBlock = fs.getInt("ExtraInsertsSingleBlock", 2);
        this.extraInsertsSplitfileHeaderBlock = fs.getInt("ExtraInsertsSplitfileHeaderBlock", 2);
        this.realTimeFlag = fs.getBoolean("RealTimeFlag", false);
        this.metadataThreshold = fs.getLong("MetadataThreshold", -1L);
        this.ignoreUSKDatehints = fs.getBoolean("IgnoreUSKDatehints", false);
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet sfs = new SimpleFieldSet(true);
        sfs.putSingle("URI", this.uri.toString());
        sfs.putSingle("Identifier", this.identifier);
        sfs.put("Verbosity", this.verbosity);
        sfs.put("MaxRetries", this.maxRetries);
        sfs.putSingle("Metadata.ContentType", this.contentType);
        sfs.putSingle("ClientToken", this.clientToken);
        switch (this.uploadFromType) {
            case DIRECT: {
                sfs.putSingle("UploadFrom", "direct");
                sfs.put("DataLength", this.dataLength);
                break;
            }
            case DISK: {
                sfs.putSingle("UploadFrom", "disk");
                sfs.putSingle("Filename", this.origFilename.getAbsolutePath());
                sfs.put("DataLength", this.dataLength);
                break;
            }
            case REDIRECT: {
                sfs.putSingle("UploadFrom", "redirect");
                sfs.putSingle("TargetURI", this.redirectTarget.toString());
            }
        }
        sfs.put("GetCHKOnly", this.getCHKOnly);
        sfs.put("PriorityClass", this.priorityClass);
        sfs.putSingle("Persistence", this.persistence.toString().toLowerCase());
        sfs.put("DontCompress", this.dontCompress);
        if (this.compressorDescriptor != null) {
            sfs.putSingle("Codecs", this.compressorDescriptor);
        }
        sfs.put("Global", this.global);
        sfs.put("BinaryBlob", this.binaryBlob);
        return sfs;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        handler.startClientPut(this);
    }

    @Override
    long dataLength() {
        if (this.uploadFromType == ClientPutBase.UploadFrom.DIRECT) {
            return this.dataLength;
        }
        return -1L;
    }

    @Override
    String getIdentifier() {
        return this.identifier;
    }

    @Override
    RandomAccessBucket createBucket(BucketFactory bf, long length, FCPServer server) throws IOException, PersistenceDisabledException {
        if (this.persistence == ClientRequest.Persistence.FOREVER) {
            if (server.getCore().killedDatabase()) {
                throw new PersistenceDisabledException();
            }
            return server.getCore().getPersistentTempBucketFactory().makeBucket(length);
        }
        return super.createBucket(bf, length, server);
    }

    @Override
    boolean isGlobal() {
        return this.global;
    }

    public void freeData() {
        if (this.bucket == null) {
            if (this.dataLength() <= 0L) {
                return;
            }
            Logger.error(this, "bucket is null on " + this + " - freed twice?", (Throwable)new Exception("error"));
            return;
        }
        this.bucket.free();
    }
}

