/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.MessageInvalidException;
import freenet.clients.fcp.MultipleDataCarryingMessage;
import freenet.node.Node;
import freenet.support.SimpleFieldSet;
import freenet.support.io.ArrayBucket;
import java.nio.charset.StandardCharsets;

public class FeedMessage
extends MultipleDataCarryingMessage {
    public static final String NAME = "Feed";
    private String header;
    private String shortText;
    private final short priorityClass;
    private final long updatedTime;

    public FeedMessage(String header, String shortText, String text, short priorityClass, long updatedTime) {
        this.header = header;
        this.shortText = shortText;
        this.priorityClass = priorityClass;
        this.updatedTime = updatedTime;
        ArrayBucket textBucket = new ArrayBucket(text.getBytes(StandardCharsets.UTF_8));
        this.buckets.put("Text", textBucket);
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = super.getFieldSet();
        fs.putSingle("Header", this.header);
        fs.putSingle("ShortText", this.shortText);
        fs.put("PriorityClass", this.priorityClass);
        fs.put("UpdatedTime", this.updatedTime);
        return fs;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, this.getName() + " goes from server to client not the other way around", null, false);
    }

    @Override
    public String getName() {
        return NAME;
    }
}

