/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.filter.PushingTagReplacerCallback;
import freenet.clients.http.HTTPRequestImpl;
import freenet.clients.http.InfoboxNode;
import freenet.clients.http.LinkEnabledCallback;
import freenet.clients.http.PageNode;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContainer;
import freenet.clients.http.ToadletContext;
import freenet.l10n.NodeL10n;
import freenet.node.DarknetPeerNode;
import freenet.node.Node;
import freenet.node.SecurityLevels;
import freenet.pluginmanager.FredPluginL10n;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.api.HTTPRequest;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PageMaker {
    public static final int MODE_SIMPLE = 1;
    public static final int MODE_ADVANCED = 2;
    private static final String MODE_SWITCH_PARAMETER = "fproxyAdvancedMode";
    private THEME theme;
    private String override;
    private final Node node;
    private List<SubMenu> menuList = new ArrayList<SubMenu>();
    private Map<String, SubMenu> subMenus = new HashMap<String, SubMenu>();

    protected PageMaker(THEME t, Node n) {
        this.setTheme(t);
        this.node = n;
    }

    void setOverride(String pointTo) {
        this.override = pointTo;
    }

    public void setTheme(THEME theme2) {
        URL themeurl;
        this.theme = theme2 == null ? THEME.getDefault() : ((themeurl = this.getClass().getResource("staticfiles/themes/" + theme2.code + "/theme.css")) == null ? THEME.getDefault() : theme2);
    }

    public synchronized void addNavigationCategory(String link, String name, String title, FredPluginL10n plugin) {
        SubMenu menu = new SubMenu(link, name, title, plugin);
        this.subMenus.put(name, menu);
        this.menuList.add(menu);
    }

    public synchronized void addNavigationCategory(String link, String name, String title, FredPluginL10n plugin, int menuOffset) {
        SubMenu menu = new SubMenu(link, name, title, plugin);
        this.subMenus.put(name, menu);
        this.menuList.add(menuOffset, menu);
    }

    public synchronized void removeNavigationCategory(String name) {
        SubMenu menu = this.subMenus.remove(name);
        if (menu == null) {
            Logger.error(this, "can't remove navigation category, name=" + name);
            return;
        }
        this.menuList.remove(menu);
    }

    public synchronized void addNavigationLink(String menutext, String path, String name, String title, boolean fullOnly, LinkEnabledCallback cb, FredPluginL10n l10n) {
        SubMenu menu = this.subMenus.get(menutext);
        if (menu == null) {
            throw new NullPointerException("there is no menu named " + menutext);
        }
        menu.addNavigationLink(path, name, title, fullOnly, cb, l10n);
    }

    public synchronized void removeNavigationLink(String menutext, String name) {
        SubMenu menu = this.subMenus.get(menutext);
        if (menu != null) {
            menu.removeNavigationLink(name);
        }
    }

    public HTMLNode createBackLink(ToadletContext toadletContext, String name) {
        String referer = toadletContext.getHeaders().getFirst("referer");
        if (referer != null) {
            return new HTMLNode("a", new String[]{"href", "title"}, new String[]{referer, name}, name);
        }
        return new HTMLNode("a", new String[]{"href", "title"}, new String[]{"javascript:back()", name}, name);
    }

    public PageNode getPageNode(String title, ToadletContext ctx) {
        return this.getPageNode(title, true, ctx);
    }

    @Deprecated
    public PageNode getPageNode(String title, boolean renderNavigationLinks, ToadletContext ctx) {
        return this.getPageNode(title, renderNavigationLinks, true, ctx);
    }

    @Deprecated
    public PageNode getPageNode(String title, boolean renderNavigationLinks, boolean renderStatus, ToadletContext ctx) {
        return this.getPageNode(title, ctx, new RenderParameters().renderNavigationLinks(renderNavigationLinks).renderStatus(renderStatus).renderModeSwitch(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageNode getPageNode(String title, ToadletContext ctx, RenderParameters renderParameters) {
        Object physical;
        Toadlet t;
        boolean webPushingEnabled;
        URL themeJsUrl;
        boolean sendAllThemes;
        boolean fullAccess = ctx == null ? false : ctx.isAllowedFullAccess();
        HTMLNode.HTMLDoctype pageNode = new HTMLNode.HTMLDoctype("html", "-//W3C//DTD XHTML 1.1//EN");
        HTMLNode htmlNode = pageNode.addChild("html", "xml:lang", NodeL10n.getBase().getSelectedLanguage().isoCode);
        HTMLNode headNode = htmlNode.addChild("head");
        headNode.addChild("meta", new String[]{"http-equiv", "content"}, new String[]{"Content-Type", "text/html; charset=utf-8"});
        headNode.addChild("title", title + " - Freenet");
        headNode.addChild("noscript").addChild("style", " .jsonly {display:none;}");
        if (this.override != null) {
            headNode.addChild(this.getOverrideContent());
        } else {
            headNode.addChild("link", new String[]{"rel", "href", "type", "title"}, new String[]{"stylesheet", "/static/themes/" + this.theme.code + "/theme.css", "text/css", this.theme.code});
        }
        boolean bl = sendAllThemes = ctx != null && ctx.getContainer().sendAllThemes();
        if (sendAllThemes) {
            for (THEME t2 : THEME.values()) {
                String themeName = t2.code;
                headNode.addChild("link", new String[]{"rel", "href", "type", "media", "title"}, new String[]{"alternate stylesheet", "/static/themes/" + themeName + "/theme.css", "text/css", "screen", themeName});
            }
        }
        if (ctx != null && ctx.getContainer().isFProxyJavascriptEnabled() && (themeJsUrl = this.getClass().getResource("staticfiles/themes/" + this.theme.code + "/script.js")) != null) {
            headNode.addChild("script", new String[]{"type", "language", "src"}, new String[]{"text/javascript", "javascript", "/static/themes/" + this.theme.code + "/script.js"});
        }
        boolean bl2 = webPushingEnabled = ctx != null && ctx.getContainer().isFProxyJavascriptEnabled() && ctx.getContainer().isFProxyWebPushingEnabled();
        if (webPushingEnabled) {
            headNode.addChild("script", new String[]{"type", "language", "src"}, new String[]{"text/javascript", "javascript", "/static/freenetjs/freenetjs.nocache.js"});
        }
        if (ctx != null) {
            t = ctx.activeToadlet();
            t = t.showAsToadlet(ctx);
        } else {
            t = null;
        }
        String activePath = "";
        if (t != null) {
            activePath = t.path();
        }
        HTMLNode bodyNode = htmlNode.addChild("body", new String[]{"class", "id"}, new String[]{"fproxy-page", PageMaker.filterCSSIdentifier("page-" + activePath)});
        if (webPushingEnabled) {
            bodyNode.addChild("input", new String[]{"type", "name", "value", "id"}, new String[]{"hidden", "requestId", ctx.getUniqueId(), "requestId"});
        }
        if (webPushingEnabled) {
            bodyNode.addChild("script", new String[]{"type", "language"}, new String[]{"text/javascript", "javascript"}).addChild("%", PushingTagReplacerCallback.getClientSideLocalizationScript());
        }
        HTMLNode pageDiv = bodyNode.addChild("div", "id", "page");
        HTMLNode topBarDiv = pageDiv.addChild("div", "id", "topbar");
        if (renderParameters.isRenderStatus() && fullAccess) {
            HTMLNode alerts;
            HTMLNode statusBarDiv = pageDiv.addChild("div", "id", "statusbar-container").addChild("div", "id", "statusbar");
            if (this.node != null && this.node.getClientCore() != null && (alerts = ctx.getAlertManager().createSummary(true)) != null) {
                statusBarDiv.addChild(alerts).addAttribute("id", "statusbar-alerts");
                statusBarDiv.addChild("div", "class", "separator", "\u00a0");
            }
            statusBarDiv.addChild("div", "id", "statusbar-language").addChild("a", "href", "/config/node#l10n", NodeL10n.getBase().getSelectedLanguage().fullName);
            if (this.node.getClientCore() != null && ctx != null && renderParameters.isRenderModeSwitch()) {
                boolean isAdvancedMode = ctx.isAdvancedModeEnabled();
                String uri = ctx.getUri().getQuery();
                Map<String, List<String>> parameters = HTTPRequestImpl.parseUriParameters(uri, true);
                ArrayList<String> newModeSwitchValues = new ArrayList<String>();
                newModeSwitchValues.add(String.valueOf(isAdvancedMode ? 1 : 2));
                parameters.put(MODE_SWITCH_PARAMETER, newModeSwitchValues);
                statusBarDiv.addChild("div", "class", "separator", "\u00a0");
                HTMLNode switchMode = statusBarDiv.addChild("div", "id", "statusbar-switchmode");
                switchMode.addAttribute("class", isAdvancedMode ? "simple" : "advanced");
                switchMode.addChild("a", "href", "?" + HTTPRequestImpl.createQueryString(parameters, false), isAdvancedMode ? NodeL10n.getBase().getString("StatusBar.switchToSimpleMode") : NodeL10n.getBase().getString("StatusBar.switchToAdvancedMode"));
            }
            if (this.node != null && this.node.getClientCore() != null) {
                statusBarDiv.addChild("div", "class", "separator", "\u00a0");
                HTMLNode secLevels = statusBarDiv.addChild("div", "id", "statusbar-seclevels", NodeL10n.getBase().getString("SecurityLevels.statusBarPrefix"));
                HTMLNode network = secLevels.addChild("a", "href", "/seclevels/", SecurityLevels.localisedName(this.node.getSecurityLevels().getNetworkThreatLevel()) + "\u00a0");
                network.addAttribute("title", NodeL10n.getBase().getString("SecurityLevels.networkThreatLevelShort"));
                network.addAttribute("class", this.node.getSecurityLevels().getNetworkThreatLevel().toString().toLowerCase());
                physical = secLevels.addChild("a", "href", "/seclevels/", SecurityLevels.localisedName(this.node.getSecurityLevels().getPhysicalThreatLevel()));
                ((HTMLNode)physical).addAttribute("title", NodeL10n.getBase().getString("SecurityLevels.physicalThreatLevelShort"));
                ((HTMLNode)physical).addAttribute("class", this.node.getSecurityLevels().getPhysicalThreatLevel().toString().toLowerCase());
                statusBarDiv.addChild("div", "class", "separator", "\u00a0");
                int connectedPeers = this.node.getPeers().countConnectedPeers();
                int darknetTotal = 0;
                for (DarknetPeerNode n : this.node.getPeers().getDarknetPeers()) {
                    if (n == null || n.isDisabled()) continue;
                    ++darknetTotal;
                }
                int connectedDarknetPeers = this.node.getPeers().countConnectedDarknetPeers();
                int totalPeers = this.node.getOpennet() == null ? (darknetTotal > 0 ? darknetTotal : Integer.MAX_VALUE) : this.node.getOpennet().getNumberOfConnectedPeersToAimIncludingDarknet();
                double connectedRatio = (double)connectedPeers / (double)totalPeers;
                String additionalClass = connectedPeers > connectedDarknetPeers ? (connectedRatio < 0.3 || connectedPeers < 3 ? "very-few-peers" : (connectedRatio < 0.5 ? "few-peers" : (connectedRatio < 0.75 ? "avg-peers" : "full-peers"))) : (connectedDarknetPeers < 3 ? "very-few-peers" : (connectedDarknetPeers < 5 ? "few-peers" : (connectedDarknetPeers < 10 ? "avg-peers" : "full-peers")));
                HTMLNode progressBar = statusBarDiv.addChild("div", "class", "progressbar");
                progressBar.addChild("div", new String[]{"class", "style"}, new String[]{"progressbar-done progressbar-peers " + additionalClass, "width: " + Math.min(100.0, Math.floor(100.0 * connectedRatio)) + "%;"});
                progressBar.addChild("div", new String[]{"class", "title"}, new String[]{"progress_fraction_finalized", NodeL10n.getBase().getString("StatusBar.connectedPeers", new String[]{"X", "Y"}, new String[]{Integer.toString(this.node.getPeers().countConnectedDarknetPeers()), Integer.toString(this.node.getPeers().countConnectedOpennetPeers())})}, Integer.toString(connectedPeers) + (totalPeers != Integer.MAX_VALUE ? " / " + Integer.toString(totalPeers) : ""));
            }
        }
        topBarDiv.addChild("h1", title);
        if (renderParameters.isRenderNavigationLinks()) {
            SubMenu selected = null;
            HTMLNode navbarDiv = pageDiv.addChild("div", "id", "navbar");
            HTMLNode navbarUl = navbarDiv.addChild("ul", "id", "navlist");
            physical = this;
            synchronized (physical) {
                for (SubMenu menu : this.menuList) {
                    HTMLNode listItem;
                    HTMLNode subnavlist = new HTMLNode("ul");
                    boolean isSelected = false;
                    boolean nonEmpty = false;
                    for (String navigationLink : fullAccess ? menu.navigationLinkTexts : menu.navigationLinkTextsNonFull) {
                        HTMLNode sublistItem;
                        LinkEnabledCallback cb = (LinkEnabledCallback)menu.navigationLinkCallbacks.get(navigationLink);
                        if (cb != null && !cb.isEnabled(ctx)) continue;
                        nonEmpty = true;
                        String navigationTitle = (String)menu.navigationLinkTitles.get(navigationLink);
                        String navigationPath = (String)menu.navigationLinks.get(navigationLink);
                        if (activePath.equals(navigationPath)) {
                            sublistItem = subnavlist.addChild("li", "class", "submenuitem-selected");
                            isSelected = true;
                        } else {
                            sublistItem = subnavlist.addChild("li", "class", "submenuitem-not-selected");
                        }
                        FredPluginL10n l10n = (FredPluginL10n)menu.navigationLinkL10n.get(navigationLink);
                        if (l10n == null) {
                            l10n = menu.plugin;
                        }
                        if (l10n != null) {
                            sublistItem.addAttribute("id", PageMaker.getPluginL10nCSSIdentifier(l10n, navigationTitle));
                            if (navigationTitle != null) {
                                String newNavigationTitle = l10n.getString(navigationTitle);
                                if (newNavigationTitle == null) {
                                    Logger.error(this, "Plugin '" + l10n + "' did return null in getString(key)!");
                                } else {
                                    navigationTitle = newNavigationTitle;
                                }
                            }
                            if (navigationLink != null) {
                                String newNavigationLink = l10n.getString(navigationLink);
                                if (newNavigationLink == null) {
                                    Logger.error(this, "Plugin '" + l10n + "' did return null in getString(key)!");
                                } else {
                                    navigationLink = newNavigationLink;
                                }
                            }
                        } else {
                            sublistItem.addAttribute("id", PageMaker.filterCSSIdentifier(navigationTitle));
                            if (navigationTitle != null) {
                                navigationTitle = NodeL10n.getBase().getString(navigationTitle);
                            }
                            if (navigationLink != null) {
                                navigationLink = NodeL10n.getBase().getString(navigationLink);
                            }
                        }
                        if (navigationTitle != null) {
                            sublistItem.addChild("a", new String[]{"href", "title"}, new String[]{navigationPath, navigationTitle}, navigationLink);
                            continue;
                        }
                        sublistItem.addChild("a", "href", navigationPath, navigationLink);
                    }
                    if (!nonEmpty) continue;
                    if (isSelected) {
                        selected = menu;
                        subnavlist.addAttribute("class", "subnavlist-selected");
                        listItem = new HTMLNode("li", "class", "navlist-selected");
                    } else {
                        subnavlist.addAttribute("class", "subnavlist");
                        listItem = new HTMLNode("li", "class", "navlist-not-selected");
                    }
                    String menuItemTitle = menu.defaultNavigationLinkTitle;
                    String text = menu.navigationLinkText;
                    if (menu.plugin == null) {
                        listItem.addAttribute("id", PageMaker.filterCSSIdentifier(menuItemTitle));
                        menuItemTitle = NodeL10n.getBase().getString(menuItemTitle);
                        text = NodeL10n.getBase().getString(text);
                    } else {
                        listItem.addAttribute("id", PageMaker.getPluginL10nCSSIdentifier(menu.plugin, text));
                        String newTitle = menu.plugin.getString(menuItemTitle);
                        if (newTitle == null) {
                            Logger.error(this, "Plugin '" + menu.plugin + "' did return null in getString(key)!");
                        } else {
                            menuItemTitle = newTitle;
                        }
                        String newText = menu.plugin.getString(text);
                        if (newText == null) {
                            Logger.error(this, "Plugin '" + menu.plugin + "' did return null in getString(key)!");
                        } else {
                            text = newText;
                        }
                    }
                    listItem.addChild("a", new String[]{"href", "title"}, new String[]{menu.defaultNavigationLink, menuItemTitle}, text);
                    listItem.addChild(subnavlist);
                    navbarUl.addChild(listItem);
                }
            }
            if (selected != null) {
                HTMLNode div = new HTMLNode("div", "id", "selected-subnavbar");
                HTMLNode subnavlist = div.addChild("ul", "id", "selected-subnavbar-list");
                boolean nonEmpty = false;
                for (String navigationLink : fullAccess ? selected.navigationLinkTexts : selected.navigationLinkTextsNonFull) {
                    LinkEnabledCallback cb = (LinkEnabledCallback)selected.navigationLinkCallbacks.get(navigationLink);
                    if (cb != null && !cb.isEnabled(ctx)) continue;
                    nonEmpty = true;
                    String navigationTitle = (String)selected.navigationLinkTitles.get(navigationLink);
                    String navigationPath = (String)selected.navigationLinks.get(navigationLink);
                    HTMLNode sublistItem = activePath.equals(navigationPath) ? subnavlist.addChild("li", "class", "submenuitem-selected") : subnavlist.addChild("li", "class", "submenuitem-not-selected");
                    FredPluginL10n l10n = (FredPluginL10n)selected.navigationLinkL10n.get(navigationLink);
                    if (l10n == null) {
                        l10n = selected.plugin;
                    }
                    if (l10n != null) {
                        if (navigationTitle != null) {
                            navigationTitle = l10n.getString(navigationTitle);
                        }
                        if (navigationLink != null) {
                            navigationLink = l10n.getString(navigationLink);
                        }
                    } else {
                        if (navigationTitle != null) {
                            navigationTitle = NodeL10n.getBase().getString(navigationTitle);
                        }
                        if (navigationLink != null) {
                            navigationLink = NodeL10n.getBase().getString(navigationLink);
                        }
                    }
                    if (navigationTitle != null) {
                        sublistItem.addChild("a", new String[]{"href", "title"}, new String[]{navigationPath, navigationTitle}, navigationLink);
                        continue;
                    }
                    sublistItem.addChild("a", "href", navigationPath, navigationLink);
                }
                if (nonEmpty) {
                    pageDiv.addChild(div);
                }
            }
        }
        HTMLNode contentDiv = pageDiv.addChild("div", "id", "content");
        return new PageNode(pageNode, headNode, contentDiv);
    }

    public static String getPluginL10nCSSIdentifier(FredPluginL10n plugin, String key) {
        return PageMaker.filterCSSIdentifier(plugin.getClass().getName() + '-' + key);
    }

    public static String filterCSSIdentifier(String input) {
        while (input.length() < 2) {
            input = input.concat("_");
        }
        return input.replaceFirst("^-[^_a-zA-Z]", "-_").replaceAll("[^-_a-zA-Z0-9]", "_");
    }

    public THEME getTheme() {
        return this.theme;
    }

    public InfoboxNode getInfobox(String header) {
        return this.getInfobox(header, null, false);
    }

    public InfoboxNode getInfobox(HTMLNode header) {
        return this.getInfobox(header, null, false);
    }

    public InfoboxNode getInfobox(String category, String header) {
        return this.getInfobox(category, header, null, false);
    }

    public HTMLNode getInfobox(String category, String header, HTMLNode parent) {
        return this.getInfobox(category, header, parent, null, false);
    }

    public InfoboxNode getInfobox(String category, HTMLNode header) {
        return this.getInfobox(category, header, null, false);
    }

    public InfoboxNode getInfobox(String header, String title, boolean isUnique) {
        if (header == null) {
            throw new NullPointerException();
        }
        return this.getInfobox(new HTMLNode("#", header), title, isUnique);
    }

    public InfoboxNode getInfobox(HTMLNode header, String title, boolean isUnique) {
        if (header == null) {
            throw new NullPointerException();
        }
        return this.getInfobox(null, header, title, isUnique);
    }

    public InfoboxNode getInfobox(String category, String header, String title, boolean isUnique) {
        if (header == null) {
            throw new NullPointerException();
        }
        return this.getInfobox(category, new HTMLNode("#", header), title, isUnique);
    }

    public HTMLNode getInfobox(String category, String header, HTMLNode parent, String title, boolean isUnique) {
        InfoboxNode node = this.getInfobox(category, header, title, isUnique);
        parent.addChild(node.getOuterNode());
        return node.getContentNode();
    }

    public InfoboxNode getInfobox(String category, HTMLNode header, String title, boolean isUnique) {
        if (header == null) {
            throw new NullPointerException();
        }
        StringBuffer classes = new StringBuffer("infobox");
        if (category != null) {
            classes.append(" ");
            classes.append(category);
        }
        if (title != null && !isUnique) {
            classes.append(" ");
            classes.append(title);
        }
        HTMLNode infobox = new HTMLNode("div", "class", classes.toString());
        if (title != null && isUnique) {
            infobox.addAttribute("id", title);
        }
        infobox.addChild("div", "class", "infobox-header").addChild(header);
        return new InfoboxNode(infobox, infobox.addChild("div", "class", "infobox-content"));
    }

    private HTMLNode getOverrideContent() {
        return new HTMLNode("link", new String[]{"rel", "href", "type", "media", "title"}, new String[]{"stylesheet", this.override, "text/css", "screen", "custom"});
    }

    public boolean advancedMode(HTTPRequest req, ToadletContainer container) {
        return this.parseMode(req, container) >= 2;
    }

    public int parseMode(HTTPRequest req, ToadletContainer container) {
        int mode;
        int n = mode = container.isAdvancedModeEnabled() ? 2 : 1;
        if (req.isParameterSet(MODE_SWITCH_PARAMETER)) {
            if ((mode = req.getIntParam(MODE_SWITCH_PARAMETER, mode)) == 2) {
                container.setAdvancedMode(true);
            } else {
                container.setAdvancedMode(false);
            }
        }
        return mode;
    }

    public static class RenderParameters {
        private final boolean renderNavigationLinks;
        private final boolean renderStatus;
        private final boolean renderModeSwitch;

        public RenderParameters() {
            this(true, true, true);
        }

        private RenderParameters(boolean renderNavigationLinks, boolean renderStatus, boolean renderModeSwitch) {
            this.renderNavigationLinks = renderNavigationLinks;
            this.renderStatus = renderStatus;
            this.renderModeSwitch = renderModeSwitch;
        }

        public boolean isRenderNavigationLinks() {
            return this.renderNavigationLinks;
        }

        public RenderParameters renderNavigationLinks(boolean renderNavigationLinks) {
            return new RenderParameters(renderNavigationLinks, this.renderStatus, this.renderModeSwitch);
        }

        public boolean isRenderStatus() {
            return this.renderStatus;
        }

        public RenderParameters renderStatus(boolean renderStatus) {
            return new RenderParameters(this.renderNavigationLinks, renderStatus, this.renderModeSwitch);
        }

        public boolean isRenderModeSwitch() {
            return this.renderModeSwitch;
        }

        public RenderParameters renderModeSwitch(boolean renderModeSwitch) {
            return new RenderParameters(this.renderNavigationLinks, this.renderStatus, renderModeSwitch);
        }
    }

    private static class SubMenu {
        private final String navigationLinkText;
        private final String defaultNavigationLink;
        private final String defaultNavigationLinkTitle;
        private final FredPluginL10n plugin;
        private final List<String> navigationLinkTexts = new ArrayList<String>();
        private final List<String> navigationLinkTextsNonFull = new ArrayList<String>();
        private final Map<String, String> navigationLinkTitles = new HashMap<String, String>();
        private final Map<String, String> navigationLinks = new HashMap<String, String>();
        private final Map<String, LinkEnabledCallback> navigationLinkCallbacks = new HashMap<String, LinkEnabledCallback>();
        private final Map<String, FredPluginL10n> navigationLinkL10n = new HashMap<String, FredPluginL10n>();

        public SubMenu(String link, String name, String title, FredPluginL10n plugin) {
            this.navigationLinkText = name;
            this.defaultNavigationLink = link;
            this.defaultNavigationLinkTitle = title;
            this.plugin = plugin;
        }

        public void addNavigationLink(String path, String name, String title, boolean fullOnly, LinkEnabledCallback cb, FredPluginL10n l10n) {
            this.navigationLinkTexts.add(name);
            if (!fullOnly) {
                this.navigationLinkTextsNonFull.add(name);
            }
            this.navigationLinkTitles.put(name, title);
            this.navigationLinks.put(name, path);
            if (cb != null) {
                this.navigationLinkCallbacks.put(name, cb);
            }
            if (l10n != null) {
                this.navigationLinkL10n.put(name, l10n);
            }
        }

        public void removeNavigationLink(String name) {
            this.navigationLinkTexts.remove(name);
            this.navigationLinkTextsNonFull.remove(name);
            this.navigationLinkTitles.remove(name);
            this.navigationLinks.remove(name);
            this.navigationLinkL10n.remove(name);
        }
    }

    public static enum THEME {
        BOXED("boxed", "Boxed (Top menu)", "", false, false),
        BOXED_CLASSIC("boxed-classic", "Boxed (Classic menu)", "", false, false),
        BOXED_DROPDOWN("boxed-dropdown", "Boxed (Dropdown menu)", "", false, false),
        BOXED_DYNAMIC("boxed-classic", "Boxed (Dynamic menu)", "", false, false),
        BOXED_STATIC("boxed-static", "Boxed (Static menu)", "", false, false),
        CLEAN("clean", "Clean", "Mr. Proper", false, false),
        CLEAN_CLASSIC("clean-classic", "Clean (Classic menu)", "Clean theme with a classic menu.", false, false),
        CLEAN_DROPDOWN("clean-dropdown", "Clean (Dropdown menu)", "Clean theme with a dropdown menu.", false, false),
        CLEAN_STATIC("clean-static", "Clean (Static menu)", "Clean theme with a static menu.", false, false),
        CLEAN_TOP("clean-top", "Clean (Top menu)", "Clean theme with a static top menu.", false, false),
        GRAYANDBLUE("grayandblue", "Gray And Blue (Classic menu)", "", false, false),
        GRAYANDBLUE_DYNAMIC("grayandblue-dynamic", "Gray And Blue (Dynamic menu)", "", false, false),
        GRAYANDBLUE_DROPDOWN("grayandblue-dropdown", "Gray And Blue (Dropdown menu)", "", false, false),
        GRAYANDBLUE_STATIC("grayandblue-static", "Gray And Blue (Static menu)", "", false, false),
        GRAYANDBLUE_TOP("grayandblue-top", "Gray And Blue (Top menu)", "", false, false),
        SKY("sky", "Sky (Top menu)", "", false, false),
        SKY_CLASSIC("sky-classic", "Sky (Classic menu)", "", false, false),
        SKY_DROPDOWN("sky-dropdown", "Sky (Dropdown menu)", "", false, false),
        SKY_DYNAMIC("sky-dynamic", "Sky (Dynamic menu)", "", false, false),
        SKY_STATIC("sky-static", "Sky (Static menu)", "", false, false),
        SKY_DARK_STATIC("sky-dark-static", "Sky Dark (Static menu)", "", false, false),
        MINIMALBLUE("minimalblue", "Minimal Blue", "A minimalistic theme in blue", false, false),
        MINIMALISTIC("minimalist", "Minimalistic", "A very minimalistic theme based on Google's designs", true, true),
        RABBIT_HOLE("rabbit-hole", "Into the Rabbit Hole", "Simple and clean theme", false, false),
        WINTERFACEY("winterfacey", "Winterfacey", "2016th-theme, based on Winterface (Bootstrap)", true, false);

        public static final String[] possibleValues;
        public final String code;
        public final String name;
        public final String description;
        public final boolean forceActivelinks;
        public final boolean fetchKeyBoxAboveBookmarks;

        private THEME(String code, String name, String description) {
            this(code, name, description, false, false);
        }

        private THEME(String code, String name, String description, boolean forceActivelinks, boolean fetchKeyBoxAboveBookmarks) {
            this.code = code;
            this.name = name;
            this.description = description;
            this.forceActivelinks = forceActivelinks;
            this.fetchKeyBoxAboveBookmarks = fetchKeyBoxAboveBookmarks;
        }

        public static THEME themeFromName(String cssName) {
            for (THEME t : THEME.values()) {
                if (!t.code.equalsIgnoreCase(cssName) && !t.name.equalsIgnoreCase(cssName)) continue;
                return t;
            }
            return THEME.getDefault();
        }

        public static THEME getDefault() {
            return WINTERFACEY;
        }

        static {
            possibleValues = new String[]{THEME.BOXED.code, THEME.BOXED_CLASSIC.code, THEME.BOXED_DROPDOWN.code, THEME.BOXED_DYNAMIC.code, THEME.BOXED_STATIC.code, THEME.CLEAN.code, THEME.CLEAN_CLASSIC.code, THEME.CLEAN_DROPDOWN.code, THEME.CLEAN_STATIC.code, THEME.CLEAN_TOP.code, THEME.GRAYANDBLUE.code, THEME.GRAYANDBLUE_DYNAMIC.code, THEME.GRAYANDBLUE_DROPDOWN.code, THEME.GRAYANDBLUE_STATIC.code, THEME.GRAYANDBLUE_TOP.code, THEME.SKY.code, THEME.SKY_CLASSIC.code, THEME.SKY_DROPDOWN.code, THEME.SKY_DYNAMIC.code, THEME.SKY_STATIC.code, THEME.SKY_DARK_STATIC.code, THEME.MINIMALBLUE.code, THEME.MINIMALISTIC.code, THEME.RABBIT_HOLE.code, THEME.WINTERFACEY.code};
        }
    }
}

