/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.PageNode;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.l10n.NodeL10n;
import freenet.node.useralerts.AbstractNodeToNodeFileOfferUserAlert;
import freenet.node.useralerts.NodeToNodeMessageUserAlert;
import freenet.node.useralerts.UserAlert;
import freenet.support.HTMLNode;
import freenet.support.MultiValueTable;
import freenet.support.api.HTTPRequest;
import java.io.IOException;
import java.net.URI;
import java.util.NoSuchElementException;
import javax.naming.SizeLimitExceededException;

public class UserAlertsToadlet
extends Toadlet {
    private static final String DISMISS_ALL_ALERTS_PART = "dismissAllAlerts";
    private static final String DELETE_ALL_MESSAGES_PART = "deleteAllMessages";
    private static final String REALLY_DELETE_AFFIRMED = "reallyDeleteAffirmed";

    UserAlertsToadlet(HighLevelSimpleClient client) {
        super(client);
    }

    @Override
    public void handleMethodGET(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        if (!ctx.checkFullAccess(this)) {
            return;
        }
        PageNode page = ctx.getPageMaker().getPageNode(this.l10n("title"), ctx);
        HTMLNode contentNode = page.getContentNode();
        HTMLNode alertsNode = ctx.getAlertManager().createAlerts(false);
        if (alertsNode.getFirstTag() == null) {
            alertsNode = new HTMLNode("div", "class", "infobox");
            alertsNode.addChild("div", "class", "infobox-content").addChild("div", NodeL10n.getBase().getString("UserAlertsToadlet.noMessages"));
        } else {
            this.addDismissAllButtons(ctx, contentNode);
        }
        contentNode.addChild(alertsNode);
        this.writeHTMLReply(ctx, 200, "OK", page.generate());
    }

    private void addDismissAllButtons(ToadletContext ctx, HTMLNode contentNode) {
        HTMLNode dismissAlertsContainer = contentNode.addChild("div", "class", "dismiss-all-alerts-container");
        HTMLNode dismissAlertsForm = ctx.addFormChild(dismissAlertsContainer, "", "deleteAllNotificationsForm");
        dismissAlertsForm.addChild("input", new String[]{"name", "type", "title", "value"}, new String[]{DISMISS_ALL_ALERTS_PART, "submit", this.l10n("dismissAlertsButtonTitle"), this.l10n("dismissAlertsButtonContent")});
        HTMLNode deleteMessagesForm = ctx.addFormChild(dismissAlertsContainer, "", "deleteAllNotificationsForm");
        deleteMessagesForm.addChild("input", new String[]{"name", "type", "title", "value"}, new String[]{DELETE_ALL_MESSAGES_PART, "submit", this.l10n("deleteMessagesButtonTitle"), this.l10n("deleteMessagesButtonContent")});
        String deleteMessagesReallyCheckboxId = "reallyDeleteAllMessagesCheckbox";
        deleteMessagesForm.addChild("input", new String[]{"type", "name", "id", "required"}, new String[]{"checkbox", REALLY_DELETE_AFFIRMED, deleteMessagesReallyCheckboxId, "true"});
        deleteMessagesForm.addChild("label", "for", deleteMessagesReallyCheckboxId, this.l10n("deleteMessagesButtonReallyDeleteLabel"));
    }

    public void handleMethodPOST(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        String redirect;
        if (request.isPartSet("dismiss-user-alert")) {
            int userAlertHashCode = request.getIntPart("disable", -1);
            ctx.getAlertManager().dismissAlert(userAlertHashCode);
        }
        if (request.isPartSet(DISMISS_ALL_ALERTS_PART)) {
            for (UserAlert alert : ctx.getAlertManager().getAlerts()) {
                if (!alert.userCanDismiss() || alert instanceof NodeToNodeMessageUserAlert) continue;
                ctx.getAlertManager().dismissAlert(alert.hashCode());
            }
        }
        if (request.isPartSet(DELETE_ALL_MESSAGES_PART) && request.isPartSet(REALLY_DELETE_AFFIRMED)) {
            for (UserAlert alert : ctx.getAlertManager().getAlerts()) {
                if (!(alert instanceof NodeToNodeMessageUserAlert) || alert instanceof AbstractNodeToNodeFileOfferUserAlert || !alert.userCanDismiss()) continue;
                ctx.getAlertManager().dismissAlert(alert.hashCode());
            }
        }
        try {
            redirect = request.getPartAsStringThrowing("redirectToAfterDisable", 1024);
        }
        catch (NoSuchElementException | SizeLimitExceededException e) {
            redirect = ".";
        }
        if (!("/alerts/".equals(redirect) || "/".equals(redirect) || "/#bookmarks".equals(redirect))) {
            redirect = ".";
        }
        MultiValueTable<String, String> headers = MultiValueTable.from("Location", redirect);
        ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
    }

    protected String l10n(String name) {
        return NodeL10n.getBase().getString("UserAlertsToadlet." + name);
    }

    @Override
    public String path() {
        return "/alerts/";
    }
}

