/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.wizardsteps;

import freenet.node.Node;

public class BandwidthLimit {
    public static final double secondsPerMonth = 2592000.0;
    public static final Double minMonthlyLimit = (double)(2 * Node.getMinimumBandwidth()) * 2592000.0 / 1.073741824E9;
    public final long downBytes;
    public final long upBytes;
    public final String descriptionKey;
    public final boolean maybeDefault;

    public BandwidthLimit(long downBytes, long upBytes, String descriptionKey, boolean maybeDefault) {
        this.downBytes = downBytes;
        this.upBytes = upBytes;
        this.descriptionKey = descriptionKey;
        this.maybeDefault = maybeDefault;
    }

    public BandwidthLimit(long bytesPerMonth) {
        double bytesPerSecond = (double)bytesPerMonth / 2592000.0;
        double minBytesPerSecond = Node.getMinimumBandwidth();
        double bwinc = bytesPerSecond - 2.0 * minBytesPerSecond;
        double asymptoticDlFraction = 0.8;
        double dllimit = minBytesPerSecond + bwinc * asymptoticDlFraction;
        double ullimit = minBytesPerSecond + bwinc * (1.0 - asymptoticDlFraction);
        this.downBytes = (long)Math.ceil(dllimit);
        this.upBytes = (long)Math.ceil(ullimit);
        this.descriptionKey = "Monthly bandwidth limit";
        this.maybeDefault = false;
    }
}

