/*
 * Decompiled with CFR 0.152.
 */
package freenet.config;

import freenet.config.Config;
import freenet.config.InvalidConfigValueException;
import freenet.config.Option;
import freenet.config.SubConfig;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import java.util.Iterator;

public class PersistentConfig
extends Config {
    protected SimpleFieldSet origConfigFileContents;
    protected volatile boolean finishedInit;

    public PersistentConfig(SimpleFieldSet initialContents) {
        this.origConfigFileContents = initialContents;
    }

    @Override
    public synchronized void finishedInit() {
        this.finishedInit = true;
        if (this.origConfigFileContents == null) {
            return;
        }
        Iterator<String> i = this.origConfigFileContents.keyIterator();
        while (i.hasNext()) {
            String key = i.next();
            Logger.error(this, "Unknown option: " + key + " (value=" + this.origConfigFileContents.get(key) + ')');
        }
        this.origConfigFileContents = null;
        super.finishedInit();
    }

    public SimpleFieldSet exportFieldSet() {
        return this.exportFieldSet(false);
    }

    public SimpleFieldSet exportFieldSet(boolean withDefaults) {
        return this.exportFieldSet(Config.RequestType.CURRENT_SETTINGS, withDefaults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleFieldSet exportFieldSet(Config.RequestType configRequestType, boolean withDefaults) {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        SubConfig[] subConfigArray = this;
        synchronized (this) {
            SubConfig[] configs = this.configsByPrefix.values().toArray(new SubConfig[this.configsByPrefix.size()]);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            for (SubConfig current : configs) {
                SimpleFieldSet scfs = current.exportFieldSet(configRequestType, withDefaults);
                fs.tput(current.prefix, scfs);
            }
            return fs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRegister(SubConfig config, Option<?> o) {
        String val;
        String name;
        PersistentConfig persistentConfig = this;
        synchronized (persistentConfig) {
            if (this.finishedInit) {
                throw new IllegalStateException("onRegister(" + config + ':' + o + ") called after finishedInit() !!");
            }
            if (this.origConfigFileContents == null) {
                return;
            }
            name = config.prefix + '.' + o.name;
            val = this.origConfigFileContents.get(name);
            this.origConfigFileContents.removeValue(name);
            if (val == null) {
                return;
            }
        }
        try {
            o.setInitialValue(val.trim());
        }
        catch (InvalidConfigValueException e) {
            Logger.error(this, "Could not parse config option " + name + ": " + e, (Throwable)e);
        }
    }

    public synchronized SimpleFieldSet getSimpleFieldSet() {
        return this.origConfigFileContents == null ? null : new SimpleFieldSet(this.origConfigFileContents);
    }
}

