/*
 * Decompiled with CFR 0.152.
 */
package freenet.pluginmanager;

import freenet.keys.FreenetURI;
import freenet.pluginmanager.PluginManager;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class OfficialPlugins {
    private final Map<String, OfficialPluginDescription> officialPlugins = new HashMap<String, OfficialPluginDescription>();

    public OfficialPlugins() {
        try {
            this.addPlugin("Freemail").inGroup("communication").minimumVersion(15).usesXml().loadedFrom("CHK@6dfMgGf7YEfJhF0W~K0HUv0fnbuRwYH6iMqrLIbTI7k,huYBf8oBevwW6lRQnz-0jDP1dl5ej7FKeyVZ3CnH0Ec,AAMC--8/Freemail.jar").deprecated();
            this.addPlugin("Freemail_wot").inGroup("communication").recommendedVersion(33).minimumVersion(27).loadedFrom("CHK@SeUdM2xx~Pl9bCt3uzafbVM8HijDpxoQXwTxkkgqeUE,5GCNdPxg649uE~5SicWQSETGa8WVEe0RkIOSIC86UrE,AAMC--8/Freemail.jar");
            this.addPlugin("HelloWorld").inGroup("example").loadedFrom("CHK@ZdTXnWV-ikkt25-y8jmhlHjCY-nikDMQwcYlWHww5eg,Usq3uRHpHuIRmMRRlNQE7BNveO1NwNI7oNKdb7cowFM,AAIC--8/HelloWorld.jar").advanced();
            this.addPlugin("HelloFCP").inGroup("example").loadedFrom("CHK@0gtXJpw1QUJCmFOhoPRNqhsNbMtVw1CGVe46FUv7-e0,X8QqhtPkHoaFCUd89bgNaKxX1AV0WNBVf3sRgSF51-g,AAIC--8/HelloFCP.jar").advanced();
            this.addPlugin("JSTUN").inGroup("connectivity").advanced().essential().minimumVersion(2).loadedFrom("CHK@Zgib8xrGxcEuix7AVB4eajton1FpNHbIJeQZgEbHMNU,BQekU261VLSDUBQPOHSMKUF5qxY1v0zjXa33RyoEbYk,AAMC--8/JSTUN.jar");
            this.addPlugin("KeyUtils").inGroup("technical").minimumVersion(5028).loadedFrom("CHK@IQs-ssTnVh8ZuvYASea-O78hVA2y81FI7AVf2X5PXJI,J7yf0iM5Q1W4MppL0DlTyeKJMDdVQQiVlUFQAJvUzjs,AAMC--8/KeyUtils.jar");
            this.addPlugin("KeepAlive").inGroup("file-transfer").loadedFrom("CHK@mR-kJQNZYRaMRdO0D36NhLv8WnfF1sqsBe1ixKUg5lo,i-HExcBFiue3u4q5jooqRZUzRBGZJ0DSpd~~1T7fW6Q,AAMC--8/plugin-KeepAlive.jar");
            this.addPlugin("MDNSDiscovery").advanced().inGroup("connectivity").minimumVersion(2).loadedFrom("CHK@wPyhY61bsDM3OW6arFlxYX8~mBKjo~XtOTIAbT0dk88,Vr3MTAzkW5J28SJs2dTxkj6D4GVNm3u8GFsxJgzTL1M,AAIC--8/MDNSDiscovery.jar");
            this.addPlugin("SNMP").inGroup("connectivity").loadedFrom("CHK@EykJIv83UE291zONVzfXqyJYX5t66uCQJHkzQrB61MI,-npuolPZj1fcAWane2~qzRNEjKDERx52aQ5bC6NBQgw,AAIC--8/SNMP.jar").advanced();
            this.addPlugin("TestGallery").inGroup("example").minimumVersion(1).loadedFrom("CHK@LfJVh1EkCr4ry0yDW74vwxkX-3nkr~ztW2z0SUZHfC0,-mz7l39dC6n0RTUiSokjC~pUDO7PWZ89miYesKH0-WA,AAIC--8/TestGallery.jar").experimental();
            this.addPlugin("ThawIndexBrowser").inGroup("file-transfer").advanced().minimumVersion(6).usesXml().loadedFrom("CHK@9bjNQtl7ndPKh~gi4woH0Xvb7uRunJ81deIlXwGE6qg,clwp0Bhx2LZxt2XCWeARqv24tBNmjlhXDZtwAJpzlIc,AAMC--8/ThawIndexBrowser-v6.jar");
            this.addPlugin("UPnP").inGroup("connectivity").essential().advanced().recommendedVersion(10007).minimumVersion(10003).loadedFrom("CHK@ZiX8yeMHTUtNfJAgxpwH~jLRnnbb41BKEkAxOD~33tY,aBTvD3IoPKPLjnHOCNQ4-iRwqVED5kHgkmD4UhGdITk,AAMC--8/UPnP-10007.jar");
            this.addPlugin("UPnP2").inGroup("connectivity").loadedFrom("CHK@oFNunyhic~ug3lWas8Jabpwbt3heHhrFzHswN~GhPNc,j~2AHw~ZyZGNMuqW3zmukTJHysDg5lBTvrySerSPxkI,AAMC--8/freenet-UPnP2.jar");
            this.addPlugin("XMLLibrarian").inGroup("index").minimumVersion(26).usesXml().loadedFrom("CHK@TvjyCaG1dx0xIBSJkXSKA1ZT4I~NkRKeQqwC0a0bhFM,JiQe4CRjF1RwhQRFFQzP-ih9t2i0peV0tBCfJAeFCdk,AAIC--8/XMLLibrarian.jar").unsupported();
            this.addPlugin("XMLSpider").inGroup("index").minimumVersion(48).usesXml().loadedFrom("CHK@ne-aaLuzVZLcHj0YmrclaCXJqxsSb7q-J0eYEiL9V9o,v0EdgDGBhTE9k6GsB44UrQ4ADUq5LCUVknLaE4iSEBk,AAMC--8/XMLSpider.jar").unsupported();
            this.addPlugin("Freereader").inGroup("index").minimumVersion(6).usesXml().loadedFrom("CHK@SjXgPC5IEZa2g7a6gIKmNuxEKN4~eWrPhIwsznmGV-8,QUxm9R3sp3mNwhEHhL8mlx9zbOhIqIyR93tu7jD~0EU,AAMC--8/Freereader-6.jar");
            this.addPlugin("Library").inGroup("index").recommendedVersion(37).minimumVersion(36).usesXml().loadedFrom("CHK@RrYmOu8RGoEY44LOgGBBgY9qRxmiev0SFAVxWAbwROI,cfYMrDcBdewk4I7AC4J3mAq0g~NH3TxVpfeSkQ9Xaa8,AAMC--8/Library.jar").advanced();
            this.addPlugin("Spider").inGroup("index").minimumVersion(53).loadedFrom("CHK@AsgPJMi335uI0lW5ZTx7PIauP-O2piHARJQsMZPdRLE,c-WnilzeQ2JApq1GdXQPukUeMQ51teUMjgqDRoBxlpg,AAMC--8/Spider.jar").advanced();
            this.addPlugin("WebOfTrust").inGroup("communication").minimumVersion(18).recommendedVersion(20).usesXml().loadedFrom("CHK@5c0yqhe9lcM~dXWeM5jZkZAeTpsAIxozHU5j1-BvhQY,7dwiZkEwyceOfDotFe4fDeySyXFQH990~AKySmDGGrI,AAMC--8/WebOfTrust-build0020.jar");
            this.addPlugin("WebOfTrustTesting").inGroup("communication").advanced().experimental().usesXml().alwaysFetchLatestVersion().minimumVersion(17).loadedFrom("USK@QeTBVWTwBldfI-lrF~xf0nqFVDdQoSUghT~PvhyJ1NE,OjEywGD063La2H-IihD7iYtZm3rC0BP6UTvvwyF5Zh4,AQACAAE/WebOfTrustTesting.jar/17");
            this.addPlugin("FlogHelper").inGroup("communication").minimumVersion(36).usesXml().loadedFrom("CHK@zAvWPxjh2rJ7j2cAiXcm2wnDYlURL9BFDGfLBaVtjqU,Ak90k0Qw1b6CWoWZ1AMdvrUj~evz4p9vl75mg7BsEp0,AAMC--8/FlogHelper.jar");
            this.addPlugin("Sharesite").inGroup("communication").recommendedVersion(7).minimumVersion(2).loadedFrom("CHK@~JCtW4wZDI3dX1vKejUQ-y19sC6tfc5L87hcknvAT-g,x5jFuw2KkDVEQ5d31zi47y7lXAHDfcvfu6rOgQpZkHs,AAMC--8/Sharesite-0-5-1.jar");
        }
        catch (MalformedURLException mue1) {
            throw new RuntimeException("Could not create FreenetURI.", mue1);
        }
    }

    private OfficialPluginBuilder addPlugin(String name) {
        return new OfficialPluginBuilder(name);
    }

    public OfficialPluginDescription get(String name) {
        return this.officialPlugins.get(name);
    }

    public Collection<OfficialPluginDescription> getAll() {
        return Collections.unmodifiableCollection(this.officialPlugins.values());
    }

    public static class OfficialPluginDescription {
        public final String name;
        public final String group;
        public final boolean essential;
        public final long minimumVersion;
        public final long recommendedVersion;
        public final boolean alwaysFetchLatestVersion;
        public final boolean usesXML;
        public final FreenetURI uri;
        public final boolean deprecated;
        public final boolean experimental;
        public final boolean advanced;
        public final boolean unsupported;

        OfficialPluginDescription(String name, String group, boolean essential, long minVer, long recVer, boolean alwaysFetchLatestVersion, boolean usesXML, FreenetURI uri, boolean deprecated, boolean experimental, boolean advanced, boolean unsupported) {
            this.name = name;
            this.group = group;
            this.essential = essential;
            this.minimumVersion = minVer;
            this.recommendedVersion = recVer;
            this.alwaysFetchLatestVersion = alwaysFetchLatestVersion;
            this.usesXML = usesXML;
            this.deprecated = deprecated;
            this.experimental = experimental;
            this.advanced = advanced;
            this.unsupported = unsupported;
            if (alwaysFetchLatestVersion && uri != null) {
                assert (uri.isUSK()) : "Non-USK URIs do not support updates!";
                long edition = uri.getSuggestedEdition();
                if (edition >= 0L) {
                    edition = Math.min(-1L, -edition);
                }
                uri = uri.setSuggestedEdition(edition);
            }
            this.uri = uri;
        }

        public String getLocalisedPluginName() {
            return PluginManager.getOfficialPluginLocalisedName(this.name);
        }

        public String getLocalisedPluginDescription() {
            return PluginManager.l10n("pluginDesc." + this.name);
        }
    }

    private class OfficialPluginBuilder {
        private final String name;
        private String group;
        private boolean essential;
        private long minimumVersion = -1L;
        private long recommendedVersion = -1L;
        private boolean alwaysFetchLatestVersion;
        private boolean usesXml;
        private FreenetURI uri;
        private boolean deprecated;
        private boolean experimental;
        private boolean advanced;
        private boolean unsupported;

        private OfficialPluginBuilder(String name) {
            this.name = name;
            this.addCurrentPluginDescription();
        }

        public OfficialPluginBuilder inGroup(String group) {
            this.group = group;
            this.addCurrentPluginDescription();
            return this;
        }

        public OfficialPluginBuilder essential() {
            this.essential = true;
            this.addCurrentPluginDescription();
            return this;
        }

        public OfficialPluginBuilder minimumVersion(int minimumVersion) {
            this.minimumVersion = minimumVersion;
            this.addCurrentPluginDescription();
            return this;
        }

        public OfficialPluginBuilder recommendedVersion(int recommendedVersion) {
            this.recommendedVersion = recommendedVersion;
            this.addCurrentPluginDescription();
            return this;
        }

        public OfficialPluginBuilder alwaysFetchLatestVersion() {
            this.alwaysFetchLatestVersion = true;
            this.addCurrentPluginDescription();
            return this;
        }

        public OfficialPluginBuilder usesXml() {
            this.usesXml = true;
            this.addCurrentPluginDescription();
            return this;
        }

        public OfficialPluginBuilder loadedFrom(String uri) throws MalformedURLException {
            this.uri = new FreenetURI(uri);
            this.addCurrentPluginDescription();
            return this;
        }

        public OfficialPluginBuilder deprecated() {
            this.deprecated = true;
            this.addCurrentPluginDescription();
            return this;
        }

        public OfficialPluginBuilder experimental() {
            this.experimental = true;
            this.addCurrentPluginDescription();
            return this;
        }

        public OfficialPluginBuilder advanced() {
            this.advanced = true;
            this.addCurrentPluginDescription();
            return this;
        }

        public OfficialPluginBuilder unsupported() {
            this.unsupported = true;
            this.addCurrentPluginDescription();
            return this;
        }

        private void addCurrentPluginDescription() {
            if (this.recommendedVersion == 0L && this.minimumVersion > 0L) {
                this.recommendedVersion = this.minimumVersion;
            }
            if (this.minimumVersion == 0L && this.recommendedVersion > 0L) {
                this.minimumVersion = this.recommendedVersion;
            }
            OfficialPlugins.this.officialPlugins.put(this.name, this.createOfficialPluginDescription());
        }

        private OfficialPluginDescription createOfficialPluginDescription() {
            return new OfficialPluginDescription(this.name, this.group, this.essential, this.minimumVersion, this.recommendedVersion, this.alwaysFetchLatestVersion, this.usesXml, this.uri, this.deprecated, this.experimental, this.advanced, this.unsupported);
        }
    }
}

