/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.node.FastRunnable;
import freenet.support.Executor;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.Ticker;
import freenet.support.io.NativeThread;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeMap;

public class PrioritizedTicker
implements Ticker,
Runnable {
    private static volatile boolean logMINOR;
    private final TreeMap<Long, Object> timedJobsByTime;
    private final HashMap<Job, Long> timedJobsQueued;
    final NativeThread myThread;
    final Executor executor;
    static final int MAX_SLEEP_TIME = 200;

    public PrioritizedTicker(Executor executor, int portNumber) {
        this.executor = executor;
        this.timedJobsByTime = new TreeMap();
        this.timedJobsQueued = new HashMap();
        this.myThread = new NativeThread(this, "Ticker thread for " + portNumber, NativeThread.MAX_PRIORITY, false);
        this.myThread.setDaemon(true);
    }

    public void start() {
        Logger.normal(this, "Starting Ticker");
        System.out.println("Starting Ticker");
        this.myThread.start();
    }

    @Override
    public void run() {
        if (logMINOR) {
            Logger.minor(this, "In Ticker.run()");
        }
        while (true) {
            try {
                while (true) {
                    this.realRun();
                }
            }
            catch (Throwable t) {
                Logger.error(this, "Caught in PacketSender: " + t, t);
                System.err.println("Caught in PacketSender: " + t);
                t.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realRun() {
        long now = System.currentTimeMillis();
        ArrayList<Job> jobsToRun = null;
        long sleepTime = 200L;
        TreeMap<Long, Object> treeMap = this.timedJobsByTime;
        synchronized (treeMap) {
            while (!this.timedJobsByTime.isEmpty()) {
                Long tRun = this.timedJobsByTime.firstKey();
                if (tRun <= now) {
                    Object o;
                    if (jobsToRun == null) {
                        jobsToRun = new ArrayList<Job>();
                    }
                    if ((o = this.timedJobsByTime.remove(tRun)) instanceof Job[]) {
                        for (Job r : (Job[])o) {
                            jobsToRun.add(r);
                            this.timedJobsQueued.remove(r);
                        }
                        continue;
                    }
                    Job r = (Job)o;
                    jobsToRun.add(r);
                    this.timedJobsQueued.remove(r);
                    continue;
                }
                sleepTime = Math.min(sleepTime, tRun - now);
                break;
            }
        }
        if (jobsToRun != null) {
            for (Job r : jobsToRun) {
                if (logMINOR) {
                    Logger.minor(this, "Running " + r);
                }
                if (r.job instanceof FastRunnable) {
                    try {
                        r.job.run();
                    }
                    catch (Throwable t) {
                        Logger.error(this, "Caught " + t + " running " + r, t);
                    }
                    continue;
                }
                try {
                    this.executor.execute(r.job, r.name, true);
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught in PacketSender: " + t, t);
                    System.err.println("Caught in PacketSender: " + t);
                    t.printStackTrace();
                    System.err.println("Will retry above failed operation...");
                    this.queueTimedJob(r.job, r.name, 200L, true, false);
                }
            }
        }
        if (sleepTime > 0L) {
            try {
                this.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sleep(long sleepTime) throws InterruptedException {
        if (logMINOR) {
            Logger.minor(this, "Sleeping for " + sleepTime);
        }
        PrioritizedTicker prioritizedTicker = this;
        synchronized (prioritizedTicker) {
            this.wait(sleepTime);
        }
    }

    @Override
    public void queueTimedJob(Runnable job, long offset) {
        this.queueTimedJob(job, "Scheduled job: " + job, offset, false, false);
    }

    @Override
    public void queueTimedJob(Runnable runner, String name, long offset, boolean runOnTickerAnyway, boolean noDupes) {
        long now = System.currentTimeMillis();
        if (offset < 0L) {
            offset = 0L;
        }
        this.queueTimedJobInner(runner, name, now + offset, offset, runOnTickerAnyway, noDupes);
    }

    @Override
    public void queueTimedJobAbsolute(Runnable runner, String name, long time, boolean runOnTickerAnyway, boolean noDupes) {
        long now = System.currentTimeMillis();
        this.queueTimedJobInner(runner, name, time, time - now, runOnTickerAnyway, noDupes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueTimedJobInner(Runnable runner, String name, long runJobAt, long offset, boolean runOnTickerAnyway, boolean noDupes) {
        if (noDupes) {
            runOnTickerAnyway = true;
        }
        if (offset <= 0L && !runOnTickerAnyway) {
            if (logMINOR) {
                Logger.minor(this, "Running directly: " + runner);
            }
            this.executor.execute(runner, name);
            return;
        }
        Job job = new Job(name, runner);
        TreeMap<Long, Object> treeMap = this.timedJobsByTime;
        synchronized (treeMap) {
            Object o;
            Long alreadyQueuedAt;
            if (noDupes && (alreadyQueuedAt = this.timedJobsQueued.get(job)) != null) {
                if (alreadyQueuedAt <= runJobAt) {
                    Logger.normal(this, "Not re-running as already queued: " + runner + " for " + name);
                    return;
                }
                this.removeQueuedJobInner(job, alreadyQueuedAt);
            }
            if ((o = this.timedJobsByTime.get(runJobAt)) == null) {
                this.timedJobsByTime.put(runJobAt, job);
            } else if (o instanceof Job) {
                this.timedJobsByTime.put(runJobAt, new Job[]{(Job)o, job});
            } else if (o instanceof Job[]) {
                Job[] r = (Job[])o;
                Job[] jobs = Arrays.copyOf(r, r.length + 1);
                jobs[jobs.length - 1] = job;
                this.timedJobsByTime.put(runJobAt, jobs);
            }
            this.timedJobsQueued.put(job, runJobAt);
        }
        if (offset < 200L) {
            this.wakeUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeUp() {
        PrioritizedTicker prioritizedTicker = this;
        synchronized (prioritizedTicker) {
            this.notifyAll();
        }
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int queuedJobs() {
        TreeMap<Long, Object> treeMap = this.timedJobsByTime;
        synchronized (treeMap) {
            return this.timedJobsQueued.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int queuedJobsUniqueTimes() {
        TreeMap<Long, Object> treeMap = this.timedJobsByTime;
        synchronized (treeMap) {
            return this.timedJobsByTime.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeQueuedJob(Runnable runnable) {
        Job job = new Job(null, runnable);
        TreeMap<Long, Object> treeMap = this.timedJobsByTime;
        synchronized (treeMap) {
            Long t = this.timedJobsQueued.remove(job);
            if (t != null) {
                this.removeQueuedJobInner(job, t);
            }
        }
    }

    private void removeQueuedJobInner(Job job, Long t) {
        Object o = this.timedJobsByTime.get(t);
        assert (o != null);
        if (o instanceof Job) {
            assert (o.equals(job));
            this.timedJobsByTime.remove(t);
        } else {
            Job[] jobs = (Job[])o;
            if (jobs.length == 1) {
                assert (jobs[0].equals(job));
                this.timedJobsByTime.remove(t);
            } else {
                Job[] newJobs = new Job[jobs.length - 1];
                int x = 0;
                for (Job oldjob : jobs) {
                    if (oldjob.equals(job)) continue;
                    newJobs[x++] = oldjob;
                    assert (x != jobs.length);
                }
                assert (x != 0);
                if (x == 1) {
                    this.timedJobsByTime.put(t, newJobs[0]);
                } else {
                    if (x != newJobs.length) {
                        newJobs = Arrays.copyOf(newJobs, x);
                    }
                    this.timedJobsByTime.put(t, newJobs);
                    assert (x == jobs.length - 1);
                }
            }
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    private static final class Job {
        final String name;
        final Runnable job;

        Job(String name, Runnable job) {
            this.name = name;
            this.job = job;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Job)) {
                return false;
            }
            return ((Job)o).job == this.job;
        }

        public int hashCode() {
            return this.job.hashCode();
        }
    }
}

