/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.Objects;

public class BitInputStream
implements Closeable {
    private final InputStream in;
    private final ByteOrder streamBitOrder;
    private int bitsBuffer;
    private byte bitsLeft;

    public BitInputStream(InputStream in) {
        this(in, ByteOrder.BIG_ENDIAN);
    }

    public BitInputStream(InputStream in, ByteOrder bitOrder) {
        Objects.requireNonNull(in);
        Objects.requireNonNull(bitOrder);
        this.in = in;
        this.streamBitOrder = bitOrder;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public int readBit() throws IOException {
        int n;
        if (this.bitsLeft == 0) {
            this.bitsBuffer = this.in.read();
            if (this.bitsBuffer < 0) {
                throw new EOFException();
            }
            this.bitsLeft = (byte)8;
        }
        if (this.streamBitOrder == ByteOrder.BIG_ENDIAN) {
            n = this.bitsLeft = (int)(this.bitsLeft - 1);
        } else {
            byte by = this.bitsLeft;
            this.bitsLeft = (byte)(by - 1);
            n = 8 - by;
        }
        int bitIdx = n;
        return this.bitsBuffer >> bitIdx & 1;
    }

    public int readInt(int length) throws IOException {
        return this.readInt(length, this.streamBitOrder);
    }

    public int readInt(int length, ByteOrder bitOrder) throws IOException {
        if (length == 0) {
            return 0;
        }
        if (length < 0) {
            throw new IllegalArgumentException("Invalid length: " + length + " (must be positive)");
        }
        if (this.bitsLeft == 0) {
            switch (length) {
                case 8: {
                    int b = this.in.read();
                    if (b < 0) {
                        throw new EOFException();
                    }
                    return b;
                }
                case 16: {
                    int b = this.in.read();
                    int b2 = this.in.read();
                    if ((b | b2) < 0) {
                        throw new EOFException();
                    }
                    if (bitOrder == ByteOrder.BIG_ENDIAN) {
                        return b << 8 | b2;
                    }
                    return b | b2 << 8;
                }
                case 24: {
                    int b = this.in.read();
                    int b2 = this.in.read();
                    int b3 = this.in.read();
                    if ((b | b2 | b3) < 0) {
                        throw new EOFException();
                    }
                    if (bitOrder == ByteOrder.BIG_ENDIAN) {
                        return b << 16 | b2 << 8 | b3;
                    }
                    return b | b2 << 8 | b3 << 16;
                }
                case 32: {
                    int b = this.in.read();
                    int b2 = this.in.read();
                    int b3 = this.in.read();
                    int b4 = this.in.read();
                    if ((b | b2 | b3 | b4) < 0) {
                        throw new EOFException();
                    }
                    if (bitOrder == ByteOrder.BIG_ENDIAN) {
                        return b << 24 | b2 << 16 | b3 << 8 | b4;
                    }
                    return b | b2 << 8 | b3 << 16 | b4 << 24;
                }
            }
        }
        int value = 0;
        if (bitOrder == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < length; ++i) {
                value = value << 1 | this.readBit();
            }
        } else {
            if (length % 8 == 0) {
                throw new UnsupportedOperationException("Not implemented, yet");
            }
            for (int i = 0; i < length; ++i) {
                value |= this.readBit() << i;
            }
        }
        return value;
    }

    public void readFully(byte[] b) throws IOException {
        if (this.bitsLeft == 0) {
            if (this.in.read(b) < b.length) {
                throw new EOFException();
            }
            return;
        }
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)this.readInt(8);
        }
    }

    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long remaining = n;
        if (this.bitsLeft > 0) {
            if ((long)this.bitsLeft > remaining) {
                this.readInt((int)remaining);
                return remaining;
            }
            remaining -= (long)this.bitsLeft;
            this.readInt(this.bitsLeft);
        }
        while (remaining >= 8L) {
            if (this.in.read() == -1) {
                return n - remaining;
            }
            remaining -= 8L;
        }
        while (remaining > 0L) {
            try {
                this.readBit();
                --remaining;
            }
            catch (EOFException ignored) {
                return n - remaining;
            }
        }
        return remaining;
    }
}

