/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.async.ClientBaseCallback;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.ClientRequestSchedulerGroup;
import freenet.client.async.PersistentClientCallback;
import freenet.client.async.PersistentJob;
import freenet.crypt.ChecksumChecker;
import freenet.keys.FreenetURI;
import freenet.node.RequestClient;
import freenet.node.useralerts.SimpleUserAlert;
import freenet.node.useralerts.UserAlert;
import freenet.support.Logger;
import freenet.support.io.ResumeFailedException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.WeakHashMap;

public abstract class ClientRequester
implements Serializable,
ClientRequestSchedulerGroup {
    private static final long serialVersionUID = 1L;
    private static volatile boolean logMINOR;
    protected short priorityClass;
    protected final boolean realTimeFlag;
    protected boolean cancelled;
    protected transient RequestClient client;
    private final int hashCode;
    protected int totalBlocks;
    protected int successfulBlocks;
    protected Date latestSuccess = new Date();
    protected int failedBlocks;
    protected int fatallyFailedBlocks;
    protected Date latestFailure = null;
    protected int minSuccessBlocks;
    protected boolean blockSetFinalized;
    protected boolean sentToNetwork;
    static final transient UserAlert brokenClientAlert;
    private static WeakHashMap<ClientRequester, Object> allRequesters;
    private static Object dumbValue;
    public final long creationTime;
    private transient boolean resumed = false;

    public abstract void onTransition(ClientGetState var1, ClientGetState var2, ClientContext var3);

    public short getPriorityClass() {
        return this.priorityClass;
    }

    protected ClientRequester() {
        this.realTimeFlag = false;
        this.creationTime = 0L;
        this.hashCode = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClientRequester(short priorityClass, RequestClient requestClient) {
        this.priorityClass = priorityClass;
        this.client = requestClient;
        this.realTimeFlag = this.client.realTimeFlag();
        if (this.client == null) {
            throw new NullPointerException();
        }
        this.hashCode = super.hashCode();
        WeakHashMap<ClientRequester, Object> weakHashMap = allRequesters;
        synchronized (weakHashMap) {
            if (!this.persistent()) {
                allRequesters.put(this, dumbValue);
            }
        }
        this.creationTime = System.currentTimeMillis();
    }

    protected synchronized boolean cancel() {
        boolean ret = this.cancelled;
        this.cancelled = true;
        return ret;
    }

    public abstract void cancel(ClientContext var1);

    public boolean isCancelled() {
        return this.cancelled;
    }

    public abstract FreenetURI getURI();

    public abstract boolean isFinished();

    public int hashCode() {
        return this.hashCode;
    }

    public int getTotalBlocks() {
        return this.totalBlocks;
    }

    public Date getLatestSuccess() {
        return this.latestSuccess != null ? (Date)this.latestSuccess.clone() : new Date(0L);
    }

    public Date getLatestFailure() {
        return this.latestFailure != null ? (Date)this.latestFailure.clone() : null;
    }

    protected synchronized void resetBlocks() {
        this.totalBlocks = 0;
        this.successfulBlocks = 0;
        this.latestSuccess = new Date();
        this.failedBlocks = 0;
        this.fatallyFailedBlocks = 0;
        this.latestFailure = null;
        this.minSuccessBlocks = 0;
        this.blockSetFinalized = false;
        this.sentToNetwork = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockSetFinalized(ClientContext context) {
        ClientRequester clientRequester = this;
        synchronized (clientRequester) {
            if (this.blockSetFinalized) {
                return;
            }
            this.blockSetFinalized = true;
        }
        if (logMINOR) {
            Logger.minor(this, "Finalized set of blocks for " + this, (Throwable)new Exception("debug"));
        }
        this.notifyClients(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBlock() {
        boolean wasFinalized;
        ClientRequester clientRequester = this;
        synchronized (clientRequester) {
            ++this.totalBlocks;
            wasFinalized = this.blockSetFinalized;
        }
        if (wasFinalized) {
            if (Logger.LogLevel.MINOR.matchesThreshold(Logger.globalGetThresholdNew())) {
                Logger.error(this, "addBlock() but set finalized! on " + this, (Throwable)new Exception("error"));
            } else {
                Logger.error(this, "addBlock() but set finalized! on " + this);
            }
        }
        if (logMINOR) {
            Logger.minor(this, "addBlock(): total=" + this.totalBlocks + " successful=" + this.successfulBlocks + " failed=" + this.failedBlocks + " required=" + this.minSuccessBlocks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBlocks(int num) {
        boolean wasFinalized;
        ClientRequester clientRequester = this;
        synchronized (clientRequester) {
            this.totalBlocks += num;
            wasFinalized = this.blockSetFinalized;
        }
        if (wasFinalized) {
            if (Logger.LogLevel.MINOR.matchesThreshold(Logger.globalGetThresholdNew())) {
                Logger.error(this, "addBlocks() but set finalized! on " + this, (Throwable)new Exception("error"));
            } else {
                Logger.error(this, "addBlocks() but set finalized! on " + this);
            }
        }
        if (logMINOR) {
            Logger.minor(this, "addBlocks(" + num + "): total=" + this.totalBlocks + " successful=" + this.successfulBlocks + " failed=" + this.failedBlocks + " required=" + this.minSuccessBlocks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completedBlock(boolean dontNotify, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Completed block (" + dontNotify + "): total=" + this.totalBlocks + " success=" + this.successfulBlocks + " failed=" + this.failedBlocks + " fatally=" + this.fatallyFailedBlocks + " finalised=" + this.blockSetFinalized + " required=" + this.minSuccessBlocks + " on " + this);
        }
        ClientRequester clientRequester = this;
        synchronized (clientRequester) {
            if (this.cancelled) {
                return;
            }
            ++this.successfulBlocks;
            this.latestSuccess = new Date();
        }
        if (dontNotify) {
            return;
        }
        this.notifyClients(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failedBlock(boolean dontNotify, ClientContext context) {
        ClientRequester clientRequester = this;
        synchronized (clientRequester) {
            ++this.failedBlocks;
            this.latestFailure = new Date();
        }
        if (!dontNotify) {
            this.notifyClients(context);
        }
    }

    public void failedBlock(ClientContext context) {
        this.failedBlock(false, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fatallyFailedBlock(ClientContext context) {
        ClientRequester clientRequester = this;
        synchronized (clientRequester) {
            ++this.fatallyFailedBlocks;
            this.latestFailure = new Date();
        }
        this.notifyClients(context);
    }

    public synchronized void addMustSucceedBlocks(int blocks) {
        this.totalBlocks += blocks;
        this.minSuccessBlocks += blocks;
        if (logMINOR) {
            Logger.minor(this, "addMustSucceedBlocks(" + blocks + "): total=" + this.totalBlocks + " successful=" + this.successfulBlocks + " failed=" + this.failedBlocks + " required=" + this.minSuccessBlocks);
        }
    }

    public synchronized void addRedundantBlocksInsert(int blocks) {
        this.totalBlocks += blocks;
        this.minSuccessBlocks += blocks;
        if (logMINOR) {
            Logger.minor(this, "addMustSucceedBlocks(" + blocks + "): total=" + this.totalBlocks + " successful=" + this.successfulBlocks + " failed=" + this.failedBlocks + " required=" + this.minSuccessBlocks);
        }
    }

    public final void notifyClients(ClientContext context) {
        context.getJobRunner(this.persistent()).queueNormalOrDrop(new PersistentJob(){

            @Override
            public boolean run(ClientContext context) {
                ClientRequester.this.innerNotifyClients(context);
                return false;
            }
        });
    }

    protected abstract void innerNotifyClients(ClientContext var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toNetwork(ClientContext context) {
        ClientRequester clientRequester = this;
        synchronized (clientRequester) {
            if (this.sentToNetwork) {
                return;
            }
            this.sentToNetwork = true;
        }
        this.innerToNetwork(context);
    }

    protected abstract void innerToNetwork(ClientContext var1);

    protected void clearCountersOnRestart() {
        this.blockSetFinalized = false;
        this.cancelled = false;
        this.failedBlocks = 0;
        this.fatallyFailedBlocks = 0;
        this.latestFailure = null;
        this.minSuccessBlocks = 0;
        this.sentToNetwork = false;
        this.successfulBlocks = 0;
        this.latestSuccess = new Date();
        this.totalBlocks = 0;
    }

    public RequestClient getClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriorityClass(short newPriorityClass, ClientContext ctx) {
        short oldPrio;
        ClientRequester clientRequester = this;
        synchronized (clientRequester) {
            oldPrio = this.priorityClass;
            this.priorityClass = newPriorityClass;
        }
        if (logMINOR) {
            Logger.minor(this, "Changing priority class of " + this + " from " + oldPrio + " to " + newPriorityClass);
        }
        ctx.getChkFetchScheduler(this.realTimeFlag).reregisterAll(this, oldPrio);
        ctx.getChkInsertScheduler(this.realTimeFlag).reregisterAll(this, oldPrio);
        ctx.getSskFetchScheduler(this.realTimeFlag).reregisterAll(this, oldPrio);
        ctx.getSskInsertScheduler(this.realTimeFlag).reregisterAll(this, oldPrio);
    }

    public boolean realTimeFlag() {
        return this.realTimeFlag;
    }

    public boolean persistent() {
        return this.client.persistent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientRequester[] getAll() {
        WeakHashMap<ClientRequester, Object> weakHashMap = allRequesters;
        synchronized (weakHashMap) {
            return allRequesters.keySet().toArray(new ClientRequester[0]);
        }
    }

    public byte[] getClientDetail(ChecksumChecker checker) throws IOException {
        return new byte[0];
    }

    protected static byte[] getClientDetail(PersistentClientCallback callback, ChecksumChecker checker) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        callback.getClientDetail(dos, checker);
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onResume(ClientContext context) throws ResumeFailedException {
        ClientRequester clientRequester = this;
        synchronized (clientRequester) {
            if (this.resumed) {
                return;
            }
            this.resumed = true;
        }
        this.innerOnResume(context);
    }

    protected void innerOnResume(ClientContext context) throws ResumeFailedException {
        ClientBaseCallback cb = this.getCallback();
        this.client = cb.getRequestClient();
        assert (this.client.persistent());
        if (this.sentToNetwork) {
            this.innerToNetwork(context);
        }
    }

    protected abstract ClientBaseCallback getCallback();

    public void onShutdown(ClientContext context) {
    }

    public boolean isCurrentState(ClientGetState state) {
        return false;
    }

    public ClientRequestSchedulerGroup getSchedulerGroup() {
        return this;
    }

    static {
        Logger.registerClass(ClientRequester.class);
        brokenClientAlert = new SimpleUserAlert(true, "Some broken downloads/uploads were cancelled. Please restart them.", "Some downloads/uploads were broken due to a bug (some time before 1287) causing unrecoverable database corruption. They have been cancelled. Please restart them from the Downloads or Uploads page.", "Some downloads/uploads were broken due to a pre-1287 bug, please restart them.", 1);
        allRequesters = new WeakHashMap();
        dumbValue = new Object();
    }
}

