/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.FlacPacket;
import java.nio.ByteBuffer;

class FlacMetadataBlock
extends FlacPacket {
    private FlacMetadataBlockHeader header = new FlacMetadataBlockHeader();

    FlacMetadataBlock(int header, byte[] payload) {
        super(payload);
        this.header.lastMetadataBlock = (header & Integer.MIN_VALUE) >>> 31 == 1;
        this.header.block_type = (byte)((header & 0x7F000000) >>> 24);
        this.header.length = header & 0xFFFFFF;
    }

    @Override
    public byte[] toArray() {
        ByteBuffer bb = ByteBuffer.allocate(this.getLength());
        bb.putInt(this.header.toInt());
        bb.put(this.payload);
        return bb.array();
    }

    public boolean isLastMetadataBlock() {
        return this.header.lastMetadataBlock;
    }

    public BlockType getMetadataBlockType() {
        switch (this.header.block_type) {
            case 0: {
                return BlockType.STREAMINFO;
            }
            case 1: {
                return BlockType.PADDING;
            }
            case 2: {
                return BlockType.APPLICATION;
            }
            case 3: {
                return BlockType.SEEKTABLE;
            }
            case 4: {
                return BlockType.VORBIS_COMMENT;
            }
            case 5: {
                return BlockType.CUESHEET;
            }
            case 6: {
                return BlockType.PICTURE;
            }
            case 127: {
                return BlockType.INVALID;
            }
        }
        return BlockType.UNKNOWN;
    }

    public void setMetadataBlockType(BlockType type) {
        switch (type) {
            case STREAMINFO: {
                this.header.block_type = 0;
                break;
            }
            case PADDING: {
                this.header.block_type = 1;
                break;
            }
            case APPLICATION: {
                this.header.block_type = (byte)2;
                break;
            }
            case SEEKTABLE: {
                this.header.block_type = (byte)3;
                break;
            }
            case VORBIS_COMMENT: {
                this.header.block_type = (byte)4;
                break;
            }
            case CUESHEET: {
                this.header.block_type = (byte)5;
                break;
            }
            case PICTURE: {
                this.header.block_type = (byte)6;
            }
        }
    }

    public FlacMetadataBlockHeader getHeader() {
        FlacMetadataBlockHeader newHeader = new FlacMetadataBlockHeader();
        newHeader.lastMetadataBlock = this.header.lastMetadataBlock;
        newHeader.block_type = this.header.block_type;
        newHeader.length = this.header.length;
        return newHeader;
    }

    public int getLength() {
        return 4 + this.header.length;
    }

    class FlacMetadataBlockHeader {
        boolean lastMetadataBlock;
        byte block_type;
        int length;

        FlacMetadataBlockHeader() {
        }

        public int toInt() {
            return (this.lastMetadataBlock ? 1 : 0) << 31 | this.block_type << 24 | this.length;
        }
    }

    static enum BlockType {
        STREAMINFO,
        PADDING,
        APPLICATION,
        SEEKTABLE,
        VORBIS_COMMENT,
        CUESHEET,
        PICTURE,
        UNKNOWN,
        INVALID;

    }
}

