/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.CodecPacket;
import freenet.client.filter.CodecPacketFilter;
import freenet.client.filter.FlacMetadataBlock;
import freenet.crypt.HashResult;
import freenet.crypt.HashType;
import freenet.support.Logger;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;

public class FlacPacketFilter
implements CodecPacketFilter {
    boolean streamValid = true;
    State currentState = State.UNINITIALIZED;
    int minimumBlockSize;
    int maximumBlockSize;
    int minimumFrameSize;
    int maximumFrameSize;
    int sampleRate;
    int channels;
    int bitsPerSample;
    long totalSamples;
    HashResult md5sum;

    @Override
    public CodecPacket parse(CodecPacket packet) throws IOException {
        if (!this.streamValid) {
            return null;
        }
        boolean logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(packet.toArray()));
        block0 : switch (this.currentState) {
            case UNINITIALIZED: {
                if (!(packet instanceof FlacMetadataBlock) && ((FlacMetadataBlock)packet).getMetadataBlockType() != FlacMetadataBlock.BlockType.STREAMINFO) {
                    this.streamValid = false;
                    return null;
                }
                if (((FlacMetadataBlock)packet).isLastMetadataBlock()) {
                    this.currentState = State.METADATA_FOUND;
                }
                this.minimumBlockSize = input.readUnsignedShort();
                this.maximumBlockSize = input.readUnsignedShort();
                this.minimumFrameSize = input.readUnsignedShort() << 8 | input.readUnsignedByte();
                this.maximumFrameSize = input.readUnsignedShort() << 8 | input.readUnsignedByte();
                long unaligned = input.readLong();
                this.sampleRate = (int)(unaligned >>> 40);
                this.channels = (int)(unaligned >>> 37) & 6;
                this.bitsPerSample = (int)(unaligned >>> 32) & 0x1F;
                this.totalSamples = unaligned << 28 >>> 28;
                byte[] hash = new byte[4];
                input.readFully(hash);
                this.md5sum = new HashResult(HashType.MD5, hash);
                this.currentState = State.STREAMINFO_FOUND;
                break;
            }
            case STREAMINFO_FOUND: {
                if (((FlacMetadataBlock)packet).isLastMetadataBlock()) {
                    this.currentState = State.METADATA_FOUND;
                }
                switch (((FlacMetadataBlock)packet).getMetadataBlockType()) {
                    case APPLICATION: {
                        byte[] payload = new byte[packet.payload.length];
                        Arrays.fill(payload, (byte)0);
                        FlacMetadataBlock.FlacMetadataBlockHeader header = ((FlacMetadataBlock)packet).getHeader();
                        packet = new FlacMetadataBlock(header.toInt(), payload);
                        ((FlacMetadataBlock)packet).setMetadataBlockType(FlacMetadataBlock.BlockType.PADDING);
                        break block0;
                    }
                    case VORBIS_COMMENT: {
                        byte[] payload = new byte[packet.payload.length];
                        Arrays.fill(payload, (byte)0);
                        FlacMetadataBlock.FlacMetadataBlockHeader header = ((FlacMetadataBlock)packet).getHeader();
                        packet = new FlacMetadataBlock(header.toInt(), payload);
                        ((FlacMetadataBlock)packet).setMetadataBlockType(FlacMetadataBlock.BlockType.PADDING);
                        break block0;
                    }
                    case PICTURE: {
                        byte[] payload = new byte[packet.payload.length];
                        Arrays.fill(payload, (byte)0);
                        FlacMetadataBlock.FlacMetadataBlockHeader header = ((FlacMetadataBlock)packet).getHeader();
                        packet = new FlacMetadataBlock(header.toInt(), payload);
                        ((FlacMetadataBlock)packet).setMetadataBlockType(FlacMetadataBlock.BlockType.PADDING);
                    }
                }
            }
        }
        if (packet instanceof FlacMetadataBlock && logMINOR) {
            Logger.minor(this, "Returning packet of type" + (Object)((Object)((FlacMetadataBlock)packet).getMetadataBlockType()));
        }
        return packet;
    }

    static enum State {
        UNINITIALIZED,
        STREAMINFO_FOUND,
        METADATA_FOUND;

    }
}

