/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.client.InsertException;
import freenet.clients.fcp.ClientRequest;
import freenet.clients.fcp.RequestStatus;
import freenet.keys.FreenetURI;
import java.util.Date;

public abstract class UploadRequestStatus
extends RequestStatus {
    private FreenetURI finalURI;
    private final FreenetURI targetURI;
    private InsertException.InsertExceptionMode failureCode;
    private String failureReasonShort;
    private String failureReasonLong;

    UploadRequestStatus(String identifier, ClientRequest.Persistence persistence, boolean started, boolean finished, boolean success, int total, int min, int fetched, Date latestSuccess, int fatal, int failed, Date latestFailure, boolean totalFinalized, short prio, FreenetURI finalURI, FreenetURI targetURI, InsertException.InsertExceptionMode failureCode, String failureReasonShort, String failureReasonLong) {
        super(identifier, persistence, started, finished, success, total, min, fetched, latestSuccess, fatal, failed, latestFailure, totalFinalized, prio);
        this.finalURI = finalURI;
        this.targetURI = targetURI;
        this.failureCode = failureCode;
        this.failureReasonShort = failureReasonShort;
        this.failureReasonLong = failureReasonLong;
    }

    synchronized void setFinished(boolean success, FreenetURI finalURI, InsertException.InsertExceptionMode failureCode, String failureReasonShort, String failureReasonLong) {
        this.setFinished(success);
        this.finalURI = finalURI;
        this.failureCode = failureCode;
        this.failureReasonShort = failureReasonShort;
        this.failureReasonLong = failureReasonLong;
    }

    public FreenetURI getFinalURI() {
        return this.finalURI;
    }

    public FreenetURI getTargetURI() {
        return this.targetURI;
    }

    @Override
    public FreenetURI getURI() {
        return this.finalURI;
    }

    @Override
    public abstract long getDataSize();

    @Override
    public String getFailureReason(boolean longDescription) {
        return longDescription ? this.failureReasonLong : this.failureReasonShort;
    }

    synchronized void setFinalURI(FreenetURI finalURI2) {
        this.finalURI = finalURI2;
    }

    @Override
    public String getPreferredFilename() {
        FreenetURI uri = this.getFinalURI();
        if (uri != null && (uri.hasMetaStrings() || uri.getDocName() != null)) {
            return uri.getPreferredFilename();
        }
        uri = this.getTargetURI();
        if (uri != null && (uri.hasMetaStrings() || uri.getDocName() != null)) {
            return uri.getPreferredFilename();
        }
        return null;
    }
}

