/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.updateableelements;

import freenet.clients.http.updateableelements.BaseUpdateableElement;
import freenet.support.Logger;
import freenet.support.Ticker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PushDataManager {
    private static volatile boolean logMINOR;
    private Map<String, List<UpdateEvent>> awaitingNotifications = new HashMap<String, List<UpdateEvent>>();
    private Map<String, List<BaseUpdateableElement>> pages = new HashMap<String, List<BaseUpdateableElement>>();
    private Map<String, List<String>> elements = new HashMap<String, List<String>>();
    private Map<String, Boolean> isKeepaliveReceived = new HashMap<String, Boolean>();
    private Map<String, Boolean> isFirstKeepaliveReceived = new HashMap<String, Boolean>();
    private Ticker cleaner;
    private CleanerTimerTask cleanerTask = new CleanerTimerTask();
    private boolean isScheduled = false;

    public PushDataManager(Ticker ticker) {
        this.cleaner = ticker;
    }

    public synchronized void updateElement(String id) {
        if (logMINOR) {
            Logger.minor(this, "Element updated id:" + id);
        }
        boolean needsUpdate = false;
        if (!this.elements.containsKey(id) && logMINOR) {
            Logger.minor(this, "Element is updating, but not present on elements! elements:" + this.elements + " pages:" + this.pages + " awaitingNotifications:" + this.awaitingNotifications);
        }
        if (this.elements.containsKey(id)) {
            for (String reqId : this.elements.get(id)) {
                if (logMINOR) {
                    Logger.minor(this, "Element is present on page:" + reqId + ". Adding an UpdateEvent for all notification list.");
                }
                for (Map.Entry<String, List<UpdateEvent>> entry : this.awaitingNotifications.entrySet()) {
                    UpdateEvent updateEvent;
                    List<UpdateEvent> notificationList = entry.getValue();
                    if (!notificationList.contains(updateEvent = new UpdateEvent(reqId, id))) {
                        notificationList.add(updateEvent);
                        if (!logMINOR) continue;
                        Logger.minor(this, "Notification(" + updateEvent + ") added to a notification list for " + entry.getKey());
                        continue;
                    }
                    if (!logMINOR) continue;
                    Logger.minor(this, "Not notifying " + entry.getKey() + " because already on list");
                }
                needsUpdate = true;
            }
        }
        if (needsUpdate) {
            if (logMINOR) {
                Logger.minor(this, "Waking up notification polls");
            }
            this.notifyAll();
        }
    }

    public synchronized void elementRendered(String requestUniqueId, BaseUpdateableElement element) {
        if (logMINOR) {
            Logger.minor(this, "Element is rendered in page:" + requestUniqueId + " element:" + element);
        }
        if (!this.pages.containsKey(requestUniqueId)) {
            this.pages.put(requestUniqueId, new ArrayList());
        }
        this.pages.get(requestUniqueId).add(element);
        String id = element.getUpdaterId(requestUniqueId);
        if (!this.elements.containsKey(id)) {
            this.elements.put(id, new ArrayList());
        }
        this.elements.get(id).add(requestUniqueId);
        this.isKeepaliveReceived.put(requestUniqueId, true);
        if (!this.awaitingNotifications.containsKey(requestUniqueId)) {
            this.awaitingNotifications.put(requestUniqueId, new ArrayList());
        }
        if (!this.isScheduled) {
            if (logMINOR) {
                Logger.minor(this, "Cleaner is queued(1) time:" + System.currentTimeMillis());
            }
            this.cleaner.queueTimedJob(this.cleanerTask, "cleanerTask", this.getDelayInMs(), false, true);
            this.isScheduled = true;
        }
    }

    public synchronized BaseUpdateableElement getRenderedElement(String requestId, String id) {
        if (logMINOR) {
            Logger.minor(this, "Getting element data for element:" + id + " in page:" + requestId);
        }
        if (this.pages.get(requestId) != null) {
            for (BaseUpdateableElement element : this.pages.get(requestId)) {
                if (element.getUpdaterId(requestId).compareTo(id) != 0) continue;
                element.updateState(false);
                return element;
            }
        }
        Logger.error(this, "Could not find data for the element requested. requestId:" + requestId + " id:" + id + " pages:" + this.pages + " keepaliveReceived:" + this.isKeepaliveReceived);
        return null;
    }

    public synchronized boolean failover(String originalRequestId, String newRequestId) {
        if (logMINOR) {
            Logger.minor(this, "Failover, original:" + originalRequestId + " new:" + newRequestId);
        }
        if (this.awaitingNotifications.containsKey(originalRequestId)) {
            this.awaitingNotifications.put(newRequestId, this.awaitingNotifications.remove(originalRequestId));
            if (logMINOR) {
                Logger.minor(this, "copied " + this.awaitingNotifications.get(newRequestId).size() + " notification:" + this.awaitingNotifications.get(newRequestId));
            }
            this.notifyAll();
            return true;
        }
        if (logMINOR) {
            Logger.minor(this, "Does not contains key");
        }
        return false;
    }

    public synchronized boolean leaving(String requestId) {
        return this.deleteRequest(requestId);
    }

    public synchronized boolean keepAliveReceived(String requestId) {
        if (logMINOR) {
            Logger.minor(this, "Keepalive is received for page:" + requestId);
        }
        if (!this.isKeepaliveReceived.containsKey(requestId)) {
            if (logMINOR) {
                Logger.minor(this, "Keepalive failed");
            }
            return false;
        }
        this.isKeepaliveReceived.put(requestId, true);
        this.isFirstKeepaliveReceived.put(requestId, true);
        this.notifyAll();
        return true;
    }

    public synchronized UpdateEvent getNextNotification(String requestId) {
        if (logMINOR) {
            Logger.minor(this, "Polling for notification:" + requestId);
        }
        while (this.awaitingNotifications.get(requestId) != null && this.awaitingNotifications.get(requestId).isEmpty() || this.awaitingNotifications.get(requestId) != null && !this.awaitingNotifications.get(requestId).isEmpty() && !this.isFirstKeepaliveReceived.containsKey(this.awaitingNotifications.get(requestId).get(0).requestId)) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                return null;
            }
        }
        if (this.awaitingNotifications.get(requestId) == null) {
            return null;
        }
        if (logMINOR) {
            Logger.minor(this, "Getting notification, notification:" + this.awaitingNotifications.get(requestId).get(0) + ",remaining:" + (this.awaitingNotifications.get(requestId).size() - 1));
        }
        return this.awaitingNotifications.get(requestId).remove(0);
    }

    private int getDelayInMs() {
        return 1260000;
    }

    private synchronized boolean deleteRequest(String requestId) {
        if (logMINOR) {
            Logger.minor(this, "DeleteRequest with requestId:" + requestId);
        }
        if (!this.isKeepaliveReceived.containsKey(requestId)) {
            if (logMINOR) {
                Logger.minor(this, "Request already cleaned, doing nothing");
            }
            return false;
        }
        this.isKeepaliveReceived.remove(requestId);
        this.isFirstKeepaliveReceived.remove(requestId);
        for (BaseUpdateableElement element : new ArrayList(this.pages.get(requestId))) {
            this.pages.get(requestId).remove(element);
            if (this.pages.get(requestId).isEmpty()) {
                this.pages.remove(requestId);
            }
            String id = element.getUpdaterId(requestId);
            this.elements.get(id).remove(requestId);
            if (this.elements.get(id).isEmpty()) {
                this.elements.remove(id);
            }
            element.dispose();
            for (String events : this.awaitingNotifications.keySet()) {
                for (UpdateEvent updateEvent : new ArrayList(this.awaitingNotifications.get(events))) {
                    if (updateEvent.requestId.compareTo(requestId) != 0) continue;
                    this.awaitingNotifications.get(events).remove(updateEvent);
                }
            }
        }
        this.awaitingNotifications.remove(requestId);
        return true;
    }

    static {
        Logger.registerClass(PushDataManager.class);
    }

    private class CleanerTimerTask
    implements Runnable {
        private CleanerTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PushDataManager pushDataManager = PushDataManager.this;
            synchronized (pushDataManager) {
                if (logMINOR) {
                    Logger.minor(this, "Cleaner running:" + PushDataManager.this.isKeepaliveReceived);
                }
                PushDataManager.this.isScheduled = false;
                for (Map.Entry entry : new HashMap(PushDataManager.this.isKeepaliveReceived).entrySet()) {
                    if (!((Boolean)entry.getValue()).booleanValue()) {
                        if (logMINOR) {
                            Logger.minor(this, "Cleaner cleaned request:" + (String)entry.getKey());
                        }
                        PushDataManager.this.deleteRequest((String)entry.getKey());
                        continue;
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Cleaner reseted request:" + (String)entry.getKey());
                    }
                    PushDataManager.this.isKeepaliveReceived.put(entry.getKey(), false);
                }
                if (!PushDataManager.this.isKeepaliveReceived.isEmpty()) {
                    if (logMINOR) {
                        Logger.minor(this, "Cleaner is queued(2) time:" + System.currentTimeMillis());
                    }
                    PushDataManager.this.cleaner.queueTimedJob(PushDataManager.this.cleanerTask, "cleanerTask", PushDataManager.this.getDelayInMs(), false, true);
                    PushDataManager.this.isScheduled = true;
                }
            }
        }
    }

    public class UpdateEvent {
        private String requestId;
        private String elementId;

        private UpdateEvent(String requestId, String elementId) {
            this.requestId = requestId;
            this.elementId = elementId;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public String getElementId() {
            return this.elementId;
        }

        public boolean equals(Object obj) {
            UpdateEvent o;
            if (obj == this) {
                return true;
            }
            return obj instanceof UpdateEvent && (o = (UpdateEvent)obj).getRequestId().compareTo(this.requestId) == 0 && o.getElementId().compareTo(this.elementId) == 0;
        }

        public int hashCode() {
            return this.requestId.hashCode() + this.elementId.hashCode();
        }

        public String toString() {
            return "UpdateEvent[requestId=" + this.requestId + ",elementId=" + this.elementId + "]";
        }
    }
}

