/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.support.Logger;
import freenet.support.io.Closer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyGenerator;

public class JceLoader {
    public static final Provider BouncyCastle;
    public static final Provider NSS;
    public static final Provider SUN;
    public static final Provider SunJCE;

    private static boolean checkUse(String prop) {
        return JceLoader.checkUse(prop, "true");
    }

    private static boolean checkUse(String prop, String def) {
        return "true".equalsIgnoreCase(System.getProperty("freenet.jce." + prop, def));
    }

    public static void dumpLoaded() {
        System.out.println("BouncyCastle: " + BouncyCastle);
        System.out.println("SunPKCS11-NSS: " + NSS);
        System.out.println("SUN: " + SUN);
        System.out.println("SunJCE: " + SunJCE);
    }

    static {
        String msg;
        KeyGenerator kgen;
        Provider p = null;
        if (JceLoader.checkUse("use.NSS", "false")) {
            try {
                p = new NSSLoader().load(JceLoader.checkUse("prefer.NSS"));
                try {
                    kgen = KeyGenerator.getInstance("AES", "SunPKCS11-NSS");
                    kgen.init(256);
                }
                catch (GeneralSecurityException e) {
                    msg = "Error with SunPKCS11-NSS. Unlimited policy file not installed.";
                    Logger.warning(NSSLoader.class, "Error with SunPKCS11-NSS. Unlimited policy file not installed.", (Throwable)e);
                    System.out.println("Error with SunPKCS11-NSS. Unlimited policy file not installed.");
                }
            }
            catch (Throwable e) {
                msg = "Unable to load SunPKCS11-NSScrypto provider. This is NOT fatal error, Freenet will work, but some performance degradation possible. Consider installing libnss3 package.";
                Logger.warning(NSSLoader.class, "Unable to load SunPKCS11-NSScrypto provider. This is NOT fatal error, Freenet will work, but some performance degradation possible. Consider installing libnss3 package.", e);
            }
        }
        NSS = p;
        p = null;
        if (JceLoader.checkUse("use.BC.I.know.what.I.am.doing")) {
            try {
                p = new BouncyCastleLoader().load();
            }
            catch (Throwable e) {
                msg = "SERIOUS PROBLEM: Unable to load or use BouncyCastle provider.";
                System.err.println("SERIOUS PROBLEM: Unable to load or use BouncyCastle provider.");
                e.printStackTrace();
                Logger.error(JceLoader.class, "SERIOUS PROBLEM: Unable to load or use BouncyCastle provider.", e);
            }
        }
        BouncyCastle = p;
        if (JceLoader.checkUse("use.SunJCE")) {
            try {
                kgen = KeyGenerator.getInstance("AES", "SunJCE");
                kgen.init(256);
            }
            catch (Throwable e) {
                Logger.warning(NSSLoader.class, "Error with SunJCE. Unlimited policy file not installed.", e);
            }
            SunJCE = Security.getProvider("SunJCE");
        } else {
            SunJCE = null;
        }
        SUN = JceLoader.checkUse("use.SUN") ? Security.getProvider("SUN") : null;
    }

    private static class NSSLoader {
        private NSSLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Provider load(boolean atfirst) throws Throwable {
            Provider nssProvider;
            block6: {
                block5: {
                    nssProvider = null;
                    for (Provider p : Security.getProviders()) {
                        if (!p.getName().matches("^SunPKCS11-(?i)NSS.*$")) continue;
                        nssProvider = p;
                        break;
                    }
                    if (nssProvider != null) break block5;
                    File nssFile = File.createTempFile("nss", ".cfg");
                    nssFile.deleteOnExit();
                    FileOutputStream os = null;
                    try {
                        os = new FileOutputStream(nssFile);
                        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, StandardCharsets.ISO_8859_1);
                        BufferedWriter bw = new BufferedWriter(osw);
                        bw.write("name=NSScrypto\n");
                        bw.write("nssDbMode=noDb\n");
                        bw.write("attributes=compatibility\n");
                        bw.close();
                        os = null;
                    }
                    catch (Throwable throwable) {
                        Closer.close(os);
                        throw throwable;
                    }
                    Closer.close(os);
                    Class<?> c = Class.forName("sun.security.pkcs11.SunPKCS11");
                    Constructor<?> constructor = c.getConstructor(String.class);
                    nssProvider = (Provider)constructor.newInstance(nssFile.getPath());
                    if (atfirst) {
                        Security.insertProviderAt(nssProvider, 1);
                    } else {
                        Security.addProvider(nssProvider);
                    }
                    Logger.debug(NSSLoader.class, "Loaded NSS provider " + nssProvider);
                    break block6;
                }
                Logger.debug(NSSLoader.class, "Found NSS provider " + nssProvider);
            }
            return nssProvider;
        }
    }

    private static class BouncyCastleLoader {
        private BouncyCastleLoader() {
        }

        private Provider load() throws Throwable {
            Provider p = Security.getProvider("BC");
            if (p == null) {
                Class<?> c = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
                p = (Provider)c.newInstance();
                Security.addProvider(p);
                Logger.debug(BouncyCastleLoader.class, "Loaded BouncyCastle provider: " + p);
            } else {
                Logger.debug(BouncyCastleLoader.class, "Found BouncyCastle provider: " + p);
            }
            try {
                KeyAgreement.getInstance("ECDH", p);
                Signature.getInstance("SHA256withECDSA", p);
            }
            catch (Throwable e) {
                throw new Error("Cannot use required algorithm from BouncyCaste provider", e);
            }
            return p;
        }
    }
}

