/*
 * Decompiled with CFR 0.152.
 */
package freenet.io;

import freenet.io.AddressMatcher;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.StringTokenizer;

public class Inet4AddressMatcher
implements AddressMatcher {
    private int address;
    private int networkMask;

    public Inet4AddressMatcher(String cidrHostname) throws IllegalArgumentException {
        int slashPosition = cidrHostname.indexOf(47);
        if (slashPosition == -1) {
            this.address = Inet4AddressMatcher.convertToBytes(cidrHostname);
            this.networkMask = -1;
        } else {
            this.address = Inet4AddressMatcher.convertToBytes(cidrHostname.substring(0, slashPosition));
            String maskPart = cidrHostname.substring(slashPosition + 1);
            if (maskPart.indexOf(46) == -1) {
                int bits = Integer.parseInt(maskPart);
                if (bits > 32 || bits < 0) {
                    throw new IllegalArgumentException("Mask bits out of range: " + bits + " (" + maskPart + ")");
                }
                this.networkMask = -1 << 32 - bits;
                if (Integer.parseInt(maskPart) == 0) {
                    this.networkMask = 0;
                }
            } else {
                this.networkMask = Inet4AddressMatcher.convertToBytes(maskPart);
            }
        }
    }

    public static int convertToBytes(String address) {
        StringTokenizer addressTokens = new StringTokenizer(address, ".");
        int bytes = Integer.parseInt(addressTokens.nextToken()) << 24 | Integer.parseInt(addressTokens.nextToken()) << 16 | Integer.parseInt(addressTokens.nextToken()) << 8 | Integer.parseInt(addressTokens.nextToken());
        return bytes;
    }

    @Override
    public boolean matches(InetAddress inetAddress) {
        if (!(inetAddress instanceof Inet4Address)) {
            return false;
        }
        int matchAddress = Inet4AddressMatcher.convertToBytes(inetAddress.getHostAddress());
        return (matchAddress & this.networkMask) == (this.address & this.networkMask);
    }

    public static boolean matches(String cidrHostname, InetAddress address) {
        return new Inet4AddressMatcher(cidrHostname).matches(address);
    }

    @Override
    public String getHumanRepresentation() {
        if (this.networkMask == -1) {
            return this.convertToString(this.address);
        }
        return this.convertToString(this.address) + '/' + this.convertToString(this.networkMask);
    }

    private String convertToString(int addr) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            int x = addr >>> 24;
            addr <<= 8;
            if (i != 0) {
                sb.append('.');
            }
            sb.append(x);
        }
        return sb.toString();
    }
}

