/*
 * Decompiled with CFR 0.152.
 */
package freenet.keys;

import freenet.crypt.CTRBlockCipher;
import freenet.crypt.JceLoader;
import freenet.crypt.PCFBMode;
import freenet.crypt.SHA256;
import freenet.crypt.UnsupportedCipherException;
import freenet.crypt.Util;
import freenet.crypt.ciphers.Rijndael;
import freenet.keys.CHKBlock;
import freenet.keys.CHKDecodeException;
import freenet.keys.CHKEncodeException;
import freenet.keys.CHKVerifyException;
import freenet.keys.ClientCHK;
import freenet.keys.ClientKeyBlock;
import freenet.keys.Key;
import freenet.keys.KeyEncodeException;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.compress.InvalidCompressionCodecException;
import freenet.support.io.ArrayBucket;
import freenet.support.io.ArrayBucketFactory;
import freenet.support.io.BucketTools;
import freenet.support.math.MersenneTwister;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Provider;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class ClientCHKBlock
implements ClientKeyBlock {
    final ClientCHK key;
    private final CHKBlock block;
    private static final Provider hmacProvider;

    public String toString() {
        return super.toString() + ",key=" + this.key;
    }

    public ClientCHKBlock(byte[] data, byte[] header, ClientCHK key2, boolean verify) throws CHKVerifyException {
        this.block = new CHKBlock(data, header, key2.getNodeCHK(), verify, key2.cryptoAlgorithm);
        this.key = key2;
    }

    public ClientCHKBlock(CHKBlock block, ClientCHK key2) throws CHKVerifyException {
        this(block.getData(), block.getHeaders(), key2, true);
    }

    @Override
    public byte[] memoryDecode() throws CHKDecodeException {
        try {
            ArrayBucket a = (ArrayBucket)this.decode(new ArrayBucketFactory(), 32768, false);
            return BucketTools.toByteArray(a);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    @Override
    public Bucket decode(BucketFactory bf, int maxLength, boolean dontCompress) throws CHKDecodeException, IOException {
        return this.decode(bf, maxLength, dontCompress, false);
    }

    Bucket decode(BucketFactory bf, int maxLength, boolean dontCompress, boolean forceNoJCA) throws CHKDecodeException, IOException {
        if (this.key.cryptoAlgorithm == 2) {
            return this.decodeOld(bf, maxLength, dontCompress);
        }
        if (this.key.cryptoAlgorithm == 3) {
            if (Rijndael.AesCtrProvider == null || forceNoJCA) {
                return this.decodeNewNoJCA(bf, maxLength, dontCompress);
            }
            return this.decodeNew(bf, maxLength, dontCompress);
        }
        throw new UnsupportedOperationException();
    }

    public Bucket decodeOld(BucketFactory bf, int maxLength, boolean dontCompress) throws CHKDecodeException, IOException {
        Rijndael cipher;
        if (this.key.cryptoAlgorithm != 2) {
            throw new UnsupportedOperationException();
        }
        try {
            cipher = new Rijndael(256, 256);
        }
        catch (UnsupportedCipherException e) {
            throw new Error(e);
        }
        byte[] cryptoKey = this.key.cryptoKey;
        if (cryptoKey.length < 32) {
            throw new CHKDecodeException("Crypto key too short");
        }
        cipher.initialize(this.key.cryptoKey);
        PCFBMode pcfb = PCFBMode.create(cipher);
        byte[] headers = this.block.headers;
        byte[] data = this.block.data;
        byte[] hbuf = Arrays.copyOfRange(headers, 2, headers.length);
        byte[] dbuf = Arrays.copyOf(data, data.length);
        pcfb.blockDecipher(hbuf, 0, hbuf.length);
        pcfb.blockDecipher(dbuf, 0, dbuf.length);
        MessageDigest md256 = SHA256.getMessageDigest();
        byte[] dkey = this.key.cryptoKey;
        byte[] predIV = md256.digest(dkey);
        byte[] iv = Arrays.copyOf(hbuf, 32);
        if (!Arrays.equals(iv, predIV)) {
            throw new CHKDecodeException("Check failed: Decrypted IV == H(decryption key)");
        }
        int size = ((hbuf[32] & 0xFF) << 8) + (hbuf[33] & 0xFF);
        if (size > 32768 || size < 0) {
            throw new CHKDecodeException("Invalid size: " + size);
        }
        return Key.decompress(dontCompress ? false : this.key.isCompressed(), dbuf, size, bf, Math.min(maxLength, Integer.MAX_VALUE), this.key.compressionAlgorithm, false);
    }

    private static long benchmark(Mac hmac) throws GeneralSecurityException {
        int i;
        long times = Long.MAX_VALUE;
        byte[] input = new byte[1024];
        byte[] output = new byte[hmac.getMacLength()];
        byte[] key = new byte[32];
        String algo = hmac.getAlgorithm();
        hmac.init(new SecretKeySpec(key, algo));
        for (i = 0; i < 32; ++i) {
            hmac.update(input, 0, input.length);
            hmac.doFinal(output, 0);
            System.arraycopy(output, 0, input, i * output.length % (input.length - output.length), output.length);
        }
        System.arraycopy(output, 0, key, 0, Math.min(key.length, output.length));
        for (i = 0; i < 1024; ++i) {
            long startTime = System.nanoTime();
            hmac.init(new SecretKeySpec(key, algo));
            for (int j = 0; j < 8; ++j) {
                for (int k = 0; k < 32; ++k) {
                    hmac.update(input, 0, input.length);
                }
                hmac.doFinal(output, 0);
            }
            long endTime = System.nanoTime();
            times = Math.min(endTime - startTime, times);
            System.arraycopy(output, 0, input, 0, output.length);
            System.arraycopy(output, 0, key, 0, Math.min(key.length, output.length));
        }
        return times;
    }

    public Bucket decodeNew(BucketFactory bf, int maxLength, boolean dontCompress) throws CHKDecodeException, IOException {
        if (this.key.cryptoAlgorithm != 3) {
            throw new UnsupportedOperationException();
        }
        byte[] headers = this.block.headers;
        byte[] data = this.block.data;
        byte[] hash = Arrays.copyOfRange(headers, 2, 34);
        byte[] cryptoKey = this.key.cryptoKey;
        if (cryptoKey.length < 32) {
            throw new CHKDecodeException("Crypto key too short");
        }
        try {
            Cipher cipher = Cipher.getInstance("AES/CTR/NOPADDING", Rijndael.AesCtrProvider);
            cipher.init(1, (java.security.Key)new SecretKeySpec(cryptoKey, "AES"), new IvParameterSpec(hash, 0, 16));
            byte[] plaintext = new byte[data.length + 2];
            int moved = cipher.update(data, 0, data.length, plaintext);
            cipher.doFinal(headers, hash.length + 2, 2, plaintext, moved);
            int size = ((plaintext[data.length] & 0xFF) << 8) + (plaintext[data.length + 1] & 0xFF);
            if (size > 32768 || size < 0) {
                throw new CHKDecodeException("Invalid size: " + size);
            }
            Mac hmac = Mac.getInstance("HmacSHA256", hmacProvider);
            hmac.init(new SecretKeySpec(cryptoKey, "HmacSHA256"));
            hmac.update(plaintext);
            byte[] hashCheck = hmac.doFinal();
            if (!Arrays.equals(hash, hashCheck)) {
                throw new CHKDecodeException("HMAC is wrong, wrong decryption key?");
            }
            return Key.decompress(dontCompress ? false : this.key.isCompressed(), plaintext, size, bf, Math.min(maxLength, Integer.MAX_VALUE), this.key.compressionAlgorithm, false);
        }
        catch (GeneralSecurityException e) {
            throw new CHKDecodeException("Problem with JCA, should be impossible!", e);
        }
    }

    public Bucket decodeNewNoJCA(BucketFactory bf, int maxLength, boolean dontCompress) throws CHKDecodeException, IOException {
        Rijndael aes;
        if (this.key.cryptoAlgorithm != 3) {
            throw new UnsupportedOperationException();
        }
        byte[] headers = this.block.headers;
        byte[] data = this.block.data;
        byte[] hash = Arrays.copyOfRange(headers, 2, 34);
        byte[] cryptoKey = this.key.cryptoKey;
        if (cryptoKey.length < 32) {
            throw new CHKDecodeException("Crypto key too short");
        }
        try {
            aes = new Rijndael(256, 128);
        }
        catch (UnsupportedCipherException e) {
            throw new Error(e);
        }
        aes.initialize(cryptoKey);
        CTRBlockCipher cipher = new CTRBlockCipher(aes);
        cipher.init(hash, 0, 16);
        byte[] plaintext = new byte[data.length];
        cipher.processBytes(data, 0, data.length, plaintext, 0);
        byte[] lengthBytes = new byte[2];
        cipher.processBytes(headers, hash.length + 2, 2, lengthBytes, 0);
        int size = ((lengthBytes[0] & 0xFF) << 8) + (lengthBytes[1] & 0xFF);
        if (size > 32768 || size < 0) {
            throw new CHKDecodeException("Invalid size: " + size);
        }
        try {
            Mac hmac = Mac.getInstance("HmacSHA256", hmacProvider);
            hmac.init(new SecretKeySpec(cryptoKey, "HmacSHA256"));
            hmac.update(plaintext);
            hmac.update(lengthBytes);
            byte[] hashCheck = hmac.doFinal();
            if (!Arrays.equals(hash, hashCheck)) {
                throw new CHKDecodeException("HMAC is wrong, wrong decryption key?");
            }
        }
        catch (GeneralSecurityException e) {
            throw new CHKDecodeException("Problem with JCA, should be impossible!", e);
        }
        return Key.decompress(dontCompress ? false : this.key.isCompressed(), plaintext, size, bf, Math.min(maxLength, Integer.MAX_VALUE), this.key.compressionAlgorithm, false);
    }

    public static ClientCHKBlock encodeSplitfileBlock(byte[] data, byte[] cryptoKey, byte cryptoAlgorithm) throws CHKEncodeException {
        if (data.length != 32768) {
            throw new IllegalArgumentException();
        }
        if (cryptoKey != null && cryptoKey.length != 32) {
            throw new IllegalArgumentException();
        }
        MessageDigest md256 = SHA256.getMessageDigest();
        if (cryptoKey == null) {
            cryptoKey = md256.digest(data);
        }
        if (cryptoAlgorithm == 2) {
            return ClientCHKBlock.innerEncode(data, 32768, md256, cryptoKey, false, (short)-1, cryptoAlgorithm);
        }
        if (cryptoAlgorithm != 3) {
            throw new IllegalArgumentException("Unknown crypto algorithm: " + cryptoAlgorithm);
        }
        if (Rijndael.AesCtrProvider == null) {
            return ClientCHKBlock.encodeNewNoJCA(data, 32768, md256, cryptoKey, false, (short)-1, cryptoAlgorithm, 1);
        }
        return ClientCHKBlock.encodeNew(data, 32768, md256, cryptoKey, false, (short)-1, cryptoAlgorithm, 1);
    }

    public static ClientCHKBlock encode(Bucket sourceData, boolean asMetadata, boolean dontCompress, short alreadyCompressedCodec, long sourceLength, String compressorDescriptor, byte[] cryptoKey, byte cryptoAlgorithm) throws CHKEncodeException, IOException {
        return ClientCHKBlock.encode(sourceData, asMetadata, dontCompress, alreadyCompressedCodec, sourceLength, compressorDescriptor, cryptoKey, cryptoAlgorithm, false);
    }

    static ClientCHKBlock encode(Bucket sourceData, boolean asMetadata, boolean dontCompress, short alreadyCompressedCodec, long sourceLength, String compressorDescriptor, byte[] cryptoKey, byte cryptoAlgorithm, boolean forceNoJCA) throws CHKEncodeException, IOException {
        byte[] data;
        byte[] finalData = null;
        short compressionAlgorithm = -1;
        try {
            Key.Compressed comp = Key.compress(sourceData, dontCompress, alreadyCompressedCodec, sourceLength, Integer.MAX_VALUE, 32768, false, compressorDescriptor);
            finalData = comp.compressedData;
            compressionAlgorithm = comp.compressionAlgorithm;
        }
        catch (KeyEncodeException e2) {
            throw new CHKEncodeException(e2.getMessage(), e2);
        }
        catch (InvalidCompressionCodecException e2) {
            throw new CHKEncodeException(e2.getMessage(), e2);
        }
        MessageDigest md256 = SHA256.getMessageDigest();
        int dataLength = finalData.length;
        if (finalData.length != 32768) {
            if (finalData.length != 0) {
                md256.update(finalData);
            }
            byte[] digest = md256.digest();
            MersenneTwister mt = new MersenneTwister(digest);
            data = Arrays.copyOf(finalData, 32768);
            Util.randomBytes((Random)((Object)mt), data, finalData.length, 32768 - finalData.length);
        } else {
            data = finalData;
        }
        byte[] encKey = cryptoKey != null ? cryptoKey : md256.digest(data);
        if (cryptoAlgorithm == 0) {
            Logger.error(ClientCHKBlock.class, "Passed in 0 crypto algorithm", (Throwable)new Exception("warning"));
            cryptoAlgorithm = (byte)2;
        }
        if (cryptoAlgorithm == 2) {
            return ClientCHKBlock.innerEncode(data, dataLength, md256, encKey, asMetadata, compressionAlgorithm, cryptoAlgorithm);
        }
        if (Rijndael.AesCtrProvider == null || forceNoJCA) {
            return ClientCHKBlock.encodeNewNoJCA(data, dataLength, md256, encKey, asMetadata, compressionAlgorithm, cryptoAlgorithm, 1);
        }
        return ClientCHKBlock.encodeNew(data, dataLength, md256, encKey, asMetadata, compressionAlgorithm, cryptoAlgorithm, 1);
    }

    public static ClientCHKBlock encodeNew(byte[] data, int dataLength, MessageDigest md256, byte[] encKey, boolean asMetadata, short compressionAlgorithm, byte cryptoAlgorithm, int blockHashAlgorithm) throws CHKEncodeException {
        if (cryptoAlgorithm != 3) {
            throw new IllegalArgumentException("Unsupported crypto algorithm " + cryptoAlgorithm);
        }
        try {
            Mac hmac = Mac.getInstance("HmacSHA256", hmacProvider);
            hmac.init(new SecretKeySpec(encKey, "HmacSHA256"));
            byte[] tmpLen = new byte[]{(byte)(dataLength >> 8), (byte)(dataLength & 0xFF)};
            hmac.update(data);
            hmac.update(tmpLen);
            byte[] hash = hmac.doFinal();
            byte[] header = new byte[hash.length + 2 + 2];
            if (blockHashAlgorithm == 0) {
                cryptoAlgorithm = 1;
            }
            if (blockHashAlgorithm != 1) {
                throw new IllegalArgumentException("Unsupported block hash algorithm " + cryptoAlgorithm);
            }
            header[0] = (byte)(blockHashAlgorithm >> 8);
            header[1] = (byte)(blockHashAlgorithm & 0xFF);
            System.arraycopy(hash, 0, header, 2, hash.length);
            SecretKeySpec ckey = new SecretKeySpec(encKey, "AES");
            Cipher cipher = Cipher.getInstance("AES/CTR/NOPADDING", Rijndael.AesCtrProvider);
            cipher.init(1, (java.security.Key)ckey, new IvParameterSpec(hash, 0, 16));
            byte[] cdata = new byte[data.length];
            int moved = cipher.update(data, 0, data.length, cdata);
            if (moved == data.length) {
                cipher.doFinal(tmpLen, 0, 2, header, hash.length + 2);
            } else {
                byte[] tmp = cipher.doFinal(tmpLen, 0, 2);
                System.arraycopy(tmp, 0, cdata, moved, tmp.length - 2);
                System.arraycopy(tmp, tmp.length - 2, header, hash.length + 2, 2);
            }
            md256.update(header);
            byte[] finalHash = md256.digest(cdata);
            ClientCHK finalKey = new ClientCHK(finalHash, encKey, asMetadata, cryptoAlgorithm, compressionAlgorithm);
            try {
                return new ClientCHKBlock(cdata, header, finalKey, false);
            }
            catch (CHKVerifyException e3) {
                throw new Error(e3);
            }
        }
        catch (GeneralSecurityException e) {
            throw new CHKEncodeException("Problem with JCA, should be impossible!", e);
        }
    }

    public static ClientCHKBlock encodeNewNoJCA(byte[] data, int dataLength, MessageDigest md256, byte[] encKey, boolean asMetadata, short compressionAlgorithm, byte cryptoAlgorithm, int blockHashAlgorithm) throws CHKEncodeException {
        if (cryptoAlgorithm != 3) {
            throw new IllegalArgumentException("Unsupported crypto algorithm " + cryptoAlgorithm);
        }
        try {
            Rijndael aes;
            Mac hmac = Mac.getInstance("HmacSHA256", hmacProvider);
            hmac.init(new SecretKeySpec(encKey, "HmacSHA256"));
            byte[] tmpLen = new byte[]{(byte)(dataLength >> 8), (byte)(dataLength & 0xFF)};
            hmac.update(data);
            hmac.update(tmpLen);
            byte[] hash = hmac.doFinal();
            byte[] header = new byte[hash.length + 2 + 2];
            if (blockHashAlgorithm == 0) {
                cryptoAlgorithm = 1;
            }
            if (blockHashAlgorithm != 1) {
                throw new IllegalArgumentException("Unsupported block hash algorithm " + cryptoAlgorithm);
            }
            header[0] = (byte)(blockHashAlgorithm >> 8);
            header[1] = (byte)(blockHashAlgorithm & 0xFF);
            try {
                aes = new Rijndael(256, 128);
            }
            catch (UnsupportedCipherException e) {
                throw new Error(e);
            }
            aes.initialize(encKey);
            CTRBlockCipher ctr = new CTRBlockCipher(aes);
            ctr.init(hash, 0, 16);
            System.arraycopy(hash, 0, header, 2, hash.length);
            byte[] cdata = new byte[data.length];
            ctr.processBytes(data, 0, data.length, cdata, 0);
            ctr.processBytes(tmpLen, 0, 2, header, hash.length + 2);
            md256.update(header);
            byte[] finalHash = md256.digest(cdata);
            ClientCHK finalKey = new ClientCHK(finalHash, encKey, asMetadata, cryptoAlgorithm, compressionAlgorithm);
            try {
                return new ClientCHKBlock(cdata, header, finalKey, false);
            }
            catch (CHKVerifyException e3) {
                throw new Error(e3);
            }
        }
        catch (GeneralSecurityException e) {
            throw new CHKEncodeException("Problem with JCA, should be impossible!", e);
        }
    }

    public static ClientCHKBlock innerEncode(byte[] data, int dataLength, MessageDigest md256, byte[] encKey, boolean asMetadata, short compressionAlgorithm, byte cryptoAlgorithm) {
        Rijndael cipher;
        data = (byte[])data.clone();
        if (cryptoAlgorithm != 2) {
            throw new IllegalArgumentException("Unsupported crypto algorithm " + cryptoAlgorithm);
        }
        byte[] plainIV = md256.digest(encKey);
        byte[] header = new byte[plainIV.length + 2 + 2];
        header[0] = 0;
        header[1] = 1;
        System.arraycopy(plainIV, 0, header, 2, plainIV.length);
        header[plainIV.length + 2] = (byte)(dataLength >> 8);
        header[plainIV.length + 3] = (byte)(dataLength & 0xFF);
        try {
            cipher = new Rijndael(256, 256);
        }
        catch (UnsupportedCipherException e) {
            Logger.error(ClientCHKBlock.class, "Impossible: " + e, (Throwable)e);
            throw new Error(e);
        }
        cipher.initialize(encKey);
        PCFBMode pcfb = PCFBMode.create(cipher);
        pcfb.blockEncipher(header, 2, header.length - 2);
        pcfb.blockEncipher(data, 0, data.length);
        md256.update(header);
        byte[] finalHash = md256.digest(data);
        ClientCHK key = new ClientCHK(finalHash, encKey, asMetadata, cryptoAlgorithm, compressionAlgorithm);
        try {
            return new ClientCHKBlock(data, header, key, false);
        }
        catch (CHKVerifyException e3) {
            throw new Error(e3);
        }
    }

    public static ClientCHKBlock encode(byte[] sourceData, boolean asMetadata, boolean dontCompress, short alreadyCompressedCodec, int sourceLength, String compressorDescriptor) throws CHKEncodeException, InvalidCompressionCodecException {
        try {
            return ClientCHKBlock.encode(new ArrayBucket(sourceData), asMetadata, dontCompress, alreadyCompressedCodec, sourceLength, compressorDescriptor, null, (byte)3);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    @Override
    public ClientCHK getClientKey() {
        return this.key;
    }

    @Override
    public boolean isMetadata() {
        return this.key.isMetadata();
    }

    @Override
    public int hashCode() {
        return this.key.hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ClientCHKBlock)) {
            return false;
        }
        ClientCHKBlock block = (ClientCHKBlock)o;
        if (!this.key.equals(block.key)) {
            return false;
        }
        return block.block.equals(this.block);
    }

    @Override
    public CHKBlock getBlock() {
        return this.block;
    }

    @Override
    public Key getKey() {
        return this.block.getKey();
    }

    static {
        try {
            Class<ClientCHKBlock> clazz = ClientCHKBlock.class;
            String algo = "HmacSHA256";
            Provider sun = JceLoader.SunJCE;
            SecretKeySpec dummyKey = new SecretKeySpec(new byte[32], "HmacSHA256");
            Mac hmac = Mac.getInstance("HmacSHA256");
            hmac.init(dummyKey);
            boolean logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, clazz);
            if (sun != null) {
                try {
                    Mac sun_hmac = Mac.getInstance("HmacSHA256", sun);
                    sun_hmac.init(dummyKey);
                    if (hmac.getProvider() != sun_hmac.getProvider()) {
                        long time_def = ClientCHKBlock.benchmark(hmac);
                        long time_sun = ClientCHKBlock.benchmark(sun_hmac);
                        System.out.println("HmacSHA256 (" + hmac.getProvider() + "): " + time_def + "ns");
                        System.out.println("HmacSHA256 (" + sun_hmac.getProvider() + "): " + time_sun + "ns");
                        if (logMINOR) {
                            Logger.minor(clazz, "HmacSHA256/" + hmac.getProvider() + ": " + time_def + "ns");
                            Logger.minor(clazz, "HmacSHA256/" + sun_hmac.getProvider() + ": " + time_sun + "ns");
                        }
                        if (time_sun < time_def) {
                            hmac = sun_hmac;
                        }
                    }
                }
                catch (GeneralSecurityException e) {
                    Logger.warning(clazz, "HmacSHA256@" + sun + " benchmark failed", (Throwable)e);
                }
                catch (Throwable e) {
                    Logger.error(clazz, "HmacSHA256@" + sun + " benchmark failed", e);
                }
            }
            hmacProvider = hmac.getProvider();
            System.out.println("HmacSHA256: using " + hmacProvider);
            Logger.normal(clazz, "HmacSHA256: using " + hmacProvider);
        }
        catch (GeneralSecurityException e) {
            throw new Error(e);
        }
    }
}

