/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.keys.NodeCHK;
import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.node.RequestSender;
import freenet.node.UIDTag;
import freenet.support.Logger;
import freenet.support.TimeUtil;
import java.lang.ref.WeakReference;

public class RequestTag
extends UIDTag {
    private static volatile boolean logMINOR;
    final START start;
    final boolean isSSK;
    private boolean servedFromDatastore;
    private WeakReference<RequestSender> sender;
    private boolean sent;
    private int requestSenderFinishedCode = -1;
    private Throwable handlerThrew;
    private boolean rejected;
    private boolean handlerDisconnected;
    private WeakReference<PeerNode> waitingForOpennet;
    private boolean handlerTransferring;
    private boolean senderTransferring;
    private NodeCHK key;
    private boolean completedDownstreamTransfers;

    public RequestTag(boolean isSSK, START start, PeerNode source, boolean realTimeFlag, long uid, Node node) {
        super(source, realTimeFlag, uid, node);
        this.start = start;
        this.isSSK = isSSK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequestSenderFinished(int status) {
        boolean noRecordUnlock;
        RequestTag requestTag = this;
        synchronized (requestTag) {
            if (status == -1) {
                throw new IllegalArgumentException();
            }
            this.requestSenderFinishedCode = status;
            if (!this.mustUnlock()) {
                return;
            }
            noRecordUnlock = this.noRecordUnlock;
        }
        this.innerUnlock(noRecordUnlock);
    }

    public synchronized void setSender(RequestSender rs, boolean coalesced) {
        if (!coalesced) {
            this.sent = true;
        }
        this.sender = new WeakReference<RequestSender>(rs);
    }

    @Override
    protected synchronized boolean mustUnlock() {
        if (this.sent && this.requestSenderFinishedCode == -1) {
            return false;
        }
        if (this.waitingForOpennet != null && this.waitingForOpennet.get() != null) {
            return false;
        }
        return super.mustUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void innerUnlock(boolean noRecordUnlock) {
        boolean senderFinished;
        boolean handlerFinished;
        NodeCHK k = null;
        RequestSender s = null;
        RequestTag requestTag = this;
        synchronized (requestTag) {
            handlerFinished = this.handlerTransferring;
            this.handlerTransferring = false;
            senderFinished = this.senderTransferring;
            if (senderFinished) {
                Logger.error(this, "Nobody called senderTransferEnds() for " + this, (Throwable)new Exception("debug"));
                k = this.key;
                s = (RequestSender)this.sender.get();
            }
            this.senderTransferring = false;
        }
        super.innerUnlock(noRecordUnlock);
        if (handlerFinished) {
            this.tracker.removeTransferringRequestHandler(this.uid);
        }
        if (senderFinished) {
            assert (k != null);
            assert (s != null);
            this.tracker.removeTransferringSender(k, s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlerThrew(Throwable t) {
        RequestTag requestTag = this;
        synchronized (requestTag) {
            this.handlerThrew = t;
        }
        this.unlockHandler();
    }

    public synchronized void setServedFromDatastore() {
        this.servedFromDatastore = true;
    }

    public synchronized void setRejected() {
        this.rejected = true;
    }

    @Override
    public void logStillPresent(Long uid) {
        StringBuffer sb = new StringBuffer();
        sb.append("Still present after ").append(TimeUtil.formatTime(this.age()));
        sb.append(" : ").append(uid).append(" : start=").append((Object)this.start);
        sb.append(" ssk=").append(this.isSSK).append(" from store=").append(this.servedFromDatastore);
        if (this.sender == null) {
            sb.append(" sender hasn't been set!");
        } else {
            RequestSender s = (RequestSender)this.sender.get();
            if (s == null) {
                sb.append(" sender=null");
            } else {
                sb.append(" sender=").append(s);
                sb.append(" status=");
                sb.append(s.getStatusString());
            }
        }
        if (this.sent) {
            sb.append(" sent");
        }
        sb.append(" finishedCode=").append(this.requestSenderFinishedCode);
        sb.append(" rejected=").append(this.rejected);
        if (this.handlerThrew != null) {
            sb.append(" thrown=").append(this.handlerThrew);
        }
        if (this.handlerDisconnected) {
            sb.append(" handlerDisconnected=true");
        }
        if (this.waitingForOpennet != null) {
            PeerNode pn = (PeerNode)this.waitingForOpennet.get();
            sb.append(" waitingForOpennet=");
            sb.append(pn == null ? "(null)" : pn.shortToString());
        }
        sb.append(" : ");
        sb.append(super.toString());
        if (this.handlerThrew != null) {
            Logger.error(this, sb.toString(), this.handlerThrew);
        } else {
            Logger.error(this, sb.toString());
        }
    }

    public synchronized void handlerDisconnected() {
        this.handlerDisconnected = true;
    }

    @Override
    public synchronized int expectedTransfersIn(boolean ignoreLocalVsRemote, int outwardTransfersPerInsert, boolean forAccept) {
        if (!this.accepted) {
            return 0;
        }
        return this.notRoutedOnwards ? 0 : 1;
    }

    @Override
    public synchronized int expectedTransfersOut(boolean ignoreLocalVsRemote, int outwardTransfersPerInsert, boolean forAccept) {
        if (!this.accepted) {
            return 0;
        }
        if (this.completedDownstreamTransfers) {
            return 0;
        }
        if (forAccept && (this.sourceRestarted || this.unlockedHandler)) {
            return 0;
        }
        return !this.isLocal() || ignoreLocalVsRemote ? 1 : 0;
    }

    public synchronized void completedDownstreamTransfers() {
        this.completedDownstreamTransfers = true;
    }

    @Override
    public boolean isSSK() {
        return this.isSSK;
    }

    @Override
    public boolean isInsert() {
        return false;
    }

    @Override
    public boolean isOfferReply() {
        return false;
    }

    public synchronized void waitingForOpennet(PeerNode next) {
        if (this.waitingForOpennet != null) {
            Logger.error(this, "Have already waited for opennet: " + this.waitingForOpennet.get() + " on " + this, (Throwable)new Exception("error"));
        }
        this.waitingForOpennet = next.myRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishedWaitingForOpennet(PeerNode next) {
        boolean noRecordUnlock;
        RequestTag requestTag = this;
        synchronized (requestTag) {
            if (this.waitingForOpennet == null) {
                if (logMINOR) {
                    Logger.minor(this, "Not waiting for opennet!");
                }
                return;
            }
            PeerNode got = (PeerNode)this.waitingForOpennet.get();
            if (got != next) {
                Logger.error(this, "Finished waiting for opennet on " + next + " but was waiting for " + got);
            }
            this.waitingForOpennet = null;
            if (!this.mustUnlock()) {
                return;
            }
            noRecordUnlock = this.noRecordUnlock;
        }
        this.innerUnlock(noRecordUnlock);
    }

    @Override
    public synchronized boolean currentlyRoutingTo(PeerNode peer) {
        if (this.waitingForOpennet != null && this.waitingForOpennet == peer.myRef) {
            return true;
        }
        return super.currentlyRoutingTo(peer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlerTransferBegins() {
        RequestTag requestTag = this;
        synchronized (requestTag) {
            if (this.handlerTransferring) {
                return;
            }
            this.handlerTransferring = true;
        }
        this.tracker.addTransferringRequestHandler(this.uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void senderTransferBegins(NodeCHK k, RequestSender requestSender) {
        RequestTag requestTag = this;
        synchronized (requestTag) {
            if (this.senderTransferring) {
                return;
            }
            this.senderTransferring = true;
            if (this.sender == null || this.sender.get() != requestSender) {
                throw new IllegalStateException("Set RequestSender first!");
            }
            this.key = k;
        }
        this.tracker.addTransferringSender(k, requestSender);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void senderTransferEnds(NodeCHK key, RequestSender requestSender) {
        RequestTag requestTag = this;
        synchronized (requestTag) {
            if (!this.senderTransferring) {
                return;
            }
            this.senderTransferring = false;
            assert (this.sender != null && this.sender.get() == requestSender);
            assert (this.key != null && this.key.equals(key));
            this.key = null;
        }
        this.tracker.removeTransferringSender(key, requestSender);
    }

    static {
        Logger.registerClass(RequestTag.class);
    }

    static enum START {
        ASYNC_GET,
        LOCAL,
        REMOTE;

    }
}

