/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class SemiOrderedShutdownHook
extends Thread {
    private static final long TIMEOUT = TimeUnit.SECONDS.toMillis(100L);
    private final ArrayList<Thread> earlyJobs = new ArrayList();
    private final ArrayList<Thread> lateJobs = new ArrayList();
    public static final SemiOrderedShutdownHook singleton = new SemiOrderedShutdownHook();

    public static SemiOrderedShutdownHook get() {
        return singleton;
    }

    private SemiOrderedShutdownHook() {
    }

    public synchronized void addEarlyJob(Thread r) {
        this.earlyJobs.add(r);
    }

    public synchronized void addLateJob(Thread r) {
        this.lateJobs.add(r);
    }

    @Override
    public void run() {
        Thread[] late;
        Thread[] early;
        System.err.println("Shutting down...");
        for (Thread r : early = this.getEarlyJobs()) {
            r.start();
        }
        for (Thread r : early) {
            try {
                r.join(TIMEOUT);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        for (Thread r : late = this.getLateJobs()) {
            r.start();
        }
        for (Thread r : late) {
            try {
                r.join(TIMEOUT);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private synchronized Thread[] getEarlyJobs() {
        return this.earlyJobs.toArray(new Thread[this.earlyJobs.size()]);
    }

    private synchronized Thread[] getLateJobs() {
        return this.lateJobs.toArray(new Thread[this.lateJobs.size()]);
    }

    static {
        Runtime.getRuntime().addShutdownHook(singleton);
    }
}

