/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.node.PrioRunnable;
import freenet.support.Executor;
import freenet.support.Logger;
import freenet.support.MemoryLimitedChunk;
import freenet.support.MemoryLimitedJob;
import freenet.support.io.NativeThread;
import java.util.ArrayDeque;
import java.util.Deque;

public class MemoryLimitedJobRunner {
    public static final int THREAD_PRIORITY = NativeThread.LOW_PRIORITY;
    public long capacity;
    private long counter;
    private final Deque<MemoryLimitedJob>[] jobs;
    private final Executor executor;
    private int runningThreads;
    private int maxThreads;
    private boolean shutdown;
    private static boolean logMINOR;

    public MemoryLimitedJobRunner(long capacity, int maxThreads, Executor executor, int priorities) {
        this.capacity = capacity;
        this.counter = 0L;
        this.jobs = new ArrayDeque[priorities];
        for (int i = 0; i < this.jobs.length; ++i) {
            this.jobs[i] = new ArrayDeque<MemoryLimitedJob>();
        }
        this.executor = executor;
        this.maxThreads = maxThreads;
    }

    public synchronized void queueJob(MemoryLimitedJob job) {
        if (this.shutdown) {
            return;
        }
        if (job.initialAllocation > this.capacity) {
            throw new IllegalArgumentException("Job size " + job.initialAllocation + " > capacity " + this.capacity);
        }
        if (logMINOR) {
            Logger.minor(this, "Queueing job " + job + " at priority " + job.getPriority());
        }
        this.jobs[job.getPriority()].add(job);
        this.maybeStartJobs();
    }

    synchronized void deallocate(long size, boolean finishedThread) {
        if (size == 0L) {
            return;
        }
        if (size < 0L) {
            throw new IllegalArgumentException();
        }
        assert (size <= this.counter);
        this.counter -= size;
        if (finishedThread) {
            --this.runningThreads;
            if (this.shutdown) {
                this.notifyAll();
            }
        }
        this.maybeStartJobs();
    }

    private synchronized void maybeStartJobs() {
        if (this.shutdown) {
            return;
        }
        while (true) {
            int prio;
            MemoryLimitedJob job = null;
            for (prio = 0; prio < this.jobs.length && (job = this.jobs[prio].peekFirst()) == null; ++prio) {
            }
            if (job == null) {
                return;
            }
            if (job.initialAllocation + this.counter > this.capacity || this.runningThreads >= this.maxThreads) break;
            this.jobs[prio].removeFirst();
            this.startJob(job);
        }
    }

    private synchronized void startJob(final MemoryLimitedJob job) {
        this.counter += job.initialAllocation;
        ++this.runningThreads;
        if (logMINOR) {
            Logger.minor(this, "Starting job " + job);
        }
        this.executor.execute(new PrioRunnable(){

            @Override
            public void run() {
                MemoryLimitedChunk chunk = new MemoryLimitedChunk(MemoryLimitedJobRunner.this, job.initialAllocation);
                if (job.start(chunk)) {
                    chunk.release();
                }
            }

            @Override
            public int getPriority() {
                return THREAD_PRIORITY;
            }
        });
    }

    long used() {
        return this.counter;
    }

    public synchronized void setMaxThreads(int val) {
        this.maxThreads = val;
        this.maybeStartJobs();
    }

    public synchronized int getMaxThreads() {
        return this.maxThreads;
    }

    public synchronized long getCapacity() {
        return this.capacity;
    }

    public synchronized void setCapacity(long val) {
        this.capacity = val;
        this.maybeStartJobs();
    }

    public synchronized void shutdown() {
        this.shutdown = true;
    }

    public synchronized void waitForShutdown() {
        this.shutdown = true;
        while (this.runningThreads > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized int getRunningThreads() {
        return this.runningThreads;
    }

    static {
        Logger.registerClass(MemoryLimitedJobRunner.class);
    }
}

