/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import java.nio.charset.StandardCharsets;

public class URLEncoder {
    static final String safeURLCharacters = "*-_./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz";

    public static String getSafeURLCharacters() {
        return safeURLCharacters;
    }

    public static String encode(String URL2, String force, boolean ascii) {
        return URLEncoder.encode(URL2, force, ascii, "");
    }

    public static String encode(String URL2, String force, boolean ascii, String extraSafeChars) {
        StringBuilder enc = new StringBuilder(URL2.length());
        for (int i = 0; i < URL2.length(); ++i) {
            char c = URL2.charAt(i);
            if (!(safeURLCharacters.indexOf(c) < 0 && (ascii || c < '\u0080' || !Character.isDefined(c) || Character.isISOControl(c) || Character.isSpaceChar(c)) && extraSafeChars.indexOf(c) < 0 || force != null && force.indexOf(c) >= 0)) {
                enc.append(c);
                continue;
            }
            for (byte b : String.valueOf(c).getBytes(StandardCharsets.UTF_8)) {
                int x = b & 0xFF;
                if (x < 16) {
                    enc.append("%0");
                } else {
                    enc.append('%');
                }
                enc.append(Integer.toHexString(x));
            }
        }
        return enc.toString();
    }

    public static String encode(String s, boolean ascii) {
        return URLEncoder.encode(s, null, ascii);
    }
}

