/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.client.async.ClientContext;
import freenet.crypt.MasterSecret;
import freenet.support.api.LockableRandomAccessBuffer;
import freenet.support.io.BucketTools;
import freenet.support.io.DelayedFree;
import freenet.support.io.FilenameGenerator;
import freenet.support.io.PersistentFileTracker;
import freenet.support.io.ResumeFailedException;
import freenet.support.io.StorageFormatException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public class DelayedFreeRandomAccessBuffer
implements LockableRandomAccessBuffer,
Serializable,
DelayedFree {
    private static final long serialVersionUID = 1L;
    final LockableRandomAccessBuffer underlying;
    private boolean freed;
    private transient PersistentFileTracker factory;
    private transient long createdCommitID;
    static final int MAGIC = 1068910046;

    public DelayedFreeRandomAccessBuffer(LockableRandomAccessBuffer raf, PersistentFileTracker factory) {
        this.underlying = raf;
        this.createdCommitID = factory.commitID();
        this.factory = factory;
    }

    @Override
    public long size() {
        return this.underlying.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pread(long fileOffset, byte[] buf, int bufOffset, int length) throws IOException {
        DelayedFreeRandomAccessBuffer delayedFreeRandomAccessBuffer = this;
        synchronized (delayedFreeRandomAccessBuffer) {
            if (this.freed) {
                throw new IOException("Already freed");
            }
        }
        this.underlying.pread(fileOffset, buf, bufOffset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pwrite(long fileOffset, byte[] buf, int bufOffset, int length) throws IOException {
        DelayedFreeRandomAccessBuffer delayedFreeRandomAccessBuffer = this;
        synchronized (delayedFreeRandomAccessBuffer) {
            if (this.freed) {
                throw new IOException("Already freed");
            }
        }
        this.underlying.pwrite(fileOffset, buf, bufOffset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        DelayedFreeRandomAccessBuffer delayedFreeRandomAccessBuffer = this;
        synchronized (delayedFreeRandomAccessBuffer) {
            if (this.freed) {
                return;
            }
        }
        this.underlying.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free() {
        DelayedFreeRandomAccessBuffer delayedFreeRandomAccessBuffer = this;
        synchronized (delayedFreeRandomAccessBuffer) {
            if (this.freed) {
                return;
            }
            this.freed = true;
        }
        this.factory.delayedFree(this, this.createdCommitID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockableRandomAccessBuffer.RAFLock lockOpen() throws IOException {
        DelayedFreeRandomAccessBuffer delayedFreeRandomAccessBuffer = this;
        synchronized (delayedFreeRandomAccessBuffer) {
            if (this.freed) {
                throw new IOException("Already freed");
            }
        }
        return this.underlying.lockOpen();
    }

    @Override
    public void onResume(ClientContext context) throws ResumeFailedException {
        this.factory = context.persistentBucketFactory;
        this.underlying.onResume(context);
    }

    @Override
    public void storeTo(DataOutputStream dos) throws IOException {
        dos.writeInt(1068910046);
        this.underlying.storeTo(dos);
    }

    public DelayedFreeRandomAccessBuffer(DataInputStream dis, FilenameGenerator fg, PersistentFileTracker persistentFileTracker, MasterSecret masterSecret) throws IOException, StorageFormatException, ResumeFailedException {
        this.underlying = BucketTools.restoreRAFFrom(dis, fg, persistentFileTracker, masterSecret);
        this.factory = persistentFileTracker;
    }

    @Override
    public boolean toFree() {
        return this.freed;
    }

    public LockableRandomAccessBuffer getUnderlying() {
        if (this.freed) {
            return null;
        }
        return this.underlying;
    }

    @Override
    public void realFree() {
        this.underlying.free();
    }

    @Override
    public int hashCode() {
        return this.underlying.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DelayedFreeRandomAccessBuffer other = (DelayedFreeRandomAccessBuffer)obj;
        return this.underlying.equals(other.underlying);
    }
}

