/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.math;

import freenet.node.Location;
import freenet.support.SimpleFieldSet;
import freenet.support.math.BootstrappingDecayingRunningAverage;
import freenet.support.math.RunningAverage;

public final class DecayingKeyspaceAverage
implements RunningAverage,
Cloneable {
    private static final long serialVersionUID = 5129429614949179428L;
    BootstrappingDecayingRunningAverage avg;

    public DecayingKeyspaceAverage(double defaultValue, int maxReports, SimpleFieldSet fs) {
        this.avg = new BootstrappingDecayingRunningAverage(defaultValue, -2.0, 2.0, maxReports, fs);
    }

    public DecayingKeyspaceAverage(BootstrappingDecayingRunningAverage a) {
        this.avg = a.clone();
    }

    @Override
    public synchronized DecayingKeyspaceAverage clone() {
        return new DecayingKeyspaceAverage(this.avg);
    }

    @Override
    public synchronized double currentValue() {
        return this.avg.currentValue();
    }

    @Override
    public synchronized void report(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Not a valid normalized key: " + d);
        }
        double superValue = this.avg.currentValue();
        double thisValue = Location.normalize(superValue);
        double diff = Location.change(thisValue, d);
        double toAverage = superValue + diff;
        this.avg.report(toAverage);
        double newValue = this.avg.currentValue();
        if (newValue < 0.0 || newValue > 1.0) {
            this.avg.setCurrentValue(Location.normalize(newValue));
        }
    }

    @Override
    public synchronized double valueIfReported(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Not a valid normalized key: " + d);
        }
        double superValue = this.avg.currentValue();
        double thisValue = Location.normalize(superValue);
        double diff = Location.change(thisValue, d);
        return Location.normalize(this.avg.valueIfReported(superValue + diff));
    }

    @Override
    public synchronized long countReports() {
        return this.avg.countReports();
    }

    @Override
    public void report(long d) {
        throw new IllegalArgumentException("KeyspaceAverage does not like longs");
    }

    public synchronized void changeMaxReports(int maxReports) {
        this.avg.changeMaxReports(maxReports);
    }

    public synchronized SimpleFieldSet exportFieldSet(boolean shortLived) {
        return this.avg.exportFieldSet(shortLived);
    }
}

