/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.wizardsteps;

import freenet.clients.http.FirstTimeWizardToadlet;
import freenet.clients.http.wizardsteps.BandwidthLimit;
import freenet.clients.http.wizardsteps.BandwidthManipulator;
import freenet.clients.http.wizardsteps.PageHelper;
import freenet.clients.http.wizardsteps.Step;
import freenet.clients.http.wizardsteps.WizardL10n;
import freenet.config.Config;
import freenet.config.InvalidConfigValueException;
import freenet.l10n.NodeL10n;
import freenet.node.NodeClientCore;
import freenet.support.HTMLNode;
import freenet.support.URLEncoder;
import freenet.support.api.HTTPRequest;

public class BANDWIDTH_MONTHLY
extends BandwidthManipulator
implements Step {
    private static final long[] caps = new long[]{(long)Math.ceil(BandwidthLimit.minMonthlyLimit), 100L, 150L, 250L, 500L};

    public BANDWIDTH_MONTHLY(NodeClientCore core, Config config) {
        super(core, config);
    }

    @Override
    public void getStep(HTTPRequest request, PageHelper helper) {
        HTMLNode contentNode = helper.getPageContent(WizardL10n.l10n("bandwidthLimit"));
        String parseTarget = request.getParam("parseTarget");
        if (request.isParameterSet("parseError")) {
            this.parseErrorBox(contentNode, helper, WizardL10n.l10n("bandwidthCouldNotParse", "limit", parseTarget));
        } else if (request.isParameterSet("tooLow")) {
            HTMLNode errorBox = this.parseErrorBox(contentNode, helper, WizardL10n.l10n("bandwidthMonthlyLow", new String[]{"requested", "minimum", "useMinimum"}, new String[]{parseTarget, String.valueOf(Math.round(BandwidthLimit.minMonthlyLimit)), WizardL10n.l10n("bandwidthMonthlyUseMinimum")}));
            HTMLNode minimumForm = helper.addFormChild(errorBox, ".", "use-minimum");
            minimumForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "capTo", String.valueOf(BandwidthLimit.minMonthlyLimit)});
            minimumForm.addChild("input", new String[]{"type", "value"}, new String[]{"submit", WizardL10n.l10n("bandwidthMonthlyUseMinimum")});
        }
        HTMLNode infoBox = helper.getInfobox("infobox-normal", WizardL10n.l10n("bandwidthLimitMonthlyTitle"), contentNode, null, false);
        NodeL10n.getBase().addL10nSubstitution(infoBox, "FirstTimeWizardToadlet.bandwidthLimitMonthly", new String[]{"bold", "coreSettings"}, new HTMLNode[]{HTMLNode.STRONG, new HTMLNode("#", NodeL10n.getBase().getString("ConfigToadlet.node"))});
        HTMLNode table = infoBox.addChild("table");
        HTMLNode headerRow = table.addChild("tr");
        headerRow.addChild("th", WizardL10n.l10n("bandwidthLimitMonthlyTitle"));
        headerRow.addChild("th", WizardL10n.l10n("bandwidthSelect"));
        for (long cap : caps) {
            HTMLNode row = table.addChild("tr");
            row.addChild("td", String.valueOf(cap) + " GB");
            HTMLNode selectForm = helper.addFormChild(row.addChild("td"), ".", "limit");
            selectForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "capTo", String.valueOf(cap)});
            selectForm.addChild("input", new String[]{"type", "value"}, new String[]{"submit", WizardL10n.l10n("bandwidthSelect")});
        }
        HTMLNode customForm = helper.addFormChild(table.addChild("tr"), ".", "custom-form");
        HTMLNode capInput = customForm.addChild("td");
        capInput.addChild("input", new String[]{"type", "name"}, new String[]{"text", "capTo"});
        capInput.addChild("#", " GB");
        customForm.addChild("td").addChild("input", new String[]{"type", "value"}, new String[]{"submit", WizardL10n.l10n("bandwidthSelect")});
        HTMLNode backForm = helper.addFormChild(infoBox, ".", "backForm");
        backForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "back", NodeL10n.getBase().getString("Toadlet.back")});
    }

    @Override
    public String postStep(HTTPRequest request) {
        long bytesPerMonth;
        double GBPerMonth;
        String capTo = request.getPartAsStringFailsafe("capTo", 4096);
        StringBuilder target = new StringBuilder(FirstTimeWizardToadlet.WIZARD_STEP.BANDWIDTH_MONTHLY.name()).append("&parseTarget=");
        try {
            GBPerMonth = Double.parseDouble(capTo);
            bytesPerMonth = Math.round(GBPerMonth * 1.073741824E9);
        }
        catch (NumberFormatException e) {
            target.append(URLEncoder.encode(capTo, true));
            target.append("&parseError=true");
            return target.toString();
        }
        BandwidthLimit bandwidth = new BandwidthLimit(bytesPerMonth);
        try {
            this.setBandwidthLimit(Long.toString(bandwidth.downBytes), false);
            this.setBandwidthLimit(Long.toString(bandwidth.upBytes), true);
        }
        catch (InvalidConfigValueException e) {
            target.append(URLEncoder.encode(String.valueOf(GBPerMonth), true));
            target.append("&tooLow=true");
            return target.toString();
        }
        this.setWizardComplete();
        return FirstTimeWizardToadlet.WIZARD_STEP.COMPLETE.name();
    }
}

