/*
 * Decompiled with CFR 0.152.
 */
package freenet.config;

import freenet.config.InvalidConfigValueException;
import freenet.config.Option;
import freenet.config.SubConfig;
import freenet.l10n.NodeL10n;
import freenet.support.URLDecoder;
import freenet.support.URLEncodedFormatException;
import freenet.support.URLEncoder;
import freenet.support.api.StringArrCallback;
import java.util.Arrays;

public class StringArrOption
extends Option<String[]> {
    public static final String delimiter = ";";

    public StringArrOption(SubConfig conf, String optionName, String[] defaultValue, int sortOrder, boolean expert, boolean forceWrite, String shortDesc, String longDesc, StringArrCallback cb) {
        super(conf, optionName, cb, sortOrder, expert, forceWrite, shortDesc, longDesc, Option.DataType.STRING_ARRAY);
        this.defaultValue = defaultValue == null ? new String[]{} : defaultValue;
        this.currentValue = defaultValue == null ? new String[]{} : defaultValue;
    }

    @Override
    public String[] parseString(String val) throws InvalidConfigValueException {
        if (val.isEmpty()) {
            return new String[0];
        }
        String[] out = val.split(delimiter);
        try {
            for (int i = 0; i < out.length; ++i) {
                out[i] = out[i].equals(":") ? "" : URLDecoder.decode(out[i], true);
            }
        }
        catch (URLEncodedFormatException e) {
            throw new InvalidConfigValueException(this.l10n("parseError", "error", e.getLocalizedMessage()));
        }
        return out;
    }

    public void setInitialValue(String[] val) throws InvalidConfigValueException {
        this.currentValue = val;
    }

    private String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("StringArrOption." + key, pattern, value);
    }

    @Override
    public String toString(String[] arr) {
        if (arr == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            String val = arr[i];
            if (val.isEmpty()) {
                sb.append(":").append(delimiter);
                continue;
            }
            sb.append(URLEncoder.encode(arr[i], false)).append(delimiter);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String decode(String s) {
        try {
            return URLDecoder.decode(s, false);
        }
        catch (URLEncodedFormatException e) {
            return null;
        }
    }

    @Override
    public boolean isDefault() {
        this.getValue();
        return this.currentValue == null ? false : Arrays.equals((Object[])this.currentValue, (Object[])this.defaultValue);
    }
}

