/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.AsyncMessageCallback;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.Message;
import freenet.support.Logger;

public class MessageItem {
    final Message msg;
    final byte[] buf;
    final AsyncMessageCallback[] cb;
    final long submitted;
    final boolean formatted;
    final ByteCounter ctrCallback;
    private final short priority;
    private long cachedID;
    private boolean hasCachedID;
    private long deadline;

    public MessageItem(Message msg2, AsyncMessageCallback[] cb2, ByteCounter ctr, short overridePriority) {
        this.msg = msg2;
        this.cb = cb2;
        this.formatted = false;
        this.ctrCallback = ctr;
        this.submitted = System.currentTimeMillis();
        this.priority = overridePriority > 0 ? overridePriority : msg2.getPriority();
        this.buf = this.msg.encodeToPacket();
        if (this.buf.length > 4096) {
            Logger.error(this, "WARNING: Message too big: " + this.buf.length + " for " + msg2, (Throwable)new Exception("error"));
        }
    }

    public MessageItem(Message msg2, AsyncMessageCallback[] cb2, ByteCounter ctr) {
        this(msg2, cb2, ctr, -1);
    }

    public MessageItem(byte[] data, AsyncMessageCallback[] cb2, boolean formatted, ByteCounter ctr, short priority) {
        this.cb = cb2;
        this.msg = null;
        this.buf = data;
        this.formatted = formatted;
        if (formatted && this.buf == null) {
            throw new NullPointerException();
        }
        this.ctrCallback = ctr;
        this.submitted = System.currentTimeMillis();
        this.priority = priority;
    }

    public byte[] getData() {
        return this.buf;
    }

    public int getLength() {
        return this.buf.length;
    }

    public void onSent(int length) {
        if (this.ctrCallback != null) {
            try {
                this.ctrCallback.sentBytes(length);
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t + " reporting " + length + " sent bytes on " + this, t);
            }
        }
    }

    public short getPriority() {
        return this.priority;
    }

    public String toString() {
        return super.toString() + ":formatted=" + this.formatted + ",msg=" + this.msg;
    }

    public void onDisconnect() {
        if (this.cb != null) {
            for (AsyncMessageCallback cbi : this.cb) {
                try {
                    cbi.disconnected();
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught " + t + " calling sent() on " + cbi + " for " + this, t);
                }
            }
        }
    }

    public void onFailed() {
        if (this.cb != null) {
            for (AsyncMessageCallback cbi : this.cb) {
                try {
                    cbi.fatalError();
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught " + t + " calling sent() on " + cbi + " for " + this, t);
                }
            }
        }
    }

    public synchronized long getID() {
        if (this.hasCachedID) {
            return this.cachedID;
        }
        this.cachedID = this.generateID();
        this.hasCachedID = true;
        return this.cachedID;
    }

    private long generateID() {
        if (this.msg == null) {
            return -1L;
        }
        Object o = this.msg.getObject("uid");
        if (o == null || !(o instanceof Long)) {
            return -1L;
        }
        return (Long)o;
    }

    public void onSentAll() {
        if (this.cb != null) {
            for (AsyncMessageCallback cbi : this.cb) {
                try {
                    cbi.sent();
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught " + t + " calling sent() on " + cbi + " for " + this, t);
                }
            }
        }
    }

    public synchronized void setDeadline(long time) {
        this.deadline = time;
    }

    public synchronized void clearDeadline() {
        this.deadline = 0L;
    }

    public synchronized long getDeadline() {
        return this.deadline;
    }
}

