/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestSelector;
import freenet.client.async.RequestSelectionTreeNode;
import freenet.support.Logger;
import freenet.support.RandomGrabArrayItem;
import freenet.support.RandomGrabArrayItemExclusionList;
import freenet.support.RemoveRandom;
import freenet.support.RemoveRandomParent;
import freenet.support.RemoveRandomWithObject;
import java.util.Arrays;

public class SectoredRandomGrabArray<T, C extends RemoveRandomWithObject<T>>
implements RemoveRandom,
RemoveRandomParent,
RequestSelectionTreeNode {
    private static volatile boolean logMINOR;
    private RemoveRandomWithObject<T>[] grabArrays;
    private T[] grabClients = this.newClientArray(0);
    private RemoveRandomParent parent;
    protected final ClientRequestSelector root;
    private long wakeupTime;

    public SectoredRandomGrabArray(RemoveRandomParent parent, ClientRequestSelector root) {
        this.grabArrays = this.newGrabberArray(0);
        this.parent = parent;
        this.root = root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addElement(T client, C rga) {
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            int len = this.grabArrays.length;
            this.grabArrays = Arrays.copyOf(this.grabArrays, len + 1);
            this.grabArrays[len] = rga;
            this.grabClients = Arrays.copyOf(this.grabClients, len + 1);
            this.grabClients[len] = client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int haveClient(T client) {
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            for (int i = 0; i < this.grabClients.length; ++i) {
                if (this.grabClients[i] != client) continue;
                return i;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C getGrabber(T client) {
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            int idx = this.haveClient(client);
            if (idx == -1) {
                return null;
            }
            return (C)this.grabArrays[idx];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getClient(int x) {
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            return this.grabClients[x];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGrabber(T client, C requestGrabber, ClientContext context) {
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            if (requestGrabber.getObject() != client) {
                throw new IllegalArgumentException("Client not equal to RemoveRandomWithObject's client: client=" + client + " rr=" + requestGrabber + " his object=" + requestGrabber.getObject());
            }
            this.addElement(client, requestGrabber);
            if (context != null) {
                this.clearWakeupTime(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveRandom.RemoveRandomReturn removeRandom(RandomGrabArrayItemExclusionList excluding, ClientContext context, long now) {
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            block7: {
                RemoveRandom.RemoveRandomReturn ret;
                do {
                    if (this.grabArrays.length == 0) {
                        return null;
                    }
                    if (this.grabArrays.length == 1) {
                        return this.removeRandomOneOnly(excluding, context, now);
                    }
                    if (this.grabArrays.length != 2) break block7;
                } while ((ret = this.removeRandomTwoOnly(excluding, context, now)) == null);
                return ret;
            }
            RandomGrabArrayItem item = this.removeRandomLimited(excluding, context, now);
            if (item != null) {
                return new RemoveRandom.RemoveRandomReturn(item);
            }
            return this.removeRandomExhaustive(excluding, context, now);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoveRandom.RemoveRandomReturn removeRandomExhaustive(RandomGrabArrayItemExclusionList excluding, ClientContext context, long now) {
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            long wakeupTime = Long.MAX_VALUE;
            if (this.grabArrays.length == 0) {
                return null;
            }
            int x = context.fastWeakRandom.nextInt(this.grabArrays.length);
            for (int i = 0; i < this.grabArrays.length; ++i) {
                RemoveRandomWithObject<T> rga;
                long excludeTime;
                if (++x >= this.grabArrays.length) {
                    x = 0;
                }
                if ((excludeTime = (rga = this.grabArrays[x]).getWakeupTime(context, now)) > 0L) {
                    if (wakeupTime <= excludeTime) continue;
                    wakeupTime = excludeTime;
                    continue;
                }
                if (logMINOR) {
                    Logger.minor(this, "Picked " + x + " of " + this.grabArrays.length + " : " + rga + " on " + this);
                }
                RandomGrabArrayItem item = null;
                RemoveRandom.RemoveRandomReturn val = rga.removeRandom(excluding, context, now);
                if (val != null) {
                    if (val.item != null) {
                        item = val.item;
                    } else if (wakeupTime > val.wakeupTime) {
                        wakeupTime = val.wakeupTime;
                    }
                }
                if (logMINOR) {
                    Logger.minor(this, "RGA has picked " + x + "/" + this.grabArrays.length + ": " + item + " rga.isEmpty=" + rga.isEmpty());
                }
                if (item != null) {
                    return new RemoveRandom.RemoveRandomReturn(item);
                }
                if (!rga.isEmpty()) continue;
                if (logMINOR) {
                    Logger.minor(this, "Removing grab array " + x + " : " + rga + " (is empty)");
                }
                this.removeElement(x);
            }
            this.reduceWakeupTime(wakeupTime, context);
            return new RemoveRandom.RemoveRandomReturn(wakeupTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomGrabArrayItem removeRandomLimited(RandomGrabArrayItemExclusionList excluding, ClientContext context, long now) {
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            int MAX_EXCLUDED = 10;
            int excluded = 0;
            while (true) {
                if (this.grabArrays.length == 0) {
                    return null;
                }
                int x = context.fastWeakRandom.nextInt(this.grabArrays.length);
                RemoveRandomWithObject<T> rga = this.grabArrays[x];
                if (rga == null) {
                    Logger.error(this, "Slot " + x + " is null for client " + this.grabClients[x]);
                    if (++excluded <= 10) continue;
                    if (logMINOR) {
                        Logger.minor(this, "Too many sub-arrays are entirely excluded on " + this + " length = " + this.grabArrays.length, (Throwable)new Exception("error"));
                    }
                    return null;
                }
                long excludeTime = rga.getWakeupTime(context, now);
                if (excludeTime > 0L) {
                    if (++excluded <= 10) continue;
                    if (logMINOR) {
                        Logger.minor(this, "Too many sub-arrays are entirely excluded on " + this + " length = " + this.grabArrays.length, (Throwable)new Exception("error"));
                    }
                    return null;
                }
                if (logMINOR) {
                    Logger.minor(this, "Picked " + x + " of " + this.grabArrays.length + " : " + rga + " on " + this);
                }
                RandomGrabArrayItem item = null;
                RemoveRandom.RemoveRandomReturn val = rga.removeRandom(excluding, context, now);
                if (val != null && val.item != null) {
                    item = val.item;
                }
                if (logMINOR) {
                    Logger.minor(this, "RGA has picked " + x + "/" + this.grabArrays.length + ": " + item + " rga.isEmpty=" + rga.isEmpty());
                }
                if (item != null) {
                    return item;
                }
                if (rga.isEmpty()) {
                    if (logMINOR) {
                        Logger.minor(this, "Removing grab array " + x + " : " + rga + " (is empty)");
                    }
                    this.removeElement(x);
                    continue;
                }
                if (++excluded > 10) break;
            }
            if (logMINOR) {
                Logger.minor(this, "Too many sub-arrays are entirely excluded on " + this + " length = " + this.grabArrays.length, (Throwable)new Exception("error"));
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoveRandom.RemoveRandomReturn removeRandomTwoOnly(RandomGrabArrayItemExclusionList excluding, ClientContext context, long now) {
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            long excludeTime;
            RemoveRandomWithObject<T> rga;
            long wakeupTime = Long.MAX_VALUE;
            int x = context.fastWeakRandom.nextBoolean() ? 1 : 0;
            RemoveRandomWithObject<T> firstRGA = rga = this.grabArrays[x];
            if (rga == null) {
                Logger.error(this, "rga = null on " + this);
                if (this.grabArrays[1 - x] == null) {
                    Logger.error(this, "other rga is also null on " + this);
                    this.grabArrays = this.newGrabberArray(0);
                    this.grabClients = this.newClientArray(0);
                    return null;
                }
                Logger.error(this, "grabArrays[" + (1 - x) + "] is valid but [" + x + "] is null, correcting...");
                this.grabArrays = this.asGrabberArray(this.grabArrays[1 - x]);
                this.grabClients = this.asClientArray(this.grabClients[1 - x]);
                return null;
            }
            RandomGrabArrayItem item = null;
            RemoveRandom.RemoveRandomReturn val = null;
            if (logMINOR) {
                Logger.minor(this, "Only 2, trying " + rga);
            }
            if ((excludeTime = rga.getWakeupTime(context, now)) > 0L) {
                wakeupTime = excludeTime;
                rga = null;
                firstRGA = null;
            } else {
                val = rga.removeRandom(excluding, context, now);
                if (val != null) {
                    if (val.item != null) {
                        item = val.item;
                    } else if (wakeupTime > val.wakeupTime) {
                        wakeupTime = val.wakeupTime;
                    }
                }
            }
            if (item != null) {
                if (logMINOR) {
                    Logger.minor(this, "Returning (two items only) " + item + " for " + rga);
                }
                return new RemoveRandom.RemoveRandomReturn(item);
            }
            rga = this.grabArrays[x = 1 - x];
            if (rga == null) {
                Logger.error(this, "Other RGA is null later on on " + this);
                this.grabArrays = this.asGrabberArray(this.grabArrays[1 - x]);
                this.grabClients = this.asClientArray(this.grabClients[1 - x]);
                this.reduceWakeupTime(wakeupTime, context);
                return new RemoveRandom.RemoveRandomReturn(wakeupTime);
            }
            excludeTime = rga.getWakeupTime(context, now);
            if (excludeTime > 0L) {
                if (wakeupTime > excludeTime) {
                    wakeupTime = excludeTime;
                }
                rga = null;
            } else {
                val = rga.removeRandom(excluding, context, now);
                if (val != null) {
                    if (val.item != null) {
                        item = val.item;
                    } else if (wakeupTime > val.wakeupTime) {
                        wakeupTime = val.wakeupTime;
                    }
                }
            }
            if (firstRGA != null && firstRGA.isEmpty() && rga != null && rga.isEmpty()) {
                if (logMINOR) {
                    Logger.minor(this, "Removing both on " + this + " : " + firstRGA + " and " + rga + " are empty");
                }
                this.grabArrays = this.newGrabberArray(0);
                this.grabClients = this.newClientArray(0);
            } else if (firstRGA != null && firstRGA.isEmpty()) {
                if (logMINOR) {
                    Logger.minor(this, "Removing first: " + firstRGA + " is empty on " + this);
                }
                this.grabArrays = this.asGrabberArray(this.grabArrays[x]);
                this.grabClients = this.asClientArray(this.grabClients[x]);
            }
            if (logMINOR) {
                Logger.minor(this, "Returning (two items only) " + item + " for " + rga);
            }
            if (item == null) {
                if (this.grabArrays.length == 0) {
                    return null;
                }
                this.reduceWakeupTime(wakeupTime, context);
                return new RemoveRandom.RemoveRandomReturn(wakeupTime);
            }
            return new RemoveRandom.RemoveRandomReturn(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoveRandom.RemoveRandomReturn removeRandomOneOnly(RandomGrabArrayItemExclusionList excluding, ClientContext context, long now) {
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            long excludeTime;
            long wakeupTime = Long.MAX_VALUE;
            RemoveRandomWithObject<T> rga = this.grabArrays[0];
            if (logMINOR) {
                Logger.minor(this, "Only one RGA: " + rga);
            }
            if ((excludeTime = rga.getWakeupTime(context, now)) > 0L) {
                return new RemoveRandom.RemoveRandomReturn(excludeTime);
            }
            if (rga == null) {
                Logger.error(this, "Only one entry and that is null");
                this.grabArrays = this.newGrabberArray(0);
                this.grabClients = this.newClientArray(0);
                return null;
            }
            RemoveRandom.RemoveRandomReturn val = rga.removeRandom(excluding, context, now);
            RandomGrabArrayItem item = null;
            if (val != null) {
                if (val.item != null) {
                    item = val.item;
                } else {
                    wakeupTime = val.wakeupTime;
                }
            }
            if (rga.isEmpty()) {
                if (logMINOR) {
                    Logger.minor(this, "Removing only grab array (0) : " + rga);
                }
                this.grabArrays = this.newGrabberArray(0);
                this.grabClients = this.newClientArray(0);
            }
            if (logMINOR) {
                Logger.minor(this, "Returning (one item only) " + item + " for " + rga);
            }
            if (item == null) {
                if (this.grabArrays.length == 0) {
                    if (logMINOR) {
                        Logger.minor(this, "Arrays are empty on " + this);
                    }
                    return null;
                }
                this.reduceWakeupTime(wakeupTime, context);
                return new RemoveRandom.RemoveRandomReturn(wakeupTime);
            }
            return new RemoveRandom.RemoveRandomReturn(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeElement(int x) {
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            int grabArraysLength = this.grabArrays.length;
            int newLen = grabArraysLength > 1 ? grabArraysLength - 1 : 0;
            RemoveRandomWithObject<T>[] newArray = this.newGrabberArray(newLen);
            if (x > 0) {
                System.arraycopy(this.grabArrays, 0, newArray, 0, x);
            }
            if (x < grabArraysLength - 1) {
                System.arraycopy(this.grabArrays, x + 1, newArray, x, grabArraysLength - (x + 1));
            }
            this.grabArrays = newArray;
            T[] newClients = this.newClientArray(newLen);
            if (x > 0) {
                System.arraycopy(this.grabClients, 0, newClients, 0, x);
            }
            if (x < grabArraysLength - 1) {
                System.arraycopy(this.grabClients, x + 1, newClients, x, grabArraysLength - (x + 1));
            }
            this.grabClients = newClients;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            return this.grabArrays.length == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            return this.grabArrays.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void maybeRemove(RemoveRandom r, ClientContext context) {
        int finalSize;
        int count = 0;
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            while (true) {
                int found = -1;
                for (int i = 0; i < this.grabArrays.length; ++i) {
                    if (this.grabArrays[i] != r) continue;
                    found = i;
                    break;
                }
                if (found == -1) break;
                if (++count > 1) {
                    Logger.error(this, "Found " + r + " many times in " + this, (Throwable)new Exception("error"));
                }
                this.removeElement(found);
            }
            finalSize = this.grabArrays.length;
        }
        if (count == 0 && logMINOR) {
            Logger.minor(this, "Not in parent: " + r + " for " + this, (Throwable)new Exception("error"));
        }
        if (finalSize == 0 && this.parent != null) {
            this.parent.maybeRemove(this, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParent(RemoveRandomParent newParent) {
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            this.parent = newParent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestSelectionTreeNode getParentGrabArray() {
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            return this.parent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getWakeupTime(ClientContext context, long now) {
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            if (this.wakeupTime < now) {
                this.wakeupTime = 0L;
            }
            return this.wakeupTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reduceWakeupTime(long wakeupTime, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "reduceCooldownTime(" + (wakeupTime - System.currentTimeMillis()) + ") on " + this);
        }
        boolean reachedRoot = false;
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            if (this.wakeupTime > wakeupTime) {
                this.wakeupTime = wakeupTime;
                if (this.parent != null) {
                    this.parent.reduceWakeupTime(wakeupTime, context);
                } else {
                    reachedRoot = true;
                }
            } else {
                return false;
            }
        }
        if (reachedRoot) {
            this.root.wakeUp(context);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWakeupTime(ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "clearCooldownTime() on " + this);
        }
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            this.wakeupTime = 0L;
            if (this.parent != null) {
                this.parent.clearWakeupTime(context);
            }
        }
    }

    private T[] asClientArray(T client) {
        T[] clients = this.newClientArray(1);
        clients[0] = client;
        return clients;
    }

    private T[] newClientArray(int length) {
        return new Object[length];
    }

    private RemoveRandomWithObject<T>[] asGrabberArray(RemoveRandomWithObject<T> grabber) {
        RemoveRandomWithObject<T>[] grabbers = this.newGrabberArray(1);
        grabbers[0] = grabber;
        return grabbers;
    }

    private RemoveRandomWithObject<T>[] newGrabberArray(int length) {
        return new RemoveRandomWithObject[length];
    }

    static {
        Logger.registerClass(SectoredRandomGrabArray.class);
    }
}

