/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.TimeUtil;
import freenet.support.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.tanukisoftware.wrapper.WrapperManager;

public class FilenameGenerator {
    private transient Random random;
    private String prefix;
    private File tmpDir;
    private static volatile boolean logMINOR;

    public FilenameGenerator(Random random, boolean wipeFiles, File dir, String prefix) throws IOException {
        this.random = random;
        this.prefix = prefix;
        this.tmpDir = dir == null ? FileUtil.getCanonicalFile(new File(System.getProperty("java.io.tmpdir"))) : FileUtil.getCanonicalFile(dir);
        if (!this.tmpDir.exists()) {
            this.tmpDir.mkdir();
        }
        if (!(this.tmpDir.isDirectory() && this.tmpDir.canRead() && this.tmpDir.canWrite())) {
            throw new IOException("Not a directory or cannot read/write: " + this.tmpDir);
        }
        if (wipeFiles) {
            long wipedFiles = 0L;
            long wipeableFiles = 0L;
            long startWipe = System.currentTimeMillis();
            File[] filenames = this.tmpDir.listFiles();
            if (filenames != null) {
                for (int i = 0; i < filenames.length; ++i) {
                    WrapperManager.signalStarting((int)((int)TimeUnit.MINUTES.toMillis(5L)));
                    if (i % 1024 == 0 && i > 0) {
                        System.err.println("Deleted " + wipedFiles + " temp files (" + ((long)i - wipeableFiles) + " non-temp files in temp dir)");
                    }
                    File f = filenames[i];
                    String name = f.getName();
                    if ((File.separatorChar != '\\' || !name.toLowerCase().startsWith(prefix.toLowerCase())) && !name.startsWith(prefix)) continue;
                    ++wipeableFiles;
                    if (!f.delete() && f.exists()) {
                        System.err.println("Unable to delete temporary file " + f + " - permissions problem?");
                        continue;
                    }
                    ++wipedFiles;
                }
                long endWipe = System.currentTimeMillis();
                System.err.println("Deleted " + wipedFiles + " of " + wipeableFiles + " temporary files (" + ((long)filenames.length - wipeableFiles) + " non-temp files in temp directory) in " + TimeUtil.formatTime(endWipe - startWipe));
            }
        }
    }

    public long makeRandomFilename() throws IOException {
        String filename;
        File ret;
        long randomFilename;
        while ((randomFilename = this.random.nextLong()) == -1L || !(ret = new File(this.tmpDir, filename = this.prefix + Long.toHexString(randomFilename))).createNewFile()) {
        }
        if (logMINOR) {
            Logger.minor(this, "Made random filename: " + ret, (Throwable)new Exception("debug"));
        }
        return randomFilename;
    }

    public File getFilename(long id) {
        return new File(this.tmpDir, this.prefix + Long.toHexString(id));
    }

    public File makeRandomFile() throws IOException {
        return this.getFilename(this.makeRandomFilename());
    }

    public File getDir() {
        return this.tmpDir;
    }

    protected boolean matches(File file) {
        return FileUtil.equals(file.getParentFile(), this.tmpDir) && file.getName().startsWith(this.prefix);
    }

    public File maybeMove(File file, long id) {
        if (this.matches(file)) {
            return file;
        }
        File newFile = this.getFilename(id);
        Logger.normal(this, "Moving tempfile " + file + " to " + newFile);
        if (FileUtil.moveTo(file, newFile, false)) {
            return newFile;
        }
        Logger.error(this, "Unable to move old temporary file " + file + " to " + newFile);
        return file;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

