/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.async.ChosenBlock;
import freenet.client.async.ClientContext;
import freenet.client.async.PersistentJob;
import freenet.keys.ClientKey;
import freenet.keys.Key;
import freenet.node.LowLevelGetException;
import freenet.node.LowLevelPutException;
import freenet.node.RequestScheduler;
import freenet.node.SendableGet;
import freenet.node.SendableInsert;
import freenet.node.SendableRequest;
import freenet.node.SendableRequestItem;
import freenet.node.SendableRequestSender;
import freenet.support.Logger;

public class ChosenBlockImpl
extends ChosenBlock {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    public final SendableRequest request;
    public final RequestScheduler sched;
    public final boolean persistent;

    public ChosenBlockImpl(SendableRequest req, SendableRequestItem token, Key key, ClientKey ckey, boolean localRequestOnly, boolean ignoreStore, boolean canWriteClientCache, boolean forkOnCacheable, boolean realTimeFlag, RequestScheduler sched, boolean persistent) {
        super(token, key, ckey, localRequestOnly, ignoreStore, canWriteClientCache, forkOnCacheable, realTimeFlag, sched);
        this.request = req;
        this.sched = sched;
        this.persistent = persistent;
        if (logDEBUG) {
            Logger.minor(this, "Created " + this + " for " + (persistent ? "persistent" : "transient") + " block " + token + " for key " + key, (Throwable)new Exception("debug"));
        }
    }

    @Override
    public boolean isCancelled() {
        return this.request.isCancelled();
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    @Override
    public void onFailure(final LowLevelPutException e, ClientContext context) {
        context.getJobRunner(this.persistent).queueNormalOrDrop(new PersistentJob(){

            @Override
            public boolean run(ClientContext context) {
                try {
                    ((SendableInsert)ChosenBlockImpl.this.request).onFailure(e, ChosenBlockImpl.this.token, context);
                }
                finally {
                    ChosenBlockImpl.this.sched.removeRunningInsert((SendableInsert)ChosenBlockImpl.this.request, ChosenBlockImpl.this.token.getKey());
                }
                ChosenBlockImpl.this.sched.wakeStarter();
                return false;
            }
        });
    }

    @Override
    public void onInsertSuccess(final ClientKey key, ClientContext context) {
        context.getJobRunner(this.persistent).queueNormalOrDrop(new PersistentJob(){

            @Override
            public boolean run(ClientContext context) {
                try {
                    ((SendableInsert)ChosenBlockImpl.this.request).onSuccess(ChosenBlockImpl.this.token, key, context);
                }
                finally {
                    ChosenBlockImpl.this.sched.removeRunningInsert((SendableInsert)ChosenBlockImpl.this.request, ChosenBlockImpl.this.token.getKey());
                }
                ChosenBlockImpl.this.sched.wakeStarter();
                return false;
            }
        });
    }

    @Override
    public void onFailure(final LowLevelGetException e, ClientContext context) {
        context.getJobRunner(this.persistent).queueNormalOrDrop(new PersistentJob(){

            @Override
            public boolean run(ClientContext context) {
                try {
                    ((SendableGet)ChosenBlockImpl.this.request).onFailure(e, ChosenBlockImpl.this.token, context);
                }
                finally {
                    ChosenBlockImpl.this.sched.removeFetchingKey(ChosenBlockImpl.this.key);
                }
                ChosenBlockImpl.this.sched.wakeStarter();
                return false;
            }
        });
    }

    @Override
    public void onFetchSuccess(ClientContext context) {
        context.getJobRunner(this.persistent).queueNormalOrDrop(new PersistentJob(){

            @Override
            public boolean run(ClientContext context) {
                try {
                    ChosenBlockImpl.this.sched.succeeded((SendableGet)ChosenBlockImpl.this.request, false);
                }
                finally {
                    ChosenBlockImpl.this.sched.removeFetchingKey(ChosenBlockImpl.this.key);
                }
                ChosenBlockImpl.this.sched.wakeStarter();
                return false;
            }
        });
    }

    @Override
    public short getPriority() {
        return this.request.getPriorityClass();
    }

    @Override
    public SendableRequestSender getSender(ClientContext context) {
        return this.request.getSender(context);
    }

    static {
        Logger.registerClass(ChosenBlockImpl.class);
    }
}

