/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutState;
import freenet.client.async.PutCompletionCallback;
import freenet.keys.BaseClientKey;
import freenet.support.ListUtils;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.ResumeFailedException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MultiPutCompletionCallback
implements PutCompletionCallback,
ClientPutState,
Serializable {
    private static final long serialVersionUID = 1L;
    private static volatile boolean logMINOR;
    private final ArrayList<ClientPutState> waitingFor;
    private final ArrayList<ClientPutState> waitingForBlockSet;
    private final ArrayList<ClientPutState> waitingForFetchable;
    private final PutCompletionCallback cb;
    private ClientPutState generator;
    private final BaseClientPutter parent;
    private InsertException e;
    private boolean cancelling;
    private boolean finished;
    private boolean started;
    private boolean calledFetchable;
    public final Object token;
    private final boolean persistent;
    private final boolean collisionIsOK;
    private final boolean finishOnFailure;
    private transient boolean resumed;
    private BaseClientKey encodedKey;

    public MultiPutCompletionCallback(PutCompletionCallback cb, BaseClientPutter parent, Object token, boolean persistent) {
        this(cb, parent, token, persistent, false);
    }

    public MultiPutCompletionCallback(PutCompletionCallback cb, BaseClientPutter parent, Object token, boolean persistent, boolean collisionIsOK) {
        this(cb, parent, token, persistent, collisionIsOK, false);
    }

    public MultiPutCompletionCallback(PutCompletionCallback cb, BaseClientPutter parent, Object token, boolean persistent, boolean collisionIsOK, boolean finishOnFailure) {
        this.cb = cb;
        this.collisionIsOK = collisionIsOK;
        this.finishOnFailure = finishOnFailure;
        this.waitingFor = new ArrayList();
        this.waitingForBlockSet = new ArrayList();
        this.waitingForFetchable = new ArrayList();
        this.parent = parent;
        this.token = token;
        this.cancelling = false;
        this.finished = false;
        this.persistent = persistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(ClientPutState state, ClientContext context) {
        this.onBlockSetFinished(state, context);
        this.onFetchable(state);
        boolean complete = true;
        MultiPutCompletionCallback multiPutCompletionCallback = this;
        synchronized (multiPutCompletionCallback) {
            if (this.finished) {
                Logger.error(this, "Already finished but got onSuccess() for " + state + " on " + this);
                return;
            }
            ListUtils.removeBySwapLast(this.waitingFor, state);
            ListUtils.removeBySwapLast(this.waitingForBlockSet, state);
            ListUtils.removeBySwapLast(this.waitingForFetchable, state);
            if (!this.waitingFor.isEmpty() || !this.started) {
                complete = false;
            }
            if (state == this.generator) {
                this.generator = null;
            }
        }
        if (complete) {
            Logger.minor(this, "Completing...");
            this.complete(null, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(InsertException e, ClientPutState state, ClientContext context) {
        if (this.collisionIsOK && e.getMode() == InsertException.InsertExceptionMode.COLLISION) {
            this.onSuccess(state, context);
            return;
        }
        boolean complete = true;
        boolean doCancel = false;
        MultiPutCompletionCallback multiPutCompletionCallback = this;
        synchronized (multiPutCompletionCallback) {
            if (this.finished) {
                Logger.error(this, "Already finished but got onFailure() for " + state + " on " + this);
                return;
            }
            ListUtils.removeBySwapLast(this.waitingFor, state);
            ListUtils.removeBySwapLast(this.waitingForBlockSet, state);
            ListUtils.removeBySwapLast(this.waitingForFetchable, state);
            if (!this.waitingFor.isEmpty() || !this.started) {
                this.e = e;
                if (logMINOR) {
                    Logger.minor(this, "Still running: " + this.waitingFor.size() + " started = " + this.started);
                }
                complete = false;
            }
            if (state == this.generator) {
                this.generator = null;
            }
            if (this.finishOnFailure) {
                if (this.started) {
                    doCancel = true;
                } else {
                    this.cancelling = true;
                }
            }
        }
        if (complete) {
            this.complete(e, context);
        } else if (doCancel) {
            this.cancel(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void complete(InsertException e, ClientContext context) {
        MultiPutCompletionCallback multiPutCompletionCallback = this;
        synchronized (multiPutCompletionCallback) {
            if (this.finished) {
                return;
            }
            this.finished = true;
            if (e != null && this.e != null && this.e != e) {
                if (e.getMode() == InsertException.InsertExceptionMode.CANCELLED) {
                    e = this.e;
                    if (this.persistent) {
                        e = e.clone();
                    }
                } else {
                    this.e = e;
                }
            }
            if (e == null) {
                e = this.e;
                if (this.persistent && e != null) {
                    e = e.clone();
                }
            }
        }
        if (e != null) {
            this.cb.onFailure(e, this, context);
        } else {
            this.cb.onSuccess(this, context);
        }
    }

    public synchronized void addURIGenerator(ClientPutState ps) {
        this.add(ps);
        this.generator = ps;
    }

    public synchronized void add(ClientPutState ps) {
        if (this.finished) {
            return;
        }
        this.waitingFor.add(ps);
        this.waitingForBlockSet.add(ps);
        this.waitingForFetchable.add(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void arm(ClientContext context) {
        boolean doCancel;
        boolean allGotBlocks;
        boolean allDone;
        if (logMINOR) {
            Logger.minor(this, "Arming " + this);
        }
        MultiPutCompletionCallback multiPutCompletionCallback = this;
        synchronized (multiPutCompletionCallback) {
            this.started = true;
            allDone = this.waitingFor.isEmpty();
            allGotBlocks = this.waitingForBlockSet.isEmpty();
            doCancel = this.cancelling;
        }
        if (allGotBlocks) {
            this.cb.onBlockSetFinished(this, context);
        }
        if (allDone) {
            this.complete(this.e, context);
        } else if (doCancel) {
            this.cancel(context);
        }
    }

    @Override
    public BaseClientPutter getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEncode(BaseClientKey key, ClientPutState state, ClientContext context) {
        MultiPutCompletionCallback multiPutCompletionCallback = this;
        synchronized (multiPutCompletionCallback) {
            if (state != this.generator) {
                return;
            }
            if (this.encodedKey != null) {
                if (key.equals(this.encodedKey)) {
                    return;
                }
                Logger.error(this, "Encoded twice with different keys for " + this + " : " + this.encodedKey + " -> " + key);
            }
            this.encodedKey = key;
        }
        this.cb.onEncode(key, this, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(ClientContext context) {
        ClientPutState[] states = new ClientPutState[this.waitingFor.size()];
        MultiPutCompletionCallback multiPutCompletionCallback = this;
        synchronized (multiPutCompletionCallback) {
            states = this.waitingFor.toArray(states);
        }
        boolean logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
        for (int i = 0; i < states.length; ++i) {
            if (logDEBUG) {
                Logger.minor(this, "Cancelling state " + i + " of " + states.length + " : " + states[i]);
            }
            states[i].cancel(context);
        }
    }

    @Override
    public synchronized void onTransition(ClientPutState oldState, ClientPutState newState, ClientContext context) {
        int i;
        if (this.generator == oldState) {
            this.generator = newState;
        }
        if (oldState == newState) {
            return;
        }
        for (i = 0; i < this.waitingFor.size(); ++i) {
            if (this.waitingFor.get(i) != oldState) continue;
            this.waitingFor.set(i, newState);
        }
        for (i = 0; i < this.waitingForBlockSet.size(); ++i) {
            if (this.waitingForBlockSet.get(i) != oldState) continue;
            this.waitingForBlockSet.set(i, newState);
        }
        for (i = 0; i < this.waitingForFetchable.size(); ++i) {
            if (this.waitingForFetchable.get(i) != oldState) continue;
            this.waitingForFetchable.set(i, newState);
        }
    }

    @Override
    public synchronized void onMetadata(Metadata m, ClientPutState state, ClientContext context) {
        if (this.generator == state) {
            this.cb.onMetadata(m, (ClientPutState)this, context);
        } else {
            Logger.error(this, "Got metadata for " + state);
        }
    }

    @Override
    public synchronized void onMetadata(Bucket metadata, ClientPutState state, ClientContext context) {
        if (this.generator == state) {
            this.cb.onMetadata(metadata, (ClientPutState)this, context);
        } else {
            Logger.error(this, "Got metadata for " + state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBlockSetFinished(ClientPutState state, ClientContext context) {
        MultiPutCompletionCallback multiPutCompletionCallback = this;
        synchronized (multiPutCompletionCallback) {
            ListUtils.removeBySwapLast(this.waitingForBlockSet, state);
            if (!this.started) {
                return;
            }
            if (!this.waitingForBlockSet.isEmpty()) {
                return;
            }
        }
        this.cb.onBlockSetFinished(this, context);
    }

    @Override
    public void schedule(ClientContext context) throws InsertException {
    }

    @Override
    public Object getToken() {
        return this.token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFetchable(ClientPutState state) {
        MultiPutCompletionCallback multiPutCompletionCallback = this;
        synchronized (multiPutCompletionCallback) {
            ListUtils.removeBySwapLast(this.waitingForFetchable, state);
            if (!this.started) {
                return;
            }
            if (!this.waitingForFetchable.isEmpty()) {
                return;
            }
            if (this.calledFetchable) {
                if (logMINOR) {
                    Logger.minor(this, "Trying to call onFetchable() twice");
                }
                return;
            }
            this.calledFetchable = true;
        }
        this.cb.onFetchable(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResume(ClientContext context) throws InsertException, ResumeFailedException {
        MultiPutCompletionCallback multiPutCompletionCallback = this;
        synchronized (multiPutCompletionCallback) {
            if (this.resumed) {
                return;
            }
            this.resumed = true;
        }
        for (ClientPutState s : this.getWaitingFor()) {
            s.onResume(context);
        }
        if (this.cb != this.parent) {
            this.cb.onResume(context);
        }
    }

    @Override
    public void onShutdown(ClientContext context) {
        for (ClientPutState state : this.getWaitingFor()) {
            state.onShutdown(context);
        }
    }

    private synchronized List<ClientPutState> getWaitingFor() {
        return new ArrayList<ClientPutState>(this.waitingFor);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

