/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.FECCodec;
import freenet.client.FetchException;
import freenet.client.async.ClientContext;
import freenet.client.async.PersistenceDisabledException;
import freenet.client.async.PersistentJob;
import freenet.client.async.PersistentJobRunner;
import freenet.client.async.SplitFileFetcherSegmentStorage;
import freenet.client.async.SplitFileFetcherStorage;
import freenet.client.async.SplitFileSegmentKeys;
import freenet.keys.CHKEncodeException;
import freenet.keys.ClientCHK;
import freenet.keys.ClientCHKBlock;
import freenet.support.Logger;
import freenet.support.MemoryLimitedChunk;
import freenet.support.MemoryLimitedJob;
import freenet.support.MemoryLimitedJobRunner;
import freenet.support.io.StorageFormatException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SplitFileFetcherCrossSegmentStorage {
    private static volatile boolean logMINOR;
    public final int crossSegmentNumber;
    public final SplitFileFetcherStorage parent;
    private final SplitFileFetcherSegmentStorage[] segments;
    private final int[] blockNumbers;
    private final boolean[] blocksFound;
    final int dataBlockCount;
    final int crossCheckBlockCount;
    final int totalBlocks;
    private int totalFound;
    private boolean tryDecode;
    private boolean cancelled;
    private boolean succeeded;
    private final FECCodec codec;
    private int counter;

    SplitFileFetcherCrossSegmentStorage(int segNo, int blocksPerSegment, int crossCheckBlocks, SplitFileFetcherStorage parent, FECCodec codec) {
        this.crossSegmentNumber = segNo;
        this.parent = parent;
        this.dataBlockCount = blocksPerSegment;
        this.crossCheckBlockCount = crossCheckBlocks;
        this.totalBlocks = this.dataBlockCount + crossCheckBlocks;
        int totalBlocks = this.dataBlockCount + crossCheckBlocks;
        this.codec = codec;
        this.segments = new SplitFileFetcherSegmentStorage[totalBlocks];
        this.blockNumbers = new int[totalBlocks];
        this.blocksFound = new boolean[totalBlocks];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFetchedRelevantBlock(SplitFileFetcherSegmentStorage segment, int blockNo) {
        short priorityClass = this.parent.getPriorityClass();
        SplitFileFetcherCrossSegmentStorage splitFileFetcherCrossSegmentStorage = this;
        synchronized (splitFileFetcherCrossSegmentStorage) {
            boolean found = false;
            for (int i = 0; i < this.segments.length; ++i) {
                if (this.segments[i] != segment || this.blockNumbers[i] != blockNo) continue;
                found = true;
                if (this.blocksFound[i]) {
                    return;
                }
                this.blocksFound[i] = true;
                ++this.totalFound;
            }
            if (this.tryDecode || this.succeeded || this.cancelled) {
                return;
            }
            if (!found) {
                Logger.warning(this, "Block " + blockNo + " on " + segment + " not wanted by " + this);
                return;
            }
            if (this.totalFound < this.dataBlockCount) {
                if (logMINOR) {
                    Logger.minor(this, "Not decoding " + this + " : found " + this.totalFound + " blocks of " + this.dataBlockCount + " (total " + this.segments.length + ")");
                }
                return;
            }
            this.tryDecodeOrEncode(priorityClass);
        }
    }

    private synchronized void tryDecodeOrEncode(final short prio) {
        if (this.succeeded) {
            return;
        }
        if (this.tryDecode) {
            return;
        }
        if (this.cancelled) {
            return;
        }
        long limit = (long)(this.totalBlocks * 32768) + Math.max(this.parent.fecCodec.maxMemoryOverheadDecode(this.dataBlockCount, this.crossCheckBlockCount), this.parent.fecCodec.maxMemoryOverheadEncode(this.dataBlockCount, this.crossCheckBlockCount));
        this.parent.memoryLimitedJobRunner.queueJob(new MemoryLimitedJob(limit){

            @Override
            public int getPriority() {
                return prio;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean start(MemoryLimitedChunk chunk) {
                boolean shutdown = false;
                PersistentJobRunner.CheckpointLock lock = null;
                try {
                    lock = SplitFileFetcherCrossSegmentStorage.this.parent.jobRunner.lock();
                    SplitFileFetcherCrossSegmentStorage.this.innerDecode(chunk);
                }
                catch (IOException e) {
                    Logger.error(this, "Failed to decode " + this + " because of disk error: " + e, (Throwable)e);
                    SplitFileFetcherCrossSegmentStorage.this.parent.failOnDiskError(e);
                }
                catch (PersistenceDisabledException e) {
                    shutdown = true;
                }
                finally {
                    block30: {
                        chunk.release();
                        try {
                            if (shutdown) break block30;
                            SplitFileFetcherCrossSegmentStorage e = SplitFileFetcherCrossSegmentStorage.this;
                            synchronized (e) {
                                SplitFileFetcherCrossSegmentStorage.this.tryDecode = false;
                            }
                            SplitFileFetcherCrossSegmentStorage.this.parent.finishedEncoding(SplitFileFetcherCrossSegmentStorage.this);
                        }
                        finally {
                            if (lock != null) {
                                lock.unlock(false, MemoryLimitedJobRunner.THREAD_PRIORITY);
                            }
                        }
                    }
                }
                return true;
            }
        });
        this.tryDecode = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerDecode(MemoryLimitedChunk chunk) throws IOException {
        int i;
        int realTotalCrossCheckBlocks;
        if (logMINOR) {
            Logger.minor(this, "Trying to decode " + this + " for " + this.parent);
        }
        boolean killed = false;
        SplitFileFetcherCrossSegmentStorage splitFileFetcherCrossSegmentStorage = this;
        synchronized (splitFileFetcherCrossSegmentStorage) {
            if (this.succeeded) {
                return;
            }
            if (this.cancelled) {
                killed = true;
            }
        }
        if (killed) {
            return;
        }
        byte[][] dataBlocks = this.readBlocks(false);
        byte[][] checkBlocks = this.readBlocks(true);
        if (dataBlocks == null || checkBlocks == null) {
            return;
        }
        boolean[] dataBlocksFound = SplitFileFetcherCrossSegmentStorage.wasNonNullFill(dataBlocks);
        boolean[] checkBlocksFound = SplitFileFetcherCrossSegmentStorage.wasNonNullFill(checkBlocks);
        int realTotalDataBlocks = SplitFileFetcherCrossSegmentStorage.count(dataBlocksFound);
        int realTotalFound = realTotalDataBlocks + (realTotalCrossCheckBlocks = SplitFileFetcherCrossSegmentStorage.count(checkBlocksFound));
        if (realTotalFound < this.dataBlockCount) {
            return;
        }
        boolean decoded = false;
        boolean encoded = false;
        if (realTotalDataBlocks < this.dataBlockCount) {
            this.codec.decode(dataBlocks, checkBlocks, dataBlocksFound, checkBlocksFound, 32768);
            for (i = 0; i < this.dataBlockCount; ++i) {
                if (dataBlocksFound[i]) continue;
                this.checkDecodedBlock(i, dataBlocks[i]);
                dataBlocksFound[i] = true;
            }
        }
        if (realTotalCrossCheckBlocks < this.crossCheckBlockCount) {
            this.codec.encode(dataBlocks, checkBlocks, checkBlocksFound, 32768);
            for (i = 0; i < this.crossCheckBlockCount; ++i) {
                if (checkBlocksFound[i]) continue;
                this.checkDecodedBlock(i + this.dataBlockCount, checkBlocks[i]);
            }
        }
        SplitFileFetcherCrossSegmentStorage splitFileFetcherCrossSegmentStorage2 = this;
        synchronized (splitFileFetcherCrossSegmentStorage2) {
            this.succeeded = true;
        }
        if (logMINOR) {
            Logger.minor(this, "Completed a cross-segment: decoded=" + decoded + " encoded=" + encoded);
        }
    }

    private void checkDecodedBlock(int i, byte[] data) {
        String decoded;
        ClientCHK key = this.getKey(i);
        if (key == null) {
            Logger.error(this, "Key not found");
            this.failOffThread(new FetchException(FetchException.FetchExceptionMode.INTERNAL_ERROR, "Key not found"));
            return;
        }
        ClientCHKBlock block = this.encodeBlock(key, data);
        String string = decoded = i >= this.dataBlockCount ? "Encoded" : "Decoded";
        if (block == null || !key.getNodeCHK().equals(block.getKey())) {
            Logger.error(this, decoded + " cross-segment block " + i + " failed!");
            this.failOffThread(new FetchException(FetchException.FetchExceptionMode.SPLITFILE_DECODE_ERROR, decoded + " cross-segment block does not match expected key"));
            return;
        }
        this.reportBlockToSegmentOffThread(i, key, block, data);
    }

    private ClientCHKBlock encodeBlock(ClientCHK key, byte[] data) {
        try {
            return ClientCHKBlock.encodeSplitfileBlock(data, key.getCryptoKey(), key.getCryptoAlgorithm());
        }
        catch (CHKEncodeException e) {
            return null;
        }
    }

    private void reportBlockToSegmentOffThread(final int blockNo, final ClientCHK key, final ClientCHKBlock block, final byte[] data) {
        this.parent.jobRunner.queueNormalOrDrop(new PersistentJob(){

            @Override
            public boolean run(ClientContext context) {
                try {
                    SplitFileSegmentKeys keys = SplitFileFetcherCrossSegmentStorage.this.segments[blockNo].getSegmentKeys();
                    if (keys == null) {
                        return false;
                    }
                    boolean success = SplitFileFetcherCrossSegmentStorage.this.segments[blockNo].innerOnGotKey(key.getNodeCHK(), block, keys, SplitFileFetcherCrossSegmentStorage.this.blockNumbers[blockNo], data);
                    if (success) {
                        if (logMINOR) {
                            Logger.minor(this, "Successfully decoded cross-segment block");
                        }
                    } else {
                        Logger.warning(this, "Decoded cross-segment block but not wanted by segment");
                    }
                }
                catch (IOException e) {
                    SplitFileFetcherCrossSegmentStorage.this.parent.failOnDiskError(e);
                    return true;
                }
                return false;
            }
        });
    }

    private void failOffThread(final FetchException e) {
        this.parent.jobRunner.queueNormalOrDrop(new PersistentJob(){

            @Override
            public boolean run(ClientContext context) {
                SplitFileFetcherCrossSegmentStorage.this.parent.fail(e);
                return true;
            }
        });
    }

    private void failDiskOffThread(final IOException e) {
        this.parent.jobRunner.queueNormalOrDrop(new PersistentJob(){

            @Override
            public boolean run(ClientContext context) {
                SplitFileFetcherCrossSegmentStorage.this.parent.failOnDiskError(e);
                return true;
            }
        });
    }

    private ClientCHK getKey(int i) {
        return this.segments[i].getKey(this.blockNumbers[i]);
    }

    private static boolean[] wasNonNullFill(byte[][] blocks) {
        boolean[] nonNulls = new boolean[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            if (blocks[i] == null) {
                blocks[i] = new byte[32768];
                continue;
            }
            nonNulls[i] = true;
        }
        return nonNulls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[][] readBlocks(boolean checkBlocks) {
        int start = checkBlocks ? this.dataBlockCount : 0;
        int end = checkBlocks ? this.totalBlocks : this.dataBlockCount;
        byte[][] blocks = new byte[end - start][];
        for (int i = start; i < end; ++i) {
            try {
                byte[] block = this.segments[i].checkAndGetBlockData(this.blockNumbers[i]);
                blocks[i - start] = block;
                SplitFileFetcherCrossSegmentStorage splitFileFetcherCrossSegmentStorage = this;
                synchronized (splitFileFetcherCrossSegmentStorage) {
                    if (block != null) {
                        if (!this.blocksFound[i]) {
                            ++this.totalFound;
                        }
                        this.blocksFound[i] = true;
                    } else {
                        if (this.blocksFound[i]) {
                            --this.totalFound;
                        }
                        this.blocksFound[i] = false;
                    }
                    continue;
                }
            }
            catch (IOException e) {
                this.failDiskOffThread(e);
                return null;
            }
        }
        return blocks;
    }

    private static int count(boolean[] array) {
        int total = 0;
        for (boolean b : array) {
            if (!b) continue;
            ++total;
        }
        return total;
    }

    public void addDataBlock(SplitFileFetcherSegmentStorage seg, int blockNum) {
        this.segments[this.counter] = seg;
        this.blockNumbers[this.counter] = blockNum;
        ++this.counter;
    }

    public synchronized boolean isDecoding() {
        return this.tryDecode;
    }

    public void writeFixedMetadata(DataOutputStream dos) throws IOException {
        dos.writeInt(this.dataBlockCount);
        dos.writeInt(this.crossCheckBlockCount);
        for (int i = 0; i < this.totalBlocks; ++i) {
            dos.writeInt(this.segments[i].segNo);
            dos.writeInt(this.blockNumbers[i]);
        }
    }

    public SplitFileFetcherCrossSegmentStorage(SplitFileFetcherStorage parent, int segNo, DataInputStream dis) throws IOException, StorageFormatException {
        this.parent = parent;
        this.crossSegmentNumber = segNo;
        this.codec = parent.fecCodec;
        this.dataBlockCount = dis.readInt();
        this.crossCheckBlockCount = dis.readInt();
        this.totalBlocks = this.dataBlockCount + this.crossCheckBlockCount;
        this.blocksFound = new boolean[this.totalBlocks];
        this.segments = new SplitFileFetcherSegmentStorage[this.totalBlocks];
        this.blockNumbers = new int[this.totalBlocks];
        for (int i = 0; i < this.totalBlocks; ++i) {
            SplitFileFetcherSegmentStorage segment;
            int readSeg = dis.readInt();
            if (readSeg < 0 || readSeg >= parent.segments.length) {
                throw new StorageFormatException("Invalid segment number " + readSeg);
            }
            this.segments[i] = segment = parent.segments[readSeg];
            int blockNo = dis.readInt();
            if (blockNo < 0 || blockNo >= segment.totalBlocks()) {
                throw new StorageFormatException("Invalid block number " + blockNo + " for segment " + segment.segNo);
            }
            this.blockNumbers[i] = blockNo;
            segment.resumeCallback(blockNo, this);
        }
    }

    public void checkBlocks() {
        for (int i = 0; i < this.totalBlocks; ++i) {
            if (!this.segments[i].hasBlock(this.blockNumbers[i])) continue;
            this.blocksFound[i] = true;
            ++this.totalFound;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        SplitFileFetcherCrossSegmentStorage splitFileFetcherCrossSegmentStorage = this;
        synchronized (splitFileFetcherCrossSegmentStorage) {
            if (this.succeeded) {
                return;
            }
        }
        short priorityClass = this.parent.getPriorityClass();
        SplitFileFetcherCrossSegmentStorage splitFileFetcherCrossSegmentStorage2 = this;
        synchronized (splitFileFetcherCrossSegmentStorage2) {
            if (this.totalBlocks < this.dataBlockCount) {
                return;
            }
            this.tryDecodeOrEncode(priorityClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        SplitFileFetcherCrossSegmentStorage splitFileFetcherCrossSegmentStorage = this;
        synchronized (splitFileFetcherCrossSegmentStorage) {
            this.cancelled = true;
            if (this.tryDecode) {
                return;
            }
            this.succeeded = true;
        }
        this.parent.finishedEncoding(this);
    }

    int[] getSegmentNumbers() {
        int[] ret = new int[this.totalBlocks];
        for (int i = 0; i < this.totalBlocks; ++i) {
            ret[i] = this.segments[i].segNo;
        }
        return ret;
    }

    int[] getBlockNumbers() {
        return (int[])this.blockNumbers.clone();
    }

    static {
        Logger.registerClass(SplitFileFetcherCrossSegmentStorage.class);
    }
}

