/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.async.ClientContext;
import freenet.client.async.USKCallback;
import freenet.client.async.USKProgressCallback;
import freenet.keys.USK;
import freenet.support.Logger;

public class USKSparseProxyCallback
implements USKProgressCallback {
    final USKCallback target;
    final USK key;
    private long lastEdition;
    private long lastSent;
    private boolean lastMetadata;
    private short lastCodec;
    private byte[] lastData;
    private boolean lastWasKnownGoodToo;
    private boolean roundFinished;
    private static volatile boolean logMINOR;

    public USKSparseProxyCallback(USKCallback cb, USK key) {
        this.target = cb;
        this.lastEdition = -1L;
        this.lastSent = -1L;
        this.key = key;
        if (logMINOR) {
            Logger.minor(this, "Creating sparse proxy callback " + this + " for " + cb + " for " + key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFoundEdition(long l, USK key, ClientContext context, boolean metadata, short codec, byte[] data, boolean newKnownGood, boolean newSlotToo) {
        USKSparseProxyCallback uSKSparseProxyCallback = this;
        synchronized (uSKSparseProxyCallback) {
            if (l < this.lastEdition) {
                if (!this.roundFinished) {
                    return;
                }
                if (!newKnownGood) {
                    return;
                }
            } else if (l == this.lastEdition) {
                if (newKnownGood) {
                    this.lastWasKnownGoodToo = true;
                }
            } else {
                this.lastEdition = l;
                this.lastMetadata = metadata;
                this.lastCodec = codec;
                this.lastData = data;
                this.lastWasKnownGoodToo = newKnownGood;
            }
            if (!this.roundFinished) {
                return;
            }
        }
        this.target.onFoundEdition(l, key, context, metadata, codec, data, newKnownGood, newSlotToo);
    }

    @Override
    public short getPollingPriorityNormal() {
        return this.target.getPollingPriorityNormal();
    }

    @Override
    public short getPollingPriorityProgress() {
        return this.target.getPollingPriorityProgress();
    }

    @Override
    public void onSendingToNetwork(ClientContext context) {
        this.innerRoundFinished(context, false);
    }

    @Override
    public void onRoundFinished(ClientContext context) {
        this.innerRoundFinished(context, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerRoundFinished(ClientContext context, boolean finishedRound) {
        boolean wasKnownGood;
        byte[] data;
        int codec;
        boolean meta;
        long ed;
        USKSparseProxyCallback uSKSparseProxyCallback = this;
        synchronized (uSKSparseProxyCallback) {
            if (finishedRound) {
                this.roundFinished = true;
            }
            if (this.lastSent == this.lastEdition) {
                return;
            }
            this.lastSent = ed = this.lastEdition;
            meta = this.lastMetadata;
            codec = this.lastCodec;
            data = this.lastData;
            wasKnownGood = this.lastWasKnownGoodToo;
        }
        if (ed == -1L) {
            ed = context.uskManager.lookupLatestSlot(this.key);
            if (ed == -1L) {
                return;
            }
            meta = false;
            codec = -1;
            data = null;
            wasKnownGood = false;
        }
        if (ed == -1L) {
            return;
        }
        this.target.onFoundEdition(ed, this.key, context, meta, (short)codec, data, wasKnownGood, wasKnownGood);
    }

    static {
        Logger.registerClass(USKSparseProxyCallback.class);
    }
}

