/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.CodecPacket;
import freenet.client.filter.CodecPacketFilter;
import freenet.client.filter.UnknownContentTypeException;
import freenet.support.Logger;
import freenet.support.PredicateUtil;
import freenet.support.io.BitInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.Predicate;

public class TheoraPacketFilter
implements CodecPacketFilter {
    static final byte[] magicNumber = new byte[]{116, 104, 101, 111, 114, 97};
    private Packet expectedPacket = Packet.IDENTIFICATION_HEADER;

    @Override
    public CodecPacket parse(CodecPacket packet) throws IOException {
        BitInputStream input = new BitInputStream(new ByteArrayInputStream(packet.payload));
        try {
            switch (this.expectedPacket) {
                case IDENTIFICATION_HEADER: {
                    Logger.minor(this, "IDENTIFICATION_HEADER");
                    this.verifyIdentificationHeader(input);
                    this.expectedPacket = Packet.COMMENT_HEADER;
                    break;
                }
                case COMMENT_HEADER: {
                    Logger.minor(this, "COMMENT_HEADER");
                    this.verifyTypeAndHeader("Comment", input, 129);
                    this.expectedPacket = Packet.SETUP_HEADER;
                    return this.constructCommentHeaderWithEmptyVendorStringAndComments();
                }
                case SETUP_HEADER: {
                    Logger.minor(this, "SETUP_HEADER");
                    this.verifySetupHeader(input);
                    this.expectedPacket = Packet.FRAME;
                    break;
                }
            }
        }
        catch (IOException e) {
            Logger.minor(this, "In Theora parser caught " + e, (Throwable)e);
            throw e;
        }
        return packet;
    }

    private void verifyIdentificationHeader(BitInputStream input) throws IOException {
        this.verifyTypeAndHeader("Identification", input, 128);
        this.checkHeaderField("Identification", "VMAJ", input, 8, PredicateUtil.not(v -> v != 3));
        this.checkHeaderField("Identification", "VMIN", input, 8, PredicateUtil.not(v -> v != 2));
        input.skip(8L);
        int FMBW = this.checkHeaderField("Identification", "FMBW", input, 16, v -> v > 0);
        int FMBH = this.checkHeaderField("Identification", "FMBH", input, 16, v -> v > 0);
        this.checkHeaderField("Identification", "PICW", input, 24, PredicateUtil.not(v -> v > FMBW * 16));
        this.checkHeaderField("Identification", "PICH", input, 24, PredicateUtil.not(v -> v > FMBH * 16));
        this.checkHeaderField("Identification", "PICX", input, 8, PredicateUtil.not(v -> v > FMBW * 16 - v));
        this.checkHeaderField("Identification", "PICY", input, 8, PredicateUtil.not(v -> v > FMBH * 16 - v));
        this.checkHeaderField("Identification", "FRN", input, 32, v -> v > 0);
        this.checkHeaderField("Identification", "FRD", input, 32, v -> v > 0);
        input.skip(48L);
        this.checkHeaderField("Identification", "CS", input, 8, v -> v == 0 || v == 1 || v == 2);
        input.skip(35L);
        this.checkHeaderField("Identification", "PF", input, 2, PredicateUtil.not(v -> v == 1));
        this.checkHeaderField("Identification", "Res", input, 3, PredicateUtil.not(v -> v != 0));
    }

    private void verifySetupHeader(BitInputStream input) throws IOException {
        int i;
        this.verifyTypeAndHeader("Setup", input, 130);
        int NBITS = input.readInt(3);
        for (i = 0; i < 64; ++i) {
            input.skip(NBITS);
        }
        NBITS = input.readInt(4) + 1;
        for (i = 0; i < 64; ++i) {
            input.skip(NBITS);
        }
        NBITS = input.readInt(4) + 1;
        for (i = 0; i < 64; ++i) {
            input.skip(NBITS);
        }
        int NBMS = this.checkHeaderField("Setup", "NBMS", input, 9, PredicateUtil.not(v -> v > 383)) + 1;
        int[][] BMS = new int[NBMS][64];
        for (int i2 = 0; i2 < BMS.length; ++i2) {
            for (int j = 0; j < BMS[i2].length; ++j) {
                BMS[i2][j] = input.readInt(8);
            }
        }
        for (int qti = 0; qti <= 1; ++qti) {
            for (int pli = 0; pli <= 2; ++pli) {
                int NEWQR = 1;
                if (qti > 0 || pli > 0) {
                    NEWQR = input.readBit();
                }
                int[][] NQRS = new int[2][3];
                int[][][] QRSIZES = new int[2][3][63];
                int[][][] QRBMIS = new int[2][3][64];
                if (NEWQR == 0) {
                    int plj;
                    int qtj;
                    int RPQR = 0;
                    if (qti > 0) {
                        RPQR = input.readBit();
                    }
                    if (RPQR == 1) {
                        qtj = qti - 1;
                        plj = pli;
                    } else {
                        qtj = (3 * qti + pli - 1) / 3;
                        plj = (pli + 2) % 3;
                    }
                    NQRS[qti][pli] = NQRS[qtj][plj];
                    QRSIZES[qti][pli] = QRSIZES[qtj][plj];
                    QRBMIS[qti][pli] = QRBMIS[qtj][plj];
                    continue;
                }
                if (NEWQR != 1) {
                    throw new UnknownContentTypeException("SetupHeader NEWQR: " + NEWQR + "(MUST be 0|1)");
                }
                int qri = 0;
                int qi = 0;
                QRBMIS[qti][pli][qri] = input.readInt(this.ilog(NBMS - 1));
                if (QRBMIS[qti][pli][qri] >= NBMS) {
                    throw new UnknownContentTypeException("SetupHeader (QRBMIS[qti][pli][qri]: " + QRBMIS[qti][pli][qri] + ") >= (NBMS: " + NBMS + ") The stream is undecodable.");
                }
                do {
                    QRSIZES[qti][pli][qri] = input.readInt(this.ilog(62 - qi)) + 1;
                    QRBMIS[qti][pli][++qri] = input.readInt(this.ilog(NBMS - 1));
                } while ((qi += QRSIZES[qti][pli][qri]) < 63);
                if (qi > 63) {
                    throw new UnknownContentTypeException("SetupHeader qi: " + qi + " > 63 The stream is undecodable.");
                }
                NQRS[qti][pli] = qri;
            }
        }
        int[][] HTS = new int[80][0];
        for (int hti = 0; hti < 80; ++hti) {
            HTS[hti] = this.readHuffmanTable(0, HTS[hti], input);
        }
        try {
            input.readBit();
            Logger.minor(this, "SETUP_HEADER contains redundant bits");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    private void verifyTypeAndHeader(String headerName, BitInputStream input, int expectedHeaderType) throws IOException {
        try {
            this.checkHeaderField(headerName, "type", input, 8, v -> v == expectedHeaderType);
        }
        catch (UnknownContentTypeException e) {
            throw new UnknownContentTypeException(e.getType() + "; expected: " + expectedHeaderType);
        }
        byte[] magicHeader = new byte[magicNumber.length];
        input.readFully(magicHeader);
        if (!Arrays.equals(magicNumber, magicHeader)) {
            throw new UnknownContentTypeException("Packet magicHeader: " + Arrays.toString(magicHeader) + "; expected: " + Arrays.toString(magicNumber));
        }
    }

    private int checkHeaderField(String headerName, String fieldName, BitInputStream input, int sizeInBits, Predicate<Integer> validator) throws IOException {
        int value = input.readInt(sizeInBits);
        if (!validator.test(value)) {
            throw new UnknownContentTypeException(headerName + "Header " + fieldName + ": " + value);
        }
        return value;
    }

    private CodecPacket constructCommentHeaderWithEmptyVendorStringAndComments() {
        byte[] emptyCommentHeader = new byte[magicNumber.length + 9];
        emptyCommentHeader[0] = -127;
        System.arraycopy(magicNumber, 0, emptyCommentHeader, 1, magicNumber.length);
        return new CodecPacket(emptyCommentHeader);
    }

    private int ilog(int a) {
        if (a <= 0) {
            return 0;
        }
        return 32 - Integer.numberOfLeadingZeros(a);
    }

    private int[] readHuffmanTable(int HBITSLength, int[] HTS, BitInputStream input) throws IOException {
        if (HBITSLength > 32) {
            throw new UnknownContentTypeException("HBITS.length = " + HBITSLength + "; HBITS is longer than 32 bits in length - The stream is undecodable.");
        }
        int ISLEAF = input.readBit();
        if (ISLEAF == 1) {
            if (HTS.length == 32) {
                throw new UnknownContentTypeException("HTS[hti] = " + Arrays.toString(HTS) + "; HTS[hti] is already 32 - The stream is undecodable.");
            }
            int TOKEN = input.readInt(5);
            HTS = Arrays.copyOf(HTS, HTS.length + 1);
            HTS[HTS.length - 1] = TOKEN;
        } else {
            int subTreeHbitsLength = HBITSLength + 1;
            this.readHuffmanTable(subTreeHbitsLength, HTS, input);
            this.readHuffmanTable(subTreeHbitsLength, HTS, input);
        }
        return HTS;
    }

    static enum Packet {
        IDENTIFICATION_HEADER,
        COMMENT_HEADER,
        SETUP_HEADER,
        FRAME;

    }
}

