/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.updateableelements;

import freenet.client.FetchContext;
import freenet.clients.http.FProxyFetchInProgress;
import freenet.clients.http.FProxyFetchResult;
import freenet.clients.http.FProxyFetchTracker;
import freenet.clients.http.FProxyFetchWaiter;
import freenet.clients.http.FProxyToadlet;
import freenet.clients.http.SimpleToadletServer;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.complexhtmlnodes.SecondCounterNode;
import freenet.clients.http.updateableelements.BaseUpdateableElement;
import freenet.clients.http.updateableelements.NotifierFetchListener;
import freenet.keys.FreenetURI;
import freenet.support.Base64;
import freenet.support.HTMLNode;
import freenet.support.SizeUtil;

public class ProgressInfoElement
extends BaseUpdateableElement {
    private FProxyFetchTracker tracker;
    private final FreenetURI key;
    private final FetchContext fctx;
    private long maxSize;
    private NotifierFetchListener fetchListener;
    private boolean isAdvancedMode;

    public ProgressInfoElement(FProxyFetchTracker tracker, FreenetURI key, FetchContext fctx, long maxSize, boolean isAdvancedMode, ToadletContext ctx, boolean pushed) {
        super("span", ctx);
        this.tracker = tracker;
        this.key = key;
        this.fctx = fctx;
        this.maxSize = maxSize;
        this.isAdvancedMode = isAdvancedMode;
        this.init(pushed);
        if (!pushed) {
            return;
        }
        this.fetchListener = new NotifierFetchListener(((SimpleToadletServer)ctx.getContainer()).getPushDataManager(), this);
        tracker.getFetchInProgress(key, maxSize, fctx).addListener(this.fetchListener);
    }

    @Override
    public void updateState(boolean initial) {
        FProxyFetchResult fr;
        this.children.clear();
        FProxyFetchWaiter waiter = this.tracker.makeWaiterForFetchInProgress(this.key, this.maxSize, this.fctx);
        FProxyFetchResult fProxyFetchResult = fr = waiter == null ? null : waiter.getResult();
        if (fr == null) {
            this.addChild("div", "No fetcher found");
            return;
        }
        this.addChild("#", FProxyToadlet.l10n("filenameLabel") + " ");
        this.addChild("a", "href", "/" + this.key.toString(false, false), this.key.getPreferredFilename());
        if (fr.mimeType != null) {
            this.addChild("br", FProxyToadlet.l10n("contentTypeLabel") + " " + fr.mimeType);
        }
        if (fr.size > 0L) {
            this.addChild("br", "Size: " + SizeUtil.formatSize(fr.size));
        }
        if (this.isAdvancedMode) {
            this.addChild("br", FProxyToadlet.l10n("blocksDetail", new String[]{"fetched", "required", "total", "failed", "fatallyfailed"}, new String[]{Integer.toString(fr.fetchedBlocks), Integer.toString(fr.requiredBlocks), Integer.toString(fr.totalBlocks), Integer.toString(fr.failedBlocks), Integer.toString(fr.fatallyFailedBlocks)}));
        }
        long elapsed = System.currentTimeMillis() - fr.timeStarted;
        this.addChild("br");
        this.addChild(new SecondCounterNode(elapsed, true, FProxyToadlet.l10n("timeElapsedLabel") + " "));
        long eta = fr.eta - elapsed;
        if (eta > 0L) {
            this.addChild("br");
            this.addChild(new SecondCounterNode(eta, false, "ETA: "));
        }
        if (this.ctx.getContainer().isFProxyJavascriptEnabled()) {
            HTMLNode lastRefreshNode = new HTMLNode("span", "class", "jsonly");
            lastRefreshNode.addChild("br");
            lastRefreshNode.addChild(new SecondCounterNode(0L, true, FProxyToadlet.l10n("lastRefresh")));
            this.addChild(lastRefreshNode);
        }
        if (fr.goneToNetwork) {
            this.addChild("p", FProxyToadlet.l10n("progressDownloading"));
        } else {
            this.addChild("p", FProxyToadlet.l10n("progressCheckingStore"));
        }
        if (!fr.finalizedBlocks) {
            this.addChild("p", FProxyToadlet.l10n("progressNotFinalized"));
        }
        if (waiter != null) {
            this.tracker.getFetchInProgress(this.key, this.maxSize, this.fctx).close(waiter);
        }
        if (fr != null) {
            this.tracker.getFetchInProgress(this.key, this.maxSize, this.fctx).close(fr);
        }
    }

    @Override
    public String getUpdaterId(String requestId) {
        return ProgressInfoElement.getId(this.key);
    }

    public static String getId(FreenetURI uri) {
        return Base64.encodeStandardUTF8("progressinfo[URI:" + uri.toString() + "]");
    }

    @Override
    public void dispose() {
        FProxyFetchInProgress progress = this.tracker.getFetchInProgress(this.key, this.maxSize, this.fctx);
        if (progress != null) {
            progress.removeListener(this.fetchListener);
        }
    }

    @Override
    public String getUpdaterType() {
        return "ReplacerUpdater";
    }

    public String toString() {
        return "ProgressInfoElement[key:" + this.key + ",maxSize:" + this.maxSize + ",updaterId:" + this.getUpdaterId(null) + "]";
    }
}

