/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.HashResult;
import freenet.crypt.HashType;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

final class MultiHashDigester {
    private final Collection<Digester> digesters;

    private MultiHashDigester(Collection<Digester> digesters) {
        this.digesters = digesters;
    }

    void update(byte[] input, int offset, int len) {
        this.digesters.forEach(digester -> digester.update(input, offset, len));
    }

    List<HashResult> getResults() {
        return this.digesters.stream().map(Digester::getResult).collect(Collectors.toList());
    }

    static MultiHashDigester fromBitmask(long bitmask) {
        List<Digester> digesters = Arrays.stream(HashType.values()).filter(hashType -> (bitmask & (long)hashType.bitmask) == (long)hashType.bitmask).map(Digester::new).collect(Collectors.toList());
        return new MultiHashDigester(digesters);
    }

    private static class Digester {
        private final HashType hashType;
        private final MessageDigest digest;

        Digester(HashType hashType) {
            this.hashType = hashType;
            this.digest = hashType.get();
        }

        HashResult getResult() {
            return new HashResult(this.hashType, this.digest.digest());
        }

        void update(byte[] input, int offset, int len) {
            this.digest.update(input, offset, len);
        }
    }
}

