/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.crypt.DSAPublicKey;
import freenet.node.Node;
import freenet.store.BlockMetadata;
import freenet.store.GetPubkey;
import freenet.store.PubkeyStore;
import freenet.support.ByteArrayWrapper;
import freenet.support.HexUtil;
import freenet.support.LRUMap;
import freenet.support.Logger;
import java.io.IOException;

public class NodeGetPubkey
implements GetPubkey {
    private static volatile boolean logMINOR;
    private static final boolean USE_RAM_PUBKEYS_CACHE = true;
    private static final int MAX_MEMORY_CACHED_PUBKEYS = 1000;
    private final LRUMap<ByteArrayWrapper, DSAPublicKey> cachedPubKeys = LRUMap.createSafeMap(ByteArrayWrapper.FAST_COMPARATOR);
    private PubkeyStore pubKeyDatastore;
    private PubkeyStore pubKeyDatacache;
    private PubkeyStore pubKeyClientcache;
    private PubkeyStore pubKeySlashdotcache;
    private final Node node;

    NodeGetPubkey(Node node) {
        this.node = node;
    }

    void setDataStore(PubkeyStore pubKeyDatastore, PubkeyStore pubKeyDatacache) {
        this.pubKeyDatastore = pubKeyDatastore;
        this.pubKeyDatacache = pubKeyDatacache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DSAPublicKey getKey(byte[] hash, boolean canReadClientCache, boolean forULPR, BlockMetadata meta) {
        boolean ignoreOldBlocks;
        boolean bl = ignoreOldBlocks = !this.node.getWriteLocalToDatastore();
        if (canReadClientCache) {
            ignoreOldBlocks = false;
        }
        ByteArrayWrapper w = new ByteArrayWrapper(hash);
        if (logMINOR) {
            Logger.minor(this, "Getting pubkey: " + HexUtil.bytesToHex(hash));
        }
        LRUMap<ByteArrayWrapper, DSAPublicKey> lRUMap = this.cachedPubKeys;
        synchronized (lRUMap) {
            DSAPublicKey key = this.cachedPubKeys.get(w);
            if (key != null) {
                this.cachedPubKeys.push(w, key);
                if (logMINOR) {
                    Logger.minor(this, "Got " + HexUtil.bytesToHex(hash) + " from in-memory cache");
                }
                return key;
            }
        }
        try {
            PubkeyStore pks;
            DSAPublicKey key = null;
            if (this.pubKeyClientcache != null && canReadClientCache) {
                key = this.pubKeyClientcache.fetch(hash, false, false, meta);
            }
            if (this.node.getOldPKClientCache() != null && canReadClientCache && key == null) {
                pks = this.node.getOldPKClientCache();
                if (pks != null) {
                    key = pks.fetch(hash, false, false, meta);
                }
                if (key != null && logMINOR) {
                    Logger.minor(this, "Got " + HexUtil.bytesToHex(hash) + " from old client cache");
                }
            }
            if (key == null && (key = this.pubKeyDatastore.fetch(hash, false, ignoreOldBlocks, meta)) != null && logMINOR) {
                Logger.minor(this, "Got " + HexUtil.bytesToHex(hash) + " from store");
            }
            if (key == null) {
                pks = this.node.getOldPK();
                if (pks != null) {
                    key = pks.fetch(hash, false, ignoreOldBlocks, meta);
                }
                if (key != null && logMINOR) {
                    Logger.minor(this, "Got " + HexUtil.bytesToHex(hash) + " from old store");
                }
            }
            if (key == null && (key = this.pubKeyDatacache.fetch(hash, false, ignoreOldBlocks, meta)) != null && logMINOR) {
                Logger.minor(this, "Got " + HexUtil.bytesToHex(hash) + " from cache");
            }
            if (key == null) {
                pks = this.node.getOldPKCache();
                if (pks != null) {
                    key = pks.fetch(hash, false, ignoreOldBlocks, meta);
                }
                if (key != null && logMINOR) {
                    Logger.minor(this, "Got " + HexUtil.bytesToHex(hash) + " from old cache");
                }
            }
            if (key == null && this.pubKeySlashdotcache != null && forULPR) {
                key = this.pubKeySlashdotcache.fetch(hash, false, ignoreOldBlocks, meta);
                if (logMINOR) {
                    Logger.minor(this, "Got " + HexUtil.bytesToHex(hash) + " from slashdot cache");
                }
            }
            if (key != null) {
                this.cacheKey(hash, key, false, false, false, false, false);
            }
            return key;
        }
        catch (IOException e) {
            Logger.error(this, "Error accessing pubkey store: " + e, (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheKey(byte[] hash, DSAPublicKey key, boolean deep, boolean canWriteClientCache, boolean canWriteDatastore, boolean forULPR, boolean writeLocalToDatastore) {
        if (logMINOR) {
            Logger.minor(this, "Cache key: " + HexUtil.bytesToHex(hash) + " : " + key);
        }
        ByteArrayWrapper w = new ByteArrayWrapper(hash);
        LRUMap<ByteArrayWrapper, DSAPublicKey> lRUMap = this.cachedPubKeys;
        synchronized (lRUMap) {
            DSAPublicKey key2 = this.cachedPubKeys.get(w);
            if (key2 != null && !key2.equals(key)) {
                throw new IllegalArgumentException("Wrong hash?? Already have different key with same hash!");
            }
            this.cachedPubKeys.push(w, key);
            while (this.cachedPubKeys.size() > 1000) {
                this.cachedPubKeys.popKey();
            }
        }
        try {
            if (canWriteClientCache && !canWriteDatastore && !writeLocalToDatastore && this.pubKeyClientcache != null) {
                this.pubKeyClientcache.put(hash, key, false);
            }
            if (forULPR && !canWriteDatastore && !writeLocalToDatastore && this.pubKeySlashdotcache != null) {
                this.pubKeySlashdotcache.put(hash, key, false);
            }
            if (!canWriteDatastore && !writeLocalToDatastore) {
                return;
            }
            if (deep) {
                this.pubKeyDatastore.put(hash, key, !canWriteDatastore);
            }
            this.pubKeyDatacache.put(hash, key, !canWriteDatastore);
        }
        catch (IOException e) {
            Logger.error(this, "Error accessing pubkey store: " + e, (Throwable)e);
        }
    }

    public void setLocalDataStore(PubkeyStore pubKeyClientcache) {
        this.pubKeyClientcache = pubKeyClientcache;
    }

    public void setLocalSlashdotcache(PubkeyStore pubKeySlashdotcache) {
        this.pubKeySlashdotcache = pubKeySlashdotcache;
    }

    static {
        Logger.registerClass(NodeGetPubkey.class);
    }
}

