/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.client.async.ClientContext;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.BaseFileBucket;
import freenet.support.io.FilenameGenerator;
import freenet.support.io.ResumeFailedException;
import freenet.support.io.StorageFormatException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public class TempFileBucket
extends BaseFileBucket
implements Bucket,
Serializable {
    private static final long serialVersionUID = 1L;
    long filenameID;
    protected transient FilenameGenerator generator;
    private boolean readOnly;
    private final boolean deleteOnFree;
    private File file;
    private transient boolean resumed;
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    static final int VERSION = 1;

    public TempFileBucket(long id, FilenameGenerator generator) {
        this(id, generator, true);
        this.file = generator.getFilename(id);
    }

    protected TempFileBucket(long id, FilenameGenerator generator, boolean deleteOnFree) {
        super(generator.getFilename(id), false);
        this.filenameID = id;
        this.generator = generator;
        this.deleteOnFree = deleteOnFree;
        this.file = generator.getFilename(id);
        if (logDEBUG) {
            Logger.debug(this, "Initializing TempFileBucket(" + this.getFile());
        }
    }

    protected TempFileBucket() {
        this.deleteOnFree = false;
    }

    @Override
    protected boolean createFileOnly() {
        return false;
    }

    @Override
    protected boolean deleteOnFree() {
        return this.deleteOnFree;
    }

    @Override
    public File getFile() {
        if (this.file != null) {
            return this.file;
        }
        return this.generator.getFilename(this.filenameID);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly() {
        this.readOnly = true;
    }

    @Override
    protected boolean deleteOnExit() {
        return false;
    }

    @Override
    public RandomAccessBucket createShadow() {
        TempFileBucket ret = new TempFileBucket(this.filenameID, this.generator, false);
        ret.setReadOnly();
        if (!this.getFile().exists()) {
            Logger.error(this, "File does not exist when creating shadow: " + this.getFile());
        }
        return ret;
    }

    protected void innerResume(ClientContext context) throws ResumeFailedException {
        this.generator = context.persistentFG;
        if (this.file == null) {
            this.file = this.generator.getFilename(this.filenameID);
            this.checkExists(this.file);
        } else {
            File f;
            if (!this.file.exists() && (f = this.generator.getFilename(this.filenameID)).exists()) {
                this.file = f;
            }
            this.checkExists(this.file);
            this.file = this.generator.maybeMove(this.file, this.filenameID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onResume(ClientContext context) throws ResumeFailedException {
        if (!this.persistent()) {
            throw new UnsupportedOperationException();
        }
        TempFileBucket tempFileBucket = this;
        synchronized (tempFileBucket) {
            if (this.resumed) {
                return;
            }
            this.resumed = true;
        }
        super.onResume(context);
        this.innerResume(context);
    }

    private void checkExists(File file) throws ResumeFailedException {
        try {
            if (!file.createNewFile() && !file.exists()) {
                throw new ResumeFailedException("Tempfile " + file + " does not exist and cannot be created");
            }
        }
        catch (IOException e) {
            throw new ResumeFailedException("Tempfile cannot be created");
        }
    }

    protected boolean persistent() {
        return false;
    }

    @Override
    protected boolean tempFileAlreadyExists() {
        return true;
    }

    @Override
    public void storeTo(DataOutputStream dos) throws IOException {
        dos.writeInt(this.magic());
        super.storeTo(dos);
        dos.writeInt(1);
        dos.writeLong(this.filenameID);
        dos.writeBoolean(this.readOnly);
        dos.writeBoolean(this.deleteOnFree);
        dos.writeUTF(this.file.toString());
    }

    protected int magic() {
        throw new UnsupportedOperationException();
    }

    protected TempFileBucket(DataInputStream dis) throws IOException, StorageFormatException {
        super(dis);
        int version = dis.readInt();
        if (version != 1) {
            throw new StorageFormatException("Bad version");
        }
        this.filenameID = dis.readLong();
        if (this.filenameID == -1L) {
            throw new StorageFormatException("Bad filename ID");
        }
        this.readOnly = dis.readBoolean();
        this.deleteOnFree = dis.readBoolean();
        this.file = new File(dis.readUTF());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.deleteOnFree ? 1231 : 1237);
        result = 31 * result + (int)(this.filenameID ^ this.filenameID >>> 32);
        result = 31 * result + (this.readOnly ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TempFileBucket other = (TempFileBucket)obj;
        if (this.deleteOnFree != other.deleteOnFree) {
            return false;
        }
        if (this.filenameID != other.filenameID) {
            return false;
        }
        return this.readOnly == other.readOnly;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
    }
}

