/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.activation;

import com.db4o.internal.ClassMetadata;
import com.db4o.internal.activation.ActivationDepth;
import com.db4o.internal.activation.ActivationDepthProvider;
import com.db4o.internal.activation.ActivationMode;
import com.db4o.internal.activation.DescendingActivationDepth;
import com.db4o.internal.activation.FixedActivationDepth;
import com.db4o.internal.activation.FullActivationDepth;
import com.db4o.internal.activation.NonDescendingActivationDepth;
import com.db4o.reflect.generic.GenericReflector;
import com.db4o.ta.Activatable;

public class TransparentActivationDepthProvider
implements ActivationDepthProvider {
    @Override
    public ActivationDepth activationDepth(int depth, ActivationMode mode) {
        if (Integer.MAX_VALUE == depth) {
            return new FullActivationDepth(mode);
        }
        return new FixedActivationDepth(depth, mode);
    }

    @Override
    public ActivationDepth activationDepthFor(ClassMetadata classMetadata, ActivationMode mode) {
        if (this.isTAAware(classMetadata)) {
            return new NonDescendingActivationDepth(mode);
        }
        if (mode.isPrefetch()) {
            return new FixedActivationDepth(classMetadata.prefetchActivationDepth(), mode);
        }
        return new DescendingActivationDepth(this, mode);
    }

    private boolean isTAAware(ClassMetadata classMetadata) {
        GenericReflector reflector = classMetadata.reflector();
        return reflector.forClass(Activatable.class).isAssignableFrom(classMetadata.classReflector());
    }
}

