/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.recovery;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.cleaner.RecoveryUtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.log.CheckpointFileReader;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.INFileReader;
import com.sleepycat.je.log.LNFileReader;
import com.sleepycat.je.log.LastFileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.recovery.CheckpointEnd;
import com.sleepycat.je.recovery.LevelRecorder;
import com.sleepycat.je.recovery.NoRootException;
import com.sleepycat.je.recovery.RecoveryException;
import com.sleepycat.je.recovery.RecoveryInfo;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.TrackingInfo;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.PreparedTxn;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.Tracer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecoveryManager {
    private static final String TRACE_DUP_ROOT_REPLACE = "DupRootRecover:";
    private static final String TRACE_LN_REDO = "LNRedo:";
    private static final String TRACE_LN_UNDO = "LNUndo";
    private static final String TRACE_IN_REPLACE = "INRecover:";
    private static final String TRACE_ROOT_REPLACE = "RootRecover:";
    private static final String TRACE_IN_DEL_REPLAY = "INDelReplay:";
    private static final String TRACE_IN_DUPDEL_REPLAY = "INDupDelReplay:";
    private static final String TRACE_ROOT_DELETE = "RootDelete:";
    private EnvironmentImpl env;
    private int readBufferSize;
    private RecoveryInfo info;
    private Map<Long, Long> committedTxnIds;
    private Set<Long> abortedTxnIds;
    private Map<Long, Txn> preparedTxns;
    private Set<DatabaseId> inListBuildDbIds;
    private Set<DatabaseId> tempDbIds;
    private Level detailedTraceLevel;
    private RecoveryUtilizationTracker tracker;

    public RecoveryManager(EnvironmentImpl env) throws DatabaseException {
        this.env = env;
        DbConfigManager cm = env.getConfigManager();
        this.readBufferSize = cm.getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        this.committedTxnIds = new HashMap<Long, Long>();
        this.abortedTxnIds = new HashSet<Long>();
        this.preparedTxns = new HashMap<Long, Txn>();
        this.inListBuildDbIds = new HashSet<DatabaseId>();
        this.tempDbIds = new HashSet<DatabaseId>();
        this.tracker = new RecoveryUtilizationTracker(env);
        this.detailedTraceLevel = Tracer.parseLevel(env, EnvironmentParams.JE_LOGGING_LEVEL_RECOVERY);
    }

    public RecoveryInfo recover(boolean readOnly, boolean replicationIntended) throws DatabaseException {
        this.info = new RecoveryInfo();
        try {
            block10: {
                try {
                    FileManager fileManager = this.env.getFileManager();
                    DbConfigManager configManager = this.env.getConfigManager();
                    boolean forceCheckpoint = configManager.getBoolean(EnvironmentParams.ENV_RECOVERY_FORCE_CHECKPOINT);
                    if (fileManager.filesExist()) {
                        this.findEndOfLog(readOnly);
                        Tracer.trace(Level.CONFIG, this.env, "Recovery underway, found end of log");
                        this.findLastCheckpoint();
                        this.env.getLogManager().setLastLsnAtRecovery(fileManager.getLastUsedLsn());
                        Tracer.trace(Level.CONFIG, this.env, "Recovery checkpoint search, " + this.info);
                        this.env.readMapTreeFromLog(this.info.useRootLsn, replicationIntended);
                        this.buildTree();
                    } else {
                        this.env.enableDebugLoggingToDbLog();
                        Tracer.trace(Level.CONFIG, this.env, "Recovery w/no files.");
                        this.env.getInMemoryINs().enable();
                        this.env.logMapTreeRoot();
                        if (this.env.getSharedCache()) {
                            this.env.getEvictor().addEnvironment(this.env);
                        }
                        forceCheckpoint = true;
                    }
                    int ptSize = this.preparedTxns.size();
                    if (ptSize > 0) {
                        boolean singular = ptSize == 1;
                        Tracer.trace(Level.INFO, this.env, "There " + (singular ? "is " : "are ") + ptSize + " prepared but unfinished " + (singular ? "txn." : "txns."));
                        this.preparedTxns = null;
                    }
                    if (DbInternal.getCreateUP(this.env.getConfigManager().getEnvironmentConfig())) {
                        this.env.getUtilizationProfile().populateCache();
                    }
                    this.tracker.transferToUtilizationTracker(this.env.getUtilizationTracker());
                    this.removeTempDbs();
                    if (!readOnly && (this.env.getLogManager().getLastLsnAtRecovery() != this.info.checkpointEndLsn || forceCheckpoint)) {
                        CheckpointConfig config = new CheckpointConfig();
                        config.setForce(true);
                        config.setMinimizeRecoveryTime(true);
                        this.env.invokeCheckpoint(config, false, "recovery");
                        break block10;
                    }
                    this.env.getCheckpointer().initIntervals(this.info.checkpointEndLsn, System.currentTimeMillis());
                }
                catch (IOException e) {
                    Tracer.trace(this.env, "RecoveryManager", "recover", "Couldn't recover", e);
                    throw new RecoveryException(this.env, "Couldn't recover: " + e.getMessage(), e);
                }
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            Tracer.trace(Level.CONFIG, this.env, "Recovery finished: " + this.info);
            throw throwable;
        }
        Tracer.trace(Level.CONFIG, this.env, "Recovery finished: " + this.info);
        return this.info;
    }

    private void findEndOfLog(boolean readOnly) throws IOException, DatabaseException {
        LastFileReader reader = new LastFileReader(this.env, this.readBufferSize);
        while (reader.readNextEntry()) {
            LogEntryType type = reader.getEntryType();
            if (LogEntryType.LOG_CKPT_END.equals(type)) {
                this.info.checkpointEndLsn = reader.getLastLsn();
                this.info.partialCheckpointStartLsn = -1L;
                continue;
            }
            if (LogEntryType.LOG_CKPT_START.equals(type)) {
                if (this.info.partialCheckpointStartLsn != -1L) continue;
                this.info.partialCheckpointStartLsn = reader.getLastLsn();
                continue;
            }
            if (!LogEntryType.LOG_ROOT.equals(type)) continue;
            this.info.useRootLsn = reader.getLastLsn();
        }
        assert (reader.getLastValidLsn() != reader.getEndOfLog()) : "lastUsed=" + DbLsn.getNoFormatString(reader.getLastValidLsn()) + " end=" + DbLsn.getNoFormatString(reader.getEndOfLog());
        if (!readOnly) {
            reader.setEndOfFile();
        }
        this.info.lastUsedLsn = reader.getLastValidLsn();
        this.info.nextAvailableLsn = reader.getEndOfLog();
        this.info.nRepeatIteratorReads = (int)((long)this.info.nRepeatIteratorReads + reader.getNRepeatIteratorReads());
        this.env.getFileManager().setLastPosition(this.info.nextAvailableLsn, this.info.lastUsedLsn, reader.getPrevOffset());
        this.env.enableDebugLoggingToDbLog();
    }

    private void findLastCheckpoint() throws IOException, DatabaseException {
        if (this.info.checkpointEndLsn == -1L) {
            CheckpointFileReader searcher = new CheckpointFileReader(this.env, this.readBufferSize, false, this.info.lastUsedLsn, -1L, this.info.nextAvailableLsn);
            while (searcher.readNextEntry()) {
                if (searcher.isCheckpointEnd()) {
                    this.info.checkpointEndLsn = searcher.getLastLsn();
                    break;
                }
                if (searcher.isCheckpointStart()) {
                    this.info.partialCheckpointStartLsn = searcher.getLastLsn();
                    continue;
                }
                if (!searcher.isRoot() || this.info.useRootLsn != -1L) continue;
                this.info.useRootLsn = searcher.getLastLsn();
            }
            this.info.nRepeatIteratorReads = (int)((long)this.info.nRepeatIteratorReads + searcher.getNRepeatIteratorReads());
        }
        if (this.info.checkpointEndLsn == -1L) {
            this.info.checkpointStartLsn = -1L;
            this.info.firstActiveLsn = -1L;
        } else {
            CheckpointEnd checkpointEnd;
            this.info.checkpointEnd = checkpointEnd = (CheckpointEnd)this.env.getLogManager().get(this.info.checkpointEndLsn);
            this.info.checkpointStartLsn = checkpointEnd.getCheckpointStartLsn();
            this.info.firstActiveLsn = checkpointEnd.getFirstActiveLsn();
            if (checkpointEnd.getRootLsn() != -1L && this.info.useRootLsn == -1L) {
                this.info.useRootLsn = checkpointEnd.getRootLsn();
            }
            this.env.getCheckpointer().setCheckpointId(checkpointEnd.getId());
        }
        if (this.info.useRootLsn == -1L) {
            throw new NoRootException(this.env, "This environment's log file has no root. Since the root is the first entry written into a log at environment creation, this should only happen if the initial creation of the environment was never checkpointed or synced. Please move aside the existing log files to allow the creation of a new environment");
        }
    }

    private void buildTree() throws IOException, DatabaseException {
        int passNum = this.buildINs(1, true, false);
        Tracer.trace(Level.CONFIG, this.env, this.passStartHeader(passNum) + "undo map LNs");
        long start = System.currentTimeMillis();
        HashSet<LogEntryType> mapLNSet = new HashSet<LogEntryType>();
        mapLNSet.add(LogEntryType.LOG_MAPLN_TRANSACTIONAL);
        mapLNSet.add(LogEntryType.LOG_TXN_COMMIT);
        mapLNSet.add(LogEntryType.LOG_TXN_ABORT);
        mapLNSet.add(LogEntryType.LOG_TXN_PREPARE);
        this.undoLNs(this.info, mapLNSet);
        long end = System.currentTimeMillis();
        Tracer.trace(Level.CONFIG, this.env, this.passEndHeader(passNum, start, end) + this.info.toString());
        Tracer.trace(Level.CONFIG, this.env, this.passStartHeader(++passNum) + "redo map LNs");
        start = System.currentTimeMillis();
        mapLNSet.add(LogEntryType.LOG_MAPLN);
        this.redoLNs(this.info, mapLNSet);
        end = System.currentTimeMillis();
        Tracer.trace(Level.CONFIG, this.env, this.passEndHeader(passNum, start, end) + this.info.toString());
        ++passNum;
        passNum = this.buildINs(passNum, false, false);
        passNum = this.buildINs(passNum, false, true);
        this.buildINList();
        if (this.env.getSharedCache()) {
            this.env.getEvictor().addEnvironment(this.env);
        }
        this.env.invokeEvictor();
        Tracer.trace(Level.CONFIG, this.env, this.passStartHeader(9) + "undo LNs");
        start = System.currentTimeMillis();
        HashSet<LogEntryType> lnSet = new HashSet<LogEntryType>();
        lnSet.add(LogEntryType.LOG_LN_TRANSACTIONAL);
        lnSet.add(LogEntryType.LOG_NAMELN_TRANSACTIONAL);
        lnSet.add(LogEntryType.LOG_DEL_DUPLN_TRANSACTIONAL);
        lnSet.add(LogEntryType.LOG_DUPCOUNTLN_TRANSACTIONAL);
        this.undoLNs(this.info, lnSet);
        end = System.currentTimeMillis();
        Tracer.trace(Level.CONFIG, this.env, this.passEndHeader(9, start, end) + this.info.toString());
        Tracer.trace(Level.CONFIG, this.env, this.passStartHeader(10) + "redo LNs");
        start = System.currentTimeMillis();
        lnSet.add(LogEntryType.LOG_LN);
        lnSet.add(LogEntryType.LOG_NAMELN);
        lnSet.add(LogEntryType.LOG_DEL_DUPLN);
        lnSet.add(LogEntryType.LOG_DUPCOUNTLN);
        lnSet.add(LogEntryType.LOG_FILESUMMARYLN);
        this.redoLNs(this.info, lnSet);
        end = System.currentTimeMillis();
        Tracer.trace(Level.CONFIG, this.env, this.passEndHeader(10, start, end) + this.info.toString());
    }

    private int buildINs(int passNum, boolean mappingTree, boolean dupTree) throws IOException, DatabaseException {
        HashSet<LogEntryType> targetEntries = new HashSet<LogEntryType>();
        HashSet<LogEntryType> deltaType = new HashSet<LogEntryType>();
        String passADesc = null;
        String passBDesc = null;
        String passCDesc = null;
        if (mappingTree) {
            passADesc = "read mapping INs";
            passBDesc = "redo mapping INs";
            passCDesc = "read mapping BINDeltas";
        } else if (dupTree) {
            passADesc = "read dup INs";
            passBDesc = "redo dup INs";
            passCDesc = "read dup BINDeltas";
        } else {
            passADesc = "read main INs";
            passBDesc = "redo main INs";
            passCDesc = "read main BINDeltas";
        }
        if (dupTree) {
            targetEntries.add(LogEntryType.LOG_DIN);
            targetEntries.add(LogEntryType.LOG_DBIN);
            targetEntries.add(LogEntryType.LOG_IN_DUPDELETE_INFO);
            deltaType.add(LogEntryType.LOG_DUP_BIN_DELTA);
        } else {
            targetEntries.add(LogEntryType.LOG_IN);
            targetEntries.add(LogEntryType.LOG_BIN);
            targetEntries.add(LogEntryType.LOG_IN_DELETE_INFO);
            deltaType.add(LogEntryType.LOG_BIN_DELTA);
        }
        Tracer.trace(Level.CONFIG, this.env, this.passStartHeader(passNum) + passADesc);
        LevelRecorder recorder = new LevelRecorder();
        long start = System.currentTimeMillis();
        if (mappingTree) {
            this.readINsAndTrackIds(this.info.checkpointStartLsn, recorder);
        } else {
            int numINsSeen = this.readINs(this.info.checkpointStartLsn, false, targetEntries, dupTree, recorder);
            if (dupTree) {
                this.info.numDuplicateINs += numINsSeen;
            } else {
                this.info.numOtherINs += numINsSeen;
            }
        }
        long end = System.currentTimeMillis();
        Tracer.trace(Level.CONFIG, this.env, this.passEndHeader(passNum, start, end) + this.info.toString());
        ++passNum;
        Set<DatabaseId> redoSet = recorder.getDbsWithDifferentLevels();
        if (redoSet.size() > 0) {
            Tracer.trace(Level.CONFIG, this.env, this.passStartHeader(passNum) + passBDesc);
            start = System.currentTimeMillis();
            this.repeatReadINs(this.info.checkpointStartLsn, targetEntries, redoSet);
            end = System.currentTimeMillis();
            Tracer.trace(Level.CONFIG, this.env, this.passEndHeader(passNum, start, end) + this.info.toString());
            ++passNum;
        }
        Tracer.trace(Level.CONFIG, this.env, this.passStartHeader(passNum) + passCDesc);
        start = System.currentTimeMillis();
        this.info.numBinDeltas += this.readINs(this.info.checkpointStartLsn, mappingTree, deltaType, true, null);
        end = System.currentTimeMillis();
        Tracer.trace(Level.CONFIG, this.env, this.passEndHeader(passNum, start, end) + this.info.toString());
        return ++passNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readINsAndTrackIds(long rollForwardLsn, LevelRecorder recorder) throws IOException, DatabaseException {
        INFileReader reader = new INFileReader(this.env, this.readBufferSize, rollForwardLsn, this.info.nextAvailableLsn, true, false, this.info.partialCheckpointStartLsn, this.info.checkpointEndLsn, this.tracker);
        reader.addTargetType(LogEntryType.LOG_IN);
        reader.addTargetType(LogEntryType.LOG_BIN);
        reader.addTargetType(LogEntryType.LOG_IN_DELETE_INFO);
        reader.setAlwaysValidateChecksum(true);
        try {
            this.info.numMapINs = 0;
            DbTree dbMapTree = this.env.getDbTree();
            while (reader.readNextEntry()) {
                Object var9_8;
                DatabaseId dbId = reader.getDatabaseId();
                if (!dbId.equals(DbTree.ID_DB_ID)) continue;
                DatabaseImpl db = dbMapTree.getDb(dbId);
                try {
                    this.replayOneIN(reader, db, false, recorder);
                    ++this.info.numMapINs;
                    var9_8 = null;
                    dbMapTree.releaseDb(db);
                }
                catch (Throwable throwable) {
                    var9_8 = null;
                    dbMapTree.releaseDb(db);
                    throw throwable;
                }
            }
            this.info.useMinReplicatedNodeId = reader.getMinReplicatedNodeId();
            this.info.useMaxNodeId = reader.getMaxNodeId();
            this.info.useMinReplicatedDbId = reader.getMinReplicatedDbId();
            this.info.useMaxDbId = reader.getMaxDbId();
            this.info.useMinReplicatedTxnId = reader.getMinReplicatedTxnId();
            this.info.useMaxTxnId = reader.getMaxTxnId();
            if (this.info.checkpointEnd != null) {
                CheckpointEnd ckptEnd = this.info.checkpointEnd;
                if (this.info.useMinReplicatedNodeId > ckptEnd.getLastReplicatedNodeId()) {
                    this.info.useMinReplicatedNodeId = ckptEnd.getLastReplicatedNodeId();
                }
                if (this.info.useMaxNodeId < ckptEnd.getLastLocalNodeId()) {
                    this.info.useMaxNodeId = ckptEnd.getLastLocalNodeId();
                }
                if (this.info.useMinReplicatedDbId > ckptEnd.getLastReplicatedDbId()) {
                    this.info.useMinReplicatedDbId = ckptEnd.getLastReplicatedDbId();
                }
                if (this.info.useMaxDbId < ckptEnd.getLastLocalDbId()) {
                    this.info.useMaxDbId = ckptEnd.getLastLocalDbId();
                }
                if (this.info.useMinReplicatedTxnId > ckptEnd.getLastReplicatedTxnId()) {
                    this.info.useMinReplicatedTxnId = ckptEnd.getLastReplicatedTxnId();
                }
                if (this.info.useMaxTxnId < ckptEnd.getLastLocalTxnId()) {
                    this.info.useMaxTxnId = ckptEnd.getLastLocalTxnId();
                }
            }
            this.env.getNodeSequence().setLastNodeId(this.info.useMinReplicatedNodeId, this.info.useMaxNodeId);
            this.env.getDbTree().setLastDbId(this.info.useMinReplicatedDbId, this.info.useMaxDbId);
            this.env.getTxnManager().setLastTxnId(this.info.useMinReplicatedTxnId, this.info.useMaxTxnId);
            this.info.nRepeatIteratorReads = (int)((long)this.info.nRepeatIteratorReads + reader.getNRepeatIteratorReads());
            this.info.fileMappers = reader.getFileMappers();
        }
        catch (Exception e) {
            this.traceAndThrowException(reader.getLastLsn(), "readMapIns", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readINs(long rollForwardLsn, boolean mapDbOnly, Set<LogEntryType> targetLogEntryTypes, boolean requireExactMatch, LevelRecorder recorder) throws IOException, DatabaseException {
        INFileReader reader = new INFileReader(this.env, this.readBufferSize, rollForwardLsn, this.info.nextAvailableLsn, false, mapDbOnly, this.info.partialCheckpointStartLsn, this.info.checkpointEndLsn, this.tracker);
        Iterator<LogEntryType> iter = targetLogEntryTypes.iterator();
        while (iter.hasNext()) {
            reader.addTargetType(iter.next());
        }
        int numINsSeen = 0;
        try {
            DbTree dbMapTree = this.env.getDbTree();
            while (reader.readNextEntry()) {
                Object var16_15;
                DatabaseId dbId = reader.getDatabaseId();
                boolean isMapDb = dbId.equals(DbTree.ID_DB_ID);
                boolean isTarget = false;
                if (mapDbOnly && isMapDb) {
                    isTarget = true;
                } else if (!mapDbOnly && !isMapDb) {
                    isTarget = true;
                }
                if (!isTarget) continue;
                DatabaseImpl db = dbMapTree.getDb(dbId);
                try {
                    if (db != null) {
                        this.replayOneIN(reader, db, requireExactMatch, recorder);
                        ++numINsSeen;
                        this.inListBuildDbIds.add(dbId);
                    }
                    var16_15 = null;
                    dbMapTree.releaseDb(db);
                }
                catch (Throwable throwable) {
                    var16_15 = null;
                    dbMapTree.releaseDb(db);
                    throw throwable;
                }
            }
            this.info.nRepeatIteratorReads = (int)((long)this.info.nRepeatIteratorReads + reader.getNRepeatIteratorReads());
            return numINsSeen;
        }
        catch (Exception e) {
            this.traceAndThrowException(reader.getLastLsn(), "readNonMapIns", e);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repeatReadINs(long rollForwardLsn, Set<LogEntryType> targetLogEntryTypes, Set<DatabaseId> targetDbs) throws IOException, DatabaseException {
        INFileReader reader = new INFileReader(this.env, this.readBufferSize, rollForwardLsn, this.info.nextAvailableLsn, false, false, this.info.partialCheckpointStartLsn, this.info.checkpointEndLsn, this.tracker);
        Iterator<LogEntryType> iter = targetLogEntryTypes.iterator();
        while (iter.hasNext()) {
            reader.addTargetType(iter.next());
        }
        try {
            DbTree dbMapTree = this.env.getDbTree();
            while (reader.readNextEntry()) {
                Object var11_10;
                DatabaseId dbId = reader.getDatabaseId();
                if (!targetDbs.contains(dbId)) continue;
                DatabaseImpl db = dbMapTree.getDb(dbId);
                try {
                    if (db != null) {
                        this.replayOneIN(reader, db, true, null);
                    }
                    var11_10 = null;
                    dbMapTree.releaseDb(db);
                }
                catch (Throwable throwable) {
                    var11_10 = null;
                    dbMapTree.releaseDb(db);
                    throw throwable;
                }
            }
            this.info.nRepeatIteratorReads = (int)((long)this.info.nRepeatIteratorReads + reader.getNRepeatIteratorReads());
        }
        catch (Exception e) {
            this.traceAndThrowException(reader.getLastLsn(), "readNonMapIns", e);
        }
    }

    private void replayOneIN(INFileReader reader, DatabaseImpl db, boolean requireExactMatch, LevelRecorder recorder) throws DatabaseException {
        if (reader.isDeleteInfo()) {
            this.replayINDelete(db, reader.getDeletedNodeId(), false, reader.getDeletedIdKey(), null, reader.getLastLsn());
        } else if (reader.isDupDeleteInfo()) {
            this.replayINDelete(db, reader.getDupDeletedNodeId(), true, reader.getDupDeletedMainKey(), reader.getDupDeletedDupKey(), reader.getLastLsn());
        } else {
            IN in = reader.getIN();
            long inLsn = reader.getLsnOfIN();
            in.postRecoveryInit(db, inLsn);
            in.latch();
            if (recorder != null) {
                recorder.record(db.getId(), in.getLevel());
            }
            this.replaceOrInsert(db, in, reader.getLastLsn(), inLsn, requireExactMatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void undoLNs(RecoveryInfo info, Set<LogEntryType> lnTypes) throws IOException, DatabaseException {
        long firstActiveLsn = info.firstActiveLsn;
        long lastUsedLsn = info.lastUsedLsn;
        long endOfFileLsn = info.nextAvailableLsn;
        LNFileReader reader = new LNFileReader(this.env, this.readBufferSize, lastUsedLsn, false, endOfFileLsn, firstActiveLsn, null, info.checkpointEndLsn);
        for (LogEntryType lnType : lnTypes) {
            reader.addTargetType(lnType);
        }
        HashMap<TxnNodeId, Long> countedFileSummaries = new HashMap<TxnNodeId, Long>();
        HashSet<TxnNodeId> countedAbortLsnNodes = new HashSet<TxnNodeId>();
        DbTree dbMapTree = this.env.getDbTree();
        TreeLocation location = new TreeLocation();
        try {
            while (true) {
                if (!reader.readNextEntry()) {
                    info.nRepeatIteratorReads = (int)((long)info.nRepeatIteratorReads + reader.getNRepeatIteratorReads());
                    return;
                }
                if (reader.isLN()) {
                    Object var27_26;
                    Long txnId = reader.getTxnId();
                    if (txnId == null || this.committedTxnIds.containsKey(txnId) || this.preparedTxns.get(txnId) != null) continue;
                    this.env.invokeEvictor();
                    LN ln = reader.getLN();
                    long logLsn = reader.getLastLsn();
                    long abortLsn = reader.getAbortLsn();
                    boolean abortKnownDeleted = reader.getAbortKnownDeleted();
                    DatabaseId dbId = reader.getDatabaseId();
                    DatabaseImpl db = dbMapTree.getDb(dbId);
                    try {
                        if (db != null) {
                            ln.postFetchInit(db, logLsn);
                            RecoveryManager.undo(this.detailedTraceLevel, db, location, ln, reader.getKey(), reader.getDupTreeKey(), logLsn, abortLsn, abortKnownDeleted, info, true);
                            TxnNodeId txnNodeId = new TxnNodeId(reader.getNodeId(), txnId);
                            this.undoUtilizationInfo(ln, db, logLsn, abortLsn, abortKnownDeleted, reader.getLastEntrySize(), txnNodeId, countedFileSummaries, countedAbortLsnNodes);
                            this.inListBuildDbIds.add(dbId);
                            MapLN mapLN = reader.getMapLN();
                            if (mapLN != null && mapLN.getDatabase().isTemporary()) {
                                this.tempDbIds.add(mapLN.getDatabase().getId());
                            }
                        }
                        var27_26 = null;
                        dbMapTree.releaseDb(db);
                    }
                    catch (Throwable throwable) {
                        var27_26 = null;
                        dbMapTree.releaseDb(db);
                        throw throwable;
                    }
                }
                if (reader.isPrepare()) {
                    long prepareId = reader.getTxnPrepareId();
                    Long prepareIdL = prepareId;
                    if (this.committedTxnIds.containsKey(prepareIdL) || this.abortedTxnIds.contains(prepareIdL)) continue;
                    TransactionConfig txnConf = new TransactionConfig();
                    PreparedTxn preparedTxn = PreparedTxn.createPreparedTxn(this.env, txnConf, prepareId);
                    preparedTxn.setLockTimeout(0L);
                    this.preparedTxns.put(prepareIdL, preparedTxn);
                    preparedTxn.setPrepared(true);
                    this.env.getTxnManager().registerXATxn(reader.getTxnPrepareXid(), preparedTxn, true);
                    Tracer.trace(Level.INFO, this.env, "Found unfinished prepare record: id: " + reader.getTxnPrepareId() + " Xid: " + reader.getTxnPrepareXid());
                    continue;
                }
                if (reader.isAbort()) {
                    this.abortedTxnIds.add(reader.getTxnAbortId());
                    continue;
                }
                this.committedTxnIds.put(reader.getTxnCommitId(), reader.getLastLsn());
            }
        }
        catch (RuntimeException e) {
            this.traceAndThrowException(reader.getLastLsn(), "undoLNs", e);
        }
    }

    /*
     * Exception decompiling
     */
    private void redoLNs(RecoveryInfo info, Set<LogEntryType> lnTypes) throws IOException, DatabaseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildINList() throws DatabaseException {
        this.env.getInMemoryINs().enable();
        this.env.getDbTree().rebuildINListMapDb();
        for (DatabaseId dbId : this.inListBuildDbIds) {
            Object var5_4;
            if (dbId.equals(DbTree.ID_DB_ID)) continue;
            DatabaseImpl db = this.env.getDbTree().getDb(dbId);
            try {
                if (db != null && !db.isTemporary()) {
                    db.getTree().rebuildINList();
                }
                var5_4 = null;
                this.env.getDbTree().releaseDb(db);
            }
            catch (Throwable throwable) {
                var5_4 = null;
                this.env.getDbTree().releaseDb(db);
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void replaceOrInsert(DatabaseImpl db, IN inFromLog, long logLsn, long inLsn, boolean requireExactMatch) throws DatabaseException {
        block11: {
            ArrayList<TrackingInfo> trackingList = null;
            boolean inFromLogLatchReleased = false;
            try {
                block10: {
                    try {
                        if (inFromLog.isRoot()) {
                            if (inFromLog.containsDuplicates()) {
                                this.replaceOrInsertDuplicateRoot(db, (DIN)inFromLog, logLsn);
                                break block10;
                            } else {
                                this.replaceOrInsertRoot(db, inFromLog, logLsn);
                                inFromLogLatchReleased = true;
                            }
                            break block10;
                        }
                        trackingList = new ArrayList<TrackingInfo>();
                        this.replaceOrInsertChild(db, inFromLog, logLsn, inLsn, trackingList, requireExactMatch);
                        inFromLogLatchReleased = true;
                    }
                    catch (Exception e) {
                        String trace = this.printTrackList(trackingList);
                        Tracer.trace(db.getDbEnvironment(), "RecoveryManager", "replaceOrInsert", " lsnFromLog:" + DbLsn.getNoFormatString(logLsn) + " " + trace, e);
                        throw new DatabaseException("lsnFromLog=" + DbLsn.getNoFormatString(logLsn), e);
                    }
                }
                Object var13_8 = null;
                if (inFromLogLatchReleased) break block11;
            }
            catch (Throwable throwable) {
                Object var13_9 = null;
                if (!inFromLogLatchReleased) {
                    inFromLog.releaseLatch();
                }
                assert (LatchSupport.countLatchesHeld() == 0) : LatchSupport.latchesHeldToString() + "LSN = " + DbLsn.toString(logLsn) + " inFromLog = " + inFromLog.getNodeId();
                throw throwable;
            }
            inFromLog.releaseLatch();
        }
        assert (LatchSupport.countLatchesHeld() == 0) : LatchSupport.latchesHeldToString() + "LSN = " + DbLsn.toString(logLsn) + " inFromLog = " + inFromLog.getNodeId();
    }

    private String printTrackList(List<TrackingInfo> trackingList) {
        if (trackingList != null) {
            StringBuffer sb = new StringBuffer();
            Iterator<TrackingInfo> iter = trackingList.iterator();
            sb.append("Trace list:");
            sb.append('\n');
            while (iter.hasNext()) {
                sb.append(iter.next());
                sb.append('\n');
            }
            return sb.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void replayINDelete(DatabaseImpl db, long nodeId, boolean containsDuplicates, byte[] mainKey, byte[] dupKey, long logLsn) throws DatabaseException {
        SearchResult result;
        boolean deleted;
        boolean found;
        block6: {
            found = false;
            deleted = false;
            Tree tree = db.getTree();
            result = new SearchResult();
            try {
                result = db.getTree().getParentINForChildIN(nodeId, containsDuplicates, false, mainKey, dupKey, false, CacheMode.UNCHANGED, -1, null, true);
                if (result.parent == null) {
                    tree.withRootLatchedExclusive(new RootDeleter(tree));
                    db.setDirtyUtilization();
                    RecoveryManager.traceRootDeletion(Level.FINE, db);
                    deleted = true;
                } else if (result.exactParentFound) {
                    found = true;
                    deleted = result.parent.deleteEntry(result.index, false);
                }
                Object var14_11 = null;
                if (result.parent == null) break block6;
            }
            catch (Throwable throwable) {
                Object var14_12 = null;
                if (result.parent != null) {
                    result.parent.releaseLatch();
                }
                this.traceINDeleteReplay(nodeId, logLsn, found, deleted, result.index, containsDuplicates);
                throw throwable;
            }
            result.parent.releaseLatch();
        }
        this.traceINDeleteReplay(nodeId, logLsn, found, deleted, result.index, containsDuplicates);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void replaceOrInsertRoot(DatabaseImpl db, IN inFromLog, long lsn) throws DatabaseException {
        RootUpdater rootUpdater;
        boolean success;
        block7: {
            success = true;
            Tree tree = db.getTree();
            rootUpdater = new RootUpdater(tree, inFromLog, lsn);
            try {
                try {
                    tree.withRootLatchedExclusive(rootUpdater);
                    if (rootUpdater.updateDone()) {
                        db.setDirtyUtilization();
                    }
                }
                catch (Exception e) {
                    success = false;
                    throw new DatabaseException("lsnFromLog=" + DbLsn.getNoFormatString(lsn), e);
                }
                Object var10_7 = null;
                if (!rootUpdater.getInFromLogIsLatched()) break block7;
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                if (rootUpdater.getInFromLogIsLatched()) {
                    inFromLog.releaseLatch();
                }
                RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_ROOT_REPLACE, success, inFromLog, lsn, null, true, rootUpdater.getReplaced(), rootUpdater.getInserted(), rootUpdater.getOriginalLsn(), -1L, -1);
                throw throwable;
            }
            inFromLog.releaseLatch();
        }
        RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_ROOT_REPLACE, success, inFromLog, lsn, null, true, rootUpdater.getReplaced(), rootUpdater.getInserted(), rootUpdater.getOriginalLsn(), -1L, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void replaceOrInsertDuplicateRoot(DatabaseImpl db, DIN inFromLog, long lsn) throws DatabaseException {
        boolean success;
        int index;
        IN parent;
        long originalLsn;
        boolean replaced;
        boolean inserted;
        boolean found;
        block7: {
            found = true;
            inserted = false;
            replaced = false;
            originalLsn = -1L;
            byte[] mainTreeKey = inFromLog.getMainTreeKey();
            parent = null;
            index = -1;
            success = false;
            try {
                block9: {
                    block8: {
                        parent = db.getTree().searchSplitsAllowed(mainTreeKey, -1L, CacheMode.DEFAULT);
                        assert (parent instanceof BIN);
                        ChildReference newRef = new ChildReference(inFromLog, mainTreeKey, lsn);
                        index = parent.insertEntry1(newRef);
                        if (index < 0 || (index & 0x10000) == 0) break block8;
                        if (parent.isEntryKnownDeleted(index &= 0xFFFEFFFF)) {
                            parent.setEntry(index, inFromLog, mainTreeKey, lsn, (byte)0);
                            replaced = true;
                            break block9;
                        } else {
                            originalLsn = parent.getLsn(index);
                            if (DbLsn.compareTo(originalLsn, lsn) < 0) {
                                parent.setEntry(index, inFromLog, mainTreeKey, lsn, parent.getState(index));
                                replaced = true;
                            }
                        }
                        break block9;
                    }
                    found = false;
                }
                success = true;
                Object var16_13 = null;
                if (parent == null) break block7;
            }
            catch (Throwable throwable) {
                Object var16_14 = null;
                if (parent != null) {
                    parent.releaseLatch();
                }
                RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_DUP_ROOT_REPLACE, success, inFromLog, lsn, parent, found, replaced, inserted, originalLsn, -1L, index);
                throw throwable;
            }
            parent.releaseLatch();
        }
        RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_DUP_ROOT_REPLACE, success, inFromLog, lsn, parent, found, replaced, inserted, originalLsn, -1L, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void replaceOrInsertChild(DatabaseImpl db, IN inFromLog, long logLsn, long inLsn, List<TrackingInfo> trackingList, boolean requireExactMatch) throws DatabaseException {
        SearchResult result;
        boolean success;
        long originalLsn;
        boolean replaced;
        boolean inserted;
        block8: {
            block6: {
                block7: {
                    inserted = false;
                    replaced = false;
                    originalLsn = -1L;
                    success = false;
                    result = new SearchResult();
                    try {
                        result = db.getTree().getParentINForChildIN(inFromLog, requireExactMatch, CacheMode.UNCHANGED, -1, trackingList);
                        if (result.parent == null) {
                            Object var16_12 = null;
                            if (result.parent == null) break block6;
                            break block7;
                        }
                        if (result.index >= 0 && result.parent.getLsn(result.index) != logLsn && result.exactParentFound && DbLsn.compareTo(originalLsn = result.parent.getLsn(result.index), logLsn) < 0) {
                            result.parent.updateNode(result.index, inFromLog, inLsn, null);
                            replaced = true;
                        }
                        success = true;
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var16_14 = null;
                        if (result.parent != null) {
                            result.parent.releaseLatch();
                        }
                        RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_IN_REPLACE, success, inFromLog, logLsn, result.parent, result.exactParentFound, replaced, inserted, originalLsn, -1L, result.index);
                        throw throwable;
                    }
                }
                result.parent.releaseLatch();
            }
            RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_IN_REPLACE, success, inFromLog, logLsn, result.parent, result.exactParentFound, replaced, inserted, originalLsn, -1L, result.index);
            return;
        }
        Object var16_13 = null;
        if (result.parent != null) {
            result.parent.releaseLatch();
        }
        RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_IN_REPLACE, success, inFromLog, logLsn, result.parent, result.exactParentFound, replaced, inserted, originalLsn, -1L, result.index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long redo(DatabaseImpl db, TreeLocation location, LN lnFromLog, byte[] mainKey, byte[] dupKey, long logLsn, RecoveryInfo info) throws DatabaseException {
        long l;
        boolean success;
        boolean inserted;
        boolean replaced;
        boolean found;
        block18: {
            block16: {
                long l2;
                block17: {
                    found = false;
                    replaced = false;
                    inserted = false;
                    success = false;
                    try {
                        location.reset();
                        found = db.getTree().getParentBINForChildLN(location, mainKey, dupKey, lnFromLog, true, false, true, CacheMode.DEFAULT);
                        if (found || location.bin != null) break block16;
                        success = true;
                        l2 = -1L;
                        Object var16_17 = null;
                        if (location.bin == null) break block17;
                    }
                    catch (Throwable throwable) {
                        Object var16_19 = null;
                        if (location.bin != null) {
                            location.bin.releaseLatch();
                        }
                        RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_LN_REDO, success, lnFromLog, logLsn, location.bin, found, replaced, inserted, location.childLsn, -1L, location.index);
                        throw throwable;
                    }
                    location.bin.releaseLatch();
                }
                RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_LN_REDO, success, lnFromLog, logLsn, location.bin, found, replaced, inserted, location.childLsn, -1L, location.index);
                return l2;
            }
            if (lnFromLog.containsDuplicates()) {
                if (found) {
                    DIN duplicateRoot = (DIN)location.bin.fetchTarget(location.index);
                    if (DbLsn.compareTo(logLsn, location.childLsn) >= 0) {
                        duplicateRoot.latch();
                        duplicateRoot.updateDupCountLNRefAndNullTarget(logLsn);
                        duplicateRoot.releaseLatch();
                    }
                }
            } else if (found) {
                ++info.lnFound;
                if (DbLsn.compareTo(logLsn, location.childLsn) > 0) {
                    ++info.lnReplaced;
                    replaced = true;
                    location.bin.updateNode(location.index, null, logLsn, null);
                }
                if (DbLsn.compareTo(logLsn, location.childLsn) >= 0 && lnFromLog.isDeleted()) {
                    byte[] deletedKey;
                    location.bin.setKnownDeletedLeaveTarget(location.index);
                    byte[] byArray = deletedKey = location.bin.containsDuplicates() ? dupKey : mainKey;
                    if (deletedKey != null) {
                        db.getDbEnvironment().addToCompressorQueue(location.bin, new Key(deletedKey), false);
                    }
                }
            } else {
                ++info.lnNotFound;
                if (!lnFromLog.isDeleted()) {
                    ++info.lnInserted;
                    inserted = true;
                    boolean insertOk = RecoveryManager.insertRecovery(db, location, logLsn);
                    assert (insertOk);
                }
            }
            if (!inserted) {
                lnFromLog.releaseMemoryBudget();
            }
            success = true;
            l = found ? location.childLsn : -1L;
            Object var16_18 = null;
            if (location.bin == null) break block18;
            location.bin.releaseLatch();
        }
        RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_LN_REDO, success, lnFromLog, logLsn, location.bin, found, replaced, inserted, location.childLsn, -1L, location.index);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void undo(Level traceLevel, DatabaseImpl db, TreeLocation location, LN lnFromLog, byte[] mainKey, byte[] dupKey, long logLsn, long abortLsn, boolean abortKnownDeleted, RecoveryInfo info, boolean splitsAllowed) throws DatabaseException {
        boolean success;
        boolean replaced;
        boolean found;
        block17: {
            found = false;
            replaced = false;
            success = false;
            try {
                block19: {
                    block18: {
                        location.reset();
                        found = db.getTree().getParentBINForChildLN(location, mainKey, dupKey, lnFromLog, splitsAllowed, true, false, CacheMode.DEFAULT);
                        if (!lnFromLog.containsDuplicates()) break block18;
                        if (found) {
                            DIN duplicateRoot = (DIN)location.bin.fetchTarget(location.index);
                            duplicateRoot.latch();
                            try {
                                if (DbLsn.compareTo(logLsn, location.childLsn) == 0) {
                                    duplicateRoot.updateDupCountLNRefAndNullTarget(abortLsn);
                                    replaced = true;
                                }
                                Object var18_16 = null;
                            }
                            catch (Throwable throwable) {
                                Object var18_17 = null;
                                duplicateRoot.releaseLatch();
                                throw throwable;
                            }
                            duplicateRoot.releaseLatch();
                        }
                        break block19;
                    }
                    if (found) {
                        boolean updateEntry;
                        if (info != null) {
                            ++info.lnFound;
                        }
                        boolean bl = updateEntry = DbLsn.compareTo(logLsn, location.childLsn) == 0;
                        if (updateEntry) {
                            if (abortLsn == -1L) {
                                location.bin.setKnownDeletedLeaveTarget(location.index);
                                byte[] deletedKey = location.bin.containsDuplicates() ? dupKey : mainKey;
                                db.getDbEnvironment().addToCompressorQueue(location.bin, new Key(deletedKey), false);
                            } else {
                                if (info != null) {
                                    ++info.lnReplaced;
                                }
                                replaced = true;
                                location.bin.updateNode(location.index, null, abortLsn, null);
                                if (abortKnownDeleted) {
                                    location.bin.setKnownDeleted(location.index);
                                } else {
                                    location.bin.clearKnownDeleted(location.index);
                                }
                            }
                            location.bin.clearPendingDeleted(location.index);
                        }
                    } else if (info != null) {
                        ++info.lnNotFound;
                    }
                }
                success = true;
                Object var20_20 = null;
                if (location.bin == null) break block17;
            }
            catch (Throwable throwable) {
                Object var20_21 = null;
                if (location.bin != null) {
                    location.bin.releaseLatch();
                }
                RecoveryManager.trace(traceLevel, db, TRACE_LN_UNDO, success, lnFromLog, logLsn, location.bin, found, replaced, false, location.childLsn, abortLsn, location.index);
                throw throwable;
            }
            location.bin.releaseLatch();
        }
        RecoveryManager.trace(traceLevel, db, TRACE_LN_UNDO, success, lnFromLog, logLsn, location.bin, found, replaced, false, location.childLsn, abortLsn, location.index);
    }

    private static boolean insertRecovery(DatabaseImpl db, TreeLocation location, long logLsn) throws DatabaseException {
        BIN parentBIN = location.bin;
        ChildReference newLNRef = new ChildReference(null, location.lnKey, logLsn);
        int entryIndex = parentBIN.insertEntry1(newLNRef);
        if ((entryIndex & 0x20000) == 0) {
            boolean canOverwrite = false;
            if (parentBIN.isEntryKnownDeleted(entryIndex &= 0xFFFEFFFF)) {
                canOverwrite = true;
            } else {
                LN currentLN = (LN)parentBIN.fetchTarget(entryIndex);
                if (currentLN == null || currentLN.isDeleted()) {
                    canOverwrite = true;
                }
                parentBIN.updateNode(entryIndex, null, null);
            }
            if (canOverwrite) {
                parentBIN.updateEntry(entryIndex, null, logLsn, location.lnKey);
                parentBIN.clearKnownDeleted(entryIndex);
                location.index = entryIndex;
                return true;
            }
            return false;
        }
        location.index = entryIndex & 0xFFFDFFFF;
        return true;
    }

    private void redoUtilizationInfo(long logLsn, long treeLsn, long commitLsn, long abortLsn, boolean abortKnownDeleted, int logEntrySize, byte[] key, LN ln, DatabaseImpl db, TxnNodeId txnNodeId, Set<TxnNodeId> countedAbortLsnNodes) throws DatabaseException {
        if (ln.isDeleted()) {
            this.tracker.countObsoleteIfUncounted(logLsn, logLsn, null, logEntrySize, db.getId(), true);
        }
        if (treeLsn != -1L) {
            int cmpLogLsnToTreeLsn = DbLsn.compareTo(logLsn, treeLsn);
            if (cmpLogLsnToTreeLsn != 0) {
                long newLsn = cmpLogLsnToTreeLsn < 0 ? treeLsn : logLsn;
                long oldLsn = cmpLogLsnToTreeLsn > 0 ? treeLsn : logLsn;
                int oldSize = oldLsn == logLsn ? logEntrySize : 0;
                this.tracker.countObsoleteIfUncounted(oldLsn, newLsn, null, this.tracker.fetchLNSize(oldSize, oldLsn), db.getId(), true);
            }
            if (cmpLogLsnToTreeLsn <= 0 && abortLsn != -1L && !abortKnownDeleted && !countedAbortLsnNodes.contains(txnNodeId)) {
                assert (commitLsn != -1L);
                this.tracker.countObsoleteIfUncounted(abortLsn, commitLsn, null, 0, db.getId(), false);
                countedAbortLsnNodes.add(txnNodeId);
            }
        }
    }

    private void undoUtilizationInfo(LN ln, DatabaseImpl db, long logLsn, long abortLsn, boolean abortKnownDeleted, int logEntrySize, TxnNodeId txnNodeId, Map<TxnNodeId, Long> countedFileSummaries, Set<TxnNodeId> countedAbortLsnNodes) {
        boolean counted = this.tracker.countObsoleteIfUncounted(logLsn, logLsn, null, logEntrySize, db.getId(), true);
        if (!counted) {
            Long logFileNum = DbLsn.getFileNumber(logLsn);
            Long countedFile = countedFileSummaries.get(txnNodeId);
            if (countedFile == null || countedFile > logFileNum) {
                if (!ln.isDeleted()) {
                    this.tracker.countObsoleteUnconditional(logLsn, null, logEntrySize, db.getId(), true);
                }
                countedFileSummaries.put(txnNodeId, logFileNum);
            }
        }
    }

    private void removeTempDbs() throws DatabaseException {
        DbTree dbMapTree = this.env.getDbTree();
        BasicLocker locker = BasicLocker.createBasicLocker(this.env, false, true);
        boolean operationOk = false;
        try {
            try {
                for (DatabaseId dbId : this.tempDbIds) {
                    DatabaseImpl db = dbMapTree.getDb(dbId);
                    dbMapTree.releaseDb(db);
                    if (db == null) continue;
                    assert (db.isTemporary());
                    if (db.isDeleted()) continue;
                    this.env.getDbTree().dbRemove(locker, db.getName(), db.getId());
                }
                operationOk = true;
            }
            catch (Error E) {
                this.env.invalidate(E);
                throw E;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            locker.operationEnd(operationOk);
            throw throwable;
        }
        locker.operationEnd(operationOk);
    }

    private String passStartHeader(int passNum) {
        return "Recovery Pass " + passNum + " start: ";
    }

    private String passEndHeader(int passNum, long start, long end) {
        return "Recovery Pass " + passNum + " end (" + (end - start) + "): ";
    }

    private static void trace(Level level, DatabaseImpl database, String debugType, boolean success, Node node, long logLsn, IN parent, boolean found, boolean replaced, boolean inserted, long replacedLsn, long abortLsn, int index) {
        Logger logger = database.getDbEnvironment().getLogger();
        Level useLevel = level;
        if (!success) {
            useLevel = Level.SEVERE;
        }
        if (logger.isLoggable(useLevel)) {
            StringBuffer sb = new StringBuffer();
            sb.append(debugType);
            sb.append(" success=").append(success);
            sb.append(" node=");
            sb.append(node.getNodeId());
            sb.append(" lsn=");
            sb.append(DbLsn.getNoFormatString(logLsn));
            if (parent != null) {
                sb.append(" parent=").append(parent.getNodeId());
            }
            sb.append(" found=");
            sb.append(found);
            sb.append(" replaced=");
            sb.append(replaced);
            sb.append(" inserted=");
            sb.append(inserted);
            if (replacedLsn != -1L) {
                sb.append(" replacedLsn=");
                sb.append(DbLsn.getNoFormatString(replacedLsn));
            }
            if (abortLsn != -1L) {
                sb.append(" abortLsn=");
                sb.append(DbLsn.getNoFormatString(abortLsn));
            }
            sb.append(" index=").append(index);
            logger.log(useLevel, sb.toString());
        }
    }

    private void traceINDeleteReplay(long nodeId, long logLsn, boolean found, boolean deleted, int index, boolean isDuplicate) {
        Logger logger = this.env.getLogger();
        if (logger.isLoggable(this.detailedTraceLevel)) {
            StringBuffer sb = new StringBuffer();
            sb.append(isDuplicate ? TRACE_IN_DUPDEL_REPLAY : TRACE_IN_DEL_REPLAY);
            sb.append(" node=").append(nodeId);
            sb.append(" lsn=").append(DbLsn.getNoFormatString(logLsn));
            sb.append(" found=").append(found);
            sb.append(" deleted=").append(deleted);
            sb.append(" index=").append(index);
            logger.log(this.detailedTraceLevel, sb.toString());
        }
    }

    private void traceAndThrowException(long badLsn, String method, Exception originalException) throws DatabaseException {
        String badLsnString = DbLsn.getNoFormatString(badLsn);
        Tracer.trace(this.env, "RecoveryManager", method, "last LSN = " + badLsnString, originalException);
        throw new DatabaseException("last LSN=" + badLsnString, originalException);
    }

    public static void traceRootDeletion(Level level, DatabaseImpl database) {
        Logger logger = database.getDbEnvironment().getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(TRACE_ROOT_DELETE);
            sb.append(" Dbid=").append(database.getId());
            logger.log(level, sb.toString());
        }
    }

    private static class RootUpdater
    implements WithRootLatched {
        private Tree tree;
        private IN inFromLog;
        private long lsn = -1L;
        private boolean inserted = false;
        private boolean replaced = false;
        private long originalLsn = -1L;
        private boolean inFromLogIsLatched = true;

        RootUpdater(Tree tree, IN inFromLog, long lsn) {
            this.tree = tree;
            this.inFromLog = inFromLog;
            this.lsn = lsn;
        }

        boolean getInFromLogIsLatched() {
            return this.inFromLogIsLatched;
        }

        public IN doWork(ChildReference root) throws DatabaseException {
            ChildReference newRoot = this.tree.makeRootChildReference(this.inFromLog, new byte[0], this.lsn);
            this.inFromLog.releaseLatch();
            this.inFromLogIsLatched = false;
            if (root == null) {
                this.tree.setRoot(newRoot, false);
                this.inserted = true;
            } else {
                this.originalLsn = root.getLsn();
                if (DbLsn.compareTo(this.originalLsn, this.lsn) < 0) {
                    this.tree.setRoot(newRoot, false);
                    this.replaced = true;
                }
            }
            return null;
        }

        boolean updateDone() {
            return this.inserted || this.replaced;
        }

        boolean getInserted() {
            return this.inserted;
        }

        boolean getReplaced() {
            return this.replaced;
        }

        long getOriginalLsn() {
            return this.originalLsn;
        }
    }

    private static class RootDeleter
    implements WithRootLatched {
        Tree tree;

        RootDeleter(Tree tree) {
            this.tree = tree;
        }

        public IN doWork(ChildReference root) throws DatabaseException {
            this.tree.setRoot(null, false);
            return null;
        }
    }

    private static class TxnNodeId {
        long nodeId;
        long txnId;

        TxnNodeId(long nodeId, long txnId) {
            this.nodeId = nodeId;
            this.txnId = txnId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TxnNodeId)) {
                return false;
            }
            return ((TxnNodeId)obj).txnId == this.txnId && ((TxnNodeId)obj).nodeId == this.nodeId;
        }

        public int hashCode() {
            return (int)(this.txnId + this.nodeId);
        }

        public String toString() {
            return "txnId=" + this.txnId + "/nodeId=" + this.nodeId;
        }
    }
}

