/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.ContentDataFilter;
import freenet.client.filter.DataFilterException;
import freenet.client.filter.FilterCallback;
import freenet.l10n.NodeL10n;
import freenet.support.Logger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public abstract class RIFFFilter
implements ContentDataFilter {
    private static final byte[] magicNumber = new byte[]{82, 73, 70, 70};

    /*
     * WARNING - void declaration
     */
    @Override
    public void readFilter(InputStream input, OutputStream output, String charset, Map<String, String> otherParams, String schemeHostAndPort, FilterCallback cb) throws DataFilterException, IOException {
        void var12_17;
        DataInputStream in = new DataInputStream(input);
        DataOutputStream out = new DataOutputStream(output);
        for (byte by : magicNumber) {
            if (by == in.readByte()) continue;
            throw new DataFilterException(RIFFFilter.l10n("invalidTitle"), RIFFFilter.l10n("invalidTitle"), RIFFFilter.l10n("invalidStream"));
        }
        int fileSize = RIFFFilter.readLittleEndianInt(in);
        byte[] byArray = this.getChunkMagicNumber();
        int n = byArray.length;
        boolean bl = false;
        while (var12_17 < n) {
            byte magicCharacter = byArray[var12_17];
            if (magicCharacter != in.readByte()) {
                throw new DataFilterException(RIFFFilter.l10n("invalidTitle"), RIFFFilter.l10n("invalidTitle"), RIFFFilter.l10n("invalidStream"));
            }
            ++var12_17;
        }
        out.write(magicNumber);
        if (fileSize < 0) {
            throw new DataFilterException(RIFFFilter.l10n("invalidTitle"), RIFFFilter.l10n("invalidTitle"), RIFFFilter.l10n("data2GB"));
        }
        if (fileSize < 12) {
            throw new DataFilterException(RIFFFilter.l10n("invalidTitle"), RIFFFilter.l10n("invalidTitle"), NodeL10n.getBase().getString("ContentFilter.EOFMessage"));
        }
        RIFFFilter.writeLittleEndianInt(out, fileSize);
        out.write(this.getChunkMagicNumber());
        Object context = this.createContext();
        int remainingSize = fileSize - 4;
        try {
            int n2;
            do {
                byte[] fccType = new byte[4];
                in.readFully(fccType);
                n2 = RIFFFilter.readLittleEndianInt(in);
                if (n2 < 0 || remainingSize < n2 + 8 + (n2 & 1)) {
                    throw new DataFilterException(RIFFFilter.l10n("invalidTitle"), RIFFFilter.l10n("invalidTitle"), RIFFFilter.l10n("dataTooBig"));
                }
                this.readFilterChunk(fccType, n2, context, in, out, charset, otherParams, schemeHostAndPort, cb);
            } while ((remainingSize -= n2 + 8 + (n2 & 1)) != 0);
        }
        catch (EOFException e) {
            throw new DataFilterException(RIFFFilter.l10n("invalidTitle"), RIFFFilter.l10n("invalidTitle"), NodeL10n.getBase().getString("ContentFilter.EOFMessage"));
        }
        if (input.read() != -1) {
            throw new DataFilterException(RIFFFilter.l10n("invalidTitle"), RIFFFilter.l10n("invalidTitle"), NodeL10n.getBase().getString("ContentFilter.EOFMessage"));
        }
        if (remainingSize != 0) {
            throw new DataFilterException(RIFFFilter.l10n("invalidTitle"), RIFFFilter.l10n("invalidTitle"), NodeL10n.getBase().getString("ContentFilter.EOFMessage"));
        }
        this.EOFCheck(context);
    }

    protected abstract byte[] getChunkMagicNumber();

    protected abstract Object createContext();

    protected abstract void readFilterChunk(byte[] var1, int var2, Object var3, DataInputStream var4, DataOutputStream var5, String var6, Map<String, String> var7, String var8, FilterCallback var9) throws DataFilterException, IOException;

    protected abstract void EOFCheck(Object var1) throws DataFilterException;

    private static String l10n(String key) {
        return NodeL10n.getBase().getString("RIFFFilter." + key);
    }

    protected void passthroughBytes(DataInputStream in, DataOutputStream out, int size) throws DataFilterException, IOException {
        if (size < 0) {
            if (Logger.shouldLog(Logger.LogLevel.WARNING, this.getClass())) {
                Logger.warning(this, "RIFF block size " + size + " is less than 0");
            }
            throw new DataFilterException(RIFFFilter.l10n("invalidTitle"), RIFFFilter.l10n("invalidTitle"), RIFFFilter.l10n("dataTooBig"));
        }
        int remaining = size;
        int section = remaining > 0x100000 ? 0x100000 : remaining;
        byte[] buf = new byte[section];
        while (remaining > 0) {
            section = remaining > 0x100000 ? 0x100000 : remaining;
            in.readFully(buf, 0, section);
            out.write(buf, 0, section);
            remaining -= section;
        }
    }

    protected void writeJunkChunk(DataInputStream in, DataOutputStream out, int size) throws DataFilterException, IOException {
        if (in.skip(size += size % 2) < (long)size) {
            throw new EOFException();
        }
        if (size < 0) {
            if (Logger.shouldLog(Logger.LogLevel.WARNING, this.getClass())) {
                Logger.warning(this, "RIFF block size " + size + " is less than 0");
            }
            throw new DataFilterException(RIFFFilter.l10n("invalidTitle"), RIFFFilter.l10n("invalidTitle"), RIFFFilter.l10n("dataTooBig"));
        }
        int remaining = size;
        byte[] zeros = new byte[0x100000];
        for (int i = 0; i < 0x100000; ++i) {
            zeros[i] = 0;
        }
        byte[] JUNK = new byte[]{74, 85, 78, 75};
        out.write(JUNK);
        RIFFFilter.writeLittleEndianInt(out, size);
        while (remaining > 0) {
            int section = remaining > 0x100000 ? 0x100000 : remaining;
            out.write(zeros, 0, section);
            remaining -= section;
        }
    }

    protected static final int readLittleEndianInt(DataInputStream stream) throws IOException {
        int a = stream.readInt();
        return Integer.reverseBytes(a);
    }

    protected static final void writeLittleEndianInt(DataOutputStream stream, int a) throws IOException {
        stream.writeInt(Integer.reverseBytes(a));
    }
}

