/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.ClientMetadata;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.async.CacheFetchResult;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetCallback;
import freenet.client.async.ClientGetter;
import freenet.client.async.PersistenceDisabledException;
import freenet.client.events.ClientEvent;
import freenet.client.events.ClientEventListener;
import freenet.client.events.ExpectedFileSizeEvent;
import freenet.client.events.ExpectedMIMEEvent;
import freenet.client.events.SendingToNetworkEvent;
import freenet.client.events.SplitfileProgressEvent;
import freenet.client.filter.ContentFilter;
import freenet.client.filter.FilterMIMEType;
import freenet.client.filter.UnknownContentTypeException;
import freenet.clients.http.FProxyFetchListener;
import freenet.clients.http.FProxyFetchResult;
import freenet.clients.http.FProxyFetchTracker;
import freenet.clients.http.FProxyFetchWaiter;
import freenet.keys.FreenetURI;
import freenet.keys.USK;
import freenet.node.RequestClient;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.Closer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class FProxyFetchInProgress
implements ClientEventListener,
ClientGetCallback {
    private final REFILTER_POLICY refilterPolicy;
    private static volatile boolean logMINOR;
    public final FreenetURI uri;
    public final long maxSize;
    private final ClientGetter getter;
    private final ArrayList<FProxyFetchWaiter> waiters;
    private final ArrayList<FProxyFetchResult> results;
    private final List<FProxyFetchListener> listener = Collections.synchronizedList(new ArrayList());
    private Bucket data;
    private final long timeStarted;
    private boolean finished;
    private long size;
    private String mimeType;
    private boolean goneToNetwork;
    private int totalBlocks;
    private int requiredBlocks;
    private int fetchedBlocks;
    private int failedBlocks;
    private int fatallyFailedBlocks;
    private int fetchedBlocksPreNetwork;
    private boolean finalizedBlocks;
    private FetchException failed;
    private boolean hasWaited;
    private boolean hasNotifiedFailure;
    private long lastTouched;
    final FProxyFetchTracker tracker;
    private long timeFailed;
    private boolean requestImmediateCancel = false;
    private int fetched = 0;
    private FetchContext fctx;
    private boolean cancelled = false;
    private final RequestClient rc;
    static final long LIFETIME;

    public FProxyFetchInProgress(FProxyFetchTracker tracker, FreenetURI key, long maxSize2, long identifier, ClientContext context, FetchContext fctx, RequestClient rc, REFILTER_POLICY refilter) {
        this.refilterPolicy = refilter;
        this.tracker = tracker;
        this.uri = key;
        this.maxSize = maxSize2;
        this.timeStarted = System.currentTimeMillis();
        this.fctx = fctx;
        this.rc = rc;
        FetchContext alteredFctx = new FetchContext(fctx, 0);
        alteredFctx.maxOutputLength = fctx.maxTempLength = this.maxSize;
        alteredFctx.eventProducer.addEventListener(this);
        this.waiters = new ArrayList();
        this.results = new ArrayList();
        this.getter = new ClientGetter(this, this.uri, alteredFctx, 1, null, null, null);
    }

    public synchronized FProxyFetchWaiter getWaiter() {
        this.lastTouched = System.currentTimeMillis();
        FProxyFetchWaiter waiter = new FProxyFetchWaiter(this);
        this.waiters.add(waiter);
        return waiter;
    }

    public FProxyFetchTracker getTracker() {
        return this.tracker;
    }

    public synchronized void addCustomWaiter(FProxyFetchWaiter waiter) {
        this.waiters.add(waiter);
    }

    synchronized FProxyFetchResult innerGetResult(boolean hasWaited) {
        this.lastTouched = System.currentTimeMillis();
        FProxyFetchResult res = this.data != null ? new FProxyFetchResult(this, this.data, this.mimeType, this.timeStarted, this.goneToNetwork, this.getETA(), hasWaited) : new FProxyFetchResult(this, this.mimeType, this.size, this.timeStarted, this.goneToNetwork, this.totalBlocks, this.requiredBlocks, this.fetchedBlocks, this.failedBlocks, this.fatallyFailedBlocks, this.finalizedBlocks, this.failed, this.getETA(), hasWaited);
        this.results.add(res);
        if (this.data != null || this.failed != null) {
            res.setFetchCount(this.fetched);
            ++this.fetched;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ClientContext context) throws FetchException {
        try {
            if (!this.checkCache(context)) {
                context.start(this.getter);
            }
        }
        catch (FetchException e) {
            FProxyFetchInProgress fProxyFetchInProgress = this;
            synchronized (fProxyFetchInProgress) {
                this.failed = e;
                this.finished = true;
            }
        }
        catch (PersistenceDisabledException e) {
            Logger.error(this, "Failed to start: " + e);
            FProxyFetchInProgress fProxyFetchInProgress = this;
            synchronized (fProxyFetchInProgress) {
                this.failed = new FetchException(FetchException.FetchExceptionMode.INTERNAL_ERROR, (Throwable)e);
                this.finished = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkCache(ClientContext context) {
        boolean bl;
        CacheFetchResult result;
        if (this.bogusUSK(context)) {
            return false;
        }
        if (context.downloadCache == null) {
            return false;
        }
        CacheFetchResult cacheFetchResult = result = context.downloadCache.lookupInstant(this.uri, !this.fctx.filterData, false, null);
        if (result == null) {
            return false;
        }
        Bucket data = null;
        String mimeType = null;
        if (!this.fctx.filterData && !result.alreadyFiltered) {
            if (this.fctx.overrideMIME == null || this.fctx.overrideMIME.equals(result.getMimeType())) {
                this.tracker.removeFetcher(this);
                this.onSuccess(result, null);
                return true;
            }
            if (this.fctx.overrideMIME != null && !this.fctx.overrideMIME.equals(result.getMimeType())) {
                this.tracker.removeFetcher(this);
                this.onSuccess(new FetchResult(new ClientMetadata(this.fctx.overrideMIME), result.asBucket()), null);
                return true;
            }
        } else if (result.alreadyFiltered) {
            if (this.refilterPolicy == REFILTER_POLICY.RE_FETCH) return false;
            if (!this.fctx.filterData) {
                return false;
            }
            if (!this.fctx.filterData) return false;
            if (!this.shouldAcceptCachedFilteredData(this.fctx, result)) return false;
            if (this.refilterPolicy == REFILTER_POLICY.ACCEPT_OLD) {
                this.tracker.removeFetcher(this);
                this.onSuccess(result, null);
                return true;
            }
        }
        data = result.asBucket();
        mimeType = result.getMimeType();
        if (mimeType == null || mimeType.isEmpty()) {
            mimeType = "application/octet-stream";
        }
        if (this.fctx.overrideMIME != null && !result.alreadyFiltered) {
            mimeType = this.fctx.overrideMIME;
        } else if (this.fctx.overrideMIME != null && !mimeType.equals(this.fctx.overrideMIME)) {
            return false;
        }
        String fullMimeType = mimeType;
        mimeType = ContentFilter.stripMIMEType(mimeType);
        FilterMIMEType type = ContentFilter.getMIMEType(mimeType);
        if (type == null || !type.safeToRead && type.readFilter == null) {
            UnknownContentTypeException e = new UnknownContentTypeException(mimeType);
            data.free();
            this.onFailure(new FetchException(e.getFetchErrorCode(), data.size(), e, mimeType), null);
            return true;
        }
        if (type.safeToRead) {
            this.tracker.removeFetcher(this);
            this.onSuccess(new FetchResult(new ClientMetadata(mimeType), data), null);
            return true;
        }
        RandomAccessBucket output = null;
        InputStream is = null;
        OutputStream os = null;
        try {
            output = context.tempBucketFactory.makeBucket(-1L);
            is = data.getInputStream();
            os = output.getOutputStream();
            ContentFilter.filter(is, os, fullMimeType, this.uri.toURI("/"), this.fctx.getSchemeHostAndPort(), null, null, this.fctx.charset, context.linkFilterExceptionProvider);
            is.close();
            is = null;
            os.close();
            os = null;
            this.onSuccess(new FetchResult(new ClientMetadata(fullMimeType), (Bucket)output), null);
            output = null;
            bl = true;
        }
        catch (IOException e) {
            Logger.normal(this, "Failed filtering coalesced data in fproxy");
            boolean bl2 = false;
            Closer.close(is);
            Closer.close(os);
            Closer.close(output);
            Closer.close(data);
            return bl2;
        }
        catch (URISyntaxException e2) {
            Logger.error(this, "Impossible: " + e2, (Throwable)e2);
            boolean bl3 = false;
            {
                catch (Throwable throwable) {
                    Closer.close(is);
                    Closer.close(os);
                    Closer.close(output);
                    Closer.close(data);
                    throw throwable;
                }
            }
            Closer.close(is);
            Closer.close(os);
            Closer.close(output);
            Closer.close(data);
            return bl3;
        }
        Closer.close(is);
        Closer.close(os);
        Closer.close(output);
        Closer.close(data);
        return bl;
    }

    private boolean bogusUSK(ClientContext context) {
        USK usk;
        if (!this.uri.isUSK()) {
            return false;
        }
        long edition = this.uri.getSuggestedEdition();
        if (edition < 0L) {
            return true;
        }
        try {
            usk = USK.create(this.uri);
        }
        catch (MalformedURLException e) {
            return false;
        }
        long ret = context.uskManager.lookupKnownGood(usk);
        if (ret == -1L) {
            return false;
        }
        return ret > edition;
    }

    private boolean shouldAcceptCachedFilteredData(FetchContext fctx, CacheFetchResult result) {
        if (fctx.charset != null) {
            return false;
        }
        if (fctx.overrideMIME == null) {
            return true;
        }
        String finalMIME = result.getMimeType();
        if (fctx.overrideMIME.equals(finalMIME)) {
            return true;
        }
        return ContentFilter.stripMIMEType(finalMIME).equals(fctx.overrideMIME) && fctx.charset == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(ClientEvent ce, ClientContext context) {
        try {
            Iterator<FProxyFetchListener> iterator;
            if (ce instanceof SplitfileProgressEvent) {
                SplitfileProgressEvent split = (SplitfileProgressEvent)ce;
                FProxyFetchInProgress fProxyFetchInProgress = this;
                synchronized (fProxyFetchInProgress) {
                    block30: {
                        int oldReq = this.requiredBlocks - (this.fetchedBlocks + this.failedBlocks + this.fatallyFailedBlocks);
                        this.totalBlocks = split.totalBlocks;
                        this.fetchedBlocks = split.succeedBlocks;
                        this.requiredBlocks = split.minSuccessfulBlocks;
                        this.failedBlocks = split.failedBlocks;
                        this.fatallyFailedBlocks = split.fatallyFailedBlocks;
                        this.finalizedBlocks = split.finalizedTotal;
                        int req = this.requiredBlocks - (this.fetchedBlocks + this.failedBlocks + this.fatallyFailedBlocks);
                        if (req > 1024 && oldReq <= 1024) break block30;
                        return;
                    }
                }
            }
            if (ce instanceof SendingToNetworkEvent) {
                iterator = this;
                synchronized (iterator) {
                    block31: {
                        if (!this.goneToNetwork) break block31;
                        return;
                    }
                    this.goneToNetwork = true;
                    this.fetchedBlocksPreNetwork = this.fetchedBlocks;
                }
            }
            if (ce instanceof ExpectedMIMEEvent) {
                iterator = this;
                synchronized (iterator) {
                    this.mimeType = ((ExpectedMIMEEvent)ce).expectedMIMEType;
                }
                if (!this.goneToNetwork) {
                    return;
                }
            } else if (ce instanceof ExpectedFileSizeEvent) {
                iterator = this;
                synchronized (iterator) {
                    this.size = ((ExpectedFileSizeEvent)ce).expectedSize;
                }
                if (!this.goneToNetwork) {
                    return;
                }
            } else {
                return;
            }
            this.wakeWaiters(false);
        }
        finally {
            for (FProxyFetchListener l : new ArrayList<FProxyFetchListener>(this.listener)) {
                l.onEvent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeWaiters(boolean finished) {
        FProxyFetchWaiter[] fProxyFetchWaiterArray = this;
        synchronized (this) {
            FProxyFetchWaiter[] waiting = this.waiters.toArray(new FProxyFetchWaiter[this.waiters.size()]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (FProxyFetchWaiter w : waiting) {
                w.wakeUp(finished);
            }
            if (finished) {
                for (FProxyFetchListener l : new ArrayList<FProxyFetchListener>(this.listener)) {
                    l.onEvent();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(FetchException e, ClientGetter state) {
        FProxyFetchInProgress fProxyFetchInProgress = this;
        synchronized (fProxyFetchInProgress) {
            this.failed = e;
            this.finished = true;
            this.timeFailed = System.currentTimeMillis();
        }
        this.wakeWaiters(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(FetchResult result, ClientGetter state) {
        Bucket droppedData = null;
        FProxyFetchInProgress fProxyFetchInProgress = this;
        synchronized (fProxyFetchInProgress) {
            if (this.cancelled) {
                droppedData = result.asBucket();
            } else {
                this.data = result.asBucket();
            }
            this.mimeType = result.getMimeType();
            this.finished = true;
        }
        this.wakeWaiters(true);
        if (droppedData != null) {
            droppedData.free();
        }
    }

    public synchronized boolean hasData() {
        return this.data != null;
    }

    public synchronized boolean finished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(FProxyFetchWaiter waiter) {
        FProxyFetchInProgress fProxyFetchInProgress = this;
        synchronized (fProxyFetchInProgress) {
            this.waiters.remove(waiter);
            if (!this.results.isEmpty()) {
                return;
            }
            if (!this.waiters.isEmpty()) {
                return;
            }
        }
        this.tracker.queueCancel(this);
    }

    public synchronized boolean canCancel() {
        if (!this.waiters.isEmpty()) {
            return false;
        }
        if (!this.results.isEmpty()) {
            return false;
        }
        if (!this.listener.isEmpty()) {
            return false;
        }
        if (this.lastTouched + LIFETIME >= System.currentTimeMillis() && !this.requestImmediateCancel) {
            if (logMINOR) {
                Logger.minor(this, "Not able to cancel for " + this + " : " + this.uri + " : " + this.maxSize);
            }
            return false;
        }
        if (logMINOR) {
            Logger.minor(this, "Can cancel for " + this + " : " + this.uri + " : " + this.maxSize);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishCancel() {
        Bucket d;
        if (logMINOR) {
            Logger.minor(this, "Finishing cancel for " + this + " : " + this.uri + " : " + this.maxSize);
        }
        try {
            this.getter.cancel(this.tracker.context);
        }
        catch (Throwable t) {
            Logger.error(this, "Failed to cancel: " + t, t);
        }
        FProxyFetchInProgress fProxyFetchInProgress = this;
        synchronized (fProxyFetchInProgress) {
            d = this.data;
            this.cancelled = true;
        }
        if (d != null) {
            try {
                d.free();
            }
            catch (Throwable t) {
                Logger.error(this, "Failed to free: " + t, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(FProxyFetchResult result) {
        FProxyFetchInProgress fProxyFetchInProgress = this;
        synchronized (fProxyFetchInProgress) {
            this.results.remove(result);
            if (!this.results.isEmpty()) {
                return;
            }
            if (!this.waiters.isEmpty()) {
                return;
            }
        }
        this.tracker.queueCancel(this);
    }

    public synchronized long getETA() {
        if (!this.goneToNetwork) {
            return -1L;
        }
        if (this.requiredBlocks <= 0) {
            return -1L;
        }
        if (this.fetchedBlocks >= this.requiredBlocks) {
            return -1L;
        }
        if (this.fetchedBlocks - this.fetchedBlocksPreNetwork < 5) {
            return -1L;
        }
        return (System.currentTimeMillis() - this.timeStarted) * (long)(this.requiredBlocks - this.fetchedBlocksPreNetwork) / (long)(this.fetchedBlocks - this.fetchedBlocksPreNetwork);
    }

    public synchronized boolean notFinishedOrFatallyFinished() {
        if (this.data == null && this.failed == null) {
            return true;
        }
        if (this.failed != null && this.failed.isFatal()) {
            return true;
        }
        if (this.failed != null && !this.hasNotifiedFailure) {
            this.hasNotifiedFailure = true;
            return true;
        }
        return this.failed != null && (System.currentTimeMillis() - this.timeFailed < 1000L || this.fetched < 2);
    }

    public synchronized boolean hasNotifiedFailure() {
        return true;
    }

    public synchronized boolean hasWaited() {
        return this.hasWaited;
    }

    public synchronized void setHasWaited() {
        this.hasWaited = true;
    }

    public synchronized void addListener(FProxyFetchListener listener) {
        if (logMINOR) {
            Logger.minor(this, "Registered listener:" + listener);
        }
        this.listener.add(listener);
    }

    public synchronized void removeListener(FProxyFetchListener listener) {
        if (logMINOR) {
            Logger.minor(this, "Removed listener:" + listener);
        }
        this.listener.remove(listener);
        if (logMINOR) {
            Logger.minor(this, "can cancel now?:" + this.canCancel());
        }
    }

    public synchronized void requestImmediateCancel() {
        this.requestImmediateCancel = true;
    }

    public synchronized long lastTouched() {
        return this.lastTouched;
    }

    public boolean fetchContextEquivalent(FetchContext context) {
        if (this.fctx.filterData != context.filterData) {
            return false;
        }
        if (this.fctx.maxOutputLength != context.maxOutputLength) {
            return false;
        }
        if (this.fctx.maxTempLength != context.maxTempLength) {
            return false;
        }
        if (this.fctx.charset == null && context.charset != null) {
            return false;
        }
        if (this.fctx.charset != null && !this.fctx.charset.equals(context.charset)) {
            return false;
        }
        if (this.fctx.overrideMIME == null && context.overrideMIME != null) {
            return false;
        }
        return this.fctx.overrideMIME == null || this.fctx.overrideMIME.equals(context.overrideMIME);
    }

    @Override
    public void onResume(ClientContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RequestClient getRequestClient() {
        return this.rc;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        LIFETIME = TimeUnit.SECONDS.toMillis(30L);
    }

    public static enum REFILTER_POLICY {
        RE_FILTER,
        ACCEPT_OLD,
        RE_FETCH;

    }
}

