/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.bookmark;

import freenet.clients.http.bookmark.Bookmark;
import freenet.clients.http.bookmark.BookmarkItem;
import freenet.clients.http.bookmark.BookmarkManager;
import freenet.node.FSParseException;
import freenet.support.SimpleFieldSet;
import java.util.ArrayList;
import java.util.List;

public class BookmarkCategory
extends Bookmark {
    public static final String NAME = "BookmarkCategory";
    private final List<Bookmark> bookmarks = new ArrayList<Bookmark>();

    public BookmarkCategory(String name) {
        this.setName(name);
    }

    public BookmarkCategory(SimpleFieldSet sfs) throws FSParseException {
        String aName = sfs.get("Name");
        if (aName == null) {
            throw new FSParseException("No Name!");
        }
        this.setName(aName);
    }

    protected synchronized Bookmark addBookmark(Bookmark b) {
        if (b == null) {
            return null;
        }
        int x = this.bookmarks.indexOf(b);
        if (x >= 0) {
            return this.bookmarks.get(x);
        }
        this.bookmarks.add(b);
        return b;
    }

    protected synchronized void removeBookmark(Bookmark b) {
        this.bookmarks.remove(b);
    }

    public synchronized Bookmark get(int i) {
        return this.bookmarks.get(i);
    }

    protected synchronized void moveBookmarkUp(Bookmark b) {
        int index = this.bookmarks.indexOf(b);
        if (index == -1) {
            return;
        }
        Bookmark bk = this.bookmarks.remove(index);
        this.bookmarks.add(--index < 0 ? 0 : index, bk);
    }

    protected synchronized void moveBookmarkDown(Bookmark b) {
        int index = this.bookmarks.indexOf(b);
        if (index == -1) {
            return;
        }
        Bookmark bk = this.bookmarks.remove(index);
        this.bookmarks.add(++index > this.size() ? this.size() : index, bk);
    }

    public synchronized int size() {
        return this.bookmarks.size();
    }

    public synchronized List<BookmarkItem> getItems() {
        ArrayList<BookmarkItem> items = new ArrayList<BookmarkItem>();
        for (Bookmark b : this.bookmarks) {
            if (!(b instanceof BookmarkItem)) continue;
            items.add((BookmarkItem)b);
        }
        return items;
    }

    public synchronized List<BookmarkItem> getAllItems() {
        List<BookmarkItem> items = this.getItems();
        for (BookmarkCategory cat : this.getSubCategories()) {
            items.addAll(cat.getAllItems());
        }
        return items;
    }

    public synchronized List<BookmarkCategory> getSubCategories() {
        ArrayList<BookmarkCategory> categories = new ArrayList<BookmarkCategory>();
        for (Bookmark b : this.bookmarks) {
            if (!(b instanceof BookmarkCategory)) continue;
            categories.add((BookmarkCategory)b);
        }
        return categories;
    }

    public synchronized List<BookmarkCategory> getAllSubCategories() {
        List<BookmarkCategory> categories = this.getSubCategories();
        for (BookmarkCategory cat : this.getSubCategories()) {
            categories.addAll(cat.getAllSubCategories());
        }
        return categories;
    }

    public String[] toStrings() {
        return this.toStrings("").toArray(new String[0]);
    }

    private List<String> toStrings(String prefix) {
        int i;
        ArrayList<String> strings = new ArrayList<String>();
        List<BookmarkItem> items = this.getItems();
        List<BookmarkCategory> subCategories = this.getSubCategories();
        prefix = prefix + this.name + "/";
        for (i = 0; i < items.size(); ++i) {
            strings.add(prefix + items.get(i).toString());
        }
        for (i = 0; i < subCategories.size(); ++i) {
            strings.addAll(subCategories.get(i).toStrings(prefix));
        }
        return strings;
    }

    @Override
    public synchronized SimpleFieldSet getSimpleFieldSet() {
        SimpleFieldSet sfs = new SimpleFieldSet(true);
        sfs.putSingle("Name", this.name);
        sfs.put("Content", BookmarkManager.toSimpleFieldSet(this));
        return sfs;
    }
}

