/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.updateableelements;

import freenet.client.FetchException;
import freenet.client.filter.HTMLFilter;
import freenet.clients.http.FProxyFetchInProgress;
import freenet.clients.http.FProxyFetchResult;
import freenet.clients.http.FProxyFetchTracker;
import freenet.clients.http.FProxyFetchWaiter;
import freenet.clients.http.FProxyToadlet;
import freenet.clients.http.SimpleToadletServer;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.updateableelements.BaseUpdateableElement;
import freenet.clients.http.updateableelements.NotifierFetchListener;
import freenet.keys.FreenetURI;
import freenet.support.Base64;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ImageElement
extends BaseUpdateableElement {
    private static volatile boolean logMINOR;
    public FProxyFetchTracker tracker;
    public final FreenetURI origKey;
    public FreenetURI key;
    public long maxSize;
    private NotifierFetchListener fetchListener;
    private HTMLFilter.ParsedTag originalImg;
    private final int randomNumber;
    private boolean wasError = false;

    public static ImageElement createImageElement(FProxyFetchTracker tracker, FreenetURI key, long maxSize, ToadletContext ctx, boolean pushed) {
        return ImageElement.createImageElement(tracker, key, maxSize, ctx, -1, -1, null, pushed);
    }

    public static ImageElement createImageElement(FProxyFetchTracker tracker, FreenetURI key, long maxSize, ToadletContext ctx, int width, int height, String name, boolean pushed) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("src", key.toString());
        if (width != -1) {
            attributes.put("width", String.valueOf(width));
        }
        if (height != -1) {
            attributes.put("height", String.valueOf(height));
        }
        if (name != null) {
            attributes.put("alt", name);
            attributes.put("title", name);
        }
        return new ImageElement(tracker, key, maxSize, ctx, new HTMLFilter.ParsedTag("img", attributes), pushed);
    }

    public ImageElement(FProxyFetchTracker tracker, FreenetURI key, long maxSize, ToadletContext ctx, HTMLFilter.ParsedTag originalImg, boolean pushed) {
        super("span", ctx);
        this.randomNumber = tracker.makeRandomElementID();
        long now = System.currentTimeMillis();
        if (logMINOR) {
            Logger.minor(this, "ImageElement creating for uri:" + key);
        }
        this.originalImg = originalImg;
        this.tracker = tracker;
        this.key = this.origKey = key;
        this.maxSize = maxSize;
        this.init(pushed);
        if (!pushed) {
            return;
        }
        this.fetchListener = new NotifierFetchListener(((SimpleToadletServer)ctx.getContainer()).getPushDataManager(), this);
        ((SimpleToadletServer)ctx.getContainer()).getTicker().queueTimedJob(new Runnable(){

            @Override
            public void run() {
                block4: {
                    try {
                        FProxyFetchWaiter waiter = ImageElement.this.tracker.makeFetcher(ImageElement.this.key, ImageElement.this.maxSize, null, FProxyFetchInProgress.REFILTER_POLICY.RE_FILTER);
                        ImageElement.this.tracker.getFetchInProgress(ImageElement.this.key, ImageElement.this.maxSize, null).addListener(ImageElement.this.fetchListener);
                        ImageElement.this.tracker.getFetchInProgress(ImageElement.this.key, ImageElement.this.maxSize, null).close(waiter);
                    }
                    catch (FetchException fe) {
                        if (fe.newURI == null) break block4;
                        try {
                            ImageElement.this.key = fe.newURI;
                            FProxyFetchWaiter waiter = ImageElement.this.tracker.makeFetcher(ImageElement.this.key, ImageElement.this.maxSize, null, FProxyFetchInProgress.REFILTER_POLICY.RE_FILTER);
                            ImageElement.this.tracker.getFetchInProgress(ImageElement.this.key, ImageElement.this.maxSize, null).addListener(ImageElement.this.fetchListener);
                            ImageElement.this.tracker.getFetchInProgress(ImageElement.this.key, ImageElement.this.maxSize, null).close(waiter);
                        }
                        catch (FetchException fe2) {
                            ImageElement.this.wasError = true;
                        }
                    }
                }
                ImageElement.this.fetchListener.onEvent();
            }
        }, 0L);
        if (logMINOR) {
            Logger.minor(this, "ImageElement creating finished in:" + (System.currentTimeMillis() - now) + " ms");
        }
    }

    @Override
    public void dispose() {
        FProxyFetchInProgress progress;
        if (logMINOR) {
            Logger.minor(this, "Disposing ImageElement");
        }
        if ((progress = this.tracker.getFetchInProgress(this.key, this.maxSize, null)) != null) {
            progress.removeListener(this.fetchListener);
            if (logMINOR) {
                Logger.minor(this, "canCancel():" + progress.canCancel());
            }
            progress.requestImmediateCancel();
            if (progress.canCancel()) {
                this.tracker.run();
            }
        }
    }

    @Override
    public String getUpdaterId(String requestId) {
        return ImageElement.getId(this.origKey, this.randomNumber);
    }

    public static String getId(FreenetURI uri, int randomNumber) {
        return Base64.encodeStandardUTF8("image[URI:" + uri.toString() + ",random:" + randomNumber + "]");
    }

    @Override
    public String getUpdaterType() {
        return "ImageElementUpdater";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateState(boolean initial) {
        if (logMINOR) {
            Logger.minor(this, "Updating ImageElement for url:" + this.key + (this.origKey == this.key ? " originally " + this.origKey : ""));
        }
        this.children.clear();
        HTMLNode whenJsEnabled = new HTMLNode("span", "class", "jsonly ImageElement");
        this.addChild(whenJsEnabled);
        this.addChild("noscript").addChild(this.makeHtmlNodeForParsedTag(this.originalImg));
        if (initial) {
            if (this.wasError) {
                whenJsEnabled.addChild(this.makeHtmlNodeForParsedTag(this.originalImg));
            } else {
                Map<String, String> attr = this.originalImg.getAttributesAsMap();
                String sizePart = "";
                if (attr.containsKey("width") && attr.containsKey("height")) {
                    sizePart = "&width=" + attr.get("width") + "&height=" + attr.get("height");
                }
                attr.put("src", "/imagecreator/?text=+" + FProxyToadlet.l10n("imageinitializing") + "+" + sizePart);
                whenJsEnabled.addChild(this.makeHtmlNodeForParsedTag(new HTMLFilter.ParsedTag(this.originalImg, attr)));
                whenJsEnabled.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "fetchedBlocks", String.valueOf(0)});
                whenJsEnabled.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "requiredBlocks", String.valueOf(1)});
            }
        } else {
            FProxyFetchResult fr = null;
            FProxyFetchWaiter waiter = null;
            try {
                try {
                    waiter = this.tracker.makeFetcher(this.key, this.maxSize, null, FProxyFetchInProgress.REFILTER_POLICY.RE_FILTER);
                    fr = waiter.getResultFast();
                }
                catch (FetchException fe) {
                    whenJsEnabled.addChild("div", "error");
                }
                if (fr == null) {
                    whenJsEnabled.addChild("div", "No fetcher found");
                } else if (fr.isFinished() && fr.hasData()) {
                    if (logMINOR) {
                        Logger.minor(this, "ImageElement is completed");
                    }
                    whenJsEnabled.addChild(this.makeHtmlNodeForParsedTag(this.originalImg));
                } else if (fr.failed != null) {
                    if (logMINOR) {
                        Logger.minor(this, "ImageElement is errorous");
                    }
                    whenJsEnabled.addChild(this.makeHtmlNodeForParsedTag(this.originalImg));
                } else {
                    if (logMINOR) {
                        Logger.minor(this, "ImageElement is still in progress");
                    }
                    int total = fr.requiredBlocks;
                    int fetchedPercent = (int)((double)fr.fetchedBlocks / (double)total * 100.0);
                    Map<String, String> attr = this.originalImg.getAttributesAsMap();
                    String sizePart = new String();
                    if (attr.containsKey("width") && attr.containsKey("height")) {
                        sizePart = "&width=" + attr.get("width") + "&height=" + attr.get("height");
                    }
                    attr.put("src", "/imagecreator/?text=" + fetchedPercent + "%25" + sizePart);
                    whenJsEnabled.addChild(this.makeHtmlNodeForParsedTag(new HTMLFilter.ParsedTag(this.originalImg, attr)));
                    whenJsEnabled.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "fetchedBlocks", String.valueOf(fr.fetchedBlocks)});
                    whenJsEnabled.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "requiredBlocks", String.valueOf(fr.requiredBlocks)});
                }
            }
            finally {
                if (waiter != null) {
                    this.tracker.getFetchInProgress(this.key, this.maxSize, null).close(waiter);
                }
                if (fr != null) {
                    this.tracker.getFetchInProgress(this.key, this.maxSize, null).close(fr);
                }
            }
        }
    }

    private HTMLNode makeHtmlNodeForParsedTag(HTMLFilter.ParsedTag pt) {
        ArrayList<String> attributeNames = new ArrayList<String>();
        ArrayList<String> attributeValues = new ArrayList<String>();
        for (Map.Entry<String, String> att : pt.getAttributesAsMap().entrySet()) {
            attributeNames.add(att.getKey());
            attributeValues.add(att.getValue());
        }
        return new HTMLNode(pt.element, attributeNames.toArray(new String[0]), attributeValues.toArray(new String[0]));
    }

    public String toString() {
        return "ImageElement[key:" + this.key + ",maxSize:" + this.maxSize + ",originalImg:" + this.originalImg + ",updaterId:" + this.getUpdaterId(null) + "]";
    }

    static {
        Logger.registerClass(ImageElement.class);
    }
}

